/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.esp;

import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.esp.Esp;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class EspCombinestate
implements IFormulaCombinationPreparedState {
    private BigDecimal rate;
    private Date effectDate;
    private Set set = new HashSet();

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        Esp esp = (Esp)formula;
        String sheetName = "";
        if (esp.getParameter() != null) {
            sheetName = esp.getParameter().getSheetName();
        }
        String key = esp.orgBoundNumber + esp.orgUnitInvest + esp.orgUnitInvested + esp.year + esp.period + esp.strDate + sheetName;
        Date date = esp.effectDate;
        if (this.effectDate.after(date) || this.set.contains(key)) {
            return false;
        }
        this.set.add(key);
        return true;
    }

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        if (this.rate == null) {
            return new BigDecimal(0);
        }
        return this.rate.divide(new BigDecimal("100"), 15, 4);
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
}

