/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.iref.AcctItemAsstTranslator;
import com.kingdee.eas.fi.rpt.batch.iref.DateUtils;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class IRef
extends AbstractFormulaCalculatorParameter {
    protected String company;
    protected String currency;
    protected Date startDate;
    protected Date endDate;
    protected int dataelement;
    protected ValueTypeEnum valueType;
    protected String acctFrom;
    protected String acctTo;
    protected String acctFromid;
    protected String acctToid;
    protected String accountTableid;
    protected ITranslator translator;
    protected OrgType orgType = OrgType.Company;
    protected String midTableName;
    private BatchHelper batchHelper;

    public IRef(Parameter param, BatchHelper batchHelper) {
        this.batchHelper = batchHelper;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        String acctSerial;
        int index;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.company = StringUtils.isEmpty((String)((Variant)args[index = 0]).getValue().toString()) ? this.batchHelper.getCompany_Number() : ((Variant)args[index]).getValue().toString();
        this.currency = StringUtils.isEmpty((String)((Variant)args[++index]).getValue().toString()) ? this.batchHelper.getCorrect_Currency_Number() : ((Variant)args[index]).getValue().toString();
        this.startDate = DateUtils.getStartDate(this.batchHelper.getReport_PeriodType(), this.batchHelper.getReport_Year(), this.batchHelper.getReport_Period(), ((Variant)args[++index]).getValue().toString());
        this.endDate = DateUtils.getEndDate(this.batchHelper.getReport_PeriodType(), this.batchHelper.getReport_Year(), this.batchHelper.getReport_Period(), ((Variant)args[++index]).getValue().toString());
        this.dataelement = DataElementProvider.getDataElementInnerValue((Context)this.batchHelper.getServerContext(), (String)((Variant)args[++index]).getValue().toString());
        this.valueType = ValueTypeEnum.getEnum((String)((Variant)args[++index]).getValue().toString());
        if (!StringUtils.isEmpty((String)(acctSerial = ((Variant)args[++index]).getValue().toString()))) {
            if (acctSerial.indexOf(":") != -1) {
                String[] split = acctSerial.split(":");
                this.acctFrom = split[0];
                this.acctTo = split[1];
            } else {
                this.acctFrom = acctSerial;
            }
        }
        String asstTypeSerial = ((Variant)args[++index]).getValue().toString();
        String asstItemsSerial = ((Variant)args[++index]).getValue().toString();
        this.translator = new AcctItemAsstTranslator(this.batchHelper.getServerContext());
        try {
            this.translator.translate(asstTypeSerial, asstItemsSerial);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean isTxtValueType() {
        return ValueTypeEnum.TXT.equals((Object)this.valueType);
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.acctFrom) && StringUtils.isEmpty((String)this.acctTo)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_AcctIsNull"));
        }
        if (this.acctFromid == null) {
            AccountViewCollection col = RptUtilForClient.getAccountViewCollectionByNumber(this.batchHelper.getServerContext(), this.acctFrom, this.acctTo, this.accountTableid);
            int size = col.size();
            if (col != null && size > 0) {
                if (this.acctTo != null) {
                    for (int i = 0; i < size; ++i) {
                        AccountViewInfo info = col.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        if (this.acctTo.equals(number)) {
                            this.acctToid = id;
                            continue;
                        }
                        this.acctFromid = id;
                    }
                } else {
                    AccountViewInfo info = col.get(0);
                    this.acctFromid = info.getId().toString();
                }
            }
        }
        this.midTableName = IntegrateSchemeHelper.getInstance().getTableName(this.batchHelper.getServerContext(), this.company, this.orgType);
    }
}

