/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.iref.IRef;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IRefSortState
implements IBatchSQLSortState {
    protected CombineKeys keys;
    private List<IFormulaCalculator> fromulaList = new ArrayList<IFormulaCalculator>();

    public IRefSortState() {
    }

    public IRefSortState(String companyNum, int orgType) {
        this();
        this.keys = new CombineKeys();
        this.keys.company = companyNum;
        this.keys.orgType = OrgType.getEnum((int)orgType);
    }

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.fromulaList.add(formula);
    }

    @Override
    public String generateKey() {
        return this.keys.generateKey();
    }

    @Override
    public List getFormulaList() {
        return this.fromulaList;
    }

    @Override
    public void reset() {
        this.keys = null;
    }

    @Override
    public void setContext(Map context) {
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        IRef iref = (IRef)formula;
        this.keys = new CombineKeys();
        this.keys.company = iref.company;
        this.keys.startDate = iref.startDate;
        this.keys.endDate = iref.endDate;
        this.keys.valueType = iref.valueType;
        this.keys.acctFrom = iref.acctFrom;
        this.keys.acctTo = iref.acctTo;
        this.keys.translator = iref.translator;
        this.keys.orgType = iref.orgType;
        this.keys.midTableName = iref.midTableName;
    }

    @Override
    public Object clone() {
        IRefSortState clone = new IRefSortState();
        clone.keys = new CombineKeys();
        clone.keys.company = this.keys.company;
        clone.keys.startDate = this.keys.startDate;
        clone.keys.endDate = this.keys.endDate;
        clone.keys.valueType = this.keys.valueType;
        clone.keys.acctFrom = this.keys.acctFrom;
        clone.keys.acctTo = this.keys.acctTo;
        clone.keys.translator = this.keys.translator;
        clone.keys.orgType = this.keys.orgType;
        clone.keys.midTableName = this.keys.midTableName;
        return clone;
    }

    class CombineKeys {
        String company;
        Date startDate;
        Date endDate;
        ValueTypeEnum valueType;
        String acctFrom;
        String acctTo;
        ITranslator translator;
        OrgType orgType;
        String midTableName;

        CombineKeys() {
        }

        String generateKey() {
            StringBuffer sb = new StringBuffer(50);
            sb.append(this.surgeKey(this.company));
            sb.append(this.surgeKey(this.startDate.toString()));
            sb.append(this.surgeKey(this.endDate.toString()));
            sb.append(this.surgeKey("" + this.valueType.getValue()));
            sb.append(this.surgeKey(this.acctFrom));
            sb.append(this.surgeKey(this.acctTo));
            sb.append(this.surgeKey(this.translator.toString()));
            sb.append(this.surgeKey("" + this.orgType.getValue()));
            sb.append(this.surgeKey(this.midTableName));
            return sb.toString();
        }

        String surgeKey(String key) {
            return "[" + key + "]";
        }

        void reSet() {
            this.company = null;
            this.startDate = null;
            this.endDate = null;
            this.valueType = null;
            this.acctFrom = null;
            this.acctTo = null;
            this.translator = null;
            this.orgType = null;
            this.midTableName = null;
        }
    }
}

