/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CACHE_SIZE = 0x100000;
    private int maxSize = 0x100000;
    private int totalSize = 0;
    private IObjectSizeComputer keySizeComputer;
    private IObjectSizeComputer valueSizeComputer;

    public void setKeySizeComputer(IObjectSizeComputer keySizeComputer, IObjectSizeComputer valueSizeComputer) {
        this.keySizeComputer = keySizeComputer;
        this.valueSizeComputer = valueSizeComputer;
    }

    private final int entrySize(Object key) {
        if (this.containsKey(key)) {
            return this.keyValueSize(key, this.get(key));
        }
        return 0;
    }

    private final int keyValueSize(Object key, V value) {
        if (this.keySizeComputer == null || this.valueSizeComputer == null) {
            return 1;
        }
        return this.keySizeComputer.sizeOf(key) + this.valueSizeComputer.sizeOf(value);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        assert (maxSize > 0);
        this.maxSize = maxSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public LRUMap() {
        super(16, 0.75f, true);
    }

    public LRUMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
    }

    public LRUMap(int initialCapacity) {
        super(initialCapacity, 0.75f, true);
    }

    @Override
    public void clear() {
        super.clear();
        this.totalSize = 0;
    }

    @Override
    public V remove(Object key) {
        this.totalSize -= this.entrySize(key);
        return super.remove(key);
    }

    @Override
    public V put(K key, V value) {
        this.totalSize = this.totalSize - this.entrySize(key) + this.keyValueSize(key, value);
        V o = super.put(key, value);
        while (this.totalSize > this.maxSize) {
            key = this.keySet().iterator().next();
            this.remove(key);
        }
        return o;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.totalSize > this.maxSize) {
            this.totalSize -= this.keyValueSize(eldest.getKey(), eldest.getValue());
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    public static interface IObjectSizeComputer {
        public int sizeOf(Object var1);
    }
}

