/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.sqlgetdata;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.util.DBCenterManager;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.sqlgetdata.SqlGetData;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SqlGetDataBatchCalculator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.batch.sqlgetdata.SqlGetDataBatchCalculator");
    private ICalculateContextProvider calContext;
    private Context context;
    private ReportVariables vars;
    private IReportPropertyAdapter adapt;
    private static final String DYNA_FILTER = "dynaFilter";
    private static final String RETURN_VALUE = "returnValue";
    private Map<String, Map<String, List<SqlGetData>>> exeFormulas = null;
    private Map<String, Map<String, Map<String, Object>>> exeReportVariables = null;
    private Map<String, String> dbFormulas = null;

    public SqlGetDataBatchCalculator(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = _serverCtx;
        this.calContext = calContext;
        this.vars = calContext.getReportVariables();
        this.adapt = calContext.getReportAdapter();
        this.exeFormulas = new HashMap<String, Map<String, List<SqlGetData>>>();
        this.exeReportVariables = new HashMap<String, Map<String, Map<String, Object>>>();
        this.dbFormulas = new HashMap<String, String>();
    }

    protected int getSheetStartYear(String sheetName) {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("StartYear", sheetName, 0);
    }

    protected int getReportYear() {
        return (Integer)this.adapt.getReportProperty("Report.Year");
    }

    protected int getSheetStartPeriod(String sheetName) {
        return this.vars.getIntValue("StartPeriod", sheetName, 0);
    }

    protected int getSheetEndPeriod(String sheetName) {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("EndPeriod", sheetName, 0);
    }

    protected int getReportPeriod() {
        return (Integer)this.adapt.getReportProperty("Report.Period");
    }

    protected int getSheetEndYear(String sheetName) {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("EndYear", sheetName, 0);
    }

    protected String getCompanyID() {
        return (String)this.adapt.getReportProperty("Company.Number");
    }

    protected String getCurrencyNumber(String sheetName) {
        String currency = this.vars.getStringValue("Currency", sheetName);
        if (StringUtils.isEmpty((String)currency)) {
            currency = (String)this.adapt.getReportProperty("Currency.Number");
        }
        return currency;
    }

    private Map<String, Object> getFilterValue(String sheetName) {
        HashMap<String, Object> filterAndValue = new HashMap<String, Object>();
        filterAndValue.put("{company}", this.getCompanyID());
        filterAndValue.put("{currency}", this.getCurrencyNumber(sheetName));
        filterAndValue.put("{startyear}", this.getSheetStartYear(sheetName) + this.getReportYear());
        int endYear = this.getSheetEndYear(sheetName) + this.getReportYear();
        filterAndValue.put("{endyear}", endYear);
        filterAndValue.put("{startperiod}", this.getSheetStartPeriod(sheetName) + this.getReportPeriod());
        int endPeriod = this.getSheetEndPeriod(sheetName) + this.getReportPeriod();
        filterAndValue.put("{endperiod}", endPeriod);
        filterAndValue.put("{startdate}", "{ts'" + (this.getSheetStartYear(sheetName) + this.getReportYear()) + "-" + (this.getSheetStartPeriod(sheetName) + this.getReportPeriod()) + "-1 00:00:00'}");
        filterAndValue.put("{enddate}", "{ts'" + endYear + "-" + endPeriod + "-" + this.getLastDayOfMonth(endYear, endPeriod) + " 23:59:59'}");
        return filterAndValue;
    }

    public int getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        return lastDay;
    }

    public void execute(SortedParameterArray params) {
        this.sortSqlToList(params);
        this.exeSqlGetData();
    }

    private void sortSqlToList(SortedParameterArray params) {
        int formulaSize = params.size();
        Map<String, List<SqlGetData>> curExeFormulas = null;
        Map<String, Map<String, Object>> curExeReportVariables = null;
        for (int i = 0; i < formulaSize; ++i) {
            Parameter formulaParam = params.getParameter(i);
            SqlGetData sqlGetData = new SqlGetData(formulaParam);
            String sql = sqlGetData.getFormulaSql();
            if (sql == null) continue;
            if (sqlGetData.getDbCenterNumber() != null && !StringUtils.isEmpty((String)sqlGetData.getDbCenterNumber()) && !this.dbFormulas.containsKey(sql)) {
                this.dbFormulas.put(sql, sqlGetData.getDbCenterNumber());
            }
            if (StringUtils.isEmpty((String)sqlGetData.getDynaFilter())) {
                curExeFormulas = this.exeFormulas.get("noDynaFilter");
                curExeReportVariables = this.exeReportVariables.get("noDynaFilter");
                if (this.exeFormulas.get("noDynaFilter") == null) {
                    curExeFormulas = new HashMap<String, List<SqlGetData>>();
                    this.exeFormulas.put("noDynaFilter", curExeFormulas);
                }
                if (this.exeReportVariables.get("noDynaFilter") == null) {
                    curExeReportVariables = new HashMap<String, Map<String, Object>>();
                    this.exeReportVariables.put("noDynaFilter", curExeReportVariables);
                }
            } else {
                curExeFormulas = this.exeFormulas.get("hasDynaFilter");
                curExeReportVariables = this.exeReportVariables.get("hasDynaFilter");
                if (this.exeFormulas.get("hasDynaFilter") == null) {
                    curExeFormulas = new HashMap<String, List<SqlGetData>>();
                    this.exeFormulas.put("hasDynaFilter", curExeFormulas);
                }
                if (this.exeReportVariables.get("hasDynaFilter") == null) {
                    curExeReportVariables = new HashMap<String, Map<String, Object>>();
                    this.exeReportVariables.put("hasDynaFilter", curExeReportVariables);
                }
            }
            curExeReportVariables.put(sql, this.getFilterValue(formulaParam.getSheetName()));
            List<SqlGetData> sameSqlFormulaList = curExeFormulas.get(sql);
            if (sameSqlFormulaList == null) {
                sameSqlFormulaList = new ArrayList<SqlGetData>();
                curExeFormulas.put(sql, sameSqlFormulaList);
            }
            sameSqlFormulaList.add(sqlGetData);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exeSqlGetData() {
        if (this.exeFormulas == null) {
            return;
        }
        Set<String> exeFormulasKeySet = this.exeFormulas.keySet();
        Map<String, Map<String, Object>> curExeReportVariables = null;
        Map dbCentersMap = null;
        if (this.dbFormulas != null && !this.dbFormulas.isEmpty()) {
            dbCentersMap = DBCenterManager.getAllDbCenters((Context)this.context);
        }
        Iterator<String> iterator = exeFormulasKeySet.iterator();
        block2: while (iterator.hasNext()) {
            String exeFormulasKey = iterator.next();
            Map<String, List<SqlGetData>> curExeFormulas = this.exeFormulas.get(exeFormulasKey);
            boolean isNODynaFilter = "noDynaFilter".equals(exeFormulasKey);
            curExeReportVariables = this.exeReportVariables.get(exeFormulasKey);
            Set<String> keySet = curExeFormulas.keySet();
            String sqlInStr = null;
            HashMap<String, Map<Object, Object>> dcValueCatch = new HashMap<String, Map<Object, Object>>();
            Iterator<String> iterator2 = keySet.iterator();
            block3: while (true) {
                if (!iterator2.hasNext()) continue block2;
                String sql = iterator2.next();
                dcValueCatch.clear();
                List<SqlGetData> dynaFilterList = curExeFormulas.get(sql);
                if (!isNODynaFilter) {
                    sqlInStr = this.setSqlInStr(sql, dynaFilterList, curExeReportVariables);
                }
                Object[] params = this.getExeSqlParams(sql, curExeReportVariables);
                String exeSql = this.getExeSqlText(sql, curExeReportVariables, sqlInStr);
                if (exeSql == null || exeSql.length() == 0) continue;
                Map<String, Object> dynaRSValue = new HashMap();
                Object noDynaRSValue = new HashMap();
                IRowSet rs = null;
                try {
                    Iterator<SqlGetData> iterator3 = dynaFilterList.iterator();
                    while (true) {
                        String dcNumber;
                        SqlGetData sqlgetData;
                        block24: {
                            if (!iterator3.hasNext()) continue block3;
                            sqlgetData = iterator3.next();
                            dcNumber = sqlgetData.getDbCenterNumber();
                            boolean isCurDc = StringUtils.isEmpty((String)dcNumber);
                            if (isCurDc) {
                                dcNumber = "curDcNumber";
                            }
                            if (dcValueCatch.containsKey(dcNumber)) {
                                if (isNODynaFilter) {
                                    sqlgetData.getParam().setValue(dcValueCatch.get(dcNumber));
                                } else {
                                    dynaRSValue = (Map)dcValueCatch.get(dcNumber);
                                    if (dynaRSValue != null) {
                                        sqlgetData.getParam().setValue(dynaRSValue.get(sqlgetData.getDynaFilter()));
                                    }
                                }
                                if (sqlgetData.getParam().getValue() != null) continue;
                                sqlgetData.getParam().setValue((Object)"");
                                continue;
                            }
                            dynaRSValue = new HashMap();
                            noDynaRSValue = new HashMap();
                            if (isCurDc) {
                                rs = DbUtil.executeQuery((Context)this.context, (String)exeSql, (Object[])params);
                            } else {
                                if (dbCentersMap != null && !dbCentersMap.isEmpty()) {
                                    if (dbCentersMap.containsKey(dcNumber)) {
                                        DBCenterInfo dbCenter = (DBCenterInfo)dbCentersMap.get(dcNumber);
                                        rs = DbUtil.executeQuery((Context)this.context, (DBCenterInfo)dbCenter, (String)exeSql, (Object[])params);
                                        break block24;
                                    } else {
                                        sqlgetData.getParam().setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"notExistDBCenterInfo", (Locale)this.context.getOriginLocale()));
                                        logger.error((Object)"find dbCenterInfo by dbCenterNumber error!");
                                        continue;
                                    }
                                }
                                rs = DbUtil.executeQuery((Context)this.context, (String)exeSql, (Object[])params);
                            }
                        }
                        if (rs != null) {
                            if (isNODynaFilter) {
                                if (rs.next()) {
                                    noDynaRSValue = rs.getObject(RETURN_VALUE);
                                    sqlgetData.getParam().setValue(noDynaRSValue);
                                }
                                dcValueCatch.put(dcNumber, (Map<Object, Object>)noDynaRSValue);
                            } else {
                                while (rs.next()) {
                                    String dynaFilter = rs.getString(DYNA_FILTER);
                                    Object value = rs.getObject(RETURN_VALUE);
                                    dynaRSValue.put(dynaFilter, value);
                                }
                                sqlgetData.getParam().setValue(dynaRSValue.get(sqlgetData.getDynaFilter()));
                                dcValueCatch.put(dcNumber, dynaRSValue);
                            }
                        }
                        if (sqlgetData.getParam().getValue() != null) continue;
                        sqlgetData.getParam().setValue((Object)"");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"sqlgetdata execute sql error", (Throwable)e);
                    continue;
                }
                break;
            }
            break;
        }
        return;
    }

    private Object[] getExeSqlParams(String sql, Map<String, Map<String, Object>> curExeReportVariables) {
        TreeMap<Integer, Object> paramMap = new TreeMap<Integer, Object>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        Set<String> filterKeySet = curExeReportVariables.get(sql).keySet();
        for (String filterKey : filterKeySet) {
            int paramIndex = 0;
            while (paramIndex == 0) {
                if ((paramIndex = sql.indexOf(filterKey, paramIndex)) == -1 || "startdate".equals(filterKey) || "enddate".equals(filterKey)) continue;
                paramMap.put(paramIndex, curExeReportVariables.get(sql).get(filterKey));
            }
        }
        ArrayList paramList = new ArrayList();
        Set paramSet = paramMap.keySet();
        for (Integer key : paramSet) {
            Object paramValue = paramMap.get(key);
            if (paramValue instanceof List) {
                paramList.addAll((List)paramValue);
                continue;
            }
            paramList.add(paramValue);
        }
        return paramList.toArray();
    }

    private String getExeSqlText(String sql, Map<String, Map<String, Object>> curExeReportVariables, String sqlInStr) {
        if (sql == null || !sql.trim().toLowerCase(Locale.ENGLISH).startsWith("select") && !sql.trim().toLowerCase(Locale.ENGLISH).startsWith("/*dialect*/") && !sql.trim().toLowerCase(Locale.ENGLISH).startsWith("call")) {
            return null;
        }
        Set<String> keySet = curExeReportVariables.get(sql).keySet();
        for (String filterKey : keySet) {
            String replaceStr = null;
            replaceStr = "startdate".equals(filterKey) || "enddate".equals(filterKey) ? (String)curExeReportVariables.get(sql).get(filterKey) : ("{@}".equals(filterKey) ? sqlInStr : "?");
            if (StringUtils.isEmpty((String)replaceStr)) continue;
            sql = sql.replace(filterKey, replaceStr);
        }
        return sql;
    }

    private String setSqlInStr(String sql, List<SqlGetData> dynaFilterList, Map<String, Map<String, Object>> curExeReportVariables) {
        String sqlInStr = null;
        ArrayList<String> sqlInParam = new ArrayList<String>();
        StringBuffer sqlInStrBuff = new StringBuffer();
        int size = dynaFilterList.size();
        for (int i = 0; i < size; ++i) {
            String dynaFilter = dynaFilterList.get(i).getDynaFilter();
            if (dynaFilter == null) continue;
            sqlInStrBuff.append("?");
            sqlInParam.add(dynaFilter);
            if (i == size - 1) continue;
            sqlInStrBuff.append(",");
        }
        if (sqlInParam.size() > 0) {
            curExeReportVariables.get(sql).put("{@}", sqlInParam);
            sqlInStr = sqlInStrBuff.toString();
        }
        return sqlInStr;
    }
}

