/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.temptablescheme;

import com.kingdee.eas.fi.rpt.batch.RptCalculateException;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TempTableField
implements ITempTableField {
    private List tempTableFieldItems = new ArrayList();
    private Map tempTableFieldItemMap = new HashMap();

    @Override
    public void addTempTableItem(ITempTableItem tempTableFieldItem) {
        TempTableFieldItem fieldItem = (TempTableFieldItem)tempTableFieldItem;
        if (StringUtils.isEmpty((String)fieldItem.getTempTableField())) {
            fieldItem.setTempTableField(this.getDefaultTempTableFieldName(fieldItem.getField()));
        }
        this.tempTableFieldItems.add(tempTableFieldItem);
        this.tempTableFieldItemMap.put(fieldItem.getField(), tempTableFieldItem);
    }

    @Override
    public List getTempTableFieldItems() {
        return this.tempTableFieldItems;
    }

    public int size() {
        return this.tempTableFieldItems.size();
    }

    private String getDefaultTempTableFieldName(String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        if (fieldNames.length != 2) {
            throw new RptCalculateException("temptable field define error");
        }
        return fieldNames[1] + this.size();
    }

    @Override
    public TempTableFieldItem getTempTableFieldItem(String field) {
        return (TempTableFieldItem)this.tempTableFieldItemMap.get(field);
    }
}

