/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.temptablescheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.fi.rpt.jdbc.JdbcTemplate;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class TempTableJdbcTemplate
extends JdbcTemplate {
    public TempTableJdbcTemplate(Context ctx) throws BOSException {
        this.ctx = ctx;
    }

    public void initConnection() throws BOSException {
        try {
            this.connection = EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String createTempTable(String sql) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)this.ctx).createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void releaseTempTable(String tableName) {
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tableName);
    }

    public void createIndex(String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool.getInstance((Context)this.ctx).createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String createDBSystemTempTable(String sql) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)this.ctx).createDBSystemTempTable(sql, this.connection);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void releaseDBSystemTempTable(String tableName) throws BOSException {
        try {
            TempTablePool.getInstance((Context)this.ctx).releaseDBSystemTempTable(tableName, this.connection);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public final void cleanupConnection() {
        SQLUtils.cleanup(null, null, (Connection)this.connection);
    }

    public void analyzeTable(String tableName) throws BOSException {
        try {
            TempTablePool.getInstance((Context)this.ctx).analyzeTable(this.connection, tableName);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)this.ctx).createDBSystemTempTableIndex(tableName, columns, isUnique, isClustered, this.connection);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String createTableName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 22);
        return "T_RPT_" + name;
    }

    public String createIndexName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 17);
        return "IX_" + name;
    }
}

