/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery;

import com.kingdee.eas.fi.rpt.batchquery.ExportResultManager;
import com.kingdee.eas.fi.rpt.batchquery.QueryParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QueryManager {
    private static final Logger log = Logger.getLogger((String)QueryManager.class.getName());
    private HashMap sysContext = new HashMap(1);
    private ExportResultManager exportResultManager = null;
    private QueryParameterManager queryParameterManager = null;
    private Connection conn = null;
    private int whereSize = 200;

    public QueryManager(Connection _conn) {
        this.conn = _conn;
        this.queryParameterManager = new QueryParameterManager(this.conn, this.sysContext);
        this.exportResultManager = new ExportResultManager(this.sysContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() throws SQLException, Exception {
        try {
            this.queryParameterManager.setWhereSize(this.getWhereSize());
            this.queryParameterManager.prepareForQueryStatement();
            this.exportResultManager.setGroupConditionFields(this.queryParameterManager.getGroupConditionFields());
            while (this.queryParameterManager.hasMoreToQuery()) {
                PreparedStatement statement = this.queryParameterManager.nextStatement();
                if (statement == null) continue;
                try {
                    ResultSet rs = statement.executeQuery();
                    if (rs == null) continue;
                    try {
                        this.exportResultManager.exportResult(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
        }
        catch (Throwable e) {
            this.exportResultManager.exportException(e);
            log.debug((Object)e.getMessage());
        }
    }

    public ExportResultManager getExportResultManager() {
        return this.exportResultManager;
    }

    public QueryParameterManager getQueryParameterManager() {
        return this.queryParameterManager;
    }

    public HashMap getSysContext() {
        return this.sysContext;
    }

    public int getWhereSize() {
        return this.whereSize;
    }

    public void setWhereSize(int whereSize) {
        this.whereSize = whereSize;
    }
}

