/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilFactory;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.check.CheckExrepssionIterator;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.ICustomerFormat;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ReportCheck {
    public static final String REAL_MAX_COL = "REAL_MAX_COL";
    public static final String REAL_MAX_ROW = "REAL_MAX_ROW";
    private Book workBoook;
    private RptCheckExpTank expTank;
    private int okCount = 0;
    private int allcount = 0;
    private final Locale locale;
    private String currentSheet = null;
    private boolean isCheckPass = true;
    private Book realBook;
    private static final int IF_EXPR_COLUMN = 4;

    public ReportCheck(Book book, RptCheckExpTank expTank, Locale locale) throws Exception {
        this.workBoook = book;
        this.expTank = expTank;
        this.locale = locale;
    }

    public ReportCheck(Book book, RptCheckExpTank expTank, Locale locale, String currentSheet) throws Exception {
        this.workBoook = book;
        this.expTank = expTank;
        this.locale = locale;
        this.currentSheet = currentSheet;
    }

    public String check() throws Exception {
        Map rs = this.doCheck();
        if (rs == null) {
            return null;
        }
        return this.exportCheckResult(rs);
    }

    public String exportPlainCheckResult(Map map) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : map.entrySet()) {
            sb.append(e.getKey()).append('\n');
            List list = (List)e.getValue();
            int subtotal = 0;
            for (int i = 0; i < list.size(); ++i) {
                ++this.allcount;
                ExtRptCheckExpression exprExt = (ExtRptCheckExpression)list.get(i);
                String rs = exprExt.toString();
                if (exprExt.error != null) {
                    sb.append('\t');
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_ITEM", this.locale)).append(exprExt.parentExpr.getContent().trim()).append(RptUtil.getReportResource("REPORT_CHECK_DIFINE_ERROR", this.locale)).append(exprExt.error).append('\n');
                    continue;
                }
                if (rs == null) {
                    ++subtotal;
                    continue;
                }
                sb.append('\t');
                if (!exprExt.noParsed) {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_FROM_ITEM", this.locale)).append(exprExt.parentExpr.getContent().trim()).append(RptUtil.getReportResource("REPORT_CHECK_FROM_", this.locale));
                }
                sb.append(exprExt.toString()).append('\n');
            }
            if (subtotal == list.size()) {
                sb.append('\t').append(RptUtil.getReportResource("REPORT_CHECK_PASSEDD", this.locale)).append('\n');
            }
            this.okCount += subtotal;
        }
        if (this.okCount == this.allcount) {
            return null;
        }
        return sb.toString();
    }

    public String getFormulaCheckResult(ExtRptCheckExpression exprExt, boolean isForExcel) {
        StringBuffer result = new StringBuffer();
        if (exprExt.getCheckResultState() == 2) {
            result.append(RptUtil.getReportResource("error_but_can_pass", this.locale));
        } else if (exprExt.getCheckResultState() == 3) {
            if (exprExt.isHasPostil()) {
                if (isForExcel) {
                    result.append(RptUtil.getReportResource("Warning", this.locale)).append("\uff1a").append(RptUtil.getReportResource("Warning_has_postil", this.locale));
                } else {
                    result.append("<font color=\"#ff0000\">").append(RptUtil.getReportResource("Warning", this.locale)).append("</font>").append("\uff1a").append(RptUtil.getReportResource("Warning_has_postil", this.locale));
                }
            } else {
                result.append(RptUtil.getReportResource("error_need_postil", this.locale));
            }
        } else {
            result.append(RptUtil.getReportResource("error_need_correct", this.locale));
        }
        return result.toString();
    }

    public String exportCheckResult(Map map) throws ReportException {
        return this.exportCheckResult(map, false);
    }

    public String exportCheckResult(Map map, boolean isForExcel) throws ReportException {
        StringBuffer sb = new StringBuffer();
        String reportId = null;
        if (map.get("reportId") != null) {
            reportId = map.get("reportId").toString();
            map.remove("reportId");
        }
        for (Map.Entry e : map.entrySet()) {
            String sheetName = (String)e.getKey();
            if (isForExcel) {
                sb.append(sheetName).append("<br>");
            } else {
                sb.append("<font color=\"#000080\"><b>").append(sheetName).append("</b></font><br>");
            }
            List list = (List)e.getValue();
            int subtotal = 0;
            for (int i = 0; i < list.size(); ++i) {
                ++this.allcount;
                ExtRptCheckExpression exprExt = (ExtRptCheckExpression)list.get(i);
                String info = exprExt.getDescription();
                if (info.indexOf("\"") > 0 || info.indexOf(">") > 0 || info.indexOf("<") > 0 || info.indexOf("&") > 0) {
                    char[] charArray = info.toCharArray();
                    StringBuffer sb1 = new StringBuffer();
                    for (int j = 0; j < charArray.length; ++j) {
                        char ch = charArray[j];
                        if ("<".equals(String.valueOf(ch))) {
                            sb1.append("&lt;");
                            continue;
                        }
                        if (">".equals(String.valueOf(ch))) {
                            sb1.append("&gt;");
                            continue;
                        }
                        if ("\"".equals(String.valueOf(ch))) {
                            sb1.append("&quot;");
                            continue;
                        }
                        if ("&".equals(String.valueOf(ch))) {
                            sb1.append("&amp;");
                            continue;
                        }
                        sb1.append(ch);
                    }
                    info = sb1.toString();
                }
                String rs = exprExt.toString();
                if (exprExt.error != null) {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_DIFINE_ERROR", this.locale)).append("<br>").append(exprExt.parentExpr.getContent().trim()).append("<br>").append("<br>").append("<br>");
                    continue;
                }
                if (rs == null) {
                    ++subtotal;
                    continue;
                }
                sb.append('\t');
                if (!exprExt.noParsed) {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_FROM_ITEM", this.locale)).append(exprExt.parentExpr.getContent().trim()).append(RptUtil.getReportResource("REPORT_CHECK_FROM_", this.locale));
                }
                String result = this.getFormulaCheckResult(exprExt, isForExcel) + "<br>";
                result = result + this.setItemFormulaInformation(reportId, sheetName, exprExt.getContent());
                if (exprExt.logicSymbol != null && exprExt.logicSymbol.length() > 0) {
                    String des = "<font color=\"#939393\">" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"desc", (Locale)this.locale) + info + "</font>";
                    if (isForExcel) {
                        des = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"desc", (Locale)this.locale) + info;
                    }
                    result = result + "\uff1a" + exprExt.getLeftValue() + ReportCheck.toXmlString(exprExt.logicSymbol) + exprExt.getRightValue() + RptUtil.getReportResource("REPORT_CHECK_DIFF", this.locale) + exprExt.getDiffValue() + "<br>" + (info == null || info.length() < 1 ? "" : des + "<br>");
                } else if (exprExt.resultCell != null) {
                    String des = "<font color=\"#a0a0a0\">" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"desc", (Locale)this.locale) + info + "</font>";
                    if (isForExcel) {
                        des = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"desc", (Locale)this.locale) + info;
                    }
                    result = result + "\uff1a" + (exprExt.getDiffValue() == null ? exprExt.getResultValue() : exprExt.getDiffValue()) + "<br>" + (info == null || info.length() < 1 ? "" : des + "<br>");
                }
                sb.append(result).append("<br>");
            }
            if (subtotal == list.size()) {
                if (isForExcel) {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_PASSEDD", this.locale)).append("<br>");
                } else {
                    sb.append("<font color=\"#0DB004\">").append(RptUtil.getReportResource("REPORT_CHECK_PASSEDD", this.locale)).append("</font>\n");
                }
            }
            this.okCount += subtotal;
            sb.append("<br>");
        }
        if (this.okCount == this.allcount || 0 == this.allcount) {
            return null;
        }
        return sb.toString();
    }

    public HashMap exportCheckResult2(Map map) throws Exception {
        HashMap resultMap = new HashMap();
        StringBuffer sb = new StringBuffer();
        String reportId = null;
        int myOkCount = 0;
        if (map.get("reportId") != null) {
            reportId = map.get("reportId").toString();
            map.remove("reportId");
        }
        ArrayList listCheck = null;
        ArrayList listAll = new ArrayList();
        for (Map.Entry e : map.entrySet()) {
            String sheetName = (String)e.getKey();
            List list = (List)e.getValue();
            int subtotal = 0;
            for (int i = 0; i < list.size(); ++i) {
                ++this.allcount;
                ExtRptCheckExpression exprExt = (ExtRptCheckExpression)list.get(i);
                String rs = exprExt.toString();
                listCheck = this.setItemFormulaInformation2(reportId, resultMap, sheetName, exprExt.getContent());
                if (rs == null) {
                    ++subtotal;
                    continue;
                }
                listAll.addAll(listCheck);
            }
            if (subtotal == list.size()) {
                sb.append('\t').append(RptUtil.getReportResource("REPORT_CHECK_PASSEDD", this.locale)).append('\n');
            } else {
                resultMap.put(sheetName, listAll);
            }
            myOkCount += subtotal;
        }
        if (myOkCount == this.allcount) {
            return null;
        }
        return resultMap;
    }

    private String setItemFormulaInformation(final String reportId, final String sheetName, String l) throws ReportException {
        Expression exp = null;
        try {
            exp = ExcelFormulaPaserHelper.parse(l);
        }
        catch (Exception e) {
            return l;
        }
        StringBuffer sb = new StringBuffer();
        exp.output(sb, new ICustomerFormat(){
            boolean b = false;

            public boolean wrapping() {
                return this.b;
            }

            public void afterOutput(Expression ex, StringBuffer sb) {
                if (this.wrapping() && (ex instanceof ReferenceExpr || ex instanceof Ref3DExpr || ex instanceof Area3DExpr || ex instanceof AreaExpr || ex instanceof NameExpr)) {
                    sb.append("</a>");
                    this.b = false;
                }
            }

            public void beforeOutput(Expression ex, StringBuffer sb) {
                if (!this.wrapping() && (ex instanceof ReferenceExpr || ex instanceof Ref3DExpr || ex instanceof Area3DExpr || ex instanceof AreaExpr || ex instanceof NameExpr)) {
                    this.b = true;
                    if (ex.toString().indexOf("!") != -1) {
                        sb.append("<a href=\"" + reportId + "," + ReportCheck.toXmlString(ex.toString()) + "\">");
                    } else {
                        sb.append("<a href=\"" + reportId + "," + sheetName + "," + ReportCheck.toXmlString(ex.toString()) + "\">");
                    }
                }
            }

            public String formatOP(String op) {
                return ReportCheck.toXmlString(op);
            }
        });
        return sb.toString();
    }

    private ArrayList setItemFormulaInformation2(final String reportId, HashMap resultMap, final String sheetName, String s) throws Exception {
        final ArrayList list = new ArrayList();
        if (resultMap.get(sheetName) != null) {
            ArrayList listTemp = (ArrayList)resultMap.get(sheetName);
            for (int i = 0; i < listTemp.size(); ++i) {
                list.add(listTemp.get(i));
            }
        }
        Expression exp = null;
        try {
            exp = ExcelFormulaPaserHelper.parse(s);
        }
        catch (Exception e) {
            return list;
        }
        StringBuffer sb = new StringBuffer();
        exp.output(sb, new ICustomerFormat(){
            boolean b = false;

            public boolean wrapping() {
                return this.b;
            }

            public void afterOutput(Expression ex, StringBuffer sb) {
                if (this.wrapping() && (ex instanceof ReferenceExpr || ex instanceof Ref3DExpr || ex instanceof Area3DExpr || ex instanceof AreaExpr || ex instanceof NameExpr)) {
                    this.b = false;
                }
            }

            public void beforeOutput(Expression ex, StringBuffer sb) {
                if (!this.wrapping() && (ex instanceof ReferenceExpr || ex instanceof Ref3DExpr || ex instanceof Area3DExpr || ex instanceof AreaExpr || ex instanceof NameExpr)) {
                    this.b = true;
                    if (ex instanceof ReferenceExpr || ex instanceof NameExpr) {
                        list.add(reportId + "," + sheetName + "," + ex.toString());
                    }
                    if (ex instanceof Ref3DExpr) {
                        list.add(reportId + "," + ex.toString());
                    }
                    if (ex instanceof Area3DExpr) {
                        list.add(reportId + "," + ex.toString());
                    }
                    if (ex instanceof AreaExpr) {
                        list.add(reportId + "," + sheetName + "," + ex.toString());
                    }
                }
            }

            public String formatOP(String op) {
                return ReportCheck.toXmlString(op);
            }
        });
        return list;
    }

    public Map doCheck() {
        this.clearFormula();
        if (this.expTank == null) {
            return null;
        }
        Collection expressions = this.expTank.getExpressions();
        this.workBoook.setCalculate(false);
        HashMap map = new HashMap(5);
        if (expressions != null) {
            ArrayList temp = new ArrayList(expressions);
            int length = expressions.size();
            for (int i = 0; i < length; ++i) {
                List list = (List)expressions;
                RptCheckExpression chkExp = (RptCheckExpression)list.get(i);
                String expression = chkExp.getContent().trim();
                String[] exps = expression.split("\\n+");
                if (exps.length <= 1) continue;
                RptCheckExpression first = (RptCheckExpression)chkExp.clone();
                first.setContent(exps[0].trim());
                list.set(i, first);
                for (int j = 1; j < exps.length; ++j) {
                    RptCheckExpression others = (RptCheckExpression)chkExp.clone();
                    others.setContent(exps[j].trim());
                    list.add(others);
                }
            }
            for (RptCheckExpression exp : expressions) {
                Sheet sheet;
                if (StringUtils.isEmpty((String)exp.getContent()) || !this.needCheck(exp) || (sheet = this.workBoook.getSheet(exp.getSheetName())) == null) continue;
                ExtRptCheckExpression exprExt = new ExtRptCheckExpression(exp);
                ArrayList<ExtRptCheckExpression> rlst = (ArrayList<ExtRptCheckExpression>)map.get(exprExt.getSheetName());
                if (rlst == null) {
                    rlst = new ArrayList<ExtRptCheckExpression>();
                    map.put(exprExt.getSheetName(), rlst);
                }
                CheckExrepssionIterator ci = null;
                try {
                    ci = new CheckExrepssionIterator(sheet, exprExt);
                }
                catch (ParseException e) {
                    exprExt.setParseError(e.getMessage());
                    exprExt.parentExpr = exp;
                    rlst.add(exprExt);
                    continue;
                }
                while (ci.hasNext()) {
                    RptCheckExpression next = ci.next();
                    ExtRptCheckExpression my = new ExtRptCheckExpression(next);
                    if (next == exprExt) {
                        my.noParsed = true;
                    }
                    my.parentExpr = exprExt;
                    my.fillFormula(sheet);
                    rlst.add(my);
                }
            }
            this.expTank.setExpressions(temp);
        }
        this.filterReportCheckScheme(map);
        return map;
    }

    private void filterReportCheckScheme(Map map) {
        BookProperties loadFromBook = BookProperties.loadFromBook(this.workBoook);
        ReportVariables reportVariables = loadFromBook.getVariables();
        if (reportVariables != null) {
            reportVariables.add(new VariableEntry("tableInnerCheck", null, 1, "true", false));
        }
        this.workBoook.calc();
        reportVariables.remove("tableInnerCheck", null);
        for (Map.Entry e : map.entrySet()) {
            List list = (List)e.getValue();
            ArrayList<ExtRptCheckExpression> removeList = new ArrayList<ExtRptCheckExpression>();
            for (ExtRptCheckExpression exprExt : list) {
                String rs = exprExt.toString();
                if (rs == null || rs.indexOf("REPORT IS NULL") < 0) continue;
                removeList.add(exprExt);
            }
            list.removeAll(removeList);
        }
    }

    private boolean needCheck(RptCheckExpression exp) {
        if (this.currentSheet != null) {
            return this.currentSheet.equals(exp.getSheetName());
        }
        return true;
    }

    private void clearFormula() {
        int sheetCount = this.workBoook.getSheetCount();
        for (int s = 0; s < sheetCount; ++s) {
            Sheet sheet = this.workBoook.getSheet(s);
            sheet.setUserObject(REAL_MAX_ROW, (Object)new Integer(sheet.getRows().getMaxIntMark() + 1));
            sheet.setUserObject(REAL_MAX_COL, (Object)new Integer(sheet.getCols().getMaxIntMark() + 1));
            Sheet.ICellsIterator cit = sheet.getCellsIterator(null, false, true);
            while (cit.hasNext()) {
                Cell cell = cit.next();
                if (cell == null) continue;
                Variant v = cell.getValue2();
                cell.setFormula(null);
                cell.setValue(v);
            }
        }
    }

    private static String getFormula(String formula) {
        if (formula == null || formula.length() < 1 || formula.charAt(0) == '=') {
            return formula;
        }
        return "=(" + formula + ")";
    }

    public int getOkCount() {
        return this.okCount;
    }

    public int getExpressionCount() {
        return this.allcount;
    }

    public static int getRealMaxRow(Sheet sheet) {
        Object obj = sheet.getUserObjectValue(REAL_MAX_ROW);
        return (Integer)obj;
    }

    public static int getRealMaxCol(Sheet sheet) {
        Object obj = sheet.getUserObjectValue(REAL_MAX_COL);
        return (Integer)obj;
    }

    public static final ArrayList checkReport(Context ctx, ReportBaseInfo reportInfo, String currentSheetName) throws BOSException, EASBizException {
        return ReportCheck.checkReport(ctx, reportInfo, null, currentSheetName);
    }

    public static final ArrayList checkReport(Context ctx, ReportBaseInfo reportInfo, IReportPropertyAdapter adapter, String currentSheetName) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = reportInfo.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        book.setCalculate(false);
        if (adapter == null) {
            if (reportInfo instanceof ReportInfo) {
                adapter = new RptReportPropertyAdapter((ReportInfo)reportInfo);
            } else if (reportInfo instanceof CslReportInfo) {
                adapter = new CSLPropertyAdapter((CslReportInfo)reportInfo, ctx);
            }
        }
        BookProperties loadFromBook = BookProperties.loadFromBook(book);
        ReportCalculateErrorProvider err = loadFromBook.getErrorProvider();
        ReportVariables variables = loadFromBook.getVariables();
        if (variables != null) {
            variables.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
            try {
                FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new CheckContext(ctx, variables, (IReportPropertyAdapter)adapter, (IErrorProvider)err));
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        RptOperationSchemaComp operationSchema = loadFromBook.getOperationSchema();
        ArrayList<Object> result = new ArrayList<Object>(4);
        if (operationSchema == null || loadFromBook.getOperationSchema().getExpTank() == null || loadFromBook.getOperationSchema().getExpTank().getExpressions() == null || loadFromBook.getOperationSchema().getExpTank().getExpressions().size() < 1) {
            result.add(Boolean.TRUE);
            result.add(new Integer(0));
            result.add(null);
            return result;
        }
        ReportCheck.loadPostil(ctx, reportInfo, book);
        Locale locale = null;
        locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getLocale();
        ReportCheck checker = null;
        try {
            checker = new ReportCheck(book, loadFromBook.getOperationSchema().getExpTank(), locale, currentSheetName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        checker.setRealBook(book);
        Map rss = checker.doCheck();
        if (rss == null) {
            return null;
        }
        if (reportInfo.getId() != null) {
            HashMap tableInnerCheck;
            rss.put("reportId", reportInfo.getId().toString());
            String rs = checker.exportCheckResult(rss);
            rss.put("reportId", reportInfo.getId().toString());
            try {
                tableInnerCheck = checker.exportCheckResult2(rss);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            result.add(new Boolean(checker.isCheckPass));
            result.add(new Integer(checker.getExpressionCount()));
            result.add(rs);
            result.add(tableInnerCheck);
        } else if (rss.size() > 0) {
            result.add(Boolean.FALSE);
        }
        return result;
    }

    static String toXmlString(String str) {
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    static String toBookString(String str) {
        String ret = str.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    public boolean hasRptPostil(String formula, ExtRptCheckExpression parentExpr) throws Exception {
        Sheet referSheet = this.workBoook.getSheet(parentExpr.getSheetName());
        Expression expression = ExcelFormulaPaserHelper.parse(formula);
        HashSet expReferenceSheetSet = new HashSet();
        PostilCheckHandler handler = new PostilCheckHandler(expReferenceSheetSet, referSheet);
        ExcelFormulaPaserHelper.walk(expression, handler);
        if (handler.isHasPostil) {
            parentExpr.setHasPostil(true);
            return true;
        }
        for (Sheet s : expReferenceSheetSet) {
            if (s.getBook().getComment() == null) continue;
            parentExpr.setHasPostil(true);
            return true;
        }
        return false;
    }

    public Book getRealBook() {
        return this.realBook;
    }

    public void setRealBook(Book realBook) {
        this.realBook = realBook;
    }

    public static void loadPostil(Context ctx, ReportBaseInfo info, Book book) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("sheet.sheetID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report", (Object)info.getId()));
        view.setFilter(filter);
        PostilCollection postils = PostilFactory.getLocalInstance(ctx).getPostilCollection(view);
        if (postils != null && postils.size() > 0) {
            for (int i = 0; i < postils.size(); ++i) {
                PostilInfo pi = postils.get(i);
                if (pi.getPostilType() == PostilTypeEnum.REPORT) {
                    Comment ct = book.getComment();
                    if (ct != null) continue;
                    ct = new Comment();
                    book.setComment(ct);
                    continue;
                }
                if (pi.getPostilType() == PostilTypeEnum.SHEET) {
                    Sheet sheet = book.getSheetByID(pi.getSheet().getSheetID());
                    Comment ct = sheet.getComment();
                    if (ct != null) continue;
                    ct = new Comment();
                    sheet.setComment(ct);
                    continue;
                }
                if (pi.getPostilType() != PostilTypeEnum.CELL) continue;
                Rect rect = TableToolkit.range2xy(pi.getCellName());
                pi.getCellName();
                Sheet sheet = book.getSheetByID(pi.getSheet().getSheetID());
                Cell cell = sheet.getCell(rect.y1, rect.x1, true);
                Comment ct = cell.getComment();
                if (ct != null) continue;
                ct = new Comment();
                cell.setComment(ct);
            }
        }
    }

    public boolean getCheckPass() {
        return this.isCheckPass;
    }

    private class PostilCheckHandler
    implements IBreakableExpressionHandler {
        boolean isHasPostil = false;
        Sheet referSheet;
        Set expReferenceSheetSet;

        public PostilCheckHandler(Set expReferenceSheetSet, Sheet referSheet) {
            this.referSheet = referSheet;
            this.expReferenceSheetSet = expReferenceSheetSet;
        }

        @Override
        public boolean handle(Expression expr) {
            block11: {
                block13: {
                    Sheet sheet;
                    block12: {
                        block10: {
                            if (!(expr instanceof ReferenceExpr)) break block10;
                            int row = ((ReferenceExpr)expr).getRow();
                            int col = ((ReferenceExpr)expr).getCol();
                            Cell cell = this.referSheet.getCell(row, col, true);
                            if (this.referSheet.getComment() != null || cell != null && cell.getComment() != null) {
                                this.isHasPostil = true;
                                return false;
                            }
                            this.expReferenceSheetSet.add(this.referSheet);
                            break block11;
                        }
                        if (!(expr instanceof Ref3DExpr)) break block12;
                        Ref3DExpr refExpr = (Ref3DExpr)expr;
                        if (ReportCheck.this.workBoook.getSheet(refExpr.sheetName) == null) break block11;
                        ReferenceExpr referenceExpr = refExpr.ref;
                        Sheet workSheet = ReportCheck.this.workBoook.getSheet(refExpr.sheetName);
                        if (workSheet != null) {
                            this.expReferenceSheetSet.add(workSheet);
                            Cell cell = workSheet.getCell(referenceExpr.getRow(), referenceExpr.getCol(), true);
                            if (workSheet.getComment() != null || cell != null && cell.getComment() != null) {
                                this.isHasPostil = true;
                                return false;
                            }
                            this.expReferenceSheetSet.add(workSheet);
                        }
                        break block11;
                    }
                    if (!(expr instanceof Area3DExpr)) break block13;
                    Area3DExpr area3DExpr = (Area3DExpr)expr;
                    if (ReportCheck.this.workBoook.getSheet(area3DExpr.sheetName) == null || (sheet = ReportCheck.this.workBoook.getSheet(area3DExpr.sheetName)) == null) break block11;
                    AreaExpr area = area3DExpr.area;
                    for (int row = area.getStart_row(); row <= area.getEnd_row(); ++row) {
                        for (int col = 0; col <= area.getEnd_col(); ++col) {
                            Cell cell = sheet.getCell(row, col, true);
                            if (sheet.getComment() != null || cell != null && cell.getComment() != null) {
                                this.isHasPostil = true;
                                return false;
                            }
                            this.expReferenceSheetSet.add(sheet);
                        }
                    }
                    break block11;
                }
                if (expr instanceof AreaExpr) {
                    AreaExpr area = (AreaExpr)expr;
                    for (int row = area.getStart_row(); row <= area.getEnd_row(); ++row) {
                        for (int col = 0; col <= area.getEnd_col(); ++col) {
                            Cell cell = this.referSheet.getCell(row, col, true);
                            if (this.referSheet.getComment() != null || cell != null && cell.getComment() != null) {
                                this.isHasPostil = true;
                                return false;
                            }
                            this.expReferenceSheetSet.add(this.referSheet);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static class CheckContext
    implements ICalculateContextProvider {
        private static final long serialVersionUID = 1L;
        Context ctx;
        ReportVariables v;
        IReportPropertyAdapter adapter;
        IErrorProvider err;

        public CheckContext(Context ctx, ReportVariables v, IReportPropertyAdapter adapter, IErrorProvider err) {
            this.ctx = ctx;
            this.v = v;
            this.adapter = adapter;
            this.err = err;
        }

        public Context getServerContext() {
            return this.ctx;
        }

        public ReportVariables getReportVariables() {
            return this.v;
        }

        public IReportPropertyAdapter getReportAdapter() {
            return this.adapter;
        }

        public IErrorProvider getErrorProvider() {
            return this.err;
        }

        public IErrorResultProvider getErrorResultProvider() {
            return null;
        }
    }

    private class ExtRptCheckExpression
    extends RptCheckExpression {
        public boolean noParsed;
        private Cell leftCell;
        private Cell rightCell;
        private Cell resultCell;
        private Cell diffCell;
        private List ifCell;
        private List ifFormulas;
        private String logicSymbol;
        private RptCheckExpression parentExpr = null;
        private String error;
        private boolean isHasPostil = false;
        private boolean isUnary = false;
        private FunctionExpr finalIfExpr;

        ExtRptCheckExpression(RptCheckExpression expr) {
            this.copyFrom(expr);
        }

        public void setParseError(String message) {
            this.error = message;
        }

        public void fillFormula(Sheet sheet) {
            sheet.getCell(ReportCheck.getRealMaxRow(sheet) + 10000, 1, true);
            int row = sheet.getRows().getMaxIntMark();
            ++row;
            String formula = this.getContent().trim();
            Expression exp = null;
            try {
                exp = ExcelFormulaPaserHelper.parse(formula);
                BreakableExpressionHandler handler = new BreakableExpressionHandler();
                ExcelFormulaPaserHelper.walk(exp, handler);
                if (!handler.isOK) {
                    this.setParseError(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"75_ReportCheck", (Locale)ReportCheck.this.locale));
                    return;
                }
            }
            catch (Exception e) {
                this.setParseError(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"75_ReportCheck", (Locale)ReportCheck.this.locale));
                return;
            }
            String[] exps = null;
            if (!(exp instanceof UnaryOperationExpr) && exp instanceof BinaryOperationExpr) {
                BinaryOperationExpr bo = (BinaryOperationExpr)exp;
                exps = new String[3];
                exps[1] = bo.right.toString();
                exps[0] = bo.left.toString();
                exps[2] = bo.getOperation();
            }
            if (exps == null) {
                this.isUnary = true;
            }
            Set ifSet = this.gatherExprFromIfFunc(exp, new HashSet());
            int columnIndex = 4;
            Iterator iterator = ifSet.iterator();
            while (iterator.hasNext()) {
                if (this.ifCell == null) {
                    this.ifCell = new ArrayList();
                    this.ifFormulas = new ArrayList();
                }
                String ifFormula = (String)iterator.next();
                Cell cell = sheet.getCell(row, columnIndex++, true);
                cell.setFormula(ifFormula);
                this.ifCell.add(cell);
                this.ifFormulas.add(ifFormula);
            }
            if (!this.isUnary) {
                this.leftCell = sheet.getCell(row, 0, true);
                this.rightCell = sheet.getCell(row, 1, true);
                this.resultCell = sheet.getCell(row, 2, true);
                this.diffCell = sheet.getCell(row, 3, true);
                this.leftCell.setFormula(ReportCheck.getFormula(exps[0]));
                this.rightCell.setFormula(ReportCheck.getFormula(exps[1]));
                this.resultCell.setFormula(ReportCheck.getFormula(formula));
                this.diffCell.setFormula(ReportCheck.getFormula("(" + exps[0] + ")-(" + exps[1] + ")"));
                this.logicSymbol = exps[2];
            } else {
                this.resultCell = sheet.getCell(row, 2, true);
                this.resultCell.setFormula(ReportCheck.getFormula(formula));
            }
        }

        public Object getLeftValue() {
            if (this.leftCell == null || this.leftCell.getValue() == null || this.leftCell.getValue().getValue() == null) {
                return "0";
            }
            return this.leftCell.getValue();
        }

        public Object getRightValue() {
            if (this.rightCell != null && this.rightCell.getValue() != null && this.rightCell.getValue().getValue() != null) {
                return this.rightCell.getValue();
            }
            return "0";
        }

        public Object getResultValue() {
            if (this.resultCell != null && this.resultCell.getValue() != null && this.resultCell.getValue().getValue() != null) {
                return this.getResultValueByResultFormula(this.resultCell.getFormula());
            }
            return "0";
        }

        private Object getResultValueByResultFormula(String formula) {
            Variant result = this.resultCell.getValue();
            try {
                Expression expression = ExcelFormulaPaserHelper.parse(formula);
                Map ifMap = this.getIFMap(this.ifCell, this.ifFormulas);
                this.walk(expression, ifMap);
                String finalResult = this.getFinalResult(ifMap);
                return finalResult == null ? result : finalResult;
            }
            catch (Exception e) {
                return result;
            }
        }

        private Map getIFMap(List ifCell2, List ifFormulas2) {
            HashMap result = new HashMap();
            Variant value = null;
            for (int i = 0; i < ifCell2.size(); ++i) {
                boolean isException;
                value = ((Cell)ifCell2.get(i)).getValue();
                boolean isNUll = value.getValue() == null && value.isNull();
                boolean bl = isException = value.getValue() != null && value.getValue().toString().indexOf("REPORT IS NULL") >= 0;
                if (value != null && (isNUll || isException)) {
                    value = Variant.zeroVariant;
                }
                result.put(ifFormulas2.get(i), value);
            }
            return result;
        }

        public void walk(Expression exp, Map ifMap) {
            if (exp instanceof BinaryOperationExpr) {
                this.walk(((BinaryOperationExpr)exp).left, ifMap);
                this.walk(((BinaryOperationExpr)exp).right, ifMap);
            } else if (exp instanceof UnaryOperationExpr) {
                this.walk(((UnaryOperationExpr)exp).operand, ifMap);
            } else if (exp instanceof FunctionExpr) {
                if (((FunctionExpr)exp).funcionName.equalsIgnoreCase("if")) {
                    this.finalIfExpr = (FunctionExpr)exp;
                    Expression condition = (Expression)this.finalIfExpr.parameters.get(0);
                    Sheet sheet = ReportCheck.this.workBoook.getSheet(this.getSheetName());
                    if (sheet == null) {
                        List ps = ((FunctionExpr)exp).parameters;
                        for (int i = 0; i < ps.size(); ++i) {
                            this.walk((Expression)ps.get(i), ifMap);
                        }
                    }
                    Variant variant = this.getResultFromExpr(ifMap, condition, sheet);
                    boolean result = false;
                    try {
                        result = variant.toBoolean();
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                        // empty catch block
                    }
                    FunctionExpr temp = this.finalIfExpr;
                    if (result && this.finalIfExpr.parameters.size() > 1) {
                        this.walk((Expression)this.finalIfExpr.parameters.get(1), ifMap);
                    } else if (this.finalIfExpr.parameters.size() > 2) {
                        this.walk((Expression)this.finalIfExpr.parameters.get(2), ifMap);
                    }
                    if (temp == this.finalIfExpr) {
                        this.walk(condition, ifMap);
                    }
                } else {
                    List ps = ((FunctionExpr)exp).parameters;
                    for (int i = 0; i < ps.size(); ++i) {
                        this.walk((Expression)ps.get(i), ifMap);
                    }
                }
            } else if (exp instanceof Area3DExpr) {
                this.walk(((Area3DExpr)exp).area, ifMap);
            } else if (exp instanceof Ref3DExpr) {
                this.walk(((Ref3DExpr)exp).ref, ifMap);
            }
        }

        private Variant getResultFromExpr(Map ifMap, Expression expr, Sheet sheet) {
            String formula = ReportCheck.getFormula(expr.toString());
            Variant variant = null;
            if (expr instanceof BinaryOperationExpr) {
                String rightFormula;
                Variant right;
                String leftFormula;
                Variant left;
                BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr;
                if (binaryExpr.left instanceof FunctionExpr) {
                    ((FunctionExpr)binaryExpr.left).funcionName = ((FunctionExpr)binaryExpr.left).funcionName.toUpperCase();
                }
                if ((left = (Variant)ifMap.get(ReportCheck.getFormula(leftFormula = binaryExpr.left.toString()))) != null) {
                    formula = formula.replaceAll(this.prepareStringForReplace(leftFormula), left.toString());
                }
                if (binaryExpr.right instanceof FunctionExpr) {
                    ((FunctionExpr)binaryExpr.right).funcionName = ((FunctionExpr)binaryExpr.right).funcionName.toUpperCase();
                }
                if ((right = (Variant)ifMap.get(ReportCheck.getFormula(rightFormula = binaryExpr.right.toString()))) != null) {
                    formula = formula.replaceAll(this.prepareStringForReplace(rightFormula), right.toString());
                }
                variant = sheet.calcFormula(formula);
            } else {
                variant = (Variant)ifMap.get(formula);
            }
            return variant;
        }

        private String prepareStringForReplace(String string) {
            StringBuffer sb = new StringBuffer();
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                char charAt = string.charAt(i);
                if (charAt == '(' || charAt == ')') {
                    sb.append("\\");
                }
                sb.append(charAt);
            }
            return sb.toString();
        }

        private Set gatherExprFromIfFunc(Expression exp, Set exprSet) {
            if (exp instanceof FunctionExpr) {
                FunctionExpr funcExpr = (FunctionExpr)exp;
                if (((FunctionExpr)exp).funcionName.equalsIgnoreCase("if")) {
                    Expression ifParam = (Expression)funcExpr.parameters.get(0);
                    this.gatherExprInsideIF(exprSet, ifParam);
                    if (funcExpr.parameters.size() > 1) {
                        ifParam = (Expression)funcExpr.parameters.get(1);
                        this.gatherExprInsideIF(exprSet, ifParam);
                    }
                    if (funcExpr.parameters.size() > 2) {
                        ifParam = (Expression)funcExpr.parameters.get(2);
                        this.gatherExprInsideIF(exprSet, ifParam);
                    }
                } else {
                    funcExpr.funcionName = funcExpr.funcionName.toUpperCase();
                    exprSet.add(ReportCheck.getFormula(exp.toString()));
                    List ps = ((FunctionExpr)exp).parameters;
                    for (int i = 0; i < ps.size(); ++i) {
                        this.gatherExprFromIfFunc((Expression)ps.get(i), exprSet);
                    }
                }
            } else {
                this.gatherExprInsideIF(exprSet, exp);
            }
            return exprSet;
        }

        private void gatherExprInsideIF(Set exprSet, Expression ifParam) {
            if (ifParam instanceof FunctionExpr && ((FunctionExpr)ifParam).funcionName.equalsIgnoreCase("if")) {
                this.gatherExprFromIfFunc(ifParam, exprSet);
            } else if (ifParam instanceof BinaryOperationExpr) {
                this.gatherExprFromIfFunc(((BinaryOperationExpr)ifParam).left, exprSet);
                this.gatherExprFromIfFunc(((BinaryOperationExpr)ifParam).right, exprSet);
            } else if (ifParam instanceof UnaryOperationExpr) {
                this.gatherExprFromIfFunc(((UnaryOperationExpr)ifParam).operand, exprSet);
            } else if (ifParam instanceof FunctionExpr) {
                FunctionExpr funcExpr = (FunctionExpr)ifParam;
                funcExpr.funcionName = funcExpr.funcionName.toUpperCase();
                exprSet.add(ReportCheck.getFormula(ifParam.toString()));
            } else {
                exprSet.add(ReportCheck.getFormula(ifParam.toString()));
            }
        }

        public String getFinalResult(Map ifMap) {
            if (this.finalIfExpr == null) {
                return null;
            }
            Expression condition = (Expression)this.finalIfExpr.parameters.get(0);
            Sheet sheet = ReportCheck.this.workBoook.getSheet(this.getSheetName());
            Variant variant = this.getResultFromExpr(ifMap, condition, sheet);
            boolean result = false;
            try {
                result = variant.toBoolean();
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
            int exp = result ? 2 : 1;
            ArrayList binaryOperationExprList = new ArrayList();
            for (int i = 0; i < this.finalIfExpr.parameters.size(); ++i) {
                Object parameter;
                if (i == exp || !((parameter = this.finalIfExpr.parameters.get(i)) instanceof BinaryOperationExpr)) continue;
                binaryOperationExprList.add(parameter);
            }
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"97_ReportCheck");
            if (binaryOperationExprList.size() > 0) {
                Collections.reverse(binaryOperationExprList);
                for (BinaryOperationExpr finalBinaryOperationExpr : binaryOperationExprList) {
                    BigDecimal right;
                    BigDecimal left;
                    block13: {
                        Variant[] results;
                        block12: {
                            results = new Variant[]{this.getResultFromExpr(ifMap, finalBinaryOperationExpr.left, sheet), this.getResultFromExpr(ifMap, finalBinaryOperationExpr.right, sheet)};
                            left = new BigDecimal(0.0);
                            try {
                                if (results[0].getValue() != null && !StringUtils.isEmpty((String)results[0].getValue().toString())) {
                                    left = new BigDecimal(results[0].getValue().toString());
                                }
                            }
                            catch (RuntimeException e) {
                                if (results[0].getValue().equals(results[1].getValue())) break block12;
                                return MessageFormat.format(msg, results[0].getValue(), finalBinaryOperationExpr.getOperation(), results[1].getValue(), results[0].getValue());
                            }
                        }
                        right = new BigDecimal(0.0);
                        try {
                            if (results[1].getValue() != null && !StringUtils.isEmpty((String)results[1].getValue().toString())) {
                                right = new BigDecimal(results[1].getValue().toString());
                            }
                        }
                        catch (RuntimeException e) {
                            if (results[1].getValue().equals(results[0].getValue())) break block13;
                            return MessageFormat.format(msg, results[0].getValue(), finalBinaryOperationExpr.getOperation(), results[1].getValue(), results[1].getValue());
                        }
                    }
                    if (left.equals(right)) continue;
                    return MessageFormat.format(msg, left, finalBinaryOperationExpr.getOperation(), right, left.subtract(right).toString());
                }
            }
            return null;
        }

        public Variant getDiffValue() {
            if (this.diffCell != null && this.diffCell.getValue() != null) {
                return this.diffCell.getValue();
            }
            return null;
        }

        public boolean resultIsNumberic() {
            return this.isNumberic(this.leftCell.getValue()) && this.isNumberic(this.rightCell.getValue());
        }

        private boolean isNumberic(Variant v) {
            if (v == null || v.getValue() == null) {
                return true;
            }
            return v.isNumeric();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (!StringUtils.isEmpty((String)this.getDescription())) {
                sb.append(this.getDescription()).append(" [").append(this.getContent()).append("]");
            } else {
                sb.append(" [").append(this.getContent()).append("]");
            }
            sb.append(": ");
            if (this.resultCell == null) {
                sb.append(RptUtil.getReportResource("REPORT_CHECK_EXPRESSION_ERROR", ReportCheck.this.locale));
            } else {
                if (this.checkPassed()) {
                    return null;
                }
                if (this.getCheckResultState() != 2) {
                    if (this.getCheckResultState() == 1) {
                        ReportCheck.this.isCheckPass = false;
                    } else {
                        try {
                            if (!ReportCheck.this.hasRptPostil(this.getContent().trim(), this)) {
                                ReportCheck.this.isCheckPass = false;
                            }
                        }
                        catch (Exception e) {
                            ReportCheck.this.isCheckPass = false;
                            ExceptionHandler.handle((String)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (this.isUnary) {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_ERROR", ReportCheck.this.locale));
                    sb.append(this.getResultValue());
                } else {
                    sb.append(RptUtil.getReportResource("REPORT_CHECK_ERROR", ReportCheck.this.locale)).append(this.getLeftValue()).append(" ").append(this.logicSymbol).append(" ").append(this.getRightValue()).append(" ");
                    if (this.resultIsNumberic()) {
                        sb.append(RptUtil.getReportResource("REPORT_CHECK_DIFF", ReportCheck.this.locale)).append(" ").append(this.getDiffValue());
                    }
                }
            }
            return sb.toString();
        }

        boolean checkPassed() {
            boolean passed = true;
            if (this.leftCell != null && this.leftCell.getValue() != null && (this.leftCell.getValue().toString().indexOf("REPORT IS NULL") > 0 || this.rightCell.getValue().toString().indexOf("REPORT IS NULL") > 0)) {
                return true;
            }
            try {
                passed = this.resultCell.getValue().booleanValue();
            }
            catch (SyntaxErrorException e) {
                return false;
            }
            int nullCount = 0;
            if (!passed && !this.isUnary) {
                Variant right;
                Variant left;
                Variant variant = left = this.leftCell == null ? null : this.leftCell.getValue();
                if (this.leftCell == null || left.isNull() || left.isString() && left.toString().equals("")) {
                    left = new Variant((Object)new BigDecimal(0.0));
                    ++nullCount;
                }
                Variant variant2 = right = this.rightCell == null ? null : this.rightCell.getValue();
                if (right == null || right.isNull() || right.isString() && right.toString().equals("")) {
                    right = new Variant((Object)new BigDecimal(0.0));
                    ++nullCount;
                }
                if (nullCount == 0) {
                    return passed;
                }
                boolean eq = left.equals(right);
                return (this.logicSymbol.equals("=") || this.logicSymbol.equals(">=") || this.logicSymbol.equals("<=")) && eq;
            }
            return passed;
        }

        protected RptCheckExpression getParentExpr() {
            return this.parentExpr;
        }

        protected void setParentExpr(RptCheckExpression parentExpr) {
            this.parentExpr = parentExpr;
        }

        public boolean isHasPostil() {
            return this.isHasPostil;
        }

        public void setHasPostil(boolean isHasPostil) {
            this.isHasPostil = isHasPostil;
        }

        private final class BreakableExpressionHandler
        implements IBreakableExpressionHandler {
            String sheetName = null;
            boolean isOK = true;

            private BreakableExpressionHandler() {
            }

            @Override
            public boolean handle(Expression expr) {
                String sheet = null;
                if (expr instanceof Ref3DExpr) {
                    sheet = ((Ref3DExpr)expr).sheetName;
                } else if (expr instanceof Area3DExpr) {
                    sheet = ((Area3DExpr)expr).sheetName;
                }
                if (sheet == null) {
                    return true;
                }
                if (ReportCheck.this.workBoook.getSheet(sheet) == null) {
                    this.sheetName = sheet;
                    this.isOK = false;
                    return false;
                }
                return true;
            }
        }
    }
}

