/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.k3.calc;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.k3.calc.K3CalcBase;
import com.kingdee.eas.fi.rpt.k3.calc.K3FormulaBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class K3AcctExtCalc
extends K3CalcBase {
    private static Logger logger = Logger.getLogger((String)K3AcctExtCalc.class.getName());
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public K3AcctExtCalc(Context srvCtx, ICalculateContextProvider calcCtx) {
        super(srvCtx, calcCtx);
    }

    @Override
    protected String getK3ParamText(K3FormulaBase formula) {
        StringBuffer sb = new StringBuffer();
        if (formula instanceof K3AcctExt) {
            K3AcctExt ext = (K3AcctExt)formula;
            sb.append(ext.account);
            sb.append(",");
            sb.append(ext.oppaccount);
            sb.append(",");
            sb.append(ext.customFilter);
            sb.append(",");
            sb.append(ext.balDataType);
            sb.append(",");
            sb.append(ext.currency);
            sb.append(",");
            sb.append(ext.startdate);
            sb.append(",");
            sb.append(ext.enddate);
            sb.append(",");
            sb.append(ext.isInPost ? "Y" : "N");
        }
        return sb.toString();
    }

    @Override
    protected K3FormulaBase initParam(Parameter p) {
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        String sheetName = p.getSheetName();
        String startdate = (String)((Variant)args[5]).getValue();
        String enddate = (String)((Variant)args[6]).getValue();
        startdate = StringUtils.isEmpty((String)startdate) ? format.format(this.getBatchHelper().getReport_StartDate()) : startdate;
        enddate = StringUtils.isEmpty((String)enddate) ? format.format(this.getBatchHelper().getReport_EndDate()) : enddate;
        boolean isInPost = this.getBatchHelper().isSheet_IncludePosted(sheetName);
        String currency = (String)((Variant)args[4]).getValue();
        currency = StringUtils.isEmpty((String)currency) ? this.getBatchHelper().getCorrect_Currency_Number(sheetName) : currency;
        int rptPeriodType = this.getBatchHelper().getReport_PeriodType();
        int year = this.getBatchHelper().getReport_Year();
        int period = this.getBatchHelper().getReport_Period();
        Date date = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)rptPeriodType));
        startdate = StringUtils.isEmpty((String)startdate) ? format.format(date) : startdate;
        enddate = StringUtils.isEmpty((String)enddate) ? format.format(date) : enddate;
        String formulaSdsn = (String)((Variant)args[7]).getValue();
        formulaSdsn = this.getAccountSdsn(formulaSdsn);
        K3AcctExt ext = new K3AcctExt();
        String customFilter = (String)((Variant)args[2]).getValue();
        if (!StringUtils.isEmpty((String)customFilter)) {
            ext.setHashException(true);
            ext.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"314notSupportUserDefinedFilter", (Locale)this.srvCtx.getOriginLocale())));
            return ext;
        }
        ext.account = (String)((Variant)args[0]).getValue();
        ext.oppaccount = (String)((Variant)args[1]).getValue();
        ext.customFilter = "";
        ext.balDataType = (String)((Variant)args[3]).getValue();
        ext.currency = currency;
        ext.startdate = startdate;
        ext.enddate = enddate;
        ext.isInPost = isInPost;
        ext.setFormulaSdsn(StringUtils.isEmpty((String)formulaSdsn) ? this.getCurrentCompanySdsn() : formulaSdsn);
        this.validate(ext);
        return ext;
    }

    protected void validate(K3AcctExt acct) {
        if (StringUtils.isEmpty((String)acct.account)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"313inputAccount", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)acct.balDataType)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"312inputBalDataType", (Locale)this.srvCtx.getOriginLocale())));
        }
    }

    @Override
    protected String getK3MethodName() {
        return "acctExt";
    }

    class K3AcctExt
    extends K3FormulaBase {
        String account;
        String oppaccount;
        String customFilter;
        String balDataType;
        String currency;
        String startdate;
        String enddate;
        boolean isInPost;

        K3AcctExt() {
        }
    }
}

