/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.k3.calc;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.k3.calc.K3CalcBase;
import com.kingdee.eas.fi.rpt.k3.calc.K3FormulaBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class K3RefCalc
extends K3CalcBase {
    public K3RefCalc(Context srvCtx, ICalculateContextProvider calcCtx) {
        super(srvCtx, calcCtx);
    }

    @Override
    protected K3FormulaBase initParam(Parameter p) {
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        String sdsn = (String)((Variant)args[3]).getValue();
        sdsn = this.getAccountSdsn(sdsn);
        K3Ref ref = new K3Ref();
        ref.reprot = (String)((Variant)args[0]).getValue();
        ref.cell = (String)((Variant)args[1]).getValue();
        ref.sheet = (String)((Variant)args[2]).getValue();
        ref.setFormulaSdsn(StringUtils.isEmpty((String)sdsn) ? this.getCurrentCompanySdsn() : sdsn);
        this.validate(ref);
        return ref;
    }

    protected void validate(K3Ref ref) {
        if (StringUtils.isEmpty((String)ref.reprot)) {
            ref.setHashException(true);
            ref.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"319inputReportName", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)ref.sheet)) {
            ref.setHashException(true);
            ref.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"320inputSheetName", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)ref.cell)) {
            ref.setHashException(true);
            ref.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"321inputCellName", (Locale)this.srvCtx.getOriginLocale())));
        }
    }

    @Override
    protected String getK3ParamText(K3FormulaBase formula) {
        StringBuffer sb = new StringBuffer();
        if (formula instanceof K3Ref) {
            K3Ref ref = (K3Ref)formula;
            sb.append(ref.reprot);
            sb.append(",");
            sb.append(ref.cell);
            sb.append(",");
            sb.append(ref.sheet);
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    protected String getK3MethodName() {
        return "ref_f";
    }

    class K3Ref
    extends K3FormulaBase {
        String reprot;
        String cell;
        String sheet;

        K3Ref() {
        }
    }
}

