/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.rptdata;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.fi.rpt.ISQLQueryable;
import com.kingdee.eas.fi.rpt.rptdata.RptDataInfo2DBFieldMapping;
import com.kingdee.eas.fi.rpt.rptdata.RptDataUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class RptDataQuery
implements ISQLQueryable,
Serializable {
    private static final long serialVersionUID = -5756323249501972289L;
    private static final Logger log = Logger.getLogger(RptDataQuery.class);
    private StringBuffer sql = new StringBuffer();
    private List<Object> params = new LinkedList<Object>();
    private String queryType;

    public RptDataQuery(EntityViewInfo mainQueryPara) {
        EntityViewInfo mainQuery = (EntityViewInfo)mainQueryPara.clone();
        if (mainQuery == null) {
            mainQuery = new EntityViewInfo();
            mainQuery.setFilter(new FilterInfo());
        } else if (mainQuery.getFilter() == null) {
            mainQuery.setFilter(new FilterInfo());
        }
        log.info((Object)("[rptData]mainQuery:" + mainQuery));
        boolean orderByCalcNum = this.isOrderByCalcNumByFilter(mainQuery);
        String topNum = this.readTopNum(mainQuery);
        log.info((Object)("[rptData]topNum:" + topNum));
        String sqlPath = "query.sql";
        if (orderByCalcNum) {
            sqlPath = "queryByOrderCalcNum.sql";
        }
        log.info((Object)("[rptData]QueryType:" + sqlPath));
        this.setQueryType(sqlPath);
        String formatSQL = this.getSql(sqlPath);
        this.removeStatusFilterItem(mainQuery);
        log.info((Object)("[rptData]after remove,mainQuery:" + mainQuery));
        String whereSQL = this.toSql(mainQuery.getFilter(), this.getQueryType());
        log.info((Object)("[rptData]whereSQL:" + whereSQL));
        whereSQL = !StringUtils.isEmpty((String)whereSQL) ? " WHERE " + whereSQL : "";
        log.info((Object)("[rptData]formatSQL:" + formatSQL));
        String currStr = MessageFormat.format(formatSQL, whereSQL, topNum);
        if (!mainQuery.getSorter().isEmpty()) {
            this.sql.append(" SELECT * FROM ( ");
            this.sql.append(currStr);
            this.sql.append(" ) ");
            this.sql.append(" ORDER BY ");
            this.sql.append(mainQuery.getSorter().toOQL());
        } else {
            this.sql.append(currStr);
        }
        log.info((Object)("[rptData]sql:" + this.sql));
    }

    private void removeStatusFilterItem(EntityViewInfo mainQuery) {
        FilterItemCollection filterItems = mainQuery.getFilter().getFilterItems();
        for (int i = filterItems.size() - 1; i > 0; --i) {
            if (!"rptTopNum".equalsIgnoreCase(filterItems.get(i).getPropertyName()) && !"OrderStyle".equalsIgnoreCase(filterItems.get(i).getPropertyName())) continue;
            filterItems.removeObject(i);
            RptDataUtil.removeMaskString(mainQuery.getFilter(), i);
        }
    }

    private String readTopNum(EntityViewInfo mainQuery) {
        FilterItemCollection filterItems = mainQuery.getFilter().getFilterItems();
        for (int i = filterItems.size() - 1; i > 0; --i) {
            if (!"rptTopNum".equalsIgnoreCase(filterItems.get(i).getPropertyName())) continue;
            return filterItems.get(i).getCompareValue().toString();
        }
        return "10";
    }

    private boolean isOrderByCalcNumByFilter(EntityViewInfo mainQuery) {
        FilterItemCollection filterItems = mainQuery.getFilter().getFilterItems();
        for (int i = filterItems.size() - 1; i > 0; --i) {
            if (!new FilterItemInfo("OrderStyle", (Object)"OrderByCalcNum").toString().equals(filterItems.get(i).toString())) continue;
            return true;
        }
        return false;
    }

    private String toSql(FilterInfo filter, String queryType) {
        FilterInfo newFilterInfo = (FilterInfo)filter.clone();
        newFilterInfo.setMaskString(filter.getMaskString());
        FilterItemCollection filters = newFilterInfo.getFilterItems();
        FilterItemInfo filterItemInfo = null;
        String fieldName = null;
        String dbFieldName = null;
        for (int i = 0; i < filters.size(); ++i) {
            filterItemInfo = filters.get(i);
            fieldName = filterItemInfo.getPropertyName();
            dbFieldName = this.convertField2DBField(fieldName, queryType);
            filterItemInfo.setPropertyName(dbFieldName);
        }
        return newFilterInfo.toSql();
    }

    private String convertField2DBField(String fieldName, String queryType) {
        String dbField = fieldName;
        if (fieldName.indexOf(".") == -1) {
            dbField = new RptDataInfo2DBFieldMapping().getDBField(fieldName);
            if ("query.sql".equalsIgnoreCase(queryType)) {
                dbField = "TD." + dbField;
            } else if ("queryByOrderCalcNum.sql".equalsIgnoreCase(queryType)) {
                dbField = "TD." + dbField;
            }
        }
        return dbField;
    }

    public RptDataQuery(String sqlFileName, Object[] params) {
        this.sql.append(this.getSql(sqlFileName));
        this.params = Arrays.asList(params);
        this.setQueryType("GeneralSQL");
    }

    @Override
    public String getSQL() {
        return this.sql.toString();
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    private String getSql(String fileName) {
        if ("query.sql".equalsIgnoreCase(fileName)) {
            return this.getSqlForOrderByTimeDiff();
        }
        if ("queryByOrderCalcNum.sql".equalsIgnoreCase(fileName)) {
            return this.getSqlForOrderByCalcNum();
        }
        return "";
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    protected String getSqlForOrderByTimeDiff() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT\tTOP {1} \t\t\t\t\n");
        sql.append("\tCT.FID \t\t,\t\t\t\t\n");
        sql.append("\tCT.FRptId \t ,\t\t\t\t\n");
        sql.append("\tCT.FRptName ,\t\t\t\t\n");
        sql.append("\tCT.FRptNumber \t,\t\t\t\n");
        sql.append("\tCT.FRptYear ,\t\t\t\t\n");
        sql.append("\tCT.FRptPeriod ,\t\t\t\t\n");
        sql.append("\tCT.FRptPeriodType ,\t\t\t\n");
        sql.append("\tCT.FRptSourceType ,\t\t\t\n");
        sql.append("\tCT.FCompanyId ,\t\t\t\t\n");
        sql.append("\tCT.FCompanyNumber ,\t\t\t\n");
        sql.append("\tCT.FCompanyName,\t\t\t\n");
        sql.append("\tCT.FUserId \t,\t\t\t\t\n");
        sql.append("\tCT.FUserNumber \t,\t\t\t\n");
        sql.append("\tCT.FUserName ,\t\t\t\t\n");
        sql.append("\tCT.FUserIp \t,\t\t\t\t\n");
        sql.append("\tCT.FTotalFormulaNum ,\t\t\n");
        sql.append("\tCT.FFormulaDetail ,\t\t\t\n");
        sql.append("\tCT.FCalcStartTime ,\t\t\t\n");
        sql.append("\tCT.FCalcFinishTime,\t\t\t\n");
        sql.append("\tCT.FServerCalcStartTime,\t\n");
        sql.append("\tCT.FServerCalcFinishTime,\t\n");
        sql.append("\tCT.FRptCurrencyNumber, \t\t\n");
        sql.append("\tCT.FRptCurrencyName_L1, \t\n");
        sql.append("\tCT.FRptCurrencyName_L2, \t\n");
        sql.append("\tCT.FRptCurrencyName_L3\t\t\n");
        sql.append("FROM\tT_RPT_RptData CT\t\t\n");
        sql.append("INNER JOIN (\t\t\t\t\t\n");
        sql.append("\tSELECT\t\t\t\t\t\t\n");
        sql.append("\t\tTD.FRptId,\t\t\t\t\n");
        sql.append("\t\tMAX(\t\t\t\t\t\n");
        sql.append("\t\t\tCASE \t\t\t\t\n");
        sql.append("\t\t\t\tWHEN TD.FCalcFinishTime is null THEN\t\t\t\t\t\t\n");
        sql.append("\t\t\t\t\tCONCAT('99',TD.FId)\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("\t\t\t\tELSE\t\t\t\n");
        sql.append("\t\t\t\t\tconcat(\t\t\n");
        sql.append("\t\t\t\t\t\tcase \t\n");
        sql.append("\t\t\t\t\t\t\twhen length(tochar(TD.FCalcFinishTime)) < 10 then \t\t\n");
        sql.append("\t\t\t\t\t\t\t\tconcat('0',tochar(length(tochar(TD.FCalcFinishTime))))\t\n");
        sql.append("\t\t\t\t\t\t\telse \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t\t\t\ttochar(length(tochar(TD.FCalcFinishTime)))\t\n");
        sql.append("\t\t\t\t\t\tend,\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t\ttochar(TD.FCalcFinishTime)\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t)\t\t\t\n");
        sql.append("\t\t\tEND\t\t\t\t\t\n");
        sql.append("\t\t) FCalcFinishTime\t\t\n");
        sql.append("\tfrom\tT_RPT_RptData TD\t\n");
        sql.append("\t{0}\t\t\t\t\t\t\t\n");
        sql.append("\tgroup by TD.FRptId\t\t\t\n");
        sql.append(") MAX_T\t\t\t\t\t\t\t\n");
        sql.append("ON (CT.FRptId = MAX_T.FRptId\t\t\t\t\t\n");
        sql.append("\tAND(\tMAX_T.FCalcFinishTime = (\t\t\t\n");
        sql.append("\t\t\t\tCASE \t\t\t\t\t\t\t\n");
        sql.append("\t\t\t\t\tWHEN CT.FCalcFinishTime is null THEN\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t\tCONCAT('99',CT.FId)\t\t\n");
        sql.append("\t\t\t\t\tELSE\t\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t\tconcat(\t\t\t\t\t\n");
        sql.append("\t\t\t\t\t\t\tcase \t\t\t\t\n");
        sql.append("\t\t\t\t\t\t\t\twhen length(tochar(CT.FCalcFinishTime)) < 10 then \t\n");
        sql.append("\t\t\t\t\t\t\t\t\tconcat('0',tochar(length(tochar(CT.FCalcFinishTime))))\t\n");
        sql.append("\t\t\t\t\t\t\t\telse \t\t\t\n");
        sql.append("\t\t\t\t\t\t\t\t\ttochar(length(tochar(CT.FCalcFinishTime)))\t\t\t\t\n");
        sql.append("\t\t\t\t\t\t\tend,\t\t\t\t\n");
        sql.append("\t\t\t\t\t\t\ttochar(CT.FCalcFinishTime)\t\t\t\t\n");
        sql.append("\t\t\t\t\t\t)\t\t\t\t\t\t\n");
        sql.append("\t\t\t\tEND\t\t\t\t\n");
        sql.append("\t\t\t)\t\t\t\t\t\n");
        sql.append("\t)\t\t\t\t\t\t\t\n");
        sql.append(")\t\t\t\t\t\t\t\t\n");
        sql.append("ORDER BY (\t\t\t\t\t\t\n");
        sql.append("\tCASE \t\t\t\t\t\t\n");
        sql.append("\t\tWHEN CT.FCalcFinishTime is null THEN\t\t\t\t\t\t\t\t\n");
        sql.append("\t\t\tCONCAT('99',CT.FId)\t\n");
        sql.append("\t\tELSE\t\t\t\t\t\n");
        sql.append("\t\t\tconcat(\t\t\t\t\n");
        sql.append("\t\t\t\tcase \t\t\t\n");
        sql.append("\t\t\t\t\twhen length(tochar(CT.FCalcFinishTime)) < 10 then \t\t\t\t\n");
        sql.append("\t\t\t\t\t\tconcat('0',tochar(length(tochar(CT.FCalcFinishTime))))\t\t\t\t\n");
        sql.append("\t\t\t\t\telse \t\t\n");
        sql.append("\t\t\t\t\t\ttochar(length(tochar(CT.FCalcFinishTime)))\t\t\t\n");
        sql.append("\t\t\t\tend,\t\t\t\n");
        sql.append("\t\t\t\ttochar(CT.FCalcFinishTime)\t\t\t\t\t\t\t\n");
        sql.append("\t\t\t)\t\t\t\t\t\n");
        sql.append("\tEND\t\t\t\t\t\t\t\n");
        sql.append(") DESC\t\t\t\t\t\t\t\n");
        return sql.toString();
    }

    protected String getSqlForOrderByCalcNum() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT\tTOP {1}\t\t\t\n");
        sql.append("\tTD.FRptId \t ,\t\t\n");
        sql.append("\tTD.FRptName ,\t\t\n");
        sql.append("\tTD.FRptNumber \t,\t\n");
        sql.append("\tTD.FRptYear ,\t\t\n");
        sql.append("\tTD.FRptPeriod ,\t\t\n");
        sql.append("\tTD.FRptPeriodType ,\t\n");
        sql.append("\tTD.FRptSourceType ,\t\n");
        sql.append("\tTD.FCompanyId ,\t\t\n");
        sql.append("\tTD.FCompanyNumber ,\t\n");
        sql.append("\tTD.FCompanyName,\t\n");
        sql.append("\tTD.FRptCurrencyNumber, \t\t\n");
        sql.append("\tTD.FRptCurrencyName_L1, \t\n");
        sql.append("\tTD.FRptCurrencyName_L2, \t\n");
        sql.append("\tTD.FRptCurrencyName_L3, \t\n");
        sql.append("\tCOUNT(1)\tFRptCalcNum \t\n");
        sql.append("FROM\tT_RPT_RptData TD\t\t\n");
        sql.append("{0} \t\t\t\t\t\n");
        sql.append("GROUP BY \t\t\t\t\n");
        sql.append("\tTD.FRptId ,\t\t\t\n");
        sql.append("\tTD.FRptName ,\t\t\n");
        sql.append("\tTD.FRptNumber \t,\t\n");
        sql.append("\tTD.FRptYear ,\t\t\n");
        sql.append("\tTD.FRptPeriod ,\t\t\n");
        sql.append("\tTD.FRptPeriodType ,\t\n");
        sql.append("\tTD.FRptSourceType ,\t\n");
        sql.append("\tTD.FCompanyId ,\t\t\n");
        sql.append("\tTD.FCompanyNumber ,\t\n");
        sql.append("\tTD.FCompanyName,\t\n");
        sql.append("\tTD.FRptCurrencyNumber, \t\t\n");
        sql.append("\tTD.FRptCurrencyName_L1, \t\n");
        sql.append("\tTD.FRptCurrencyName_L2, \t\n");
        sql.append("\tTD.FRptCurrencyName_L3 \t\t\n");
        sql.append("ORDER BY COUNT(1) DESC\t\t\t\n");
        return sql.toString();
    }
}

