/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.styleinherit;

import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.rpt.FormulaMoveTool;
import com.kingdee.eas.fi.rpt.GenerateSolution;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleInheritDecorator;
import java.awt.Point;
import org.apache.log4j.Logger;

public class StyleDecoratorFormula
extends StyleInheritDecorator {
    private static final Logger logger = Logger.getLogger(StyleDecoratorFormula.class);

    public StyleDecoratorFormula(IRptSheetSytleInherit sytleInherit) {
        super(sytleInherit);
    }

    public StyleDecoratorFormula() {
        super(null);
    }

    @Override
    public void regionInheritStyleByDefaultPoint(Sheet sheet, RptSheetSytleInheritParam styleParam) {
        super.regionInheritStyleByDefaultPoint(sheet, styleParam);
        if (styleParam.isVerticalInherit()) {
            this.verticalInheritFormualByBasePointNextLine(sheet, styleParam);
        } else {
            this.horizontalInheritFormualByBasePointNextLine(sheet, styleParam);
        }
    }

    public void verticalInheritFormualByBasePointNextLine(Sheet sheet, RptSheetSytleInheritParam styleParam) {
        Point standardPoint = styleParam.getStandardPoint();
        if (standardPoint == null) {
            return;
        }
        int startRow = styleParam.getStartRow();
        int startColumn = styleParam.getStartColumn();
        int endRow = styleParam.getEndRow();
        int endColumn = styleParam.getEndColumn();
        int iPosTop = standardPoint.y;
        int existRow = styleParam.getExistRow();
        if (startColumn < standardPoint.x + 1) {
            startColumn = standardPoint.x + 1;
        }
        logger.info((Object)("vertical:" + startRow + " " + startColumn + " " + endRow + " " + endColumn));
        for (int i = startColumn; i <= endColumn; ++i) {
            String formula = this.getCellFormual(sheet, styleParam, iPosTop + 1 + existRow, i);
            if (formula == null || "".equals(formula.trim()) || !formula.trim().startsWith("=")) continue;
            if (styleParam.isInsertInherit()) {
                boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)formula);
                if (!isExcelFunction) continue;
                this.fillRangeLikeDraw(sheet, endRow, iPosTop + 1, i, true);
                continue;
            }
            try {
                boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)formula);
                if (isExcelFunction) {
                    this.fillRangeLikeDraw(sheet, endRow, iPosTop + 1, i, true);
                    continue;
                }
                Expression expression = ExcelFormulaPaserHelper.parse(formula);
                boolean isHavSpecialExpr = ExcelFormulaPaserHelper.isHavSpecialExpr(expression);
                if (!isHavSpecialExpr) continue;
                if (isHavSpecialExpr && ExcelFormulaPaserHelper.isHavCommonRptExpr(expression)) {
                    int startCellRowStep = startRow - standardPoint.y - 2;
                    startCellRowStep = startCellRowStep < 0 ? 0 : startCellRowStep;
                    this.setVerticalSpecialFormulaByBasePointNextLine(sheet, styleParam, startRow, endRow, iPosTop, i);
                    this.setSpecialRangeFormulaVerticalFill(sheet, startRow, endRow, startCellRowStep, i);
                    continue;
                }
                if (isHavSpecialExpr && formula.indexOf("=") == -1 || !isHavSpecialExpr) continue;
                this.fillRangeLikeDraw(sheet, endRow, iPosTop + 1, i, true);
                continue;
            }
            catch (Exception e1) {
                logger.error((Object)e1.getStackTrace(), (Throwable)e1);
            }
        }
    }

    public void horizontalInheritFormualByBasePointNextLine(Sheet sheet, RptSheetSytleInheritParam styleParam) {
        Point standardPoint = styleParam.getStandardPoint();
        if (standardPoint == null) {
            return;
        }
        int startRow = styleParam.getStartRow();
        int startColumn = styleParam.getStartColumn();
        int endRow = styleParam.getEndRow();
        int endColumn = styleParam.getEndColumn();
        int iPosLeft = standardPoint.x;
        int existCol = styleParam.getExistCol();
        if (startRow < standardPoint.y + 1) {
            startRow = standardPoint.y + 1;
        }
        logger.info((Object)("horizontal:" + startRow + " " + startColumn + " " + endRow + " " + endColumn));
        for (int i = startRow; i <= endRow; ++i) {
            String formula = this.getCellFormual(sheet, styleParam, i, iPosLeft + 1 + existCol);
            if (formula == null || "".equals(formula.trim()) || !formula.trim().startsWith("=")) continue;
            if (styleParam.isInsertInherit()) {
                boolean isExcelFunction = BookFormulaHelper.isExcelFunction(null, (Sheet)sheet, (String)formula);
                if (!isExcelFunction) continue;
                this.fillRangeLikeDraw(sheet, endColumn, iPosLeft + 1, i, false);
                continue;
            }
            try {
                boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)formula);
                if (isExcelFunction) {
                    this.fillRangeLikeDraw(sheet, endColumn, iPosLeft + 1, i, false);
                    continue;
                }
                Expression expression = ExcelFormulaPaserHelper.parse(formula);
                boolean isHavSpecialExpr = ExcelFormulaPaserHelper.isHavSpecialExpr(expression);
                if (!isHavSpecialExpr) continue;
                if (isHavSpecialExpr && ExcelFormulaPaserHelper.isHavCommonRptExpr(expression)) {
                    int startCellColStep = startColumn - standardPoint.x - 2;
                    startCellColStep = startCellColStep < 0 ? 0 : startCellColStep;
                    this.setHorizontalSpecialFormulaByBasePointNextLine(sheet, styleParam, startColumn, endColumn, iPosLeft, i);
                    this.setSpecialRangeFormulaHorizontalFill(sheet, startColumn, endColumn, i, startCellColStep);
                    continue;
                }
                if (!isHavSpecialExpr) continue;
                this.fillRangeLikeDraw(sheet, endColumn, iPosLeft + 1, i, false);
                continue;
            }
            catch (Exception e1) {
                logger.error((Object)e1.getStackTrace(), (Throwable)e1);
            }
        }
    }

    private void setHorizontalSpecialFormulaByBasePointNextLine(Sheet sheet, RptSheetSytleInheritParam styleParam, int startColumn, int endColumn, int iPosLeft, int curRow) {
        if (!styleParam.isGradeFill()) {
            String formula = this.getCellFormual(sheet, styleParam, curRow, iPosLeft + 1);
            for (int curColumn = startColumn; curColumn <= endColumn; ++curColumn) {
                Range curRangeFill = sheet.getRange(curRow, curColumn);
                String curFormual = curRangeFill.getFormula();
                if (curFormual != null && !"".equals(curFormual.trim()) && curFormual.trim().startsWith("=")) continue;
                curRangeFill.setFormula(formula);
            }
        }
    }

    private void setVerticalSpecialFormulaByBasePointNextLine(Sheet sheet, RptSheetSytleInheritParam styleParam, int startRow, int endRow, int iPosTop, int curColumn) {
        if (!styleParam.isGradeFill()) {
            String formula = this.getCellFormual(sheet, styleParam, iPosTop + 1, curColumn);
            for (int curRow = startRow; curRow <= endRow; ++curRow) {
                Range curRangeFill = sheet.getRange(curRow, curColumn);
                String curFormual = curRangeFill.getFormula();
                if (curFormual != null && !"".equals(curFormual.trim()) && curFormual.trim().startsWith("=")) continue;
                curRangeFill.setFormula(formula);
            }
        }
    }

    private void fillRangeLikeDraw(Sheet sheet, int endRoworCol, int drawX, int y, boolean isVertical) {
        if (drawX + 1 > endRoworCol) {
            return;
        }
        Range rg = null;
        rg = isVertical ? sheet.getRange(drawX, y) : sheet.getRange(y, drawX);
        rg.setIgnoreProtected(true);
        FillType resultType = new FillType(0);
        CellBlock dstBlock = CellBlock.getNewCellBlock((int)0, (int)0);
        if (isVertical) {
            dstBlock.setRowCol(drawX, y, endRoworCol, y);
        } else {
            dstBlock.setRowCol(y, drawX, y, endRoworCol);
        }
        rg.fill(dstBlock, FillType.DEFAULT_EXCEPT_FORMAT, resultType);
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isProtect = false;
        String proPass = null;
        if (pro != null && pro.isProtected()) {
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
            isProtect = true;
        }
        if (isVertical) {
            sheet.getRange(drawX + 1, y, endRoworCol, y).setValue(null);
        } else {
            sheet.getRange(y, drawX, y, endRoworCol).setValue(null);
        }
        if (isProtect) {
            pro.startWithEncryptedPassword(proPass);
        }
    }

    private void setSpecialRangeFormulaVerticalFill(Sheet sheet, int startRow, int endRow, int startCellRowStep, int curColumn) {
        GenerateSolution solution = new GenerateSolution();
        solution.setCellRowEnable(true);
        solution.setCellRowAspect(1);
        solution.setFormulaEnable(false);
        solution.setFormulaStep(0);
        int index = 0;
        for (int curRow = startRow; curRow <= endRow; ++curRow) {
            solution.setCellRowStep(startCellRowStep + ++index);
            Range curRangeFill = sheet.getRange(curRow, curColumn);
            String curFormual = curRangeFill.getFormula();
            if (curFormual == null || "".equals(curFormual.trim())) continue;
            try {
                curRangeFill.setIgnoreProtected(true);
                String formatFormual = FormulaMoveTool.formatFormaulBysolution(solution, curFormual);
                if (!formatFormual.startsWith("=")) {
                    formatFormual = "=" + formatFormual;
                }
                curRangeFill.setFormula(formatFormual);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"inheritformual:range formual is error:", (Throwable)e);
            }
        }
    }

    private void setSpecialRangeFormulaHorizontalFill(Sheet sheet, int startColumn, int endColumn, int curRow, int startCellColStep) {
        GenerateSolution solution = new GenerateSolution();
        solution.setCellRowEnable(false);
        solution.setCellColumnEnable(true);
        solution.setCellColumnAspect(1);
        solution.setFormulaEnable(false);
        solution.setFormulaStep(0);
        int index = 0;
        for (int curColumn = startColumn; curColumn <= endColumn; ++curColumn) {
            solution.setCellColumnStep(startCellColStep + ++index);
            Range curRangeFill = sheet.getRange(curRow, curColumn);
            String curFormual = curRangeFill.getFormula();
            if (curFormual == null || "".equals(curFormual.trim())) continue;
            try {
                curRangeFill.setIgnoreProtected(true);
                String formatFormual = FormulaMoveTool.formatFormaulBysolution(solution, curFormual);
                if (!formatFormual.startsWith("=")) {
                    formatFormual = "=" + formatFormual;
                }
                curRangeFill.setFormula(formatFormual);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"inheritformual:range formual is error:", (Throwable)e);
            }
        }
    }

    private String getCellFormual(Sheet sheet, RptSheetSytleInheritParam styleParam, int row, int column) {
        String formula = "";
        if (styleParam.isGradeFill()) {
            DItemGradeInfo gradeInfo = styleParam.getGradeInfo();
            if (gradeInfo == null) {
                return formula;
            }
            String grade = styleParam.getGrade();
            formula = styleParam.isVerticalInherit() ? gradeInfo.getTempFormuma(grade + "---" + column) : gradeInfo.getTempFormuma(grade + "---" + row);
        } else {
            Range range = sheet.getRange(row, column);
            if (range == null) {
                return formula;
            }
            formula = range.getFormula();
        }
        return formula;
    }
}

