/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import java.awt.Color;

public class ColorUtil {
    private static final String regex = "^(?i)RGB\\{\\d{1,3}\\s*,\\d{1,3}\\s*,\\d{1,3}\\s*\\}$";

    public static String getColorDesc(Color color) {
        StringBuffer desc = new StringBuffer();
        desc.append("RGB{").append(color.getRed());
        desc.append(",").append(color.getGreen());
        desc.append(",").append(color.getBlue()).append("}");
        return desc.toString();
    }

    public static Color parseColor(String colorDesc) {
        if (colorDesc == null) {
            return Color.WHITE;
        }
        if (!colorDesc.matches(regex)) {
            throw new IllegalArgumentException("Invaild Color format, a right format \uff1aRGB{r,g,b}");
        }
        int begin = colorDesc.indexOf(123) + 1;
        int end = colorDesc.indexOf(125);
        if (begin < 0 || end < 0) {
            return Color.WHITE;
        }
        String[] rgb = colorDesc.substring(begin, end).split(",");
        int r = Integer.parseInt(rgb[0].trim());
        int g = Integer.parseInt(rgb[1].trim());
        int b = Integer.parseInt(rgb[2].trim());
        return new Color(r, g, b);
    }

    public static Color parseColor(Object colorDesc) {
        if (colorDesc != null) {
            return ColorUtil.parseColor(colorDesc.toString());
        }
        return ColorUtil.parseColor(null);
    }

    public static void main(String[] args) {
        String color = "RgB{111 ,2 ,3}";
    }
}

