/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.excel.io.table.BookToKdf;
import com.kingdee.bos.ctrl.excel.io.table.IBookKdfUOTrans;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.eas.fi.rpt.util.BookKdfUOTransDelegate;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class IOHelper {
    private static UserObjectTrans uoTrans = new UserObjectTrans();
    private static Map transMapping = new HashMap(2);

    public static Book unpackBook(byte[] data) throws Exception {
        return IOHelper.unpackBook(data, BookIOController.FLAG_ALL);
    }

    public static Book unpackBook(byte[] data, String kdf_trans_type) throws Exception {
        return IOHelper.unpackBook(data, BookIOController.FLAG_ALL, kdf_trans_type);
    }

    public static Book unpackBook(byte[] data, int mode, String kdf_trans_type) throws Exception {
        BookIOController ctrl = IOHelper.getCtrl();
        ctrl.setIOMode(mode);
        Book book = BookIOUtil.unpack((byte[])data, (BookIOController)ctrl, (BookKdfIOController)IOHelper.getCtrl2(kdf_trans_type));
        book.getUndoManager().enable(false);
        return book;
    }

    public static Book unpackBook(byte[] data, int mode) throws Exception {
        return IOHelper.unpackBook(data, mode, null);
    }

    public static Book unpackBook(byte[] data, Book prototype) throws Exception {
        BookIOController ctrl = IOHelper.getCtrl();
        prototype = BookIOUtil.unpack((byte[])data, (BookIOController)ctrl, (BookKdfIOController)IOHelper.getCtrl2(), (Book)prototype);
        prototype.getUndoManager().enable(false);
        prototype.setCalculate(false);
        return prototype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDataToFile(byte[] data, String fileName) throws Exception {
        try (FileOutputStream o = null;){
            File f = new File(fileName);
            o = new FileOutputStream(f);
            o.write(data);
        }
    }

    public static void saveUnpackedFile(byte[] data, String fileName) throws Exception {
        File f = new File(fileName);
        FileOutputStream o = new FileOutputStream(f);
        ZipUtil.UnpackResult result = ZipUtil.unpackWithMagic((byte[])data);
        CtrlUtil.Stream.forwardStream((InputStream)result.getInputStream(), (OutputStream)o);
        o.close();
    }

    public static byte[] packBook(Book book) throws IOException {
        BookIOController ctrl = IOHelper.getNoCommentCtrl();
        return BookIOUtil.pack((Book)book, (BookIOController)ctrl);
    }

    private static int getNoCommentMode() {
        int mod = BookIOController.FLAG_ALL;
        if ((mod & BookIOController.FLAG_BOOK_COMMENT) == BookIOController.FLAG_BOOK_COMMENT) {
            mod ^= BookIOController.FLAG_BOOK_COMMENT;
        }
        if ((mod & BookIOController.FLAG_CELL_COMMENT) == BookIOController.FLAG_CELL_COMMENT) {
            mod ^= BookIOController.FLAG_CELL_COMMENT;
        }
        if ((mod & BookIOController.FLAG_SHEET_COMMENT) == BookIOController.FLAG_SHEET_COMMENT) {
            mod ^= BookIOController.FLAG_SHEET_COMMENT;
        }
        return mod;
    }

    public static void saveToFile(Book book, String file) throws IOException {
        BookIOUtil.saveToFile((Book)book, (BookIOController)IOHelper.getNoCommentCtrl(), (String)file);
    }

    public static void saveToFile(Book book, String file, String[] sheetNames) throws IOException {
        BookIOUtil.saveToFile((Book)book, (BookIOController)IOHelper.getNoCommentCtrl(), (String)file, (String[])sheetNames);
    }

    public static KDF book2KDF(Book book) {
        BookToKdf bookToKdf = new BookToKdf();
        bookToKdf.setIOController(IOHelper.getCtrl2());
        return bookToKdf.getKDF(book);
    }

    public static Book loadFile(String file) throws Exception {
        BookIOController ctrl = new BookIOController();
        ctrl.setKmlUOTrans((Book.IUserObjectProvider)uoTrans);
        return BookIOUtil.loadFile((String)file, (BookIOController)ctrl, (BookKdfIOController)IOHelper.getCtrl2());
    }

    public static Book loadFile(InputStream is) throws Exception {
        return IOHelper.loadFile(is, 1);
    }

    public static Book loadFile(InputStream is, int type) throws Exception {
        BookIOController ctrl = new BookIOController();
        ctrl.setKmlUOTrans((Book.IUserObjectProvider)uoTrans);
        if (type == 1) {
            KmlToBook kb = new KmlToBook();
            kb.setIOController(ctrl);
            kb.load(is, null);
            return kb.getBook();
        }
        if (type == 2) {
            KdfToBook ktb = new KdfToBook();
            ktb.setIOController(IOHelper.getCtrl2());
            if (ctrl != null && ctrl.getIOMode() != BookIOController.FLAG_ALL) {
                int mode = ctrl.getIOMode();
                if ((mode & 8) != 0) {
                    mode -= 8;
                }
                if ((mode & 0x10) != 0) {
                    mode -= 16;
                }
                KDFSAX sax = new KDFSAX(mode);
                sax.load(is);
                return ktb.getBook(sax, null);
            }
            return ktb.getBook(new KDF(is), null);
        }
        throw new IOException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"262_IOHelper"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKDFUpGrader() {
        InputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = UserObjectTrans.class.getResourceAsStream("KDFUserObject2BookUserObject.properties");
            p.load(inStream);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Class<?> c = Class.forName((String)e.getValue());
                transMapping.put(e.getKey(), (IBookKdfUOTrans)c.newInstance());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static BookIOController getCtrl() {
        return IOHelper.getCtrl(BookIOController.FLAG_ALL);
    }

    private static BookIOController getNoCommentCtrl() {
        return IOHelper.getCtrl(IOHelper.getNoCommentMode());
    }

    private static BookIOController getCtrl(int mode) {
        BookIOController ctrl = new BookIOController();
        ctrl.setKmlUOTrans((Book.IUserObjectProvider)uoTrans);
        ctrl.setIOMode(mode);
        return ctrl;
    }

    public static final Book.IUserObjectProvider getKmlUOTrans() {
        return uoTrans;
    }

    private static BookKdfIOController getCtrl2() {
        return IOHelper.getCtrl2(null);
    }

    private static BookKdfIOController getCtrl2(String trans_type) {
        BookKdfIOController ctrl = new BookKdfIOController();
        BookKdfUOTransDelegate transDelegate = new BookKdfUOTransDelegate();
        if (trans_type == null) {
            Iterator it = transMapping.values().iterator();
            while (it.hasNext()) {
                transDelegate.add((IBookKdfUOTrans)it.next());
            }
        } else {
            String[] split = StringUtils.split((String)trans_type, (int)124);
            for (int i = 0; i < split.length; ++i) {
                IBookKdfUOTrans bookKdfUOTrans = (IBookKdfUOTrans)transMapping.get(split[i]);
                if (bookKdfUOTrans == null) continue;
                transDelegate.add(bookKdfUOTrans);
            }
        }
        ctrl.setTableUOTrans((IBookKdfUOTrans)transDelegate);
        return ctrl;
    }

    static {
        IOHelper.loadKDFUpGrader();
    }
}

