/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.CellRefExpr;
import com.kingdee.eas.fi.rpt.util.SheetRefExpr;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptFormulaParser {
    private static final Logger logger = Logger.getLogger((String)RptFormulaParser.class.getName());
    private static final char DONE = '\uffff';
    String _line;
    Map rangeMap = new HashMap(1);
    int _pos = 0;
    int _end = 0;

    public RptFormulaParser(String l) throws ParserException {
        this._line = l;
        if (this._line.charAt(this._line.length() - 1) != ';') {
            this._line = this._line + ';';
        }
        this._end = this._line.length() - 1;
    }

    private void parse() throws KScriptException {
        char c = '\uffff';
        while ((c = (char)this.next()) != '\uffff') {
            if (c == '\"') {
                this.skipString();
                continue;
            }
            if (Character.isWhitespace(c)) {
                this.skipWhitespace();
                continue;
            }
            if (!Character.isJavaIdentifierStart(c) && c != 39) continue;
            this.readIdentify(c);
        }
    }

    private void readIdentify(char cc) throws KScriptException {
        char c = '\uffff';
        int start = this._pos - 1;
        if (cc == '\'') {
            this.skipQuotedSheetName();
        }
        while ((c = (char)this.next()) != '\uffff') {
            if (c == ':') {
                this.readRangeToken();
                this.rangeMap.put(new Integer(start), this._line.substring(start, this._pos));
                break;
            }
            if (c == '!') {
                this.readSheetToken();
                this.rangeMap.put(new Integer(start), this._line.substring(start, this._pos));
                break;
            }
            if (c != ',' && !RptFormulaParser.isPunctuation(c)) continue;
            break;
        }
    }

    private static boolean isPunctuation(char c) {
        switch (c) {
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ';': 
            case '=': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private void readSheetToken() throws KScriptException {
        block5: {
            char c = '\uffff';
            while (true) {
                if (Character.isWhitespace(c = (char)this.next())) {
                    this.skipWhitespace();
                    continue;
                }
                if (c == ':') {
                    this.readRangeToken();
                    break block5;
                }
                if (!Character.isLetterOrDigit(c)) {
                    if (c != '\uffff') {
                        this.unget();
                    }
                    break block5;
                }
                if (!Character.isLetterOrDigit(c) && c != '!' && c != '_') break;
            }
            throw new KScriptException("Unexcepted character: '" + c + "' at " + this._pos);
        }
    }

    private void readRangeToken() throws KScriptException {
        block4: {
            char c;
            while (true) {
                if (Character.isWhitespace(c = this.next())) {
                    this.skipWhitespace();
                    continue;
                }
                if (!Character.isLetterOrDigit(c)) {
                    if (c != '\uffff') {
                        this.unget();
                    }
                    break block4;
                }
                if (!Character.isLetterOrDigit(c) && c != '!' && c != '_') break;
            }
            throw new KScriptException("Unexcepted character: '" + c + "' at " + this._pos);
        }
    }

    private void skipWhitespace() {
        char c;
        do {
            if ((c = this.next()) != '\uffff') continue;
            return;
        } while (Character.isWhitespace(c));
        this.unget();
    }

    private void skipString() throws KScriptException {
        char c;
        do {
            if ((c = this.next()) != '\uffff') continue;
            throw new KScriptException("Except punctuation \" at " + this._pos);
        } while (c != '\"' || this._line.charAt(this._pos - 1) == '\\');
    }

    private void skipQuotedSheetName() throws KScriptException {
        while (true) {
            char c;
            if ((c = this.next()) == '\uffff') {
                throw new KScriptException("Except punctuation ' at " + this._pos);
            }
            if (c != '\'') continue;
            if (this.next() != '\'') {
                return;
            }
            this.unget();
        }
    }

    public char next() {
        if (this._pos < this._end) {
            return this._line.charAt(this._pos++);
        }
        this._pos = this._end;
        return '\uffff';
    }

    public void skip() {
        ++this._pos;
    }

    public char getAbs(int index) {
        if (0 < index && index < this._end) {
            return this._line.charAt(index);
        }
        return '\uffff';
    }

    public void unget() {
        --this._pos;
    }

    public static void main(String[] args) throws ParseException, ParserException {
        logger.debug((Object)RptFormulaParser.test(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"263_RptFormulaParser")));
        logger.debug((Object)RptFormulaParser.test("value=AcctExt(\"\",\"10xx01,1001\",\"\",\"\",A1,\"\",\"2006-07-01\",\"2006-07-31\")"));
    }

    public static ExprStmt parse(String a) throws ParserException {
        try {
            RptFormulaParser parser = new RptFormulaParser(a);
            parser.parse();
            HashMap<String, String> map = new HashMap<String, String>(1);
            StringBuffer buf = new StringBuffer(a.length());
            for (int i = 0; i < a.length(); ++i) {
                String s = (String)parser.rangeMap.get(new Integer(i));
                if (s == null) {
                    buf.append(a.charAt(i));
                    continue;
                }
                String repl = "A" + RptFormulaParser.getUuid();
                buf.append(repl);
                i += s.length() - 1;
                map.put(repl, s);
            }
            KScriptParser p = RptFormulaParser.parseFormulaStr(buf.toString());
            List list = p.stmtList;
            ExprStmt stmt = (ExprStmt)list.get(0);
            BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
            CodeExpr codeExpr = expr.right;
            expr.right = codeExpr = RptFormulaParser.walk(codeExpr, map);
            return stmt;
        }
        catch (Exception e) {
            throw new ParserException(0, "", "");
        }
    }

    private static KScriptParser parseFormulaStr(String formulaStr) throws ParserException {
        if (formulaStr == null) {
            return null;
        }
        Lexer lexer = new Lexer(formulaStr);
        TokenList tokList = new TokenList(lexer);
        KScriptParser parser = new KScriptParser(tokList);
        parser.parse();
        return parser;
    }

    private static String test(String l) throws ParserException, ParseException {
        ExprStmt stmt = RptFormulaParser.parse(l);
        BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
        CodeExpr codeExpr = expr.right;
        StringBuffer sb = new StringBuffer();
        codeExpr.output(sb);
        return "=" + sb.toString() + ";";
    }

    private static CodeExpr walk(CodeExpr expr, Map map) throws KScriptException {
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            if (left instanceof IdentifierExpr) {
                bin.left = RptFormulaParser.matchExpr(left, map);
            } else {
                RptFormulaParser.walk(left, map);
            }
            CodeExpr right = ((BinaryOpExpr)expr).right;
            if (right instanceof IdentifierExpr) {
                bin.right = RptFormulaParser.matchExpr(right, map);
            } else {
                RptFormulaParser.walk(right, map);
            }
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr e = (MethodInvokeExpr)expr;
            if (e.paramList != null && e.paramList.size() > 0) {
                for (int i = 0; i < e.paramList.size(); ++i) {
                    CodeExpr ee = (CodeExpr)e.paramList.get(i);
                    if (ee instanceof IdentifierExpr) {
                        e.paramList.set(i, RptFormulaParser.matchExpr(ee, map));
                        continue;
                    }
                    RptFormulaParser.walk(ee, map);
                }
            }
        } else if (expr instanceof IdentifierExpr) {
            return RptFormulaParser.matchExpr(expr, map);
        }
        return expr;
    }

    private static CodeExpr matchExpr(CodeExpr ee, Map map) throws KScriptException {
        IdentifierExpr eee = (IdentifierExpr)ee;
        String rep = (String)map.get(eee.value);
        if (rep != null) {
            return RptFormulaParser.buildSheetRef(rep);
        }
        if (TableToolkit.isCellRef(eee.value)) {
            CellRefExpr exp = new CellRefExpr((CodeExpr)eee, (CodeExpr)eee);
            return exp;
        }
        return ee;
    }

    private static CodeExpr buildSheetRef(String rep) throws KScriptException {
        String[] sp = rep.split("!|:");
        if (sp.length == 4) {
            IdentifierExpr sheetname1 = new IdentifierExpr();
            sheetname1.value = sp[0].trim();
            IdentifierExpr cellref1 = new IdentifierExpr();
            cellref1.value = sp[1].trim();
            SheetRefExpr s1 = new SheetRefExpr((CodeExpr)sheetname1, (CodeExpr)cellref1);
            IdentifierExpr sheetname2 = new IdentifierExpr();
            sheetname2.value = sp[2].trim();
            IdentifierExpr cellref2 = new IdentifierExpr();
            cellref2.value = sp[3].trim();
            SheetRefExpr s2 = new SheetRefExpr((CodeExpr)sheetname2, (CodeExpr)cellref2);
            CellRefExpr exp = new CellRefExpr(s1, s2);
            return exp;
        }
        if (sp.length == 3) {
            IdentifierExpr sheetname1 = new IdentifierExpr();
            sheetname1.value = sp[0].trim();
            IdentifierExpr cellref1 = new IdentifierExpr();
            cellref1.value = sp[1].trim();
            IdentifierExpr cellref2 = new IdentifierExpr();
            cellref2.value = sp[2].trim();
            CellRefExpr exp = new CellRefExpr((CodeExpr)cellref1, (CodeExpr)cellref2);
            SheetRefExpr s2 = new SheetRefExpr((CodeExpr)sheetname1, exp);
            return s2;
        }
        if (sp.length == 2) {
            if (rep.indexOf(33) > -1) {
                IdentifierExpr sheetname1 = new IdentifierExpr();
                sheetname1.value = sp[0].trim();
                IdentifierExpr cellref1 = new IdentifierExpr();
                cellref1.value = sp[1].trim();
                SheetRefExpr s2 = new SheetRefExpr((CodeExpr)sheetname1, (CodeExpr)cellref1);
                return s2;
            }
            IdentifierExpr cellref1 = new IdentifierExpr();
            cellref1.value = sp[0].trim();
            IdentifierExpr cellref2 = new IdentifierExpr();
            cellref2.value = sp[1].trim();
            CellRefExpr exp = new CellRefExpr((CodeExpr)cellref1, (CodeExpr)cellref2);
            return exp;
        }
        throw new KScriptException("Bad syntax near: " + rep);
    }

    protected static String getUuid() {
        Uuid uid = Uuid.create();
        return uid.toString().replaceAll("-", "");
    }
}

