/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.utils.XMLElement;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslParam;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.CalculateErrorHandler;
import com.kingdee.eas.fi.rpt.IndexItemCollection;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.client.RptAttachmentListUI;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class RptUtil {
    private static final Logger log = Logger.getLogger((String)RptUtil.class.getName());
    public static final String RPT_RESOURCE = "com.kingdee.eas.fi.rpt.ReportResource";
    public static final String RPTMENU_RESOURCE = "com.kingdee.eas.fi.newrpt.RptMenuTextResource";
    public static final String RPT_CACL_SCHEME_DEFINE = "rpt_cacl_scheme_define";
    public static final String RPT_CACL_SCHEME_BEGINTIME = "rpt_cacl_scheme_begintime";
    public static final String RPT_CACL_SCHEME_IS_USE_CALENDAR = "rpt_cacl_scheme_is_use_calendar ";
    public static final String RPT_CACL_SCHEME_ORG = "rpt_cacl_scheme_org";
    private static int PERFORMANCE_ACCT_WHERE_SIZE = 100;
    private static Map<String, Integer> DbTypeMap;
    public static final float GZIPFACTOR = 0.75f;
    public static final String MAGICCODE = "###PACKER4.0.1###";
    static final String[] TRUTH;
    static final String[] FALSE;
    public static final String FARES = "com.kingdee.eas.fi.rpt.ReportResourceSince51";
    public static final String RPT_ERRORHANDLER = "RPT_ERRORHANDLER";
    public static final String ZERORDIVIDE = "ZERORDIVIDE";

    public static int getRptCalculatePerformanceParam(Context ctx, String key) {
        String value = null;
        int ret = PERFORMANCE_ACCT_WHERE_SIZE;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FValue from t_csl_cslparam where fkey = ?", (Object[])new Object[]{key});
            while (rs.next()) {
                value = rs.getString("FValue");
            }
            ret = Integer.parseInt(value);
        }
        catch (Exception e2) {
            ret = PERFORMANCE_ACCT_WHERE_SIZE;
        }
        return ret;
    }

    public static int getPerformanceAcctWhereVariableSize() {
        return PERFORMANCE_ACCT_WHERE_SIZE;
    }

    public static void setPerformanceAcctWhereVariableSize(int size) {
        PERFORMANCE_ACCT_WHERE_SIZE = size == -1 ? 100 : size;
    }

    public static Map getCslParams(Context ctx, String[] keys) throws BOSException, EASBizException {
        HashMap<Object, Object> paramsMap = new HashMap<Object, Object>();
        StringBuffer sql = new StringBuffer("Select FKey, FValue From T_Csl_CslParam where FKey in ( ");
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(keys[i]).append("'");
        }
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                Object fkey = rowSet.getObject("FKey");
                Object fvalue = rowSet.getObject("FValue");
                paramsMap.put(fkey, fvalue);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return paramsMap;
    }

    public static byte[] dataZip(byte[] data) throws IOException {
        if (data == null || data.length <= 0) {
            return null;
        }
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(byteout);
        gzout.write(data);
        gzout.flush();
        gzout.close();
        return byteout.toByteArray();
    }

    public static byte[] UnDataZip(byte[] data) throws IOException {
        ByteArrayOutputStream newData = new ByteArrayOutputStream();
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayInputStream i = new ByteArrayInputStream(data);
        GZIPInputStream gzin = new GZIPInputStream(i);
        Object tempFile = null;
        int b = 0;
        byte[] bufferByte = new byte[1024];
        while (gzin.available() == 1) {
            b = gzin.read(bufferByte);
            if (b <= 0) continue;
            newData.write(bufferByte, 0, b);
        }
        return newData.toByteArray();
    }

    public static Object[] ArrayListToObject(ArrayList al) {
        Object[] obj = new Object[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            obj[i] = al.get(i);
        }
        return obj;
    }

    public static byte[] pack(byte[] source) throws IOException {
        return RptUtil.pack(source, 0.75f);
    }

    public static byte[] pack(byte[] source, float factor) throws IOException {
        if (source == null || source.length < 1) {
            return null;
        }
        if (factor < 0.1f) {
            factor = 0.75f;
        }
        float initCapacity = (float)source.length * Math.min(factor, 1.0f);
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)initCapacity);
        RptUtil.writeMagic(bout, source.length);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        zout.write(source, 0, source.length);
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] unpack(byte[] source) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = RptUtil.readMagic(bin);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            return source;
        }
        if (count < 1) {
            bin.close();
            return null;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        byte[] res = new byte[count];
        int num = 0;
        while ((len = count - num) >= 0) {
            int n;
            if (len > 4096) {
                len = 4096;
            }
            if ((n = zin.read(res, num, len)) <= 0) break;
            num += n;
        }
        zin.close();
        bin.close();
        return num != count ? null : res;
    }

    private static boolean writeMagic(ByteArrayOutputStream output, int size) throws IOException {
        if (output == null) {
            return false;
        }
        int len = MAGICCODE.length();
        byte[] magic = new byte[len];
        for (int m = 0; m < len; ++m) {
            magic[m] = (byte)MAGICCODE.charAt(m);
        }
        output.write(magic);
        for (int i = 3; i >= 0; --i) {
            output.write(size >> i * 8 & 0xFF);
        }
        return true;
    }

    private static int readMagic(ByteArrayInputStream input) {
        if (input == null) {
            return 0;
        }
        int len = MAGICCODE.length();
        for (int m = 0; m < len; ++m) {
            if (MAGICCODE.charAt(m) == (char)input.read()) continue;
            return Integer.MAX_VALUE;
        }
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }

    public static TemplateInfo filterTemplateReportSavePoint(TemplateInfo templateinfo) {
        if (templateinfo != null) {
            TemplateReportSavePointCollection c = templateinfo.getReportSavePoint();
            TemplateReportSavePointCollection c2 = new TemplateReportSavePointCollection();
            if (c != null && c.size() > 0) {
                for (int i = 0; i < c.size(); ++i) {
                    TemplateReportSavePointInfo info = c.get(i);
                    if (info.getCompany() == null || info.getCompany().getId() == null || !SysContext.getSysContext().getCurrentFIUnit().getId().toString().equals(info.getCompany().getId().toString())) continue;
                    c2.add(info);
                }
            }
            templateinfo.setReportSavePoint(c2);
        }
        return templateinfo;
    }

    public static int getScaleByCyNumAtServer(Context ctx, String strNumber) {
        if (ctx.get((Object)"rptCurrencyCache") != null && ((HashMap)ctx.get((Object)"rptCurrencyCache")).containsKey(strNumber)) {
            return (Integer)((HashMap)ctx.get((Object)"rptCurrencyCache")).get(strNumber);
        }
        int scale = 2;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber));
        SelectorItemCollection sic = view.getSelector();
        SelectorItemCollection sic_1 = new SelectorItemCollection();
        sic_1.add(new SelectorItemInfo("precision"));
        sic.addObjectCollection((IObjectCollection)sic_1);
        try {
            ICurrency cy = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection cyCol = cy.getCurrencyCollection(view);
            if (cyCol != null && cyCol.size() > 0) {
                CurrencyInfo cyInfo = cyCol.get(0);
                scale = cyInfo.getPrecision();
                scale = scale < 0 ? 0 : scale;
            }
        }
        catch (BOSException e) {
            log.debug((Object)e.getMessage());
        }
        if (ctx.get((Object)"rptCurrencyCache") == null) {
            HashMap<String, Integer> rptCurrencyCache = new HashMap<String, Integer>();
            rptCurrencyCache.put(strNumber, new Integer(scale));
            ctx.put((Object)"rptCurrencyCache", rptCurrencyCache);
        } else {
            ((HashMap)ctx.get((Object)"rptCurrencyCache")).put(strNumber, new Integer(scale));
        }
        return scale;
    }

    public static boolean isTrue(Object target) {
        return RptUtil.isTrue(target, false);
    }

    public static boolean isTrue(Object target, boolean defaultValue) {
        if (target == null) {
            return defaultValue;
        }
        if (target instanceof Boolean) {
            return (Boolean)target;
        }
        String s = target.toString().trim();
        int f = 0;
        int t = 0;
        while (t + f < TRUTH.length + FALSE.length) {
            if (t < TRUTH.length) {
                if (s.equalsIgnoreCase(TRUTH[t])) {
                    return true;
                }
                ++t;
            }
            if (f >= FALSE.length) continue;
            if (s.equalsIgnoreCase(FALSE[f])) {
                return false;
            }
            ++f;
        }
        try {
            return Boolean.valueOf(s);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean findString(String source, String dest) {
        boolean bValue = false;
        if (source == null || dest == null) {
            return bValue;
        }
        bValue = dest.toUpperCase().indexOf("," + source.toUpperCase() + ",") >= 0;
        return bValue;
    }

    public static int comparePointers(Object lhv, Object rhv) {
        if (lhv != null) {
            return rhv != null ? 1 : -1;
        }
        return rhv == null ? 0 : 2;
    }

    public static boolean isEquals(String lhv, String rhv) {
        int ps = RptUtil.comparePointers(lhv, rhv);
        if (ps != 1) {
            return ps == 0;
        }
        return lhv.equals(rhv);
    }

    public static String replace(String origin, String oldPart, String newPart) {
        return RptUtil.replace(origin, oldPart, newPart, false);
    }

    public static String replaceIgnoreCase(String origin, String oldPart, String newPart) {
        return RptUtil.replace(origin, oldPart, newPart, true);
    }

    public static String replace(String origin, String oldPart, String newPart, boolean isIgnoreCase) {
        if (origin == null || origin.length() == 0 || oldPart == null || oldPart.length() == 0) {
            return origin;
        }
        if (newPart == null) {
            newPart = "";
        }
        String pool = origin;
        if (isIgnoreCase) {
            pool = new String(origin);
            origin = origin.toLowerCase();
            oldPart = oldPart.toLowerCase();
        }
        StringBuffer res = new StringBuffer(origin.length());
        int head = 0;
        int tail = 0;
        while (true) {
            if ((tail = origin.indexOf(oldPart, head)) < 0) break;
            res.append(pool.substring(head, tail));
            res.append(newPart);
            head = tail + oldPart.length();
        }
        res.append(pool.substring(head));
        return res.toString();
    }

    public static void main(String[] args) {
        String s = "IF(a<>b, c, d)";
        String[] strings = RptUtil.splitCheckFormula(s);
    }

    public static long counterStart(String name) {
        return System.currentTimeMillis();
    }

    public static long counterStop(long startTime, String name) {
        long time = System.currentTimeMillis() - startTime;
        return time;
    }

    public static Date beginOfDay(Date date) {
        Date myDate = (Date)date.clone();
        myDate.setHours(0);
        myDate.setMinutes(0);
        myDate.setSeconds(0);
        return myDate;
    }

    public static Date endOfDay(Date date) {
        Date myDate = (Date)date.clone();
        myDate.setHours(23);
        myDate.setMinutes(59);
        myDate.setSeconds(59);
        return myDate;
    }

    public static void reqDataMutex(CoreUI coreUI, List billIds, String oprtState) throws Exception {
        int i;
        try {
            coreUI.setOprtState(oprtState);
            int size = billIds.size();
            for (i = 0; i < size; ++i) {
                coreUI.pubFireVOChangeListener((String)billIds.get(i));
            }
        }
        catch (Throwable ex) {
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            for (int j = 0; j < i; ++j) {
                mutexServiceControl.releaseObjIDForUpdate((String)billIds.get(j));
            }
            coreUI.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static void releaseDataMutex(CoreUI coreUI, List billIds) throws Exception {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        int size = billIds.size();
        for (int i = 0; i < size; ++i) {
            mutexServiceControl.releaseObjIDForUpdate((String)billIds.get(i));
        }
    }

    public static void reqDataMutex(CoreUI coreUI, String billId, String oprtState) throws Exception {
        try {
            coreUI.setOprtState(oprtState);
            coreUI.pubFireVOChangeListener(billId);
        }
        catch (Throwable ex) {
            coreUI.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static void releaseDataMutex(CoreUI coreUI, String billId) throws Exception {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.releaseObjIDForUpdate(billId);
    }

    public static String getResourceSince51(String resName, String resKey) {
        return EASResource.getString((String)resName, (String)resKey);
    }

    public static String getResourceSince51(String resKey) {
        return RptUtil.getResourceSince51(FARES, resKey);
    }

    public static String getReportResource(String resKey) {
        return RptUtil.getResourceSince51(RPT_RESOURCE, resKey);
    }

    public static String getRptMenuResource(String resKey) {
        return EASResource.getString((String)RPTMENU_RESOURCE, (String)resKey);
    }

    public static String getReportResource(String resKey, Locale l) {
        return ResourceBase.getString((String)RPT_RESOURCE, (String)resKey, (Locale)l);
    }

    public static ReportCalculateErrorProvider getErrorhandlerFromKDF(KDF kdf) {
        String strDivide0;
        Object handler = kdf.getUserObject(RPT_ERRORHANDLER);
        if (handler instanceof ReportCalculateErrorProvider) {
            return (ReportCalculateErrorProvider)handler;
        }
        if (handler instanceof CalculateErrorHandler) {
            return new ReportCalculateErrorProvider((CalculateErrorHandler)handler);
        }
        if (handler == null && (strDivide0 = (String)kdf.getUserObject(ZERORDIVIDE)) != null) {
            ReportCalculateErrorProvider h = new ReportCalculateErrorProvider();
            h.setDealException(true);
            h.setExceptionReplacer(strDivide0);
            return h;
        }
        return null;
    }

    public static ReportCalculateErrorProvider getErrorhandlerFromKDF(KDFSAX kdf) {
        String strDivide0;
        Object handler = kdf.getUserObject(RPT_ERRORHANDLER);
        if (handler instanceof ReportCalculateErrorProvider) {
            return (ReportCalculateErrorProvider)handler;
        }
        if (handler instanceof CalculateErrorHandler) {
            return new ReportCalculateErrorProvider((CalculateErrorHandler)handler);
        }
        if (handler == null && (strDivide0 = (String)kdf.getUserObject(ZERORDIVIDE)) != null) {
            ReportCalculateErrorProvider h = new ReportCalculateErrorProvider();
            h.setDealException(true);
            h.setExceptionReplacer(strDivide0);
            return h;
        }
        return null;
    }

    public static List extractData(KDFSAX kdf, boolean valueFirst, int[] calIndex) throws KDFSAXException, IOException {
        List book = (List)kdf.getAllTable();
        ArrayList result = new ArrayList(book.size());
        ArrayList<String> names = new ArrayList<String>(book.size());
        result.add(names);
        for (int i = 0; i < book.size(); ++i) {
            RptSheet sheet = (RptSheet)book.get(i);
            if (sheet == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            KDTable table = sheet.getTable();
            if (table == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            names.add(table.getName());
            int rowcount = table.getBody().size();
            ArrayList myBody = new ArrayList(rowcount);
            result.add(myBody);
            for (int j = 0; j < rowcount; ++j) {
                KDTRow row = table.getBody().getRow(j);
                if (row == null) {
                    myBody.add(null);
                    continue;
                }
                ArrayList cells = row.getCells();
                ArrayList<Object> myRow = new ArrayList<Object>(cells.size());
                myBody.add(myRow);
                for (int k = 0; k < cells.size(); ++k) {
                    KDTCell cell = (KDTCell)cells.get(k);
                    if (cell == null) {
                        myRow.add(null);
                        continue;
                    }
                    String s = cell.getExpressions();
                    Object obj = cell.getValue();
                    if (!StringUtils.isEmpty((String)s)) {
                        if (valueFirst || calIndex != null && calIndex[i] < 0) {
                            myRow.add(obj);
                            continue;
                        }
                        myRow.add(s);
                        continue;
                    }
                    myRow.add(obj);
                }
            }
        }
        return result;
    }

    public static List extractData(byte[] data, boolean valueFirst, int[] calIndex) throws KDFSAXException, IOException {
        KDFSAX kdf = new KDFSAX(2);
        kdf.load(ZipUtil.unpack((byte[])data));
        return RptUtil.extractData(kdf, valueFirst, calIndex);
    }

    public static void savePrintSetting(KDTable tbl, KDF kdf) {
        Page foot;
        KDTPrintManager pm = tbl.getPrintManager();
        Page head = pm.getHeader();
        if (head != null) {
            pm.setHeaderID(tbl.getID() + "header");
            kdf.addHeader(head);
        }
        if ((foot = pm.getFooter()) != null) {
            pm.setFooterID(tbl.getID() + "footer");
            kdf.addFooter(foot);
        }
        pm.saveToKDF(kdf);
    }

    public static void recoverPrintSetting(KDTable tbl, KDF kdf) {
        Page head = kdf.getHeader(tbl.getID() + "header");
        Page foot = kdf.getFooter(tbl.getID() + "footer");
        tbl.getPrintManager().setHeaderFooter(head, foot);
        tbl.getPrintManager().setFromKDF(kdf);
    }

    public static String[] splitCheckFormula(String _formula) {
        int rightBracketCount = 0;
        int opFrom = -1;
        int opTo = -1;
        String formula = null;
        formula = _formula.trim();
        while (formula.charAt(0) == '(' && formula.charAt(_formula.length() - 1) == ')') {
            formula = formula.substring(1, formula.length() - 1);
            formula = formula.trim();
        }
        if (formula == null || formula.trim().length() == 0) {
            return null;
        }
        String op = null;
        block1: for (int i = formula.length() - 1; i >= 0; --i) {
            if (formula.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (formula.charAt(i) == '(') {
                --rightBracketCount;
            }
            if (rightBracketCount != 0) continue;
            if (formula.charAt(i) == '=') {
                opTo = i;
                for (int j = i - 1; j >= 0; --j) {
                    if (formula.charAt(j) == ' ') continue;
                    if (formula.charAt(j) == '>' || formula.charAt(j) == '<') {
                        opFrom = j;
                        if (formula.charAt(j) == '>') {
                            op = ">=";
                            break block1;
                        }
                        op = "<=";
                        break block1;
                    }
                    op = "=";
                    break block1;
                }
                break;
            }
            if (formula.charAt(i) == '>') {
                opTo = i;
                for (int j = i - 1; j >= 0; --j) {
                    if (formula.charAt(j) == ' ') continue;
                    if (formula.charAt(j) == '<') {
                        opFrom = j;
                        op = "<>";
                        break block1;
                    }
                    op = ">";
                    break block1;
                }
                break;
            }
            if (formula.charAt(i) != '<') continue;
            opTo = i;
            op = "<";
            break;
        }
        if (opFrom == -1 && opTo == -1) {
            return null;
        }
        if (opFrom == -1) {
            String[] str = new String[]{formula.substring(0, opTo).trim(), formula.substring(opTo + 1).trim(), op};
            return str;
        }
        String[] str = new String[]{formula.substring(0, opFrom).trim(), formula.substring(opTo + 1).trim(), op};
        return str;
    }

    public static boolean isParamTrue(String param) throws Exception {
        ICslParam ip = CslParamFactory.getRemoteInstance();
        CoreBaseCollection ips = ip.getCollection("where key = '" + param + "'");
        if (ips == null || ips.size() < 1) {
            return false;
        }
        return RptUtil.isTrue(((CslParamInfo)ips.get(0)).getValue());
    }

    public static int[] transYearAndPeriodFronBgNumber(String number) {
        int[] returnValue = new int[2];
        ArrayList<String> tokList = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(number, ".");
        while (tok.hasMoreTokens()) {
            tokList.add(tok.nextToken());
        }
        String year = tokList.get(0).toString().substring(0, 4);
        returnValue[0] = Integer.parseInt(year);
        if (tokList.size() == 1) {
            returnValue[1] = 12;
        } else {
            String value = tokList.get(1).toString().substring(0, 2);
            String end = tokList.get(1).toString().substring(2);
            int iv = Integer.parseInt(value);
            if (end.endsWith("HY")) {
                returnValue[1] = iv * 6;
            } else if (end.endsWith("Q")) {
                returnValue[1] = iv * 3;
            } else if (end.endsWith("M")) {
                returnValue[1] = iv;
            } else if (end.endsWith("W")) {
                Calendar calender = Calendar.getInstance();
                calender.setTime(RPTDateUtil.getPeriodLastDate((int)returnValue[0], (int)iv, (RptPeriodTypeEnum)RptPeriodTypeEnum.WEEKLY));
                returnValue[1] = calender.get(2) + 1;
            }
        }
        return returnValue;
    }

    public static boolean isFormulaValid(String text, Sheet _sheet) {
        if (text != null && text.length() > 1) {
            Expr expr;
            if (text.charAt(0) != '=') {
                text = "=" + text;
            }
            if ((expr = _sheet.getExpr(null, text)) == null || expr.isSyntaxError()) {
                return false;
            }
        }
        return true;
    }

    public static int[] transYearAndPeriodFromBgNumber2(String number) throws Exception {
        int[] returnValue = new int[3];
        ArrayList<String> tokList = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(number, ".");
        while (tok.hasMoreTokens()) {
            tokList.add(tok.nextToken());
        }
        String year = tokList.get(0).toString().substring(0, 4);
        returnValue[0] = Integer.parseInt(year);
        if (tokList.size() == 1) {
            returnValue[1] = 12;
            returnValue[2] = 6;
        } else if (tokList.size() == 2) {
            String value = tokList.get(1).toString().substring(0, 2);
            String end = tokList.get(1).toString().substring(2);
            int iv = Integer.parseInt(value);
            if (end.endsWith("HY")) {
                returnValue[1] = iv;
                returnValue[2] = 5;
            } else if (end.endsWith("Q")) {
                returnValue[1] = iv;
                returnValue[2] = 4;
            } else if (end.endsWith("M")) {
                returnValue[1] = iv;
                returnValue[2] = 3;
            } else if (end.endsWith("W")) {
                returnValue[1] = iv;
                if (iv == 53) {
                    returnValue[0] = returnValue[0] + 1;
                    returnValue[1] = 1;
                }
                returnValue[2] = 2;
            }
        } else {
            String value = tokList.get(2).toString();
            if (value.endsWith("MW")) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"264_RptUtil"));
            }
        }
        return returnValue;
    }

    public static FilterInfo buildCustomerFilter(Context ctx, OrgUnitInfo currentBizOrg, boolean isIncludeFreezed) throws EASBizException, BOSException {
        FilterInfo filter;
        String maskString;
        ObjectUuidPK cuPK = new ObjectUuidPK(currentBizOrg.getId());
        ICustomer dataBaseD = null;
        ICtrlUnit ctrlUnit = null;
        if (ctx == null) {
            dataBaseD = CustomerFactory.getRemoteInstance();
            ctrlUnit = CtrlUnitFactory.getRemoteInstance();
        } else {
            dataBaseD = CustomerFactory.getLocalInstance((Context)ctx);
            ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        }
        if (!ctrlUnit.exists((IObjectPK)cuPK)) {
            cuPK = new ObjectUuidPK(currentBizOrg.getCU().getId());
        }
        if (StringUtils.isEmpty((String)(maskString = (filter = dataBaseD.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id")).getMaskString()))) {
            maskString = "";
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (i != 0) {
                    maskString = maskString + " and ";
                }
                maskString = maskString + "#" + i;
            }
        }
        if (isIncludeFreezed) {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            maskString = "(" + maskString + ") and (#" + (filter.getFilterItems().size() - 1);
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(2)));
            maskString = maskString + " or #" + (filter.getFilterItems().size() - 1);
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3)));
            maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
        } else {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
        }
        filter.setMaskString(maskString);
        return filter;
    }

    public static boolean isUseLongNumber(AsstActTypeInfo asstActTypeInfo) {
        return RptUtil.isUseLongNumber(asstActTypeInfo.isUseLongNumber(), asstActTypeInfo.getRealtionDataObject());
    }

    public static boolean isUseLongNumber(boolean isUseLongNumber, String tableName) {
        return isUseLongNumber || tableName.equalsIgnoreCase("T_BD_GeneralAsstActType") || tableName.equalsIgnoreCase("T_ORG_Admin") || tableName.equalsIgnoreCase("T_BD_CashFlowItem") || tableName.equalsIgnoreCase("T_ORG_CostCenter") || tableName.equalsIgnoreCase("T_FDC_CurProject");
    }

    private static boolean isUseLongNumberByAttribute(String attributeName) {
        if (attributeName == null) {
            return false;
        }
        String lowAttribute = attributeName.toLowerCase(Locale.ENGLISH);
        return lowAttribute.startsWith("generalassacttype") || lowAttribute.equals("adminorg") || lowAttribute.equals("cashflowitem");
    }

    public static boolean hasPermission(String userId, String orgId, String funcPermissionName) throws BOSException, EASBizException {
        if (userId == null) {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        if (orgId == null) {
            orgId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, funcPermissionName);
    }

    public static void checkFunctionPermission(String userId, String orgId, String funcPermissionName) throws BOSException, EASBizException {
        if (userId == null) {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        if (orgId == null) {
            orgId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, funcPermissionName);
    }

    public static String getYearPeriod(int startYear, int startPeriod, int endYear, int endPeriod) {
        StringBuffer sb = new StringBuffer();
        if (startYear == endYear && startPeriod == endPeriod) {
            return sb.append(startYear).append(RptUtil.getPeriod(startPeriod)).toString();
        }
        if (startYear == endYear && startPeriod < endPeriod) {
            int diff = endPeriod - startPeriod + 1;
            for (int i = 0; i < diff; ++i) {
                sb.append(startYear).append(RptUtil.getPeriod(startPeriod + i));
                if (i >= diff - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        int yearDiff = endYear - startYear + 1;
        int year = 0;
        int startNum = 0;
        int endNum = 0;
        for (int i = 0; i < yearDiff; ++i) {
            if (i == 0) {
                year = startYear;
                startNum = startPeriod;
                endNum = 14;
            } else {
                year = startYear + i;
                if (year == endYear) {
                    startNum = 1;
                    endNum = endPeriod + 1;
                } else {
                    startNum = 1;
                    endNum = 14;
                }
            }
            for (int j = startNum; j < endNum; ++j) {
                sb.append(year).append(RptUtil.getPeriod(j)).append(",");
            }
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        return sb.toString();
    }

    public static String getPeriod(int period) {
        String sPeriod = null;
        sPeriod = period < 10 ? "0" + period : String.valueOf(period);
        return sPeriod;
    }

    public static Map<String, Cell> getBookCellItemFormula(Book book, boolean isCurrentSheet) {
        return RptUtil.getBookCellItemFormula(book, isCurrentSheet, true);
    }

    public static Map<String, Cell> getBookCellItemFormula(Book book, boolean isCurrentSheet, boolean isIncludeElimSheet) {
        HashMap<String, Cell> cellItemFormula = new HashMap<String, Cell>();
        if (isCurrentSheet) {
            cellItemFormula.putAll(RptUtil.getSheetItemFormula(book.getActiveSheet()));
            return cellItemFormula;
        }
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            if (!book.getSheet(i).isEnableCalculation()) continue;
            Sheet curSheet = book.getSheet(i);
            if (!isIncludeElimSheet && (RptUtil.isInterOrExchSheet(curSheet) || RptUtil.isInvestSheet(curSheet))) continue;
            cellItemFormula.putAll(RptUtil.getSheetItemFormula(curSheet));
        }
        return cellItemFormula;
    }

    private static Map<String, Cell> getSheetItemFormula(Sheet sheet) {
        HashMap<String, Cell> cellItemFormula = new HashMap<String, Cell>();
        int rowIndex = sheet.getMaxRowIndex() + 1;
        int colIndex = sheet.getMaxColIndex() + 1;
        for (int i = 0; i < rowIndex; ++i) {
            for (int j = 0; j < colIndex; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                if (cell == null || cell.getUserObjectValue("ITEM") == null || !"YTBEGIN".equals(((ItemFormula)cell.getUserObjectValue("ITEM")).getDataElementNumber())) continue;
                String cellItemFormulaStr = ((ItemFormula)cell.getUserObjectValue("ITEM")).getFormula();
                cellItemFormula.put(cellItemFormulaStr, cell);
            }
        }
        return cellItemFormula;
    }

    public static void fillYearInitData(Context ctx, ReportInfo report, Book book, FullOrgUnitInfo orgUnit, boolean isCurrentSheet) throws Exception {
        if (report.getReportSourceType() == RptSrcTypeEnum.NORMAL) {
            return;
        }
        if (isCurrentSheet && (RptUtil.isInterOrExchSheet(book.getActiveSheet()) || RptUtil.isInvestSheet(book.getActiveSheet()))) {
            return;
        }
        boolean isAllInterExchInvest = true;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet curSheet = book.getSheet(i);
            if (RptUtil.isInterOrExchSheet(curSheet) || RptUtil.isInvestSheet(curSheet)) continue;
            isAllInterExchInvest = false;
        }
        if (isAllInterExchInvest) {
            return;
        }
        List valueList = null;
        if (report.getCslReport() == null || report.getCslReport().getId() == null) {
            String templateID = report.getTemplate().getId().toString();
            String currencyID = report.getCurrency().getId().toString();
            String orgUnitId = orgUnit.getId().toString();
            Integer year = report.getYear();
            valueList = (ctx == null ? MaintainYearInitDataFacadeFactory.getRemoteInstance() : MaintainYearInitDataFacadeFactory.getLocalInstance((Context)ctx)).getCellValueFromYearInitDataByTemplateID(templateID, orgUnitId, currencyID, year.intValue());
        } else {
            valueList = (ctx == null ? MaintainYearInitDataFacadeFactory.getRemoteInstance() : MaintainYearInitDataFacadeFactory.getLocalInstance((Context)ctx)).getCellValueFromYearInitDataByReportID(report.getCslReport().getId().toString());
        }
        String sheetId = "";
        if (isCurrentSheet) {
            Sheet sheet = book.getActiveSheet();
            sheetId = sheet.getID();
        }
        Map<Object, Object> cellItemFormula = new HashMap();
        boolean needGetCellItemFormula = true;
        if (valueList != null) {
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            while (valueIt.hasNext()) {
                String itemFormula;
                valueMap = (HashMap)valueIt.next();
                BigDecimal value = null;
                int dc = (Integer)valueMap.get("RptItemDC");
                if (valueMap.get("Debit") != null && (valueMap.get("Credit") == null || valueMap.get("Credit") != null && ((BigDecimal)valueMap.get("Credit")).compareTo(zero) == 0)) {
                    value = ((BigDecimal)valueMap.get("Debit")).multiply(new BigDecimal(dc == 1 ? "1" : "-1"));
                }
                if (valueMap.get("Credit") != null && (valueMap.get("Debit") == null || valueMap.get("Debit") != null && ((BigDecimal)valueMap.get("Debit")).compareTo(zero) == 0)) {
                    value = ((BigDecimal)valueMap.get("Credit")).multiply(new BigDecimal(dc == 1 ? "-1" : "1"));
                }
                if (isCurrentSheet && !sheetId.equals(valueMap.get("RptItemSheetID"))) continue;
                String string = itemFormula = valueMap.get("itemFormula") == null ? null : (String)valueMap.get("itemFormula");
                if (needGetCellItemFormula) {
                    cellItemFormula = RptUtil.getBookCellItemFormula(book, isCurrentSheet, false);
                    needGetCellItemFormula = false;
                }
                if (itemFormula == null || cellItemFormula.get(itemFormula) == null) continue;
                Cell cell = (Cell)cellItemFormula.get(itemFormula);
                int currencyScale = (Integer)valueMap.get("CurrencyPrecision");
                if (value != null) {
                    value = value.setScale(currencyScale, 4);
                    cell.setValue(new Variant((Object)value));
                    continue;
                }
                cell.setValue(Variant.nullVariant);
            }
        }
    }

    public static String checkIndexRefList(IndexItemCollection collection) {
        StringBuffer errorDetailMsg = new StringBuffer();
        for (int i = collection.size() - 1; i >= 0; --i) {
            IndexItemInfo indexItem = collection.get(i);
            String cellRef = indexItem.getCell();
            if (TableToolkit.isCorrectSingleCellSelect(cellRef)) continue;
            collection.remove(indexItem);
            errorDetailMsg.append(MessageFormat.format(EASResource.getString((String)RPT_RESOURCE, (String)"errorDetailMsg"), indexItem.getName(), indexItem.getNumber(), indexItem.getCell()));
        }
        return errorDetailMsg.toString();
    }

    public static void calcRange(int startRow, int startCol, int endRow, int endCol, Sheet sheet) throws Exception {
        RptUtil.calcRange(sheet.getRange(startRow, startCol, endRow, endCol), sheet);
    }

    public static void calcRange(Range range, Sheet sheet) throws Exception {
        if (sheet != null) {
            VariableEntry var;
            Book book = sheet.getBook();
            boolean isAutoReCal = false;
            ReportVariables v = ReportVariables.loadFromBook((Book)book);
            if (v != null && (var = v.get("autoCalculateState", book.getName())) != null) {
                isAutoReCal = Boolean.valueOf(var.getValue());
            }
            if (isAutoReCal) {
                Dependents deps = book.getDeps();
                Sheet.ICellsIterator iter = null;
                Cell cell = null;
                for (Object obj : range.getArray()) {
                    if (obj == null) continue;
                    iter = sheet.getCellsIterator((CellBlock)obj, false, true);
                    while (iter.hasNext()) {
                        cell = iter.next();
                        cell.queue(deps, true);
                    }
                }
                deps.calc();
                deps.clearCalcList();
                range.calc(true);
            }
        }
    }

    public static Object copyObject(Object srcObj) throws Exception {
        Object cloneObj = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream obs = new ObjectOutputStream(out);
            obs.writeObject(srcObj);
            obs.close();
            ByteArrayInputStream ios = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(ios);
            cloneObj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw e;
        }
        return cloneObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDBType(String dbNumber) throws Exception {
        if (DbTypeMap == null) {
            FileReader reader;
            block4: {
                DbTypeMap = new HashMap<String, Integer>();
                String easHome = System.getProperty("EAS_HOME");
                String dcInfoFile = null;
                dcInfoFile = easHome == null || easHome.length() <= 0 ? "W:/eas/Server//server/properties/datacenters.xml" : System.getProperty("EAS_HOME") + "/server/properties/datacenters.xml";
                reader = null;
                try {
                    XMLElement xmlEle = new XMLElement();
                    reader = new FileReader(FilenameUtils.normalize((String)dcInfoFile));
                    xmlEle.parseFromReader((Reader)reader);
                    Vector dcList = xmlEle.getChildren();
                    if (dcList == null) break block4;
                    for (int i = 0; i < dcList.size(); ++i) {
                        XMLElement dcEle = (XMLElement)dcList.get(i);
                        if (!"false".equals(dcEle.getStringAttribute("disable").toLowerCase())) continue;
                        DbTypeMap.put(dcEle.getStringAttribute("id"), DbType.getValue((String)dcEle.getStringAttribute("dbtype")));
                    }
                }
                catch (Throwable throwable) {
                    CslRptUtil.closeReader(reader);
                    throw throwable;
                }
            }
            CslRptUtil.closeReader((Reader)reader);
        }
        return DbTypeMap.get(dbNumber);
    }

    public static void showAttachmentListUIByBoID(boolean isSave, String boID, Object owner, boolean isEdit) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        String requestId = "RptAttachment" + boID;
        if (!isSave || !mutexServiceControl.requestBizObjIDForUpdate(requestId)) {
            isEdit = false;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setEdit(isEdit);
        info.setNumber(null);
        UIContext uictx = new UIContext(owner);
        uictx.put((Object)AttachmentUIContextInfo.class.getName(), (Object)info);
        String uiname = RptAttachmentListUI.class.getName();
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx, null);
    }

    public static boolean isInterOrExchSheet(Sheet sheet) {
        int reportClass = RptUtil.getSheetType(sheet);
        boolean isInter = reportClass == 10;
        boolean isExch = reportClass == 20;
        return isInter || isExch;
    }

    public static boolean isInvestSheet(Sheet sheet) {
        int reportClass = RptUtil.getSheetType(sheet);
        return reportClass == 30 || reportClass == 40;
    }

    public static int getSheetType(Sheet sheet) {
        ReportVariables v = ReportVariables.loadFromBook((Book)sheet.getBook());
        if (v == null) {
            return 1;
        }
        int reportClass = v.getIntValue("SheetClass", sheet.getSheetName(), 1);
        return reportClass;
    }

    static {
        TRUTH = new String[]{"true", "yes", "1", "sure", "Y", "confirm", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"280_RptUtil")};
        FALSE = new String[]{"false", "no", "0", "cancel", "N", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"281_RptUtil")};
    }
}

