/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBook;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBookVO;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.BizClient;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportCommon;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCommonFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.CommonMsgBoxUICancelOnly;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptNumberSelectorUI;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RptUtilForClient {
    public static boolean isNullCollection(IObjectCollection col) {
        return col.size() == 0 || col != null && col.isEmpty();
    }

    public static void calculateSumReport(ReportInfo report, Book book) throws Exception {
        ReportBaseCollection subReports = report.getSubReport();
        ArrayList<String> subReportIds = new ArrayList<String>();
        boolean autoCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        if (RptUtilForClient.isNullCollection((IObjectCollection)subReports)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("SubReportNull"));
            SysUtil.abort();
        } else {
            int size = subReports.size();
            for (int i = 0; i < size; ++i) {
                subReportIds.add(subReports.get(i).getId().toString());
            }
        }
        HashMap<String, SumcalcRange> sheetIDs = new HashMap<String, SumcalcRange>();
        boolean isExistsSumZone = false;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (sheet == null) continue;
            String sheetName = sheet.getSheetName();
            SumcalcRange sumZone = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
            if (sumZone == null || sumZone.isEmpty()) continue;
            sheetIDs.put(sheetName, sumZone);
            isExistsSumZone = true;
        }
        ICslRptCalculator calculator = CslRptCalculatorFactory.getRemoteInstance();
        HashMap cellMap = null;
        cellMap = !isExistsSumZone ? calculator.calculateSumRptBySheets(subReportIds, RptUtilForClient.getSheetsID(book)) : calculator.calculateSumRptBySheets(subReportIds, sheetIDs);
        RptUtilForClient.loadTables(isExistsSumZone, book, cellMap);
        report.setBook(book);
        book.setCalculate(autoCalculate);
    }

    public static ArrayList getSheetsID(Book book) throws Exception {
        ArrayList<String> res = new ArrayList<String>(book.getSheetCount());
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet table = book.getSheet(i);
            String id = table.getID();
            if (StringUtils.isEmpty((String)id)) continue;
            res.add(id);
        }
        return res;
    }

    public static void loadTables(boolean isExistsSumZone, Book book, HashMap cellMap) {
        if (cellMap == null) {
            return;
        }
        if (cellMap != null && isExistsSumZone) {
            cellMap = (HashMap)cellMap.get("sumBySheet");
        }
        if (cellMap == null) {
            return;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet table = book.getSheet(i);
            String sheetTag = isExistsSumZone ? table.getSheetName() : table.getID();
            HashMap map = (HashMap)cellMap.get(sheetTag);
            if (map == null) continue;
            for (Point pos : map.keySet()) {
                Cell cell = table.getCell(pos.y, pos.x, true);
                if (cell == null) continue;
                HashMap cellInfo = (HashMap)map.get(pos);
                if (!isExistsSumZone) {
                    cell.setFormula("=" + cellInfo.get("expression"));
                }
                cell.setValue(new Variant(cellInfo.get("value")));
            }
        }
    }

    public static Book LockBookExpTank(Book book) {
        return RptUtilForClient.isLockBookExpTank(book, true);
    }

    public static Book isLockBookExpTank(Book book, boolean isLock) {
        RptCheckExpTank tank;
        if (book == null) {
            return null;
        }
        BookProperties p = BookProperties.loadFromBook(book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(book);
        }
        if ((tank = p.getOperationSchema().getExpTank()) != null && tank.getExpressions() != null) {
            Iterator it = tank.getExpressions().iterator();
            RptCheckExpression exp = null;
            while (it.hasNext()) {
                exp = (RptCheckExpression)it.next();
                if (exp == null) continue;
                exp.setStatus(isLock ? 0 : 3);
            }
        }
        return book;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoByNumber(String number) throws BOSException {
        return RptUtilForClient.getCompanyOrgUnitInfoByNumber(null, number);
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoByNumber(Context ctx, String number) throws BOSException {
        CompanyOrgUnitInfo company = null;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("accountPeriodType.name"));
        ICompanyOrgUnit icompany = null;
        icompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection companyCl = icompany.getCompanyOrgUnitCollection(view);
        if (companyCl.size() > 0) {
            company = companyCl.get(0);
        }
        return company;
    }

    public static ProfitCenterOrgUnitInfo getProfitCenterOrgUnitInfoByNumber(String number) throws BOSException {
        return RptUtilForClient.getProfitCenterOrgUnitInfoByNumber(null, number);
    }

    public static ProfitCenterOrgUnitInfo getProfitCenterOrgUnitInfoByNumber(Context ctx, String number) throws BOSException {
        ProfitCenterOrgUnitInfo profit = null;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        IProfitCenterOrgUnit Iprofit = null;
        Iprofit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        ProfitCenterOrgUnitCollection profitCol = Iprofit.getProfitCenterOrgUnitCollection(view);
        if (profitCol != null && profitCol.size() > 0) {
            profit = profitCol.get(0);
        }
        return profit;
    }

    public static AccountViewCollection getAccountViewCollectionByNumber(Context ctx, String acctFrom, String acctTo, String accountTableid) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        if (acctFrom != null) {
            set.add(acctFrom);
        }
        if (acctTo != null) {
            set.add(acctTo);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableid, CompareType.EQUALS));
        view.setFilter(filter);
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection coll = iAccountView.getAccountViewCollection(view);
        return coll;
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnitCollectionByByNumber(String number) throws BOSException, EASBizException {
        CompanyOrgUnitCollection companyOrgUnitCollection = null;
        HashSet<String> numberSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)number)) {
            CompanyOrgUnitInfo currentCompany = RptUtilForClient.getCurrentCompany();
            companyOrgUnitCollection = new CompanyOrgUnitCollection();
            companyOrgUnitCollection.add(currentCompany);
            return companyOrgUnitCollection;
        }
        String[] companyNumber = number.split(";\\s*");
        numberSet.addAll(Arrays.asList(companyNumber));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
        companyOrgUnitCollection = icompany.getCompanyOrgUnitCollection(view);
        return companyOrgUnitCollection;
    }

    public static CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    public static CurrencyInfo getCurrentCurrency() throws BOSException, EASBizException {
        CurrencyInfo res = (CurrencyInfo)SysContext.getSysContext().getProperty((Object)"CurrentCurrency");
        if (res == null) {
            CompanyOrgUnitInfo company = RptUtilForClient.getCurrentCompany();
            CurrencyInfo currencyInfo = res = company == null ? null : company.getBaseCurrency();
            if (res != null && (res.getNumber() == null || res.getNumber().length() == 0)) {
                res = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(res.getId()));
            }
            if (res != null) {
                SysContext.getSysContext().setProperty((Object)"CurrentCurrency", (Object)res);
            }
        }
        return res;
    }

    public static CurrencyInfo getBasicCurrency() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        String baseCurrencyId = company.getBaseCurrency().getId().toString();
        ObjectStringPK pk = new ObjectStringPK(baseCurrencyId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("precision"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        CurrencyInfo currInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, selector);
        return currInfo;
    }

    public static CurrencyInfo getCurrenctCurrencyFromDatabase() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = RptUtilForClient.getCurrentCompany();
        if (company == null) {
            return null;
        }
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        String currencyIdString = null;
        currencyIdString = baseCurrency == null || baseCurrency.getNumber() == null ? ((CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(company.getId()))).getBaseCurrency().getId().toString() : baseCurrency.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyIdString));
        view.setFilter(filter);
        CurrencyInfo currencyInfo = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getCollection(view).get(0);
        if (currencyInfo != null) {
            SysContext.getSysContext().setProperty((Object)"CurrentCurrency", (Object)currencyInfo);
        }
        return currencyInfo;
    }

    public static CurrencyInfo getCurrency(String number) throws Exception {
        ICurrency initICurrcny = CurrencyFactory.getRemoteInstance();
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        sicCurrency.add(new SelectorItemInfo("precision"));
        FilterInfo filterCurrency = new FilterInfo();
        filterCurrency.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewCurrency.setFilter(filterCurrency);
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(viewCurrency);
        if (initCurrencyCollection.size() > 0) {
            return initCurrencyCollection.get(0);
        }
        return null;
    }

    public static CurrencyInfo getCurrencyByName(String name) throws Exception {
        ICurrency initICurrcny = CurrencyFactory.getRemoteInstance();
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        FilterInfo filterCurrency = new FilterInfo();
        filterCurrency.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        viewCurrency.setFilter(filterCurrency);
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(viewCurrency);
        if (initCurrencyCollection.size() > 0) {
            return initCurrencyCollection.get(0);
        }
        return null;
    }

    public static Integer inquireNumber(String title, String tip, int defaultValue, int minValue, int maxValue, Object owner) {
        RptNumberSelectorUI wz;
        try {
            wz = RptNumberSelectorUI.getInstance((Object)owner);
        }
        catch (Exception e) {
            return null;
        }
        wz.open(title, tip, defaultValue, minValue, maxValue);
        return wz.isOk() ? wz.getValue() : null;
    }

    public static Pair inquireInfo(String title, String tip, String defaultValue, Object owner) {
        return RptUtilForClient.inquireInfo(title, tip, defaultValue, owner, false);
    }

    public static Pair inquireInfo(String title, String tip, String defaultValue, Object owner, boolean verify) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("title", title == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptutil-input", (Locale)SysContext.getSysContext().getLocale()) : title);
        ht.put("label", tip == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptutil-input", (Locale)SysContext.getSysContext().getLocale()) : tip);
        ht.put("edit", defaultValue);
        ht.put("verify", verify);
        UIContext uc = new UIContext(owner);
        uc.put((Object)"para", ht);
        try {
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.rpt.client.NameEditUI", (Map)uc).show();
        }
        catch (Exception e) {
            return null;
        }
        return new Pair(ht.get("action"), ht.get("edit"));
    }

    public static Pair inquireInfoForDivide(String title, String defaultValue, Object owner) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("title", title == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptutil-input", (Locale)SysContext.getSysContext().getLocale()) : title);
        ht.put("label", "");
        ht.put("edit", defaultValue);
        UIContext uc = new UIContext(owner);
        uc.put((Object)"para", ht);
        try {
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.rpt.client.NameEditForDivideUI", (Map)uc).show();
        }
        catch (Exception e) {
            return null;
        }
        return new Pair(ht.get("action"), ht.get("edit"));
    }

    public static Pair inquireInfo(String title, String defaultValue, Object owner, boolean verify) {
        return RptUtilForClient.inquireInfo(title, null, defaultValue, owner, verify);
    }

    public static Pair inquireInfo(String title, String defaultValue, Object owner) {
        return RptUtilForClient.inquireInfo(title, null, defaultValue, owner);
    }

    public static Pair inquireInfo(String title, Object owner) {
        return RptUtilForClient.inquireInfo(title, null, null, owner);
    }

    public static Pair inquireInfo(Object owner) {
        return RptUtilForClient.inquireInfo(null, null, null, owner);
    }

    public static boolean editDataIsInWorkflow(String editDataID) throws Exception {
        BizClient bizClient = BizClient.newInstance();
        AssignmentInfo[] assignments = bizClient.checkAssignmentInfos(editDataID, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        return assignments != null && assignments.length != 0;
    }

    public static void checkTemplateDataPermission(String permItem, IObjectPK dataPK) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        ReportFactory.getRemoteInstance().checkReportDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItem, dataPK);
    }

    public static void checkTemplateDataPermission(String permItem, IObjectPK dataPK, IObjectPK orgPK) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        orgPK = orgPK != null ? orgPK : new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        ReportFactory.getRemoteInstance().checkReportDataPermission((IObjectPK)userPK, orgPK, permItem, dataPK);
    }

    public static void checkReportDataPermission(String permItem, IObjectPK dataPK) throws BOSException, EASBizException {
        String oql = "SELECT ID, PublicStatus, Creator WHERE ID = '" + dataPK.toString() + "'";
        CoreBaseCollection rpts = ReportFactory.getRemoteInstance().getCollection(oql);
        if (rpts == null || rpts.size() < 1) {
            return;
        }
        RptUtilForClient.checkReportDataPermission(permItem, (ReportInfo)rpts.get(0));
    }

    public static void checkReportDataPermission(String permItem, ReportInfo report) throws BOSException, EASBizException {
        if (report.getCreator().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId())) {
            return;
        }
        if (report.getPublicStatus().getValue() == 2) {
            return;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        ReportFactory.getRemoteInstance().checkReportDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItem, (IObjectPK)new ObjectUuidPK(report.getId()));
    }

    public static boolean hasReportDataPermission(String permItem, IObjectPK dataPK) throws BOSException, EASBizException {
        String oql = "SELECT ID, PublicStatus,Creator,company WHERE ID = '" + dataPK.toString() + "'";
        CoreBaseCollection rpts = ReportFactory.getRemoteInstance().getCollection(oql);
        if (rpts == null || rpts.size() < 1) {
            return true;
        }
        return RptUtilForClient.hasReportDataPermission(permItem, (ReportInfo)rpts.get(0));
    }

    public static boolean isEditOprtStatus(String permItem, IObjectPK dataPK) throws BOSException, EASBizException {
        String oql = "SELECT ID, PublicStatus,auditedStatus,Creator,company WHERE ID = '" + dataPK.toString() + "'";
        CoreBaseCollection rpts = ReportFactory.getRemoteInstance().getCollection(oql);
        if (rpts == null || rpts.size() < 1) {
            return true;
        }
        if (AuditedStatusEnum.AUDITED.equals((Object)((ReportInfo)rpts.get(0)).getAuditedStatus())) {
            return false;
        }
        return RptUtilForClient.hasReportDataPermission(permItem, (ReportInfo)rpts.get(0));
    }

    public static boolean hasReportDataPermission(String permItem, ReportInfo report) throws BOSException, EASBizException {
        if (report == null || report.getId() == null || report.getCreator() == null) {
            return true;
        }
        if (report.getCreator().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId())) {
            return true;
        }
        if (report.getPublicStatus().getValue() == 2) {
            return true;
        }
        IPermission perm = PermissionFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(report.getCompany().getId());
        return perm.hasDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItem, (IObjectPK)new ObjectUuidPK(report.getId()));
    }

    public static File toExcelFile(KDTable[] tables) throws Exception {
        if (tables != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eastemp", ".xls");
            path = tempFile.getCanonicalPath();
            KDTables2KDSBookVO[] tablesVO = new KDTables2KDSBookVO[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tablesVO[i] = new KDTables2KDSBookVO(tables[i], false, false, false);
            }
            KDSBook book = null;
            book = KDTables2KDSBook.getInstance().exportKDTablesToKDSBook(tablesVO, true, true);
            exportM.exportToExcel(book, path);
            return new File(path);
        }
        return null;
    }

    public static File toHTMLFile(KDTable[] tables) throws Exception {
        if (tables != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eastemp", ".html");
            path = tempFile.getCanonicalPath();
            KDTables2KDSBookVO[] tablesVO = new KDTables2KDSBookVO[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tablesVO[i] = new KDTables2KDSBookVO(tables[i], false, false, false);
            }
            KDSBook book = null;
            book = KDTables2KDSBook.getInstance().exportKDTablesToKDSBook(tablesVO, true, true);
            PrintableBook printBook = new PrintableBook(book);
            exportM.exportToHtmlFile(printBook, path);
            File file = new File(path);
            return file;
        }
        return null;
    }

    public static void prepareReportInfo4Display(IObjectValue model, Book book) {
        if (model instanceof ReportInfo || model instanceof TemplateInfo || model instanceof CslReportInfo) {
            int i;
            VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
            PostilCollection postils = null;
            BookProperties properties = BookProperties.loadFromBook(book);
            ReportVariables variables = properties.getVariables();
            RptSheetParamCollection sheetParam = virtualSheetParamInfo.getSheetParam();
            RptPeriodTypeEnum periodType = null;
            periodType = virtualSheetParamInfo instanceof ReportBaseInfo ? ((ReportBaseInfo)virtualSheetParamInfo).getPeriodType() : ((TemplateInfo)virtualSheetParamInfo).getPeriodType();
            for (i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
                RptSheetParamInfo p = sheetParam.get(i);
                if (p.getReport() != null && p.getReport().get("sourceType") == null && model.get("sourceType") != null) {
                    p.getReport().put("sourceType", model.get("sourceType"));
                }
                ReportVariables sheetV = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
                variables.addAll(sheetV, false);
            }
            properties.restoreToBook(book);
            postils = virtualSheetParamInfo instanceof ReportBaseInfo ? ((ReportBaseInfo)virtualSheetParamInfo).getPostils() : ((TemplateInfo)virtualSheetParamInfo).getPostils();
            if (postils != null && postils.size() > 0) {
                for (i = 0; i < postils.size(); ++i) {
                    PostilInfo pi = postils.get(i);
                    if (pi.getPostilType() == PostilTypeEnum.REPORT) {
                        try {
                            RptComment comment;
                            RptCommentTank rptComment;
                            Comment ct = book.getComment();
                            if (ct == null || !(ct instanceof RptCommentTank)) {
                                rptComment = CommentUtil.createRptCommentTank((UserInfo)pi.getCreator(), (Timestamp)pi.getLastUpdateTime(), (String)pi.getDescription());
                                book.setComment((Comment)rptComment);
                                continue;
                            }
                            if (!(ct instanceof RptCommentTank) || RptUtilForClient.isCommentExist(rptComment = (RptCommentTank)ct, comment = new RptComment(pi))) continue;
                            rptComment.addEntry(comment);
                        }
                        catch (Exception ct) {}
                        continue;
                    }
                    if (pi.getPostilType() == PostilTypeEnum.SHEET) {
                        try {
                            RptComment comment;
                            RptCommentTank rptComment;
                            Sheet sheet = book.getSheetByID(pi.getSheet().getSheetID());
                            Comment ct = sheet.getComment();
                            if (ct == null || !(ct instanceof RptCommentTank)) {
                                rptComment = CommentUtil.createRptCommentTank((UserInfo)pi.getCreator(), (Timestamp)pi.getLastUpdateTime(), (String)pi.getDescription());
                                sheet.setComment((Comment)rptComment);
                                continue;
                            }
                            if (!(ct instanceof RptCommentTank) || RptUtilForClient.isCommentExist(rptComment = (RptCommentTank)ct, comment = new RptComment(pi))) continue;
                            rptComment.addEntry(comment);
                        }
                        catch (Exception sheet) {}
                        continue;
                    }
                    if (pi.getPostilType() != PostilTypeEnum.CELL) continue;
                    Rect rect = TableToolkit.range2xy(pi.getCellName());
                    pi.getCellName();
                    Sheet sheet = book.getSheetByID(pi.getSheet().getSheetID());
                    Cell cell = sheet.getCell(rect.y1, rect.x1, true);
                    RptCommentTank ct = CommentUtil.getReportComment((Cell)cell, (boolean)false);
                    if (ct == null) {
                        ct = new RptCommentTank();
                        cell.setComment((Comment)ct);
                    }
                    try {
                        RptComment comment = new RptComment(pi);
                        if (RptUtilForClient.isCommentExist(ct, comment)) continue;
                        ct.addEntry(comment);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static boolean isCommentExist(RptCommentTank ct, RptComment comment) {
        if (comment.getSource() == null || comment.getSource().getId() == null) {
            return false;
        }
        String commentId = comment.getSource().getId().toString();
        for (int i = 0; i < ct.getSize(); ++i) {
            RptComment tempComment = ct.getEntry(i);
            if (tempComment.getSource() == null || tempComment.getSource().getId() == null || !commentId.equals(tempComment.getSource().getId().toString())) continue;
            return true;
        }
        return false;
    }

    public static void prepareReportInfo4Save(IObjectValue model, Book book) {
        if (model instanceof ReportInfo || model instanceof TemplateInfo || model instanceof CslReportInfo) {
            VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
            PostilCollection postils = null;
            ReportVariables variables = ReportVariables.loadFromBook((Book)book);
            virtualSheetParamInfo.getSheetParam().clear();
            postils = virtualSheetParamInfo instanceof ReportBaseInfo ? ((ReportBaseInfo)virtualSheetParamInfo).getPostils() : ((TemplateInfo)virtualSheetParamInfo).getPostils();
            postils.clear();
            Comment bookcomment = book.getComment();
            RptCommentTank ct = null;
            ct = !(bookcomment instanceof RptCommentTank) ? CommentUtil.convertComment((Comment)bookcomment, (UserInfo)SysContext.getSysContext().getCurrentUserInfo()) : (RptCommentTank)bookcomment;
            if (ct != null) {
                int n = ct.getSize();
                for (int i = 0; i < n; ++i) {
                    PostilInfo source = ct.getEntry(i).getTrueSource();
                    source.setPostilType(PostilTypeEnum.REPORT);
                    postils.add(source);
                    if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                        source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                        continue;
                    }
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
            }
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                String name = sheet.getSheetName();
                RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
                pinfo.setSheetID(sheet.getID());
                if (virtualSheetParamInfo instanceof CslReportInfo) {
                    pinfo.setRelaType(ReportTypeEnum.CSLREPORT);
                } else if (virtualSheetParamInfo instanceof ReportInfo) {
                    pinfo.setRelaType(ReportTypeEnum.REPORT);
                } else if (virtualSheetParamInfo instanceof TemplateInfo) {
                    pinfo.setRelaType(ReportTypeEnum.TEMPLATE);
                }
                virtualSheetParamInfo.getSheetParam().add(pinfo);
                RptUtilForClient.pickPostil(virtualSheetParamInfo, sheet, postils, pinfo);
            }
        }
    }

    private static void pickPostil(VirtualSheetParamInfo virtualSheetParamInfo, Sheet sheet, PostilCollection postils, RptSheetParamInfo p) {
        Comment bookcomment = sheet.getComment();
        RptCommentTank ct = null;
        ct = !(bookcomment instanceof RptCommentTank) ? CommentUtil.convertComment((Comment)bookcomment, (UserInfo)SysContext.getSysContext().getCurrentUserInfo()) : (RptCommentTank)bookcomment;
        if (ct != null) {
            int n = ct.getSize();
            for (int i = 0; i < n; ++i) {
                PostilInfo source = (PostilInfo)ct.getEntry(i).getTrueSource().clone();
                source.setPostilType(PostilTypeEnum.SHEET);
                source.setSheet(p);
                if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                    source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                } else {
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
                postils.add(source);
            }
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            ct = CommentUtil.getReportComment((Cell)cell);
            if (ct == null) continue;
            int n = ct.getSize();
            for (int i = 0; i < n; ++i) {
                PostilInfo source = (PostilInfo)ct.getEntry(i).getTrueSource().clone();
                source.setPostilType(PostilTypeEnum.CELL);
                source.setSheet(p);
                source.setCellName(cell.getName(false, false));
                if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                    source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                } else {
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
                postils.add(source);
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null) continue;
                String num = f.getItemNumber();
                if (num == null || num.trim().length() < 1) {
                    num = f.getDItemNumber();
                }
                source.setItemNumber(num);
            }
        }
    }

    public static boolean checkExistsRequisition(ReportBaseInfo info) throws Exception {
        ReportBaseCollection c = new ReportBaseCollection();
        c.add(info);
        return RptUtilForClient.checkExistsRequisition((IObjectCollection)c);
    }

    public static boolean checkExistsRequisition(IObjectCollection coll) throws Exception {
        ArrayList<List> list = new ArrayList<List>();
        String p1 = ParamManager.getParamValue(null, null, (String)"GR_CSL_CACHECK_001");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        p1 = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), (String)"GLG01");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        IReportCommon iR = ReportCommonFactory.getRemoteInstance();
        Iterator it = coll.iterator();
        HashSet<String> PeriodAndYear = new HashSet<String>();
        while (it.hasNext()) {
            ReportBaseInfo info = (ReportBaseInfo)it.next();
            int period = info.getPeriod();
            int year = info.getYear();
            if (RptPeriodTypeEnum.MONTHLY != info.getPeriodType()) {
                Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)info.getPeriodType());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                year = calendar.get(1);
                period = calendar.get(2) + 1;
            }
            if (PeriodAndYear.contains(String.valueOf(year) + String.valueOf(period))) continue;
            List checked = iR.requisitionCheckData(String.valueOf(year) + '.' + String.valueOf(period), 1, 2);
            if (list != null && list.size() > 0) {
                list.add(checked);
            }
            PeriodAndYear.add(String.valueOf(year) + String.valueOf(period));
        }
        if (list != null && list.size() > 0 && (Integer)list.get(0) != 0) {
            StringBuffer sResult = new StringBuffer();
            sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"265_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale())).append(list.get(1)).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"282_RptUtilForClient")).append("\n");
            sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"266_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale())).append(list.get(0)).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"282_RptUtilForClient")).append("\n");
            String[] s = (String[])list.get(2);
            if (s != null) {
                sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"267_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
                for (int i = 0; i < s.length; ++i) {
                    sResult.append(s[i]).append(",");
                }
                sResult.deleteCharAt(sResult.length() - 1);
            }
            UIContext ctx = new UIContext((Object)ComponentUtil.getOwnerWindow(null));
            ctx.put((Object)"Title", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"268_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
            ctx.put((Object)"TextLabel", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"269_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
            ctx.put((Object)"TextMsg", (Object)sResult.toString());
            CommonMsgBoxUICancelOnly.showMessageByModel((UIContext)ctx);
            SysUtil.abort();
        }
        return false;
    }

    public static boolean isTableSelect(KDTable table) {
        if (table != null) {
            ArrayList blocks = table.getSelectManager().getBlocks();
            for (KDTSelectBlock block : blocks) {
                if (block.getMode() != 8) continue;
                return true;
            }
        }
        return false;
    }

    public static void selectRows(KDTable table, String colum, List values) {
        int rowCount = table.getRowCount();
        int firstFindRow = 0;
        for (int i = 0; i < rowCount; ++i) {
            ICell cell = table.getRow(i).getCell(colum);
            if (cell == null || cell.getValue() == null || !values.contains(cell.getValue())) continue;
            table.getSelectManager().add(i, 0);
            if (firstFindRow >= true) continue;
            firstFindRow = i;
        }
    }

    public static void getDynaKeyAndValue(Book book) throws Exception {
        if (book == null) {
            return;
        }
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ArrayList allKeyRow;
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null) continue;
            HashMap leftKeyColAndAllRow = CslRptUIUtil.getLeftColAndAllLeftRow((Sheet)sheet, (SumcalcRange)keyZone);
            if (valueZone == null || leftKeyColAndAllRow.get("leftCol") == null || (allKeyRow = (ArrayList)leftKeyColAndAllRow.get("allRow")).size() == 0) continue;
            ArrayList allValueCol = RptUtilForClient.getKeyValueCol(sheet, valueZone, allKeyRow);
            sheet.setUserObject("allValueCol", (Object)allValueCol);
            sheet.setUserObject("keyLeftCol", (Object)((Integer)leftKeyColAndAllRow.get("leftCol")));
            RptUtilForClient.reSaveKeyZoneByRange(sheet, allKeyRow, (Integer)leftKeyColAndAllRow.get("leftCol"));
        }
    }

    public static ArrayList getKeyValueCol(Sheet sheet, SumcalcRange zone, ArrayList allRow) {
        ArrayList<Integer> valueCol = new ArrayList<Integer>();
        for (int index = 0; index < zone.size(); ++index) {
            CellBlock block = zone.getCellBlock(index);
            for (int i = block.getCol(); i <= block.getCol2(); ++i) {
                if (valueCol.contains(new Integer(i))) continue;
                valueCol.add(new Integer(i));
            }
        }
        return valueCol;
    }

    public static void reSaveKeyZoneByRange(Sheet sheet, ArrayList allKeyRow, Integer keyLeftCol) {
        int beginRow;
        SumcalcRange newKeyZone = new SumcalcRange();
        Object[] o = allKeyRow.toArray();
        Arrays.sort(o);
        int endRow = beginRow = ((Integer)o[0]).intValue();
        for (int i = 0; i <= o.length && i != o.length + 1; ++i) {
            CellBlock cb;
            int row;
            if (i != o.length) {
                row = (Integer)o[i];
                if (endRow == row) {
                    ++endRow;
                    continue;
                }
                cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
                beginRow = row;
                endRow = row + 1;
                newKeyZone.addRange(sheet.getRange(cb));
                continue;
            }
            row = (Integer)o[o.length - 1];
            if (endRow - 1 != row) continue;
            cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
            newKeyZone.addRange(sheet.getRange(cb));
        }
        sheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
    }

    public static void checkFormulasBeforAudit(CoreUI ui, ReportInfo reportInfo, Book book) throws EASBizException, BOSException {
        boolean needCheck = CSLParamUtil.isRptReceive001(null);
        if (reportInfo.getAuditedStatus() != null && reportInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED) && needCheck && (reportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT) && reportInfo.getIsSupportGroup().equals((Object)IsSupportGroupReportEnum.SUPPORT)) {
            ArrayList<ReportInfo> l = new ArrayList<ReportInfo>();
            l.add(reportInfo);
            List rst = CslReportFactory.getRemoteInstance().preCheckReport(l);
            String checkResult = null;
            boolean passed = true;
            if (rst != null && rst.size() > 0) {
                for (int i = 0; i < rst.size(); ++i) {
                    Map data = (Map)rst.get(i);
                    if (data != null && data.get("KEY_CHECK_MESSAGE") != null) {
                        checkResult = (String)data.get("KEY_CHECK_MESSAGE");
                    }
                    if (data == null || data.get("KEY_CHECK_FLAG") == null) continue;
                    passed = (Boolean)data.get("KEY_CHECK_FLAG");
                }
            }
            if (!StringUtils.isEmpty(checkResult)) {
                UIContext uiCtx = new UIContext((Object)ui);
                uiCtx.put((Object)"String", checkResult);
                uiCtx.put((Object)"auditCheckAll", (Object)rst);
                uiCtx.put((Object)"book", (Object)book);
                uiCtx.put((Object)"id", (Object)reportInfo.getId().toString());
                uiCtx.put((Object)"reportSystem", (Object)new Boolean(true));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                uiWindow.show();
                ui.repaint();
            } else {
                ArrayList<String> ReportIdList = new ArrayList<String>();
                ReportIdList.add(reportInfo.getId().toString());
                if (ReportIdList.size() > 0) {
                    ItemFormulaCheckResultFactory.getRemoteInstance().batchDelete(ReportIdList);
                    for (int m = 0; m < book.getSheetCount(); ++m) {
                        book.getSheet(m).removeUserObject("FormulaErrorCell");
                    }
                    ui.repaint();
                }
            }
            if (!passed) {
                SysUtil.abort();
            }
        }
    }

    public static void setWindowIsNotResizable(IUIWindow uiWindow) {
        if (uiWindow instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)uiWindow;
            uiFrame.setResizable(false);
        }
    }

    public static String getRptCompanyInFormula(FormulaWizardUI formulaWizardUI) {
        Object companyId;
        if (formulaWizardUI != null && formulaWizardUI.getRptContext() != null && formulaWizardUI.getRptContext().getPropertyAdapter() != null && (companyId = formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("Company.ID")) != null) {
            return companyId.toString();
        }
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    public static boolean isCslGradeManageFilter(FormulaWizardUI formulaWizardUI) {
        Integer rptType;
        return formulaWizardUI == null || formulaWizardUI.getRptContext() == null || formulaWizardUI.getRptContext().getPropertyAdapter() == null || (rptType = (Integer)formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("Report.SourceType")) == null || rptType != 12 && rptType != 11 && rptType != 35 && rptType != 34 && rptType != 32 && rptType != 33 && rptType != 31 && rptType != 15 && rptType != 14 && rptType != 3 && rptType != 4 && rptType != 6;
    }
}

