/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.eas.fi.rpt.excelformula.util.AreaReference;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SumcalcRange
implements Serializable {
    private static final long serialVersionUID = 6128444671714606306L;
    private SortedCellBlockArray cellblocks = null;

    public SumcalcRange() {
        this.cellblocks = new SortedCellBlockArray();
    }

    public SumcalcRange(String range) {
        this.addRange(range);
    }

    public SortedCellBlockArray getRanges() {
        return this.cellblocks;
    }

    public boolean contains(CellBlock block) {
        return this.cellblocks.contains(block);
    }

    public void setRanges(SortedCellBlockArray rs) {
        this.cellblocks = rs;
    }

    public void addRanges(SumcalcRange r) {
        for (int k = 0; k < r.size(); ++k) {
            this.addCellBlock(r.getCellBlock(k));
        }
    }

    public void addRange(Range range) {
        for (int i = 0; i < range.size(); ++i) {
            this.addCellBlock(range.getBlock(i));
        }
    }

    public void removeRange(Range range) {
        for (int i = 0; i < range.size(); ++i) {
            this.removeCellBlock(range.getBlock(i));
        }
    }

    public void removeCellBlock(CellBlock block) {
        SortedCellBlockArray tp = new SortedCellBlockArray();
        for (int i = this.cellblocks.size() - 1; i >= 0; --i) {
            CellBlock b = this.cellblocks.getBlock(i);
            this.cellblocks.remove(b);
            block.split(b, tp);
        }
        if (tp != null && tp.size() > 0) {
            this.cellblocks.insertAll((SortedObjectArray)tp);
        }
    }

    public void addCellBlock(CellBlock b) {
        this.addCell(b);
    }

    private void addCell(CellBlock block) {
        CellBlock b;
        int i;
        for (i = 0; i < this.cellblocks.size(); ++i) {
            b = this.cellblocks.getBlock(i);
            if (!b.contains(block)) continue;
            return;
        }
        for (i = 0; i < this.cellblocks.size(); ++i) {
            b = this.cellblocks.getBlock(i);
            if (!b.isIntersect(block)) continue;
            this.cellblocks.remove(b);
            block.split(b, this.cellblocks);
        }
        this.cellblocks.insert((Object)block);
    }

    public int size() {
        return this.cellblocks.size();
    }

    public CellBlock getCellBlock(int i) {
        return this.cellblocks.getBlock(i);
    }

    public boolean isEmpty() {
        return this.cellblocks == null || this.cellblocks.size() < 1;
    }

    public void fromSerialString(String s) throws Exception {
        this.cellblocks = new SortedCellBlockArray();
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        this.addRange(s);
    }

    public void addRange(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        if (this.cellblocks == null) {
            this.cellblocks = new SortedCellBlockArray();
        }
        String[] clips = s.split(",");
        for (int i = 0; i < clips.length; ++i) {
            AreaReference ar = new AreaReference(clips[i]);
            CellReference[] cells = ar.getCells();
            if (cells.length == 1) {
                this.cellblocks.insert((Object)CellBlock.getNewCellBlock((int)cells[0].getRow(), (int)cells[0].getCol()));
                continue;
            }
            if (cells.length != 2) continue;
            int r = cells[1].getRow();
            short c = cells[1].getCol();
            this.cellblocks.insert((Object)CellBlock.getNewCellBlock((int)(cells[0].getRow() == -1 ? 0 : cells[0].getRow()), (int)(cells[0].getCol() == -1 ? (short)0 : cells[0].getCol()), (int)(r == -1 ? 65535 : r), (int)(c == -1 ? 1048 : (int)c)));
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cellblocks.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            CellBlock block = this.cellblocks.getBlock(i);
            sb.append(block.toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        SumcalcRange s = new SumcalcRange();
        s.fromSerialString("C1:C6,7:7,C8:C65536");
        s.fromSerialString(s.toSerialString());
        s.fromSerialString(s.toSerialString());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.toSerialString());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o instanceof String) {
            try {
                this.fromSerialString((String)o);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public boolean isIntersect(CellBlock block) {
        for (int i = 0; i < this.cellblocks.size(); ++i) {
            CellBlock b = this.cellblocks.getBlock(i);
            if (!b.isIntersect(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isIntersect(SumcalcRange sr) {
        if (this.getRanges() == null || sr == null || sr.getRanges() == null) {
            return false;
        }
        return this.getRanges().isTouched(sr.getRanges());
    }
}

