/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.StringUtils;

public class TemplateVersionMgr {
    public static final String INIT_VERSION = "1.0";
    private static final int MIN_INT_WIDTH = 1;
    private static final int MAX_INT_WIDTH = 4;
    private static final int MIN_PARTS = 2;
    private TemplateInfo template = null;
    private String version = null;
    private String versionOld = null;
    private boolean isChangedByCompany = false;
    private int companyLevel = 0;

    public TemplateVersionMgr(TemplateInfo template, boolean isChangedByCompany) {
        this.template = template;
        this.versionOld = template.getVersionNumber();
        this.isChangedByCompany = isChangedByCompany;
    }

    public TemplateVersionMgr(TemplateInfo template, boolean isChangedByCompany, int companyLevel) {
        this(template, isChangedByCompany);
        this.companyLevel = companyLevel;
    }

    public String getVersion() {
        if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)this.template.getTemplateType())) {
            return this.getPublicTemplateVersionNumber();
        }
        if (!TemplateVersionMgr.isGroupTemplate(this.template)) {
            if (this.isChangedByCompany) {
                if (this.versionOld == null || this.versionOld.length() == 0) {
                    return null;
                }
                if (this.template.getTemplateSource().getValue() == 1) {
                    String vn = this.versionOld;
                    String[] vns = vn.split("\\.");
                    if (vns.length == 2) {
                        return vn + ".1";
                    }
                    return vn;
                }
                return this.generateNewOwnGroupVersion();
            }
            if (this.versionOld == null || this.versionOld.length() == 0) {
                return this.generateNewOwnVersion();
            }
            if (this.template.getTemplateSource().getValue() == 1) {
                return this.generateOwnGradeNextVersion();
            }
            return this.generateVerOwnVersion();
        }
        if (this.versionOld == null || this.versionOld.length() == 0) {
            return TemplateVersionMgr.generateNewGroupVersion();
        }
        return this.generateVerGroupVersion();
    }

    private String generateOwnGradeNextVersion() {
        String firstVerNum = this.versionOld.substring(0, this.versionOld.lastIndexOf("."));
        String lastVerNum = this.versionOld.substring(this.versionOld.lastIndexOf(".") + 1, this.versionOld.length());
        int verPlus = Integer.valueOf(lastVerNum) + 1;
        return firstVerNum + "." + verPlus;
    }

    private String getPublicTemplateVersionNumber() {
        if (StringUtils.isEmpty((String)this.versionOld)) {
            return TemplateVersionMgr.generateNewGroupVersion();
        }
        if (this.isChangedByCompany) {
            return TemplateVersionMgr.generateNewSubVersion(this.companyLevel, this.versionOld);
        }
        return TemplateVersionMgr.getNextVersion(this.versionOld);
    }

    private static String generateNewGroupVersion() {
        return INIT_VERSION;
    }

    private String generateVerGroupVersion() {
        return TemplateVersionMgr.getNextVersion(this.versionOld);
    }

    private String generateNewOwnGroupVersion() {
        int[] is = TemplateVersionMgr.parse(this.versionOld);
        if (is == null) {
            return null;
        }
        int[] isResult = new int[is.length + 1];
        TemplateVersionMgr.arrayCopy(is, isResult);
        isResult[isResult.length - 1] = 0;
        isResult[isResult.length - 2] = 1;
        return TemplateVersionMgr.combine(isResult);
    }

    private String generateVerOwnGroupVersion() {
        return TemplateVersionMgr.getNextVersion(this.versionOld);
    }

    private String generateNewOwnVersion() {
        return TemplateVersionMgr.generateNewGroupVersion();
    }

    private String generateVerOwnVersion() {
        return this.generateVerGroupVersion();
    }

    public static int[] parse(String v) {
        if (v == null || v.length() == 0) {
            return null;
        }
        String pattern = "\\d{1,4}(\\.\\d{1,4})+";
        if (!v.matches(pattern)) {
            return null;
        }
        String[] ss = v.split("\\.");
        int[] is = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            is[i] = Integer.parseInt(ss[i]);
        }
        return is;
    }

    public static String combine(int[] is) {
        if (is == null || is.length < 2) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int upbound = (int)Math.pow(10.0, 4.0);
        for (int i = 0; i < is.length; ++i) {
            if (is[i] < 0 || is[i] >= upbound) {
                return null;
            }
            if (i > 0) {
                sb.append('.');
            }
            sb.append(is[i]);
        }
        return sb.toString();
    }

    public static void arrayCopy(int[] src, int[] dest) {
        if (src == null || dest == null) {
            return;
        }
        int n1 = src.length;
        int n2 = dest.length;
        int endIndex = n1 > n2 ? n2 : n1;
        for (int i = 0; i < endIndex; ++i) {
            dest[i] = src[i];
        }
    }

    public static boolean isGroupTemplate(TemplateInfo template) {
        RptTmpTypeEnum templateType = template.getTemplateType();
        return !templateType.equals((Object)RptTmpTypeEnum.COMMONREPORT) && !templateType.equals((Object)RptTmpTypeEnum.GROUPREPORT) && !templateType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) && !templateType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
    }

    public static String getNextVersion(String v) {
        int[] is = TemplateVersionMgr.parse(v);
        if (is == null || is.length < 2) {
            return null;
        }
        int n = is.length - 2;
        is[n] = is[n] + 1;
        return TemplateVersionMgr.combine(is);
    }

    public static String getPreviousVersion(String v) {
        int[] is = TemplateVersionMgr.parse(v);
        if (is == null || is.length < 2) {
            return null;
        }
        if (is[is.length - 2] == 1) {
            if (is.length < 3) {
                return null;
            }
            int[] isResult = new int[is.length - 1];
            TemplateVersionMgr.arrayCopy(is, isResult);
            isResult[isResult.length - 1] = 0;
            return TemplateVersionMgr.combine(isResult);
        }
        if (is[is.length - 2] <= 1) {
            return null;
        }
        int n = is.length - 2;
        is[n] = is[n] - 1;
        return TemplateVersionMgr.combine(is);
    }

    public static String getPreviousVersionLocal(String v) {
        int[] is = TemplateVersionMgr.parse(v);
        if (is == null || is.length < 2) {
            return null;
        }
        if (is[is.length - 2] <= 1) {
            return null;
        }
        int n = is.length - 2;
        is[n] = is[n] - 1;
        return TemplateVersionMgr.combine(is);
    }

    public static IObjectPK getLatestTemplate(IObjectPK pk) {
        return null;
    }

    public static boolean isNewGroupVersion(String v) {
        return !TemplateVersionMgr.generateNewGroupVersion().equals(v);
    }

    public static String generateNewSubVersion(int companyLevel, String versionOld) {
        int[] is = TemplateVersionMgr.parse(versionOld);
        if (is == null) {
            return null;
        }
        int[] isResult = new int[is.length + companyLevel];
        TemplateVersionMgr.arrayCopy(is, isResult);
        for (int i = 0; i < companyLevel; ++i) {
            isResult[isResult.length - i - 1] = 0;
        }
        isResult[isResult.length - 2] = 1;
        return TemplateVersionMgr.combine(isResult);
    }

    public static String getPreviousVersionByGrade(Context ctx, String group, String v) throws EASBizException, BOSException {
        String firstVer = v.substring(0, v.lastIndexOf("."));
        String lastVer = v.substring(v.lastIndexOf(".") + 1, v.length());
        String vernum = null;
        int ver = Integer.valueOf(lastVer);
        String[] nums = firstVer.split("\\.");
        String l = nums[0];
        String r = nums[1];
        int lv = Integer.valueOf(l);
        boolean isExist = false;
        if (--lv > 0) {
            vernum = lv + "." + r + "." + lastVer;
            isExist = TemplateFactory.getLocalInstance(ctx).exists("select id where group = '" + group + "' and versionNumber = '" + vernum + "' and templateSource = " + 1 + "");
        }
        int rv = Integer.valueOf(r);
        if (!isExist && --rv > 0) {
            vernum = l + "." + rv + "." + lastVer;
            isExist = TemplateFactory.getLocalInstance(ctx).exists("select id where group = '" + group + "' and versionNumber = '" + vernum + "' and templateSource = " + 1 + "");
        }
        if (!isExist && --ver > 0) {
            vernum = firstVer + "." + ver;
            isExist = TemplateFactory.getLocalInstance(ctx).exists("select id where group = '" + group + "' and versionNumber = '" + vernum + "' and templateSource = " + 1 + "");
        }
        return vernum;
    }

    public static boolean isNewGradeVersion(String v) {
        return !"1.1".equals(v);
    }
}

