/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.RptAPIUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import java.io.Serializable;

public class VariableEntry
implements Serializable {
    private static final long serialVersionUID = 8121107370570987L;
    private String name;
    private String description;
    private String value = null;
    private String sheetName = null;
    private int scope = 2;
    private boolean editable = true;
    private boolean visible = true;
    private boolean reserved = true;
    private int type = 0;
    private String query = null;
    private KDPromptSelector selector = null;
    private boolean isAllowModify = true;
    private String comboBoxEnum = null;
    public static final int VARIABLE_SCOPE_REPORT = 1;
    public static final int VARIABLE_SCOPE_SHEET = 2;
    private static final int VARIABLE_STATE_EDITABLE = 4;
    private static final int VARIABLE_STATE_VISIBLE = 8;
    private static final int VARIABLE_STATE_RESERVED = 16;
    public static final int VARIABLE_TYPE_NORMAL = 0;
    public static final int VARIABLE_TYPE_BOOL = 1;
    public static final int VARIABLE_TYPE_DATE = 2;
    public static final int VARIABLE_TYPE_NUMBER = 3;
    public static final int VARIABLE_TYPE_COMOBOX = 4;

    public VariableEntry() {
    }

    public VariableEntry(String name2, String sheetName2) {
        this.name = name2;
        this.sheetName = sheetName2;
    }

    public VariableEntry(String name2, String sheetName2, int scope2, String value2, boolean visible) {
        this.name = name2;
        this.sheetName = sheetName2;
        this.scope = scope2;
        this.value = value2;
        this.visible = visible;
    }

    public String getComboBoxEnum() {
        return this.comboBoxEnum;
    }

    public void setComboBoxEnum(String comboBoxEnum) {
        this.comboBoxEnum = comboBoxEnum;
    }

    public boolean isAllowModify() {
        return this.isAllowModify;
    }

    public void setAllowModify(boolean isAllowModify) {
        this.isAllowModify = isAllowModify;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private int getStatus() {
        int i = this.scope;
        if (this.editable) {
            i |= 4;
        }
        if (this.reserved) {
            i |= 0x10;
        }
        if (this.visible) {
            i |= 8;
        }
        return i;
    }

    private void setStatus(int i) {
        this.editable = (i & 4) == 4;
        this.reserved = (i & 0x10) == 16;
        boolean bl = this.visible = (i & 8) == 8;
        if ((i & 1) == 1) {
            this.scope = 1;
        } else if ((i & 2) == 2) {
            this.scope = 2;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableEntry)) {
            return false;
        }
        VariableEntry e = (VariableEntry)obj;
        if (this.name == null && e.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equalsIgnoreCase(e.name)) {
            return false;
        }
        if (this.sheetName == null && e.sheetName == null) {
            return true;
        }
        if (this.sheetName == null) {
            return false;
        }
        return this.sheetName.equalsIgnoreCase(e.sheetName);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.type;
        result = result * 31 + (this.editable ? 0 : 1);
        result = result * 31 + (this.visible ? 0 : 1);
        result = result * 31 + (this.reserved ? 0 : 1);
        result = result * 31 + (this.isAllowModify ? 0 : 1);
        return result;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator(s);
        if (it.hasNext()) {
            this.description = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.name = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.value = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.sheetName = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.setStatus((Integer)it.nextObject());
        }
        if (it.hasNext()) {
            this.type = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.isAllowModify = (Boolean)it.nextObject();
        }
        if (it.hasNext()) {
            this.comboBoxEnum = (String)it.nextObject();
        }
    }

    public String toSerialString() {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString(this.description, sb);
        UserObjectTrans.toString(this.name, sb);
        UserObjectTrans.toString(this.value, sb);
        UserObjectTrans.toString(this.sheetName, sb);
        UserObjectTrans.toString(this.getStatus(), sb);
        UserObjectTrans.toString(this.type, sb);
        UserObjectTrans.toString(this.isAllowModify, sb);
        if (this.comboBoxEnum != null) {
            UserObjectTrans.toString(this.comboBoxEnum, sb);
        }
        return sb.toString();
    }

    public String toString() {
        return this.description + "@" + this.sheetName + "<" + this.name + ", " + this.value + ">";
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    public VariableEntry copy() {
        VariableEntry rs = new VariableEntry();
        rs.name = this.name;
        rs.value = this.value;
        rs.sheetName = this.sheetName;
        rs.scope = this.scope;
        rs.editable = this.editable;
        rs.visible = this.visible;
        rs.reserved = this.reserved;
        rs.type = this.type;
        rs.description = this.description;
        rs.query = this.query;
        rs.selector = this.selector;
        rs.isAllowModify = this.isAllowModify;
        rs.comboBoxEnum = this.comboBoxEnum;
        return rs;
    }

    public void copyFrom(VariableEntry v) {
        this.name = v.name;
        this.value = v.value;
        this.sheetName = v.sheetName;
        this.scope = v.scope;
        this.editable = v.editable;
        this.visible = v.visible;
        this.reserved = v.reserved;
        this.type = v.type;
        this.description = v.description;
        this.query = v.query;
        this.selector = v.selector;
        this.isAllowModify = v.isAllowModify;
        this.comboBoxEnum = v.comboBoxEnum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getIntValue(int defaultV) {
        int parseInt = defaultV;
        try {
            parseInt = Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parseInt;
    }

    public boolean getBoolValue(boolean defaultV) {
        return RptAPIUtil.isTrue(this.getValue(), defaultV);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KDPromptSelector getSelector() {
        return this.selector;
    }

    public void setSelector(KDPromptSelector selector) {
        this.selector = selector;
    }
}

