/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.eas.fi.rpt.dbclean.app.DbCleanUtils;
import com.kingdee.eas.fi.rpt.dbclean.app.ITaskCallBack;
import com.kingdee.eas.fi.rpt.dbclean.app.TaskTemplate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteAdjustTask
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        try {
            TaskTemplate TaskTemplate2 = new TaskTemplate(context);
            TaskTemplate2.doTask(new ITaskCallBack(){

                public boolean execute(JZContext context) throws SQLException {
                    KDConnection dbConn = context.getDbConn();
                    int year = context.getYear();
                    ArrayList<Integer> paramList = new ArrayList<Integer>();
                    paramList.add(new Integer(year - 1));
                    DeleteAdjustTask.this.deleteAdjustDynamicItem(dbConn, "T_CSL_Adjust", "T_CSL_AdjustEntry", paramList);
                    DeleteAdjustTask.this.deleteAdjust(dbConn, "T_CSL_Adjust", "T_CSL_AdjustEntry", paramList);
                    DeleteAdjustTask.this.deleteAdjustDynamicItem(dbConn, "T_CSL_CaliAdjust", "T_CSL_CaliAdjustEntry", paramList);
                    DeleteAdjustTask.this.deleteAdjust(dbConn, "T_CSL_CaliAdjust", "T_CSL_CaliAdjustEntry", paramList);
                    return true;
                }
            });
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new JZTaskException(e.getMessage(), 2);
        }
        return true;
    }

    private void deleteAdjust(KDConnection dbConn, String adjustTable, String adjustEntryTable, List paramList) throws SQLException {
        String selectSQL = "select FID from " + adjustTable + " where FYear < ?";
        this.deleteItemData(dbConn, selectSQL, paramList);
        String deleteAdjustEntry = "delete from " + adjustEntryTable + " where FAdjustID in (" + selectSQL + ")";
        DbCleanUtils.execute(dbConn, deleteAdjustEntry, paramList.toArray());
        String deleteAdjust = "delete from " + adjustTable + " where FYear < ?";
        DbCleanUtils.execute(dbConn, deleteAdjust, paramList.toArray());
    }

    private void deleteAdjustDynamicItem(KDConnection dbConn, String adjustTable, String adjustEntryTable, List paramList) throws SQLException {
        StringBuffer deleteAdjustDynamicItemKQL = new StringBuffer();
        deleteAdjustDynamicItemKQL.append("delete from T_CSL_AdjustDynamicItem where FAdjustEntryID in \n");
        deleteAdjustDynamicItemKQL.append("(select entry.FID from ").append(adjustTable).append(" adjust inner join \n");
        deleteAdjustDynamicItemKQL.append(adjustEntryTable).append(" entry on adjust.FID = entry.FAdjustID     \n");
        deleteAdjustDynamicItemKQL.append("where adjust.FYear < ?)");
        DbCleanUtils.execute(dbConn, deleteAdjustDynamicItemKQL.toString(), paramList.toArray());
    }

    private void deleteItemData(KDConnection dbConn, String selectSQL, List paramList) throws SQLException {
        List itemDataTableList = this.getItemDataTableList(dbConn);
        Iterator it = itemDataTableList.iterator();
        while (it.hasNext()) {
            StringBuffer deleteItemDataBuffer = new StringBuffer();
            deleteItemDataBuffer.append("delete from ");
            deleteItemDataBuffer.append(it.next());
            deleteItemDataBuffer.append(" where FID in (select entry.FID from T_CSL_ItemData itemdata \n");
            deleteItemDataBuffer.append(" inner join T_CSL_ItemDataEntry entry on entry.FItemDataID = itemdata.FID where itemdata.FReportID in (");
            deleteItemDataBuffer.append(selectSQL).append("))");
            DbCleanUtils.execute(dbConn, deleteItemDataBuffer.toString(), paramList.toArray());
        }
        String deleteReporItemdataKQL = "delete from T_CSL_ItemDataEntry where FItemDataID in (select FID from T_CSL_ItemData where FReportID in (" + selectSQL + "))";
        DbCleanUtils.execute(dbConn, deleteReporItemdataKQL, paramList.toArray());
        String deleteReporItemdataEntryKQL = "delete from T_CSL_ItemData where FReportID in (" + selectSQL + ")";
        DbCleanUtils.execute(dbConn, deleteReporItemdataEntryKQL, paramList.toArray());
    }

    private List getItemDataTableList(KDConnection dbConn) throws SQLException {
        ArrayList<String> itemDataTableList = new ArrayList<String>();
        String ksql = "select FTableName from T_CSL_ItemDataTable";
        PreparedStatement pst = dbConn.prepareStatement(ksql);
        ResultSet resultSet = pst.executeQuery();
        while (resultSet.next()) {
            String tableName = resultSet.getString("FTableName");
            itemDataTableList.add(tableName);
        }
        return itemDataTableList;
    }
}

