/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.IJZTask;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.fi.rpt.dbclean.app.DbCleanUtils;
import com.kingdee.eas.fi.rpt.dbclean.app.ITaskCallBack;
import com.kingdee.eas.fi.rpt.dbclean.app.TaskTemplate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteCSLReportTask
implements IJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        try {
            TaskTemplate TaskTemplate2 = new TaskTemplate(context);
            TaskTemplate2.doTask(new ITaskCallBack(){

                public boolean execute(JZContext context) throws SQLException {
                    KDConnection dbConn = context.getDbConn();
                    String companyId = context.getOrgFId();
                    int year = context.getYear();
                    dbConn.setAutoCommit(false);
                    DeleteCSLReportTask.this.deleteHisReport(dbConn, companyId, year);
                    DeleteCSLReportTask.this.deleteReport(dbConn, companyId, year);
                    DeleteCSLReportTask.this.deleteHisCslReport(dbConn, year);
                    DeleteCSLReportTask.this.deleteCslReport(dbConn, year);
                    dbConn.commit();
                    return true;
                }
            });
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new JZTaskException(e.getMessage(), 2);
        }
        return true;
    }

    private void deleteHisReport(KDConnection dbConn, String companyId, int year) throws SQLException {
        String selectHisReportKQL = "select FID from T_CSL_HisCslReport where FOrgUnitID = ?  and FYear < ? and FSourceType in (1, 10, 13) ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(companyId);
        paramList.add(new Integer(year - 1));
        this.deleteItemData(dbConn, selectHisReportKQL, paramList);
        String deleteHisRptPostilKQL = "delete from T_CSL_CslPostil where FReportID in (" + selectHisReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteHisRptPostilKQL, paramList.toArray());
        String deleteHisRptSheetParaKQL = "delete from T_RPT_RptSheetPara where FReportID in (" + selectHisReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteHisRptSheetParaKQL, paramList.toArray());
        String deleteHisReportKQL = "delete from T_CSL_HisCslReport where FOrgUnitID = ?  and FYear < ? and FSourceType in (1, 10, 13) ";
        DbCleanUtils.execute(dbConn, deleteHisReportKQL, paramList.toArray());
    }

    private void deleteReport(KDConnection dbConn, String companyId, int year) throws SQLException {
        String selectReportKQL = "select FID from T_CSL_CslReport where FOrgUnitID = ?  and FYear < ? and FSourceType in (1, 10, 13) ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(companyId);
        paramList.add(new Integer(year - 1));
        this.deleteItemData(dbConn, selectReportKQL, paramList);
        String deleteRptPostilKQL = "delete from T_CSL_CslPostil where FReportID in (" + selectReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteRptPostilKQL, paramList.toArray());
        String deleteRptSheetParaKQL = "delete from T_RPT_RptSheetPara where FReportID in (" + selectReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteRptSheetParaKQL, paramList.toArray());
        String deleteReportKQL = "delete from T_CSL_CslReport where FOrgUnitID = ?  and FYear < ? and FSourceType in (1, 10, 13) ";
        DbCleanUtils.execute(dbConn, deleteReportKQL, paramList.toArray());
    }

    private void deleteHisCslReport(KDConnection dbConn, int year) throws SQLException {
        String selectHisCSLReportKQL = "select FID from T_CSL_HisCslReport where FYear < ? and FSourceType in (2, 3, 4, 8, 11, 12, 14, 15, 16) ";
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        paramList.add(new Integer(year - 1));
        this.deleteItemData(dbConn, selectHisCSLReportKQL, paramList);
        String deleteHisCslPostilKQL = "delete from T_CSL_CslPostil where FReportID in (" + selectHisCSLReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteHisCslPostilKQL, paramList.toArray());
        String deleteHisCslSheetParaKQL = "delete from T_RPT_RptSheetPara where FReportID in (" + selectHisCSLReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteHisCslSheetParaKQL, paramList.toArray());
        String deleteHisCSLReportKQL = "delete from T_CSL_HisCslReport where FYear < ? and FSourceType in (2, 3, 4, 8, 11, 12, 14, 15, 16) ";
        DbCleanUtils.execute(dbConn, deleteHisCSLReportKQL, paramList.toArray());
    }

    private void deleteCslReport(KDConnection dbConn, int year) throws SQLException {
        String selectCSLReportKQL = "select FID from T_CSL_CslReport where FYear < ? and FSourceType in (2, 3, 4, 8, 11, 12, 14, 15, 16) ";
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        paramList.add(new Integer(year - 1));
        this.deleteItemData(dbConn, selectCSLReportKQL, paramList);
        String deleteCslPostilKQL = "delete from T_CSL_CslPostil where FReportID in (" + selectCSLReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteCslPostilKQL, paramList.toArray());
        String deleteCslSheetParaKQL = "delete from T_RPT_RptSheetPara where FReportID in (" + selectCSLReportKQL + ")";
        DbCleanUtils.execute(dbConn, deleteCslSheetParaKQL, paramList.toArray());
        String deleteCSLReportKQL = "delete from T_CSL_CslReport where FYear < ? and FSourceType in (2, 3, 4, 8, 11, 12, 14, 15, 16) ";
        DbCleanUtils.execute(dbConn, deleteCSLReportKQL, paramList.toArray());
    }

    private void deleteItemData(KDConnection dbConn, String selectReportSQL, List paramList) throws SQLException {
        List itemDataTableList = this.getItemDataTableList(dbConn);
        Iterator it = itemDataTableList.iterator();
        while (it.hasNext()) {
            StringBuffer deleteItemDataBuffer = new StringBuffer();
            deleteItemDataBuffer.append("delete from ");
            deleteItemDataBuffer.append(it.next());
            deleteItemDataBuffer.append(" where FID in (select entry.FID from T_CSL_ItemData itemdata \n");
            deleteItemDataBuffer.append(" inner join T_CSL_ItemDataEntry entry on entry.FItemDataID = itemdata.FID where itemdata.FReportID in (");
            deleteItemDataBuffer.append(selectReportSQL).append("))");
            DbCleanUtils.execute(dbConn, deleteItemDataBuffer.toString(), paramList.toArray());
        }
        String deleteReporItemdataKQL = "delete from T_CSL_ItemDataEntry where FItemDataID in (select FID from T_CSL_ItemData where FReportID in (" + selectReportSQL + "))";
        DbCleanUtils.execute(dbConn, deleteReporItemdataKQL, paramList.toArray());
        String deleteReporItemdataEntryKQL = "delete from T_CSL_ItemData where FReportID in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteReporItemdataEntryKQL, paramList.toArray());
        String deleteInterItemDataKQL = "delete from T_CSL_InterItemData where FReport in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteInterItemDataKQL, paramList.toArray());
        String deleteExchItemDataKQL = "delete from T_CSL_ExchItemData where FReport in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteExchItemDataKQL, paramList.toArray());
        String deleteInvestItemDataKQL = "delete from T_CSL_InvestItemData where FReportID in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteInvestItemDataKQL, paramList.toArray());
        String deleteDynaItemDataEntryKQL = "delete from T_CSL_DynaItemDataEntry where FItemDataID in (select FID from T_CSL_DynaItemData where FReportID in (" + selectReportSQL + "))";
        DbCleanUtils.execute(dbConn, deleteDynaItemDataEntryKQL, paramList.toArray());
        String deleteDynaItemDataKQL = "delete from T_CSL_DynaItemData where FReportID in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteDynaItemDataKQL, paramList.toArray());
        String deleteMultiDynaItemDataEntryKQL = "delete from T_CSL_MultiDynaItemDataEntry where FItemDataID in (select FID from T_CSL_MultiDynaItemData where FReportID in (" + selectReportSQL + "))";
        DbCleanUtils.execute(dbConn, deleteMultiDynaItemDataEntryKQL, paramList.toArray());
        String deleteMultiDynaItemDataKQL = "delete from T_CSL_MultiDynaItemData where FReportID in (" + selectReportSQL + ")";
        DbCleanUtils.execute(dbConn, deleteMultiDynaItemDataKQL, paramList.toArray());
    }

    private List getItemDataTableList(KDConnection dbConn) throws SQLException {
        ArrayList<String> itemDataTableList = new ArrayList<String>();
        String ksql = "select FTableName from T_CSL_ItemDataTable";
        PreparedStatement pst = dbConn.prepareStatement(ksql);
        ResultSet resultSet = pst.executeQuery();
        while (resultSet.next()) {
            String tableName = resultSet.getString("FTableName");
            itemDataTableList.add(tableName);
        }
        return itemDataTableList;
    }
}

