/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.dbclean.app;

import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.fi.rpt.dbclean.app.ITaskCallBack;
import com.kingdee.eas.fi.rpt.dbclean.app.ITaskTemplate;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TaskTemplate
implements ITaskTemplate {
    private static final long WAIT_TIME = 150L;
    private JZContext context;

    public TaskTemplate() {
        this(null);
    }

    public TaskTemplate(JZContext context) {
        this.context = context;
    }

    public void setJZContext(JZContext context) {
        this.context = context;
    }

    /*
     * Loose catch block
     */
    public boolean doTask(ITaskCallBack taskCallBack) throws SQLException, JZTaskException {
        long waitTime = 0L;
        while (true) {
            try {
                Thread.sleep(waitTime * 1000L);
                if (this.context.isPause()) {
                    throw new JZTaskException("\u7ebf\u7a0b\u88ab\u6302\u8d77......", 6);
                }
                if (this.context.isStop()) {
                    throw new JZTaskException("\u7ebf\u7a0b\u88ab\u505c\u6b62......", 5);
                }
                taskCallBack.execute(this.context);
                return true;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                String curTime = new SimpleDateFormat("HH:mm:ss").format(new Date());
                this.context.getLogger().println(curTime + " : \u53d1\u751f\u5f02\u5e38, \u672c\u4efb\u52a1\u5c06\u7b49\u5f85\u3010" + waitTime + "\u3011\u79d2\u540e\u91cd\u65b0\u6267\u884c");
                if (waitTime >= 150L) {
                    throw sqle;
                }
                if (waitTime < 60L) {
                    waitTime += 10L;
                    continue;
                }
                waitTime += 60L;
                continue;
            }
            break;
        }
        catch (InterruptedException ex) {
            throw new JZTaskException(ex.getMessage(), 2);
        }
    }
}

