/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.fm.cbs.AgencybankCollection;
import com.kingdee.eas.fm.cbs.AgencybankFactory;
import com.kingdee.eas.fm.cbs.AgencybankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AgencybankDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.AgencybankDataImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AgencybankFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object coll;
        AgencybankInfo info = new AgencybankInfo();
        String number = (String)this.getData(hsData, "number");
        if (EmptyUtil.isEmpty((String)number)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"agencyNumber_required", (Locale)ctx.getLocale()));
        }
        String agencySwift = (String)this.getData(hsData, "agencySwift");
        if (EmptyUtil.isEmpty((String)agencySwift)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"agencySwift_required", (Locale)ctx.getLocale()));
        }
        if (agencySwift.length() != 8 && agencySwift.length() != 11) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"agentSwiftLength", (Locale)ctx.getLocale()));
        }
        info.setNumber(number);
        info.setAgencySwift(agencySwift);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
            view.setFilter(fi);
            coll = null;
            try {
                coll = AgencybankFactory.getLocalInstance(ctx).getAgencybankCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.error((Object)e);
            }
            if (coll.size() > 0) {
                info.setId(((AgencybankCollection)((Object)coll)).get(0).getId());
            }
        }
        CountryInfo country = null;
        String isoCode = (String)this.getData(hsData, "CountryISO");
        coll = null;
        try {
            coll = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection("where ISOCode = '" + isoCode + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        if (coll != null && coll.size() > 0) {
            country = coll.get(0);
        }
        info.setCountry(country);
        String name = (String)this.getData(hsData, "name");
        info.setName(name);
        String agencyBankNumber = (String)this.getData(hsData, "agencyBankNumber");
        info.setAgencyBankNumber(agencyBankNumber);
        String address = (String)this.getData(hsData, "address");
        info.setAddress(address);
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }
}

