/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.cbs.CBPaymentException;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cbs.MessageToBankEnum;
import com.kingdee.eas.fm.cbs.TransTypeCollection;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.cbs.TransTypeFactory;
import com.kingdee.eas.fm.cbs.TransTypeInfo;
import com.kingdee.eas.fm.cbs.app.AbstractCBPaymentBillWebFacadeControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CBPaymentBillWebFacadeControllerBean
extends AbstractCBPaymentBillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.CBPaymentBillWebFacadeControllerBean");

    protected Map _beforeSubmit(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        Map pageModel = super._beforeSubmit(ctx, info);
        if (pageModel.get("error").equals(0)) {
            Map beInfo = (Map)pageModel.get("beInfo");
            if (((Boolean)info.get("iscbpay")).booleanValue() && !EmptyUtil.isEmpty((Object)beInfo)) {
                Boolean isByAgentBank = info.getCbPayInfo().isIsByAgentBank();
                beInfo.put("isByAgentBank", isByAgentBank);
            }
        }
        return pageModel;
    }

    protected void _verifyBeforeSubmit(Context ctx, PaymentBillInfo info, Map param) throws BOSException, EASBizException {
        CurrencyInfo currency;
        super._verifyBeforeSubmit(ctx, info, param);
        CBPaymentInfo cbPayInfo = info.getCbPayInfo();
        if (cbPayInfo.getTransType() == null) {
            cbPayInfo = CBPaymentFactory.getLocalInstance(ctx).getCBPaymentInfo((IObjectPK)new ObjectUuidPK(cbPayInfo.getId()), this.getCBSelector());
        }
        if (11 != cbPayInfo.getTransType().getValue() && info.getPayeeAccountBank() == null) {
            throw new CBPaymentException(CBPaymentException.PAYEEACCOUNTBANK_REQUIRED);
        }
        if (cbPayInfo.getPayeeAmount() == null || cbPayInfo.getPayeeAmount().equals(BigDecimal.ZERO)) {
            throw new CBPaymentException(CBPaymentException.PAYEEAMOUNT_ZERO);
        }
        if (cbPayInfo.getPaymentCurrency().getIsoCode() == null || cbPayInfo.getPaymentCurrency().getPrecision() == 0) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cbPayInfo.getPaymentCurrency().getId()));
            cbPayInfo.setPaymentCurrency(currency);
        }
        if (cbPayInfo.getPayeeCurrency().getIsoCode() == null || cbPayInfo.getPayeeCurrency().getPrecision() == 0) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cbPayInfo.getPayeeCurrency().getId()));
            cbPayInfo.setPayeeCurrency(currency);
        }
        if (!info.getCurrency().getId().toString().equals(cbPayInfo.getPaymentCurrency().getId().toString())) {
            throw new CBPaymentException(CBPaymentException.CURRENCYNOTEQUAL);
        }
        TransTypeInfo transTypeInfo = TransTypeFactory.getLocalInstance(ctx).getTransTypeInfo((IObjectPK)new ObjectUuidPK(cbPayInfo.getTransType().getId()));
        if (1 == transTypeInfo.getValue()) {
            this.verify4TRF(info, cbPayInfo);
        } else if (2 == transTypeInfo.getValue()) {
            this.verify4ETF(info, cbPayInfo);
        } else if (3 == transTypeInfo.getValue()) {
            this.verify4TTF(info, cbPayInfo);
        } else if (4 == transTypeInfo.getValue()) {
            this.verify4BRP(info, cbPayInfo);
        } else if (11 == transTypeInfo.getValue()) {
            this.verify4FPS(info, cbPayInfo);
        } else if (5 == transTypeInfo.getValue()) {
            this.verify4PP(info, cbPayInfo);
        } else if (14 == transTypeInfo.getValue() || 13 == transTypeInfo.getValue()) {
            this.verify4SCB(info, cbPayInfo);
        } else if (16 == transTypeInfo.getValue()) {
            this.verify4BOC(info, cbPayInfo);
        } else if (19 == transTypeInfo.getValue() || 20 == transTypeInfo.getValue() || 18 == transTypeInfo.getValue() || 17 == transTypeInfo.getValue()) {
            // empty if block
        }
    }

    private void verify4ANZ(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankNumber()) && EmptyUtil.isEmpty((String)cbPayInfo.getBLClearCode())) {
            throw new CBPaymentException(CBPaymentException.BLCLEARCODENOTNULL);
        }
    }

    private void verify4BOC(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)cbPayInfo.getCltype())) {
            throw new CBPaymentException(CBPaymentException.CLTYPENOTNULL);
        }
    }

    private void verify4SCB(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankNumber()) && EmptyUtil.isEmpty((String)cbPayInfo.getBLClearBranchCode())) {
            throw new CBPaymentException(CBPaymentException.BLCLEARBRANCHCODENOTNULL);
        }
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankNumber()) && EmptyUtil.isEmpty((String)cbPayInfo.getBLClearCode())) {
            throw new CBPaymentException(CBPaymentException.BLCLEARCODENOTNULL);
        }
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankNumber()) && EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankBranch())) {
            throw new CBPaymentException(CBPaymentException.PAYEEBANKBRANCHNOTNULL);
        }
    }

    private void verify4PP(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry())) {
            throw new CBPaymentException(CBPaymentException.PAYEECOUNTRY_REQUIRED);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBankO())) {
            throw new CBPaymentException(CBPaymentException.PAYEEACCOUNTBANK_REQUIRED);
        }
    }

    private void verify4FPS(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        String payeeCurrencyIso = "";
        if (cbPayInfo.getPayeeCurrency() != null && cbPayInfo.getPayeeCurrency().getIsoCode() != null) {
            payeeCurrencyIso = cbPayInfo.getPayeeCurrency().getIsoCode();
        }
        if (!"CNY".equals(payeeCurrencyIso) && !"HKD".equals(payeeCurrencyIso)) {
            throw new CBPaymentException(CBPaymentException.FPS_PAYMENTCURRENCY_VERIFY);
        }
        int count = 0;
        if (!EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhone()) || !EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhoneCode())) {
            ++count;
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeAccountBank())) {
            ++count;
        }
        if (!EmptyUtil.isEmpty((String)cbPayInfo.getPayeeFPSNum())) {
            ++count;
        }
        if (!EmptyUtil.isEmpty((String)info.getEmail())) {
            ++count;
        }
        if (count > 1) {
            throw new CBPaymentException(CBPaymentException.FPS_4CHOICE1_VERIFY);
        }
        if (count == 0) {
            throw new CBPaymentException(CBPaymentException.FPS_4CHOICE1_NOTNULL);
        }
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhone()) && !EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhoneCode()) || !EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhone()) && EmptyUtil.isEmpty((String)cbPayInfo.getPayeePhoneCode())) {
            throw new CBPaymentException(CBPaymentException.FPS_COUNTRYANDPHONE_VERIFY);
        }
        if (cbPayInfo.isIsNoticePayee() && EmptyUtil.isEmpty((String)cbPayInfo.getNoticePayeeEmails())) {
            throw new CBPaymentException(CBPaymentException.FPS_NOTICEPAYEEEMAILS_NOTNULL);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeName())) {
            throw new CBPaymentException(CBPaymentException.PAYEENAME_REQUIRED);
        }
        if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankNumber())) {
            throw new CBPaymentException(CBPaymentException.PAYEEBANKNUMBER_NOTNULL);
        }
    }

    private void verify4TRF(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || info.getPayeeAccountBank().length() != 14) {
            throw new CBPaymentException(CBPaymentException.PAYEEACCOUNTBANK_LENGTH_14);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeName())) {
            throw new CBPaymentException(CBPaymentException.PAYEENAME_REQUIRED);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            throw new CBPaymentException(CBPaymentException.PAYEEBANK_REQUIRED);
        }
    }

    private void verify4ETF(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getPayeeName()) && EmptyUtil.isEmpty((String)cbPayInfo.getPayeeAddress())) {
            throw new CBPaymentException(CBPaymentException.PAYEENAMEADDR_REQUIRED);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            throw new CBPaymentException(CBPaymentException.PAYEEBANK_REQUIRED);
        }
        String payeeIsoCode = "";
        if (cbPayInfo.getPayeeCurrency() != null && cbPayInfo.getPayeeCurrency().getIsoCode() != null) {
            payeeIsoCode = cbPayInfo.getPayeeCurrency().getIsoCode().trim();
        }
        if (!("CNY".equals(payeeIsoCode) || "HKD".equals(payeeIsoCode) || "USD".equals(payeeIsoCode) || "EUR".equals(payeeIsoCode))) {
            throw new CBPaymentException(CBPaymentException.ETF_PAYEECURRENCY_ISOCODE);
        }
        String payeeName = info.getPayeeName();
        String payeeAddr = cbPayInfo.getPayeeAddress();
        if (payeeName != null && payeeAddr != null && payeeName.length() + payeeAddr.length() > 140) {
            throw new CBPaymentException(CBPaymentException.PAYEE_LENGTH_140);
        }
    }

    private void verify4TTF(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getPayeeName()) && EmptyUtil.isEmpty((String)cbPayInfo.getPayeeAddress())) {
            throw new CBPaymentException(CBPaymentException.PAYEENAMEADDR_REQUIRED);
        }
        if (cbPayInfo.getPayTransaction() != null && cbPayInfo.getPayTransaction().getNumber() != null && "Z".equals(cbPayInfo.getPayTransaction().getNumber().trim()) && (cbPayInfo.getPayWay() == null || cbPayInfo.getPayWay() == "")) {
            throw new CBPaymentException(CBPaymentException.BRP_PAYWAY_REQUIRED);
        }
        if (info.getPayeeBank() == null && cbPayInfo.getPayeeBankAddr() == null && cbPayInfo.getPayeeSwiftCode() == null) {
            throw new CBPaymentException(CBPaymentException.TTF_PAYEE_REQUIRED);
        }
    }

    private void verify4BRP(PaymentBillInfo info, CBPaymentInfo cbPayInfo) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getPayeeName()) && EmptyUtil.isEmpty((String)cbPayInfo.getPayeeAddress())) {
            throw new CBPaymentException(CBPaymentException.PAYEENAMEADDR_REQUIRED);
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank()) || EmptyUtil.isEmpty((String)cbPayInfo.getPayeeBankAddr())) {
            throw new CBPaymentException(CBPaymentException.PAYEEBANKANDADDR_REQUIRED);
        }
        String paymentCurrencyIso = "";
        if (cbPayInfo.getPaymentCurrency() != null && cbPayInfo.getPaymentCurrency().getIsoCode() != null) {
            paymentCurrencyIso = cbPayInfo.getPaymentCurrency().getIsoCode();
        }
        if (!"HKD".equals(paymentCurrencyIso) && !"USD".equals(paymentCurrencyIso)) {
            throw new CBPaymentException(CBPaymentException.BRP_PAYMENTCURRENCY_VERIFY);
        }
    }

    protected IObjectPK getSubmitPk(Context ctx, IPaymentBill iPaymentBill, PaymentBillInfo info) throws Exception {
        CBPaymentInfo cbInfo = info.getCbPayInfo();
        cbInfo.setPaymentBillId(info.getId().toString());
        if (cbInfo.getTransType() != null && cbInfo.getTransType().getValue() != 0) {
            cbInfo.setTransactionType(TransTypeEnum.getEnum(cbInfo.getTransType().getValue()));
        }
        CBPaymentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cbInfo);
        return super.getSubmitPk(ctx, iPaymentBill, info);
    }

    protected IObjectPK getSavePk(Context ctx, PaymentBillInfo info) throws Exception {
        CBPaymentInfo cbInfo = info.getCbPayInfo();
        cbInfo.setPaymentBillId(info.getId().toString());
        if (cbInfo.getTransType() != null && cbInfo.getTransType().getValue() != 0) {
            cbInfo.setTransactionType(TransTypeEnum.getEnum(cbInfo.getTransType().getValue()));
        }
        CBPaymentFactory.getLocalInstance(ctx).save((CoreBaseInfo)cbInfo);
        return super.getSavePk(ctx, info);
    }

    protected SelectorItemCollection getCBSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payeeCurrency.isoCode");
        selector.add("paymentCurrency.isoCode");
        selector.add("payTransaction.number");
        selector.add("transType.*");
        return selector;
    }

    protected Map<String, Object> getBeInfo(Context ctx, PaymentBillInfo info, boolean actionBe) {
        CBPaymentInfo cbPayInfo = info.getCbPayInfo();
        HashMap<String, Object> beInfo = new HashMap<String, Object>();
        beInfo.put("be_head", CASWebUtil.getResource((Context)ctx, (String)"339_SUBMIT_BE_HEAD"));
        beInfo.put("transType", cbPayInfo.getTransType().getName() + "(" + cbPayInfo.getTransType().getNumber() + ")");
        beInfo.put("payeeAccountBank", FMHelper.splitString((String)info.getPayeeAccountBank(), (int)4, (String)" "));
        beInfo.put("payeeBank", info.getPayeeBank());
        if (!EmptyUtil.isEmpty((String)info.getBankAcctName())) {
            beInfo.put("bankAcctName", info.getBankAcctName());
        } else {
            beInfo.put("bankAcctName", info.getPayeeName());
        }
        beInfo.put("payeeBankNumber", cbPayInfo.getPayeeBankNumber());
        beInfo.put("payeeBankBranch", cbPayInfo.getPayeeBankBranch());
        beInfo.put("payeeCurrency", cbPayInfo.getPayeeCurrency().getName());
        beInfo.put("payeeAmount", CBPaymentBillWebFacadeControllerBean.formatDecimal((BigDecimal)cbPayInfo.getPayeeAmount(), (int)2));
        beInfo.put("payeeAddress", cbPayInfo.getPayeeAddress());
        beInfo.put("payeeBank", info.getPayeeBank());
        beInfo.put("payeeBankAddr", cbPayInfo.getPayeeBankAddr());
        beInfo.put("swiftCode_payee", cbPayInfo.getPayeeSwiftCode());
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBank())) {
            beInfo.put("payerAccountBank", info.getPayerAccountBank().getBank().getName() + "  " + info.getPayerAccountBank().getBankAccountNumber());
        } else {
            beInfo.put("payerAccountBank", info.getPayerBank().getName() + "  " + info.getPayerAccountBank().getBankAccountNumber());
        }
        beInfo.put("paymentCurrency", cbPayInfo.getPaymentCurrency().getName());
        if (!EmptyUtil.isEmpty((Object)cbPayInfo.getPaymentAmount())) {
            beInfo.put("paymentAmount", CBPaymentBillWebFacadeControllerBean.formatDecimal((BigDecimal)cbPayInfo.getPaymentAmount(), (int)2));
        } else {
            beInfo.put("paymentAmount", null);
        }
        beInfo.put("forContractNo", cbPayInfo.getForContractNo());
        beInfo.put("payTransaction", cbPayInfo.getPayTransaction() == null ? "" : cbPayInfo.getPayTransaction().getNumber());
        beInfo.put("feeAccountBank", cbPayInfo.getFeeAccountBank() == null ? "" : cbPayInfo.getFeeAccountBank().getName());
        beInfo.put("feeCurrency", cbPayInfo.getFeeCurrency() == null ? "" : cbPayInfo.getFeeCurrency().getName());
        beInfo.put("agentAccountBank", cbPayInfo.getAgentAcctBank());
        beInfo.put("agentBankAddress", cbPayInfo.getAgentAddr());
        beInfo.put("swiftCode_agent", cbPayInfo.getAgentSwift());
        beInfo.put("transTypeValue", cbPayInfo.getTransType().getValue());
        beInfo.put("isFeeByPayAmount", cbPayInfo.isIsFeeByPayAmount());
        beInfo.put("CNYPayType", cbPayInfo.getCNYPayType());
        beInfo.put("feeBank", cbPayInfo.getFeeBank());
        beInfo.put("payeePhone", cbPayInfo.getPayeePhone());
        beInfo.put("paymentterms", cbPayInfo.getPaymentterms().getAlias());
        beInfo.put("paymentPurpose", cbPayInfo.getPaymentPurpose().getAlias());
        beInfo.put("beneficiaryType", cbPayInfo.getBeneficiaryType().getAlias());
        beInfo.put("bLClearCode", cbPayInfo.getBLClearCode());
        beInfo.put("bLClearBranchCode", cbPayInfo.getBLClearBranchCode());
        beInfo.put("otherPaymentPurpose", cbPayInfo.getOtherPaymentPurpose());
        beInfo.put("feeMode", cbPayInfo.getFeeMode().getAlias());
        beInfo.put("tocnaps", cbPayInfo.getTocnaps());
        return beInfo;
    }

    protected Map _batchUnaudit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchUnaudit(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchSubmit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchSubmit(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchAudit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchAudit(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchPay(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchPay(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCancelPay(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCancelPay(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchDelete(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchDelete(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCommitToBe(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCommitToBe(ctx, ids, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchAudit4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchAudit4Ca(ctx, ids, signature, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchSubmit4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchSubmit4Ca(ctx, ids, signature, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCommitToBe4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCommitToBe4Ca(ctx, ids, signature, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchPay4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchPay4Ca(ctx, ids, signature, billType);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    private BatchExecuteResult replacePaymentMsg(Context ctx, BatchExecuteResult result) {
        if (result.getDetailMsgList().size() > 0) {
            BatchExecuteResult cbResult = new BatchExecuteResult();
            cbResult.setSummaryMsg(result.getSummaryMsg());
            List detailMsgList = result.getDetailMsgList();
            for (int i = 0; i < detailMsgList.size(); ++i) {
                String msg = (String)detailMsgList.get(i);
                if (msg.indexOf(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"PaymentBill")) != -1) {
                    msg = msg.replaceAll(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"PaymentBill"), CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"CBPaymentBill"));
                }
                cbResult.getDetailMsgList().add(msg);
            }
            return cbResult;
        }
        return result;
    }

    @Override
    protected IObjectValue _setCBPayInfo4BOTP(Context ctx, IObjectValue paymentBillInfo) throws BOSException, EASBizException {
        PaymentBillInfo info = (PaymentBillInfo)paymentBillInfo;
        CBPaymentInfo cbInfo = new CBPaymentInfo();
        if (info.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
            cbInfo.setPaymentCurrency(currency);
            cbInfo.setPayeeCurrency(currency);
        }
        cbInfo.setPaymentAmount(info.getActPayAmt());
        cbInfo.setPayeeAmount(info.getActPayAmt());
        cbInfo.setIsFeeByPayAmount(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)3, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        TransTypeCollection transTypeCollection = TransTypeFactory.getLocalInstance(ctx).getTransTypeCollection(evi);
        cbInfo.setTransType(transTypeCollection.get(0));
        cbInfo.setTransactionType(TransTypeEnum.TTF);
        cbInfo.setMessageToBank(MessageToBankEnum.Single);
        cbInfo.setFeeAccountBank(info.getPayerAccountBank());
        cbInfo.setPaymentBillId(info.getId().toString());
        cbInfo.setFeeCurrency(info.getCurrency());
        info.setCbPayInfo(cbInfo);
        return cbInfo;
    }

    protected SelectorItemCollection getSelector() {
        this.sic = super.getSelector();
        this.sic.add(new SelectorItemInfo("cbPayInfo.*"));
        return this.sic;
    }
}

