/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillEntry;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SettleFeeTypeEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.CasPaymentBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.cbs.AgencybankInfo;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cbs.CBSPayTypeEnum;
import com.kingdee.eas.fm.cbs.MessageToBankEnum;
import com.kingdee.eas.fm.cbs.PaymentTermsEnmu;
import com.kingdee.eas.fm.cbs.ServiceLevelEnum;
import com.kingdee.eas.fm.cbs.TransTypeCollection;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.cbs.TransTypeFactory;
import com.kingdee.eas.fm.cbs.TransTypeInfo;
import com.kingdee.eas.fm.cbs.TransactionsTypeCollection;
import com.kingdee.eas.fm.cbs.TransactionsTypeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CBSPaymentBillDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)CBSPaymentBillDataImport.class.getName());
    private CasPaymentBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private Map seqMap = new HashMap();
    private boolean cs074;
    private boolean cs064;
    private boolean flag = false;
    private Map assTypeIDMap = new HashMap();

    protected ICoreBase _getController(Context ctx) throws BOSException {
        return PaymentBillFactory.getLocalInstance((Context)ctx);
    }

    public CasPaymentBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new CasPaymentBillImportVerify();
        }
        return this.verify;
    }

    public CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws BOSException, EASBizException {
        String number = (String)this.getData(hsData, "FNumber");
        this.curKey = EmptyUtil.isEmpty((String)number) ? Uuid.create().toString() : number;
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        String companyId = null;
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "FCompanyID");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber((Context)ctx, (String)((String)companyData));
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        companyId = company.getId().toString();
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        this.cs074 = contextHelper.getBooleanParam("CS074", (IObjectPK)new ObjectUuidPK(companyId));
        this.cs064 = contextHelper.getBooleanParam("CS064", (IObjectPK)new ObjectUuidPK(companyId));
        PaymentBillInfo head = null;
        PaymentBillEntryInfo entry = null;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (this.infoMap.containsKey(this.curKey)) {
            head = (PaymentBillInfo)this.infoMap.get(this.curKey);
            head.setCompany(company);
        } else {
            head = this.getHeadInfo(ctx, mode, number, companyId);
            head.setCompany(company);
            head = (PaymentBillInfo)this.parseHead(hsData, ctx, head);
            this.infoMap.put(this.curKey, head);
        }
        CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(head.getCompany());
        String headId = head.getId() == null ? null : head.getId().toString();
        Integer fseq = this.seqMap.get(this.curKey) == null ? new Integer(1) : (Integer)this.seqMap.get(this.curKey);
        entry = this.getEntryInfo(ctx, mode, headId, fseq.toString());
        this.seqMap.put(this.curKey, new Integer(fseq + 1));
        entry = (PaymentBillEntryInfo)this.parseEntry(hsData, ctx, entry, companyId);
        entry.setSeq(fseq.intValue());
        try {
            String data;
            AccountViewInfo acctViewInfo = entry.getOppAccount();
            VoucherInfo.DynamicColumnInfo[] dyColumnInfos = null;
            if (acctViewInfo != null && acctViewInfo.getCAA() != null) {
                Object[] fetchAssColumnInfo;
                IVoucherFacade voucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
                try {
                    fetchAssColumnInfo = voucherFacade.fetchAssColumnInfo(acctViewInfo.getId().toString(), acctViewInfo.getCAA().getId().toString(), null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"170_PaymentBillDataImport", (Locale)ctx.getLocale()) + acctViewInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"171_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
                dyColumnInfos = (VoucherInfo.DynamicColumnInfo[])fetchAssColumnInfo[0];
                AssItemsForCashPayCollection assCol = entry.getAssItemsEntries();
                assCol.clear();
                if (assCol == null || assCol.size() == 0) {
                    for (int i = 0; i < dyColumnInfos.length; ++i) {
                        AsstActTypeInfo aTypeinfo_temp = (AsstActTypeInfo)this.assTypeIDMap.get(dyColumnInfos[i].getId());
                        if (aTypeinfo_temp == null) {
                            aTypeinfo_temp = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(dyColumnInfos[i].getId()));
                            this.assTypeIDMap.put(dyColumnInfos[i].getId(), aTypeinfo_temp);
                        }
                        AssItemsForCashPayInfo assInfo_temp = new AssItemsForCashPayInfo();
                        assInfo_temp.setAsstActType(aTypeinfo_temp);
                        assInfo_temp.setIsSelected(false);
                        assInfo_temp.setEntryParent(entry);
                        assInfo_temp.setEntrySeq(entry.getSeq());
                        assInfo_temp.setMappingFileds(aTypeinfo_temp.getMappingFieldName());
                        assInfo_temp.setTableName(aTypeinfo_temp.getRealtionDataObject());
                        assCol.add(assInfo_temp);
                    }
                }
                String entryId = entry.getId() == null ? null : entry.getId().toString();
                for (int k = 1; k <= 8; ++k) {
                    Object data2 = this.getData(hsData, "FAssType" + k);
                    if (data2 != null && data2.toString().trim().length() > 0) {
                        AsstActTypeInfo assTypeInfo = this.getAsstActType(ctx, data2);
                        if (assTypeInfo == null) {
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"172_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                        }
                        AssItemsForCashPayInfo assInfo = this.getAssItemInfo(ctx, mode, entryId, assCol, assTypeInfo);
                        assInfo = this.parseAssItem(hsData, ctx, assTypeInfo, assInfo, k, entry);
                        if (assCol != null && assCol.size() > 0) {
                            int exFlag = 0;
                            for (int i = 0; i < assCol.size(); ++i) {
                                AssItemsForCashPayInfo entryInfo = assCol.get(i);
                                if (!entryInfo.getAsstActType().getId().equals((Object)assInfo.getAsstActType().getId())) continue;
                                assCol.set(i, assInfo);
                                ++exFlag;
                                break;
                            }
                            if (exFlag != 0) continue;
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                        }
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                    }
                    data2 = this.getData(hsData, "FAssNumber" + k);
                    if (data2 == null || data2.toString().trim().length() <= 0) continue;
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"174_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"175_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                entry.getAssItemsEntries().clear();
            }
            this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType(), dyColumnInfos);
            PaymentBillEntryCollection coll = head.getEntries();
            int collSize = coll.size();
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < collSize; ++i) {
                    PaymentBillEntryInfo entryInfo = coll.get(i);
                    if (entryInfo.getSeq() == entry.getSeq()) {
                        coll.set(i, entry);
                    } else {
                        if (entry.getSeq() <= collSize) continue;
                        coll.add(entry);
                    }
                    break;
                }
            } else {
                coll.add(entry);
            }
            String srcCurrId = head.getCurrency().getId().toString();
            String destCurrId = baseCurrency.getId().toString();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(destCurrId));
            ExchangeRateInfo exchangeRate = this.getExRateInfo(ctx, srcCurrId, destCurrId, company, new Date());
            Boolean cbIsIndirectRate1 = false;
            Boolean cbIsIndirectRate2 = false;
            Boolean cbIsIndirectRate3 = false;
            int scale1 = 2;
            BigDecimal exchangeRate1 = Constants.ONE;
            BigDecimal exchangeRate2 = Constants.ONE;
            BigDecimal exchangeRate3 = Constants.ONE;
            BigDecimal rate = head.getExchangeRate();
            int scale = head.getCurrency().getPrecision();
            if (head.getCbPayInfo() != null && head.getCbPayInfo().getPayeeCurrency() != null) {
                scale1 = head.getCbPayInfo().getPayeeCurrency().getPrecision();
                if (!head.getCbPayInfo().getPayeeCurrency().getId().equals((Object)head.getCompany().getBaseCurrency().getId())) {
                    ExchangeRateInfo exchangeRateInfo = this.getExRateInfo(ctx, head.getCbPayInfo().getPayeeCurrency().getId().toString(), null, head.getCompany(), new Date());
                    cbIsIndirectRate1 = this.isIndirectExRate(exchangeRateInfo);
                    if (exchangeRateInfo != null) {
                        exchangeRate1 = exchangeRateInfo.getConvertRate();
                    }
                } else {
                    cbIsIndirectRate1 = true;
                }
            }
            int round = 4;
            if (entry.getActualAmt() == null && head.getCbPayInfo() != null && head.getCbPayInfo().getPayeeAmount() != null) {
                entry.setActualAmt(head.getCbPayInfo().getPayeeAmount());
            }
            BigDecimal temp = entry.getActualAmt();
            entry.setActualAmt(temp);
            if (rate == null) {
                rate = Constants.ONE;
            }
            if (temp != null) {
                temp = cbIsIndirectRate1.booleanValue() ? temp.divide(exchangeRate1, baseCurrency.getPrecision(), round) : temp.multiply(exchangeRate1).setScale(baseCurrency.getPrecision(), round);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"176_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            entry.setActualLocAmt(temp);
            try {
                if (head.getCbPayInfo() != null && head.getCbPayInfo().getPayeeCurrency() != null && head.getCbPayInfo().getPaymentCurrency() != null) {
                    ExchangeRateInfo exchangeRateInfo2 = this.getExRateInfo(ctx, head.getCbPayInfo().getPayeeCurrency().getId().toString(), head.getCbPayInfo().getPaymentCurrency().getId().toString(), head.getCompany(), new Date());
                    cbIsIndirectRate2 = this.isIndirectExRate(exchangeRateInfo2);
                    if (exchangeRateInfo2 != null) {
                        exchangeRate2 = exchangeRateInfo2.getConvertRate();
                    }
                }
                if (head.getActPayAmt() != null) {
                    head.getCbPayInfo().setPaymentAmount(head.getActPayAmt());
                }
                this.getActPayLocAmt(ctx, head.getExchangeRate(), head.getCurrency(), head);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            PaymentBillEntryCollection col = head.getEntries();
            if (col != null) {
                BigDecimal amt = Constants.ZERO;
                BigDecimal amtLoc = Constants.ZERO;
                for (int i = 0; i < col.size(); ++i) {
                    PaymentBillEntryInfo entryInfo = col.get(i);
                    amt = amt.add(entryInfo.getActualAmt()).setScale(scale, round);
                    amtLoc = amtLoc.add(entryInfo.getActualLocAmt()).setScale(baseCurrency.getPrecision(), round);
                }
                head.getCbPayInfo().setPayeeAmount(amt);
            }
            if ((data = (String)this.getData(hsData, "outBgItemNumber")) != null && data.toString().trim().length() > 0) {
                BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber((String)data.toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"21_AgentPayBillDataImport", (Locale)ctx.getLocale()), (Context)ctx);
                head.setOutBgItemNumber(data.toString());
                head.setOutBgItemId(bgItemInfo.getId().toString());
                head.setOutBgItemName(bgItemInfo.getName());
            }
            this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        }
        catch (BOSException e) {
            this.seqMap.put(this.curKey, new Integer((Integer)this.seqMap.get(this.curKey) - 1));
            throw e;
        }
        return head;
    }

    private void getActPayLocAmt(Context ctx, BigDecimal rate, CurrencyInfo srcCurrency, PaymentBillInfo head) {
        boolean isIndirectExRate = false;
        if (!srcCurrency.getId().equals((Object)head.getCompany().getBaseCurrency().getId())) {
            ExchangeRateInfo exchangeRateInfo = this.getExRateInfo(ctx, srcCurrency.getId().toString(), null, head.getCompany(), new Date());
            isIndirectExRate = this.isIndirectExRate(exchangeRateInfo);
            if (isIndirectExRate && rate.compareTo(Constants.ZERO) != 0) {
                rate = Constants.ONE.divide(rate, 20, 4);
            }
        } else {
            rate = Constants.ONE;
            isIndirectExRate = true;
        }
        head.setActPayLocAmt(head.getActPayAmt().multiply(rate));
    }

    public boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exRateInfo.getConvertMode());
    }

    public TransTypeInfo getTransTypeInfoByNumber(Context ctx, String number) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)number, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        TransTypeCollection transTypeCollection = null;
        try {
            transTypeCollection = TransTypeFactory.getLocalInstance(ctx).getTransTypeCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (EmptyUtil.isEmpty((AbstractObjectCollection)transTypeCollection)) {
            throw new BOSException("\u83b7\u53d6\u4ea4\u6613\u7c7b\u578b\u7f16\u7801\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u4ea4\u6613\u7c7b\u578b\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
        }
        return transTypeCollection.get(0);
    }

    private PaymentBillEntryInfo getEntryInfo(Context ctx, int mode, String parentId, String FSeq) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (parentId == null || FSeq == null) {
                return new PaymentBillEntryInfo();
            }
            try {
                IPaymentBillEntry iPaymentBillEntry = PaymentBillEntryFactory.getLocalInstance((Context)ctx);
                PaymentBillEntryCollection coll = iPaymentBillEntry.getPaymentBillEntryCollection("where paymentBill = '" + parentId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new PaymentBillEntryInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new PaymentBillEntryInfo();
        }
        return new PaymentBillEntryInfo();
    }

    public ExchangeRateInfo getExRateInfo(Context ctx, String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        ExchangeRateInfo exRateInfo = null;
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        if (sourceCurrpk.equals((Object)destCurrpk)) {
            exRateInfo = new ExchangeRateInfo();
            exRateInfo.setConvertRate(new BigDecimal(1));
            return exRateInfo;
        }
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    private PaymentBillInfo getHeadInfo(Context ctx, int mode, String number, String companyId) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyId == null || number == null) {
                return new PaymentBillInfo();
            }
            try {
                PaymentBillCollection coll = ((IPaymentBill)this.getController(ctx)).getPaymentBillCollection("where number = '" + number + "' and company.id = '" + companyId + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new PaymentBillInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new PaymentBillInfo();
        }
        return new PaymentBillInfo();
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        CountryCollection countryColl;
        EntityViewInfo view;
        EntityViewInfo view2;
        FilterInfo filter;
        FilterInfo filter2;
        BizTypeEnum enums;
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FUsage")) != null && data.toString().trim().length() > 0) {
            info.setUsage(data.toString());
        }
        if ((data = this.getData(hsData, "FAccessoryAmt")) != null && data.toString().trim().length() > 0) {
            info.setAccessoryAmt(TypeConversionUtils.objToInt((Object)data));
        }
        if ((data = this.getData(hsData, "FPaymentBillType")) == null) {
            info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
        }
        if ((data = this.getData(hsData, "FExpectDealTime")) != null && data.toString().trim().length() > 0) {
            info.setExpectDealTime(new Timestamp(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data).getTime()));
        }
        if ((data = this.getData(hsData, "FBizDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setBizDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        } else {
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FActualAmt");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                Double douData = new DecimalFormat().parse(data.toString()).doubleValue();
                info.setActPayAmt(new BigDecimal(douData).setScale(info.getCurrency().getPrecision(), 4));
            }
            catch (Exception douData) {
                // empty catch block
            }
        }
        if ((data = this.getData(hsData, "FExchangeRate")) != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FFundType")) != null && data.toString().trim().length() > 0 && (enums = BizTypeEnum.getEnum((int)TypeConversionUtils.objToInt((Object)data))) != null) {
            info.setFundType(enums);
        }
        if ((data = this.getData(hsData, "FBizTypeID")) != null && data.toString().trim().length() > 0) {
            info.setBizType(RecAndPayDataImportUtil2.getBizTypeByNumber((Context)ctx, (String)data.toString()));
        }
        if ((data = this.getData(hsData, "FPayerAccountID")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccount(RecAndPayDataImportUtil2.getAccountByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), (String)info.getCompany().getId().toString(), (String)info.getCurrency().getId().toString(), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "FPayerAccountBankID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), (String)info.getCompany().getId().toString(), (String)data.toString(), (boolean)true, (boolean)false);
            info.setPayerAccountBank(accountBank);
            if (accountBank != null) {
                if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                    throw new BOSException("\u4ed8\u6b3e\u8d26\u6237\u4e0d\u662f\u4ed8\u6b3e\u516c\u53f8\u7684\u94f6\u884c\u8d26\u6237\u3002");
                }
                info.setPayerBank(accountBank.getBank());
                info.setPayerAccount(accountBank.getAccount());
            } else {
                throw new BOSException("\u83b7\u53d6\u4ed8\u6b3e\u8d26\u6237\"" + data.toString() + "\"\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01");
            }
        }
        if ((data = this.getData(hsData, "FFeeTypeID")) != null && data.toString().trim().length() > 0) {
            FeeTypeInfo feeType = RecAndPayDataImportUtil2.getFeeTypeByNumber((Context)ctx, (String)((String)data));
            info.setFeeType(feeType);
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0) {
            info.setSettlementType(RecAndPayDataImportUtil2.getSettlementTypeByNumber((String)data.toString(), (Context)ctx));
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, (Object[])new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayBillTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayBillType(RecAndPayDataImportUtil2.getPayBillTypeByNumber((String)data.toString(), (Context)ctx));
        }
        if (info.getPayBillType().getSourceSysType().equals((Object)SourceTypeEnum.CASH)) {
            this.flag = true;
            info.setSourceType(SourceTypeEnum.CASH);
        } else {
            info.setSourceType(info.getPayBillType().getSourceSysType());
        }
        info.setSourceSysType(SourceTypeEnum.CASH);
        data = this.getData(hsData, "FOppAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), (String)info.getCompany().getId().toString(), (String)info.getCurrency().getId().toString(), (String)data.toString(), (boolean)this.cs064, (boolean)this.flag));
        }
        if ((data = this.getData(hsData, "FPayeeTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayeeType(RecAndPayDataImportUtil2.getAsstActTypeByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"177_PaymentBillDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "FBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setBankNumber(data.toString());
        } else if (info.getPayeeBank() != null && info.getPayeeBank().trim().length() > 0) {
            EntityViewInfo view3 = new EntityViewInfo();
            filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPayeeBank().trim(), CompareType.EQUALS));
            view3.setFilter(filter2);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view3);
            if (coll.size() > 0) {
                info.setBankNumber(coll.get(0).getNumber());
            }
        }
        String companyID = null;
        data = this.getData(hsData, "FPayeeNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (info.getPayeeType() == null) {
                info.setPayeeName(data.toString());
                info.setPayeeNumber(data.toString());
                EntityViewInfo view4 = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)data.toString().trim()));
                view4.setFilter(filter);
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view4);
                if (companyColl != null && companyColl.size() > 0) {
                    companyID = companyColl.get(0).getId().toString();
                }
            } else {
                IRowSet asstActInfo = RecAndPayDataImportUtil2.getAsstActInfo((AsstActTypeInfo)info.getPayeeType(), (String)data.toString(), (Context)ctx);
                try {
                    if (asstActInfo.next()) {
                        info.setPayeeID(asstActInfo.getString("fid"));
                        info.setPayeeNumber(asstActInfo.getString("fnumber"));
                        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        info.setPayeeName(asstActInfo.getString("fname_" + loc));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
        if ((data = this.getData(hsData, "FPayeeBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBank(data.toString());
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeID()) && BOSUuid.read((String)info.getPayeeID()).getType().equals((Object)new SupplierInfo().getBOSType())) {
            ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("province.*"));
            sic.add(new SelectorItemInfo("city.*"));
            SupplierInfo realSupplier = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getProvince()) && !EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getCity())) {
                info.setRecProvince(realSupplier.getProvince().getName());
                info.setRecCity(realSupplier.getCity().getName());
            }
            info.setBankAcctName(realSupplier.getName());
            SelectorItemCollection spcSelector = new SelectorItemCollection();
            spcSelector.add(new SelectorItemInfo("id"));
            spcSelector.add(new SelectorItemInfo("supplierBank.id"));
            spcSelector.add(new SelectorItemInfo("supplierBank.bank"));
            SupplierCompanyInfoInfo supplierCompany = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
            if (supplierCompany != null && supplierCompany.getSupplierBank() != null && supplierCompany.getSupplierBank().size() > 0) {
                SupplierCompanyBankCollection coll = supplierCompany.getSupplierBank();
                SupplierCompanyBankInfo sBankInfo = coll.get(0);
                info.setPayeeBank(sBankInfo.getBank());
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            BEBankInfo beBank = RecAndPayDataImportUtil2.getBeBankByName((Context)ctx, (String)info.getPayeeBank());
            if (info != null && beBank != null) {
                info.setBankNumber(beBank.getNumber());
                info.setRecProvince(beBank.getBeProvince());
                info.setRecCity(beBank.getBeCity());
            } else {
                logger.error((Object)("\u4ed8\u6b3e\u5355\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u627e\u5bf9\u5bf9\u5e94\u7684\u884c\u540d\u884c\u53f7\uff0c\u6536\u6b3e\u94f6\u884c=" + info.getPayeeBank()));
            }
        }
        if (info.getBankAcctName() == null && (data = this.getData(hsData, "FBankAcctName")) != null && data.toString().trim().length() > 0) {
            info.setBankAcctName(data.toString());
        }
        if ((data = this.getData(hsData, "FRecCountry")) != null && data.toString().trim().length() > 0) {
            filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view2 = new EntityViewInfo();
            view2.setFilter(filter2);
            CountryCollection countryColl2 = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view2);
            info.setFRecCountry(countryColl2.get(0));
        }
        if ((data = this.getData(hsData, "FPayeeAccountBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountBank(data.toString());
            info.setPayeeAccountBankO(RecAndPayDataImportUtil2.getAccountBankByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), (String)companyID, (String)data.toString(), (boolean)false, (boolean)true));
        }
        if ((data = this.getData(hsData, "FCostCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber((String)data.toString(), (Context)ctx));
        }
        if (info.getPayeeAccountBankO() != null) {
            info.setOppInnerAcct(info.getPayeeAccountBankO().getInnerAcct());
        } else {
            info.setOppInnerAcct(null);
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        info.setIsCBPay(true);
        CBPaymentInfo cbInfo = null;
        cbInfo = info.getCbPayInfo() == null ? new CBPaymentInfo() : info.getCbPayInfo();
        data = this.getData(hsData, "FPayeeCurrency");
        if (data != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        }
        if (cbInfo.getPayeeCurrency() == null) {
            cbInfo.setPayeeCurrency(info.getCurrency());
        }
        if ((data = this.getData(hsData, "FTransactionType")) != null && data.toString().trim().length() > 0) {
            cbInfo.setTransType(this.getTransTypeInfoByNumber(ctx, data.toString()));
            cbInfo.setTransactionType(TransTypeEnum.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FPayeeBankCountry")) != null && data.toString().trim().length() > 0 && data != null && data.toString().trim().length() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view = new EntityViewInfo();
            view.setFilter(filter);
            countryColl = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
            cbInfo.setPayeeBankCountry(countryColl.get(0));
        }
        if ((data = this.getData(hsData, "FAgentCountry")) != null && data.toString().trim().length() > 0 && data != null && data.toString().trim().length() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view = new EntityViewInfo();
            view.setFilter(filter);
            countryColl = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
            cbInfo.setAgentCountry(countryColl.get(0));
        }
        if ((data = this.getData(hsData, "FPayeeBankAddr")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeBankAddr(data.toString());
        }
        if ((data = this.getData(hsData, "FBLClearBranchCode")) != null && data.toString().trim().length() > 0) {
            cbInfo.setBLClearBranchCode(data.toString());
        }
        if ((data = this.getData(hsData, "FBLClearCode")) != null && data.toString().trim().length() > 0) {
            cbInfo.setBLClearCode(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeAddress")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeAddress(data.toString());
        }
        cbInfo.setPaymentCurrency(info.getCurrency());
        data = this.getData(hsData, "FPayeeSwiftCode");
        if (data != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeSwiftCode(data.toString());
        }
        if ((data = this.getData(hsData, "FPayTransaction")) != null && data.toString().trim().length() > 0) {
            view2 = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view2.setFilter(fi);
            SelectorItemCollection sic = view2.getSelector();
            sic.add(new SelectorItemInfo("*"));
            TransactionsTypeCollection colls = TransactionsTypeFactory.getLocalInstance(ctx).getTransactionsTypeCollection(view2);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
                cbInfo.setPayTransaction(colls.get(0));
            }
        }
        if ((data = this.getData(hsData, "FEmail")) != null && data.toString().trim().length() > 0) {
            info.setEmail(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeePhoneCode")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeePhoneCode(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeePhone")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeePhone(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeFPSNum")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeFPSNum(data.toString());
        }
        if ((data = this.getData(hsData, "FMessageToBank")) != null && data.toString().trim().length() > 0) {
            cbInfo.setMessageToBank(MessageToBankEnum.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FClearReqParam")) != null && data.toString().trim().length() > 0) {
            cbInfo.setClearReqParam(data.toString());
        }
        if ((data = this.getData(hsData, "FForContractNo")) != null && data.toString().trim().length() > 0) {
            cbInfo.setForContractNo(data.toString());
        }
        if ((data = this.getData(hsData, "FPayWay")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayWay(data.toString());
        }
        if ((data = this.getData(hsData, "FTransactionType")) != null && data.toString().trim().length() > 0) {
            cbInfo.setTransactionType(TransTypeEnum.getEnum(data.toString()));
        }
        if ((data = this.getData(hsData, "FCNAPSNum")) != null && data.toString().trim().length() > 0) {
            cbInfo.setCNAPSNum(data.toString());
        }
        info.setSettleFeeType(SettleFeeTypeEnum.PayerPay);
        data = this.getData(hsData, "FPaymentterms");
        if (data != null && data.toString().trim().length() > 0) {
            cbInfo.setPaymentterms(PaymentTermsEnmu.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FFeeAccountBank")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), (String)info.getCompany().getId().toString(), (String)data.toString(), (boolean)true, (boolean)false);
            info.setPayerAccountBank(accountBank);
            if (accountBank != null) {
                if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                    throw new BOSException("\u4ed8\u6b3e\u8d26\u6237\u4e0d\u662f\u4ed8\u6b3e\u516c\u53f8\u7684\u94f6\u884c\u8d26\u6237\u3002");
                }
                cbInfo.setFeeAccountBank(accountBank);
                cbInfo.setFeeCurrency(accountBank.getCurrency());
                cbInfo.setFeeBank(accountBank.getBank().getName());
            } else {
                throw new BOSException("\u83b7\u53d6\u4ed8\u6b3e\u8d26\u6237\"" + data.toString() + "\"\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01");
            }
        }
        if ((data = this.getData(hsData, "FFeeCurrency")) != null && data.toString().trim().length() > 0) {
            cbInfo.setFeeCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        }
        if (cbInfo.getFeeCurrency() == null) {
            cbInfo.setFeeCurrency(info.getCurrency());
        }
        if ((data = this.getData(hsData, "FIsByAgentBank")) != null && data.toString().trim().length() > 0) {
            cbInfo.setIsByAgentBank(true);
        }
        if ((data = this.getData(hsData, "FAgentSwift")) != null && data.toString().trim().length() > 0) {
            cbInfo.setAgentSwift(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeBankNumber")) != null && data.toString().trim().length() > 0) {
            cbInfo.setPayeeBankNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FServiceLevel")) != null && data.toString().trim().length() > 0) {
            cbInfo.setServiceLevel(ServiceLevelEnum.getEnum(Integer.parseInt(data.toString())));
        } else {
            cbInfo.setServiceLevel(ServiceLevelEnum.URGP);
        }
        data = this.getData(hsData, "FCBSPayType");
        if (data != null && data.toString().trim().length() > 0) {
            cbInfo.setCBSPayType(CBSPayTypeEnum.getEnum(Integer.parseInt(data.toString())));
        } else {
            cbInfo.setCBSPayType(CBSPayTypeEnum.CHK);
        }
        data = this.getData(hsData, "FAgentAddr");
        if (data != null && data.toString().trim().length() > 0) {
            cbInfo.setAgentAddr(data.toString());
        }
        if ((data = this.getData(hsData, "FAgentbank")) != null && data.toString().trim().length() > 0) {
            AgencybankInfo agencybank = RecAndPayDataImportUtil2.getAgencybankByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), (String)info.getCompany().getId().toString(), (String)data.toString(), (boolean)true, (boolean)true);
            cbInfo.setAgencybank(agencybank);
            cbInfo.setAgentAcctBank(agencybank.getName());
            cbInfo.setAgentAddr(agencybank.getAddress());
            cbInfo.setAgentSwift(agencybank.getAgencySwift());
            if (cbInfo.getAgentCountry() == null) {
                cbInfo.setAgentCountry(agencybank.getCountry());
                if (agencybank == null) {
                    throw new BOSException("\u83b7\u53d6\u4ee3\u7406\u884c\"" + data.toString() + "\"\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01");
                }
            }
        }
        info.setCbPayInfo(cbInfo);
        return info;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String company = currCompany.getNumber();
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        PaymentBillCollection coll = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(evi);
        if (coll != null && coll.size() > 1) {
            throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        return false;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            PaymentBillFactory.getLocalInstance((Context)ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx, PaymentBillEntryInfo info, String companyId) throws BOSException, EASBizException {
        this.prepareImport(ctx, (IObjectValue)info, hsData, "entries");
        Object data = null;
        info.setPaymentBill(RecAndPayDataImportUtil2.getPaymentBillByNumber((Hashtable)hsData, (Context)ctx));
        data = this.getData(hsData, "FRemark");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntries_outBgItemNumber")) != null && data.toString().trim().length() > 0) {
            BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber((String)data.toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), (Context)ctx);
            info.setOutBgItemNumber(data.toString());
            info.setOutBgItemId(bgItemInfo.getId().toString());
            info.setOutBgItemName(bgItemInfo.getName());
        }
        if ((data = this.getData(hsData, "FEntryExpenseType")) != null && data.toString().trim().length() > 0) {
            info.setExpenseType(RecAndPayDataImportUtil2.getExpenseTypeByNumber((String)data.toString(), (Context)ctx));
        }
        if ((data = this.getData(hsData, "FEntryRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntryCostCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber((String)data.toString(), (Context)ctx));
        }
        if ((data = this.getData(hsData, "FEntryFundFlowItem")) != null && data.toString().trim().length() > 0) {
            info.setFundFlowItem(RecAndPayDataImportUtil2.getFundFlowItemByNumber((String)data.toString(), (Context)ctx));
        }
        CurrencyInfo currency = null;
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            currency = RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString());
        } else {
            try {
                currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getPaymentBill().getCompany());
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FEntryActualAmt");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                Double douData = new DecimalFormat().parse(data.toString()).doubleValue();
                info.setActualAmt(new BigDecimal(douData).setScale(currency.getPrecision(), 4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((data = this.getData(hsData, "FEntryOppAccID")) != null && data.toString().trim().length() > 0 && currency != null) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"179_PaymentBillDataImport", (Locale)ctx.getLocale()), (String)companyId, (String)currency.getId().toString(), (String)data.toString(), (boolean)this.cs064, (boolean)this.flag));
        }
        if (EmptyUtil.isEmpty((Object)info.getId())) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        return info;
    }

    protected String getTemplateNumber() {
        return "cbsPayingBill";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.cbs.app.CBSPaymentQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String entryID;
            String payeeName;
            String FEntryFundFlowItem;
            String FEntryCostCenter;
            String FEntryExpenseType;
            String FEntryRemark;
            BigDecimal FEntryActualAmt;
            String BgItem;
            String entryBgItem;
            String payeeBank;
            String payeeAccountBank;
            java.sql.Date expectDealTime;
            java.sql.Date bizDate;
            String entryOppAccount;
            String payeeNumber;
            String payeeType;
            String payBillType;
            String description;
            String oppAccount;
            String bankAcctName;
            String settlementNumber;
            String settlementType;
            String feeTypeId;
            String bizType;
            String payerAccountBank;
            String payerAccount;
            BigDecimal exchangeRate;
            String currency;
            BigDecimal actualLocalAmt;
            BigDecimal actualAmt;
            String companyID;
            String number;
            String agentAcctBank;
            String agentAddr;
            String agentSwift;
            Boolean isByAgentBank;
            String feeAccountBankName;
            String paymentterms;
            String CNAPSNum;
            String payWay;
            String forContractNo;
            String clearReqParam;
            String MessageToBank;
            String payeeFPSNum;
            String payeePhone;
            String payeePhoneCode;
            String payeeSwiftCode;
            String payeeAddress;
            String payeeBankAddr;
            String payeeBankCountry;
            String transactionType;
            String usage;
            Boolean fivouchered = rs.getBoolean("fivouchered");
            if (fivouchered != null) {
                result.put("FFiVouchered", fivouchered != false ? "\u662f" : "\u5426");
            }
            if ((usage = this.getString(rs, "usage")) != null) {
                result.put("FUsage", usage);
            }
            if ((transactionType = this.getString(rs, "cbPayInfo.transactionType")) != null) {
                result.put("FTransactionType", (Object)TransTypeEnum.getEnum(Integer.parseInt(transactionType)));
            }
            if ((payeeBankCountry = this.getString(rs, "FRECCOUNTRY.NAME")) != null) {
                result.put("FRecCountry", payeeBankCountry);
            }
            if ((payeeBankAddr = this.getString(rs, "cbPayInfo.payeeBankAddr")) != null) {
                result.put("FPayeeBankAddr", payeeBankAddr);
            }
            String bLClearBranchCode = this.getString(rs, "cbPayInfo.bLClearBranchCode");
            if (payeeBankAddr != null) {
                result.put("FBLClearBranchCode", bLClearBranchCode);
            }
            String bLClearCode = this.getString(rs, "cbPayInfo.bLClearCode");
            if (payeeBankAddr != null) {
                result.put("FBLClearCode", bLClearCode);
            }
            String payeeBankNumber = this.getString(rs, "cbPayInfo.payeeBankNumber");
            if (payeeBankAddr != null) {
                result.put("FPayeeBankNumber", payeeBankNumber);
            }
            String serviceLevel = this.getString(rs, "cbPayInfo.serviceLevel");
            if (transactionType != null) {
                result.put("FServiceLevel", (Object)ServiceLevelEnum.getEnum(Integer.parseInt(serviceLevel)));
            }
            String CBSPayType = this.getString(rs, "cbPayInfo.CBSPayType");
            if (transactionType != null) {
                result.put("FCBSPayType", (Object)CBSPayTypeEnum.getEnum(Integer.parseInt(CBSPayType)));
            }
            if ((payeeAddress = this.getString(rs, "cbPayInfo.payeeAddress")) != null) {
                result.put("FPayeeAddress", payeeAddress);
            }
            if ((payeeSwiftCode = this.getString(rs, "cbPayInfo.payeeSwiftCode")) != null) {
                result.put("FPayeeSwiftCode", payeeSwiftCode);
            }
            if ((payeePhoneCode = this.getString(rs, "cbPayInfo.payeePhoneCode")) != null) {
                result.put("FPayeePhoneCode", payeePhoneCode);
            }
            if ((payeePhone = this.getString(rs, "cbPayInfo.payeePhone")) != null) {
                result.put("FPayeePhone", payeePhone);
            }
            if ((payeeFPSNum = this.getString(rs, "cbPayInfo.payeeFPSNum")) != null) {
                result.put("FPayeeFPSNum", payeeFPSNum);
            }
            if ((MessageToBank = this.getString(rs, "cbPayInfo.MessageToBank")) != null) {
                result.put("FMessageToBank", MessageToBank);
            }
            if ((clearReqParam = this.getString(rs, "cbPayInfo.clearReqParam")) != null) {
                result.put("FClearReqParam", clearReqParam);
            }
            if ((forContractNo = this.getString(rs, "cbPayInfo.forContractNo")) != null) {
                result.put("FForContractNo", forContractNo);
            }
            if ((payWay = this.getString(rs, "cbPayInfo.payWay")) != null) {
                result.put("FPayWay", payWay);
            }
            if ((CNAPSNum = this.getString(rs, "cbPayInfo.CNAPSNum")) != null) {
                result.put("FCNAPSNum", CNAPSNum);
            }
            if ((paymentterms = this.getString(rs, "cbPayInfo.paymentterms")) != null) {
                result.put("FPaymentterms", paymentterms);
            }
            if ((feeAccountBankName = this.getString(rs, "feeAccountBank.name")) != null) {
                result.put("FFeeAccountBank", feeAccountBankName);
            }
            String feeCurrency = this.getString(rs, "feeCurrency.name");
            if (feeAccountBankName != null) {
                result.put("FFeeCurrency", feeCurrency);
            }
            if ((isByAgentBank = Boolean.valueOf(rs.getBoolean("cbPayInfo.isByAgentBank"))) != null) {
                result.put("FIsByAgentBank", isByAgentBank != false ? "\u662f" : "\u5426");
            }
            if ((agentSwift = this.getString(rs, "cbPayInfo.agentSwift")) != null) {
                result.put("FAgentSwift", agentSwift);
            }
            if ((agentAddr = this.getString(rs, "cbPayInfo.agentAddr")) != null) {
                result.put("FAgentAddr", agentAddr);
            }
            if ((agentAcctBank = this.getString(rs, "cbPayInfo.agentAcctBank")) != null) {
                result.put("FAgentAcctBank", agentAcctBank);
            }
            String agencybankNumber = this.getString(rs, "agencybank.number");
            if (agentAcctBank != null) {
                result.put("FAgentbank", agencybankNumber);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("FNumber", number);
            }
            if ((companyID = this.getString(rs, "company.name")) != null) {
                result.put("FCompanyID", companyID);
            }
            if ((actualAmt = rs.getBigDecimal("actPayAmt")) != null) {
                result.put("FActualAmt", actualAmt);
            }
            if ((actualLocalAmt = rs.getBigDecimal("actPayLocAmt")) != null) {
                result.put("FActualLocAmt", actualLocalAmt);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrencyID", currency);
            }
            if ((exchangeRate = rs.getBigDecimal("exchangeRate")) != null) {
                result.put("FExchangeRate", exchangeRate);
            }
            if ((payerAccount = this.getString(rs, "payerAccount.number")) != null) {
                result.put("FPayerAccountID", payerAccount);
            }
            if ((payerAccountBank = this.getString(rs, "payerAccountBank.number")) != null) {
                result.put("FPayerAccountBankID", payerAccountBank);
            }
            if ((bizType = this.getString(rs, "bizType.number")) != null) {
                result.put("FBizTypeID", bizType);
            }
            if ((feeTypeId = this.getString(rs, "feeType.number")) != null) {
                result.put("FFeeTypeID", feeTypeId);
            }
            if ((settlementType = this.getString(rs, "settlementType.number")) != null) {
                result.put("FSettlementTypeID", settlementType);
            }
            if ((settlementNumber = this.getString(rs, "settlementNumber")) != null) {
                result.put("FSettlementNumber", settlementNumber);
            }
            if ((bankAcctName = this.getString(rs, "bankAcctName")) != null) {
                result.put("FBankAcctName", bankAcctName);
            }
            if ((oppAccount = this.getString(rs, "oppAccount.number")) != null) {
                result.put("FOppAccountID", oppAccount);
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((payBillType = this.getString(rs, "payBillType.number")) != null) {
                result.put("FPayBillTypeID", payBillType);
            }
            if ((payeeType = this.getString(rs, "payeeType.number")) != null) {
                result.put("FPayeeTypeID", payeeType);
            }
            if ((payeeNumber = this.getString(rs, "payeeNumber")) != null) {
                result.put("FPayeeNumber", payeeNumber);
            }
            if ((entryOppAccount = this.getString(rs, "entries.oppAccount.number")) != null) {
                result.put("FEntryOppAccID", entryOppAccount);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((expectDealTime = rs.getDate("expectDealTime")) != null) {
                result.put("FExpectDealTime", DateTimeUtils.format((Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((payeeAccountBank = this.getString(rs, "payeeAccountBank")) != null) {
                result.put("FPayeeAccountBank", payeeAccountBank);
            }
            if ((payeeBank = this.getString(rs, "payeeBank")) != null) {
                result.put("FPayeeBank", payeeBank);
            }
            if ((entryBgItem = this.getString(rs, "entries.outBgItemNumber")) != null) {
                result.put("FEntries_outBgItemNumber", entryBgItem);
            }
            if ((BgItem = this.getString(rs, "outBgItemNumber")) != null) {
                result.put("outBgItemNumber", BgItem);
            }
            if ((FEntryActualAmt = rs.getBigDecimal("entries.actualAmt")) != null) {
                result.put("FEntryActualAmt", FEntryActualAmt);
            }
            if ((FEntryRemark = this.getString(rs, "entries.remark")) != null) {
                result.put("FEntryRemark", FEntryRemark);
            }
            if ((FEntryExpenseType = this.getString(rs, "expenseType.number")) != null) {
                result.put("FEntryExpenseType", FEntryExpenseType);
            }
            if ((FEntryCostCenter = this.getString(rs, "entries.costCenter.number")) != null) {
                result.put("FEntryCostCenter", FEntryCostCenter);
            }
            if ((FEntryFundFlowItem = this.getString(rs, "entries.fundFlowItem.number")) != null) {
                result.put("FEntryFundFlowItem", FEntryFundFlowItem);
            }
            if ((payeeName = this.getString(rs, "payeeName")) != null) {
                result.put("FPayeeNumber", payeeName);
            }
            if (!EmptyUtil.isEmpty((String)(entryID = this.getString(rs, "entries.id")))) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("asstActType.name"));
                EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null);
                AssItemsForCashPayCollection assColl = AssItemsForCashPayFactory.getLocalInstance((Context)ctx).getAssItemsForCashPayCollection(view);
                if (assColl != null && assColl.size() > 0) {
                    int j = assColl.size();
                    for (int i = 0; i < j; ++i) {
                        AssItemsForCashPayInfo assInfo = assColl.get(i);
                        if (assInfo.getAsstActType() != null && assInfo.getAsstActType().getName() != null) {
                            result.put("FAssType" + (i + 1), assInfo.getAsstActType().getName());
                        }
                        if ("T_BD_GeneralAsstActType".equals(assInfo.getTableName())) {
                            if (!EmptyUtil.isEmpty((String)assInfo.getFromID())) {
                                ObjectUuidPK pk = new ObjectUuidPK(assInfo.getFromID());
                                GeneralAsstActTypeInfo info = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)pk);
                                result.put("FAssNumber" + (i + 1), info.getLongNumber().replaceAll("!", "."));
                            }
                        } else if (assInfo.getFromNumber() != null) {
                            result.put("FAssNumber" + (i + 1), assInfo.getFromNumber());
                        }
                        if (EmptyUtil.isEmpty((String)assInfo.getFromID())) continue;
                        CoreBaseInfo entityInfo = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(assInfo.getFromID());
                        result.put("FAssName" + (i + 1), entityInfo.get("name"));
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            PaymentBillInfo info = (PaymentBillInfo)coreBaseInfo;
            if (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)info.getBillStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    private AssItemsForCashPayInfo parseAssItem(Hashtable hsData, Context ctx, AsstActTypeInfo assTypeInfo, AssItemsForCashPayInfo info, int assIndex, PaymentBillEntryInfo entry) throws BOSException {
        Object data = null;
        data = this.getData(hsData, "FAssType" + assIndex);
        if (data != null && data.toString().trim().length() > 0) {
            info.setAsstActType(assTypeInfo);
            info.setEntrySeq(entry.getSeq());
            info.setIsSelected(false);
            info.setEntryParent(entry);
            info.setMappingFileds(assTypeInfo.getMappingFieldName());
            info.setTableName(assTypeInfo.getRealtionDataObject());
            String assNumber = (String)this.getData(hsData, "FAssNumber" + assIndex);
            if (assNumber != null && assNumber.trim().length() > 0) {
                DataBaseInfo assObj = this.getAsstActObject(ctx, assTypeInfo, assNumber);
                if (assObj != null) {
                    if (assObj instanceof ProjectInfo && 2 == ((ProjectInfo)assObj).getStatus().getValue()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"471_projectClosed", (Locale)ctx.getLocale(), (Object[])new Object[]{assNumber}));
                    }
                    info.setIsSelected(true);
                    info.setFromNumber(assObj.getNumber());
                    info.setFromID(assObj.getId().toString());
                } else {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"180_PaymentBillDataImport", (Locale)ctx.getLocale()) + assNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            }
        }
        return info;
    }

    private AssItemsForCashPayInfo getAssItemInfo(Context ctx, int mode, String entryId, AssItemsForCashPayCollection assCol, AsstActTypeInfo assTypeInfo) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (entryId == null || assCol == null || assCol.size() == 0) {
                return new AssItemsForCashPayInfo();
            }
            try {
                for (AssItemsForCashPayInfo info : assCol) {
                    if (!info.getAsstActType().getId().equals((Object)assTypeInfo.getId())) continue;
                    return info;
                }
                return new AssItemsForCashPayInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        return new AssItemsForCashPayInfo();
    }
}

