/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class ConsignmentLoanBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        ConsignmentLoanBillInfo loanInfo = this.getConsignmentLoanInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = this.createJournalInfoAmt(ctx, loanInfo);
        journalColl.add(journalInfo);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(Context ctx, ConsignmentLoanBillInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getAccountBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(info.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(info.getLoanAmt());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getEffectiveDate());
        journalInfo.setAccountView(info.getAccountBank().getAccount());
        journalInfo.setOppAccountView(info.getLoanAcctView());
        journalInfo.setBillType(BillTypeEnum.consignmentLoan);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"18_ConsignmentLoanBillSubsidiaryBookProvider", (Locale)ctx.getLocale());
        }
        journalInfo.setDescription(des);
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private ConsignmentLoanBillInfo getConsignmentLoanInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountBank.account.*");
        return sic;
    }
}

