/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillCollection;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.cl.app.AbstractCLRateAdjustmentBillControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CLRateAdjustmentBillControllerBean
extends AbstractCLRateAdjustmentBillControllerBean {
    private static Map botpRelationShip = new HashMap();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.CLRateAdjustmentBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    @Override
    protected Set _batchAdjustRate(Context ctx, CLRateAdjustmentBillCollection col, Map addValueMap) throws BOSException, EASBizException {
        HashSet<String> adjustmentBillIDs = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CLRateAdjustmentBillInfo rateAdjustBillInfo = col.get(i);
            rateAdjustBillInfo.setModifyRateType((IntRateModifyType)addValueMap.get("rateModifyType"));
            rateAdjustBillInfo.setIntRateType((IntRateTypeInfo)addValueMap.get("rateType"));
            rateAdjustBillInfo.setFloatAction((FloatActionEnum)addValueMap.get("floatAction"));
            rateAdjustBillInfo.setBasePoints((BigDecimal)addValueMap.get("basePoints"));
            rateAdjustBillInfo.setFirstRateAdjustDate((Date)addValueMap.get("firstRateAjdust"));
            rateAdjustBillInfo.setRateAdjustPeriod(Integer.valueOf(addValueMap.get("rateAdjustPeriod").toString()));
            IObjectPK pk = super.submit(ctx, (CoreBaseInfo)rateAdjustBillInfo);
            adjustmentBillIDs.add(pk.toString());
        }
        return adjustmentBillIDs;
    }

    private void checkSameDay(Context ctx, CLRateAdjustmentBillInfo rateAdjustBillInfo) throws BOSException, ConsignmentLoanException {
        boolean isAddNew;
        boolean bl = isAddNew = rateAdjustBillInfo.getId() == null;
        if (!isAddNew) {
            return;
        }
        String id = rateAdjustBillInfo.getLoan().getId().toString();
        String sql = "select fid from t_cl_CLRateAdjustmentBill where floanid = ? and FAdjustDate = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id, rateAdjustBillInfo.getAdjustDate()});
        try {
            if (rs.next()) {
                throw new ConsignmentLoanException(ConsignmentLoanException.SAMEDAY, new Object[]{rateAdjustBillInfo.getLoan().getNumber()});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateLoanBill(Context ctx, CLRateAdjustmentBillInfo rateAdjustBillInfo, boolean updateAdjTimes) throws BOSException {
        StringBuffer sbUpdate = new StringBuffer();
        sbUpdate.append("update T_CL_ConsignmentLoanBill ");
        sbUpdate.append("set FLastAdjustDate=? ");
        if (updateAdjTimes) {
            sbUpdate.append(" , FAdjustRateTimes = FAdjustRateTimes + 1 ");
        }
        if (IntRateModifyType.LPR.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            sbUpdate.append(" , FISLPR = 1 ");
        } else if (IntRateModifyType.Agreement.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            sbUpdate.append(" , FISLPR = 0 ");
        }
        sbUpdate.append("where fid = ?");
        DbUtil.execute((Context)ctx, (String)sbUpdate.toString(), (Object[])new Object[]{rateAdjustBillInfo.getAdjustDate(), rateAdjustBillInfo.getLoan().getId().toString()});
    }

    private void appendScope(StringBuffer sbUpdate, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            sbUpdate.append("fid=? ");
            if (i == ids.length - 1) continue;
            sbUpdate.append(" or ");
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkSubmit(ctx, (CLRateAdjustmentBillInfo)model);
        boolean isAddNew = ((CLRateAdjustmentBillInfo)model).getId() == null;
        IObjectPK pk = super._submit(ctx, model);
        this.afterRateAdjustmentBillSubmited(ctx, (CLRateAdjustmentBillInfo)model, isAddNew);
        return pk;
    }

    private void checkSubmit(Context ctx, CLRateAdjustmentBillInfo info) throws BOSException, EASBizException {
        if (info.getLastAdjustDate() != null && info.getAdjustDate().compareTo(info.getLastAdjustDate()) < 0) {
            throw new ConsignmentLoanException(ConsignmentLoanException.ADJUST_DATE_EXC);
        }
        this.checkSameDay(ctx, info);
    }

    private void afterRateAdjustmentBillSubmited(Context ctx, CLRateAdjustmentBillInfo rateAdjustBillInfo, boolean updateAdjTimes) throws BOSException, EASBizException {
        this.updateLoanBill(ctx, rateAdjustBillInfo, updateAdjTimes);
        CLRateAdjustmentBillControllerBean.saveBOTPRelationShip(ctx, rateAdjustBillInfo);
    }

    private static void saveBOTPRelationShip(Context ctx, CLRateAdjustmentBillInfo rateAdjustBillInfo) throws BOSException, EASBizException {
        botpRelationShip.clear();
        botpRelationShip.put(rateAdjustBillInfo.getLoan().getId().toString(), rateAdjustBillInfo.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CLRateAdjustmentBillInfo rateAdjustBillInfo = this.getCLRateAdjustmentBillInfo(ctx, pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)rateAdjustBillInfo, (String)rateAdjustBillInfo.getCompany().getId().toString());
        this.afterRateAdjustBillDeleted(ctx, rateAdjustBillInfo);
    }

    private void afterRateAdjustBillDeleted(Context ctx, CLRateAdjustmentBillInfo rateAdjustBillInfo) throws BOSException, EASBizException {
        StringBuffer sbUpdate = new StringBuffer();
        if (IntRateModifyType.LPR.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            sbUpdate.append("update T_CL_ConsignmentLoanBill ");
            sbUpdate.append("set FAdjustRateTimes = FAdjustRateTimes - 1,FLastAdjustDate=?, FISLPR = 0 ");
            sbUpdate.append("where fid = ?");
        } else {
            sbUpdate.append("update T_CL_ConsignmentLoanBill ");
            sbUpdate.append("set FAdjustRateTimes = FAdjustRateTimes - 1,FLastAdjustDate=? ");
            sbUpdate.append("where fid = ?");
        }
        FMHelper.execute((Context)ctx, (String)sbUpdate.toString(), (Object[])new Object[]{rateAdjustBillInfo.getLastAdjustDate(), rateAdjustBillInfo.getLoan().getId().toString()});
    }
}

