/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConsignLoanIntBillControllerBeanHelper {
    private static Map botpRelationShip = new HashMap();

    public static void afterIntBillSaved(Context ctx, ConsignLoanIntBillInfo infoInt, IObjectPK pkReturn) throws BOSException {
        if (infoInt.getIntCalType().getValue() == 1 || infoInt.getIntCalType().getValue() == 0 || infoInt.getIntCalType().getValue() == 2) {
            // empty if block
        }
    }

    private static void afterPreIntSave(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkSavedIntBill) throws BOSException {
        ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pkSavedIntBill);
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastPreIntDate(ctx, loanInterestBillInfo);
    }

    private static void afterRecIntSave(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkSavedIntBill) throws BOSException {
        ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pkSavedIntBill);
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastSetteleDate(ctx, loanInterestBillInfo);
    }

    public static void afterIntBillSubmited(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkSubmitedIntBill) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getIntCalType().getValue() == 1) {
            ConsignLoanIntBillControllerBeanHelper.afterRecIntSubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 0) {
            ConsignLoanIntBillControllerBeanHelper.afterPreIntSubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 2) {
            ConsignLoanIntBillControllerBeanHelper.afterRepaySubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        }
    }

    private static void afterRepaySubmit(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkSubmitedIntBill) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getRepaymentBill() != null) {
            ConsignLoanIntBillControllerBeanHelper.saveRepaymentBill(ctx, loanInterestBillInfo);
            ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pkSubmitedIntBill);
            ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastSetteleDate(ctx, loanInterestBillInfo);
            ConsignLoanIntBillControllerBeanHelper.updateStrikeStatusAndAmt(ctx, loanInterestBillInfo);
            ConsignLoanIntBillControllerBeanHelper.updateAdjustRate(ctx, loanInterestBillInfo);
        } else {
            String sql = "update T_CL_ConsingnRepaymentBill set FAccrual=?,FpenaAccrual=?,fhandlingChargeAmt=?,FSaleTax=? where fid = ?";
            Object[] params = new Object[]{loanInterestBillInfo.getShijiIntAmt(), loanInterestBillInfo.getShijiPenaAmt(), loanInterestBillInfo.getHandleChargeAmt(), loanInterestBillInfo.getSalesTax(), loanInterestBillInfo.getRepayBill().getId().toString()};
            FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    public static void updateAdjustRate(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        HashSet<String> usedAdjuectID = new HashSet<String>();
        LoanInterestEntryCollection iCol = loanInterestBillInfo.getLoanInterestInfo().getEntries();
        for (int i = 0; i < iCol.size(); ++i) {
            LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
            if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
            ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestBillInfo);
            usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
        }
        ConsignLoanIntBillControllerBeanHelper.updateAdjustRateStatus(ctx, usedAdjuectID);
    }

    public static void updateAdjustRateStatus(Context ctx, Set usedAdjustID) throws BOSException {
        if (usedAdjustID != null && usedAdjustID.size() > 0) {
            String sql = "update t_cl_clrateadjustmentbill set fisused = 1 where " + ConsignLoanIntBillControllerBeanHelper.getFilterString(usedAdjustID);
            FMHelper.execute((Context)ctx, (String)sql, (Object[])usedAdjustID.toArray());
        }
    }

    public static void saveBOTPRelationShipLoanAdjust(Context ctx, String ajustId, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(ajustId, loanInterestBillInfo.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    private static String getFilterString(Set idSets) {
        StringBuffer sb = new StringBuffer();
        int size = idSets.size();
        for (int i = 0; i < size; ++i) {
            sb.append(" fid = ? ");
            if (i == size - 1) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    private static void updateIntBillLastIntDate(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, String type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (type.equals("Non_Pre_Int")) {
            sql.append("update T_CL_ConsignLoanIntBill set (FLastSettleDate,fcontrolunitid) = ");
            sql.append("( ");
            sql.append("select max(fbizDate),fcontrolunitid from T_CL_ConsignLoanIntBill ");
            sql.append("where FIntCalType <> ? and floanid = ? ");
            sql.append(") ");
        } else {
            sql.append("update T_CL_ConsignLoanIntBill set (FLastPreIntDate,fcontrolunitid) = ");
            sql.append("( ");
            sql.append("select max(fbizDate),fcontrolunitid from T_CL_ConsignLoanIntBill ");
            sql.append("where FIntCalType = ? and floanid = ? ");
            sql.append(") ");
        }
        sql.append("where fid = ? ");
        Object[] params = new Object[]{new Integer(0), loanInterestBillInfo.getLoan().getId().toString(), loanInterestBillInfo.getId().toString()};
    }

    private static void updateStrikeStatusAndAmt(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        if (ConsignLoanIntBillControllerBeanHelper.isRecInt(loanInterestBillInfo) || ConsignLoanIntBillControllerBeanHelper.isRepayIntAndRepayAll(loanInterestBillInfo)) {
            BigDecimal sumAmt = ConsignLoanIntBillControllerBeanHelper.getPreIntAmt(ctx, loanInterestBillInfo);
            String loanid = loanInterestBillInfo.getLoan().getId().toString();
            String loanIntBillID = loanInterestBillInfo.getId().toString();
            String sqlupdate1 = "update T_CL_ConsignLoanIntBill set FStrikeAmt = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sqlupdate1, (Object[])new Object[]{sumAmt, loanIntBillID});
            SQLUtil sql1 = new SQLUtil();
            sql1.appendSql("update T_CL_ConsignLoanIntBill set FIsStriked=?,FStrilkeBy=?  ");
            sql1.appendSql("where  FEndDate<=?  and fintCalType=0 and FIsStriked=0 and floanid = ?");
            sql1.addParams(new Object[]{ResourceFactory.VALUE_1, loanIntBillID, DateTimeUtils.truncateDate((java.util.Date)loanInterestBillInfo.getEndDate()), loanid});
            FMHelper.execute((Context)ctx, (String)sql1.getSql(), (Object[])sql1.getParamaters().toArray());
        }
    }

    private static BigDecimal getPreIntAmt(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        BigDecimal returnValue = Constants.ZERO;
        String loanid = loanInterestBillInfo.getLoan().getId().toString();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select sum(FShijiIntAmt+FShijiPenaAmt) from T_CL_ConsignLoanIntBill ");
        sql2.append(" where fintCalType=0 and FIsStriked =? and  ");
        sql2.append("FEndDate<=? and FLoanID = ?   ");
        Object[] params = new Object[]{ResourceFactory.VALUE_0, new Date(DateTimeUtils.truncateDate((java.util.Date)loanInterestBillInfo.getEndDate()).getTime()), loanid};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])params);
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    private static void updateLoanBillLastSetteleDate(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        if (ConsignLoanIntBillControllerBeanHelper.isRecInt(loanInterestBillInfo) || ConsignLoanIntBillControllerBeanHelper.isRepayIntAndRepayAll(loanInterestBillInfo)) {
            String sql = "update t_cl_consignmentloanbill set FLastSettleDate=? where fid=?";
            Date dataParam = new Date(DateTimeUtils.truncateDate((java.util.Date)loanInterestBillInfo.getEndDate()).getTime());
            ArrayList<Object> paramsList = new ArrayList<Object>();
            paramsList.add(dataParam);
            paramsList.add(loanInterestBillInfo.getLoan().getId().toString());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)loanInterestBillInfo.getLoan()) && !EmptyUtil.isEmpty((Object)loanInterestBillInfo.getLoan().getLastPreIntDate())) {
                sql = sql + " and  FLastSettleDate < ? ";
                paramsList.add(dataParam);
            }
            Object[] params = paramsList.toArray(new Object[paramsList.size()]);
            FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private static boolean isRecInt(ConsignLoanIntBillInfo loanInterestBillInfo) {
        return loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REC_INT;
    }

    private static boolean isRepayIntAndRepayAll(ConsignLoanIntBillInfo loanInterestBillInfo) {
        boolean isRepay = loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT;
        boolean isRepayAll = ConsignLoanIntBillControllerBeanHelper.isRepayAllThisTime(loanInterestBillInfo.getRepaymentBill());
        return isRepay && isRepayAll;
    }

    private static void updateLoanBillLastPreIntDate(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        String sql = "update t_cl_consignmentloanbill set FLastPreIntDate=? where fid=?";
        Date dataParam = new Date(DateTimeUtils.truncateDate((java.util.Date)loanInterestBillInfo.getEndDate()).getTime());
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(dataParam);
        paramsList.add(loanInterestBillInfo.getLoan().getId().toString());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)loanInterestBillInfo.getLoan()) && !EmptyUtil.isEmpty((Object)loanInterestBillInfo.getLoan().getLastPreIntDate())) {
            sql = sql + " and  FLastPreIntDate < ? ";
            paramsList.add(dataParam);
        }
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private static void saveRepaymentBill(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getRepaymentBill() != null) {
            ConsingnRepaymentBillInfo repayBill = loanInterestBillInfo.getRepaymentBill();
            repayBill.setAccrual(loanInterestBillInfo.getShijiIntAmt());
            repayBill.setPenaAccrual(loanInterestBillInfo.getShijiPenaAmt());
            repayBill.setHandlingChargeAmt(loanInterestBillInfo.getHandleChargeAmt());
            repayBill.setSaleTax(loanInterestBillInfo.getSalesTax());
            ConsingnRepaymentBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)repayBill);
        }
    }

    private static boolean isRepayAllThisTime(ConsingnRepaymentBillInfo repayBill) {
        return repayBill.getLoanBalance().compareTo(Constants.ZERO) == 0;
    }

    private static void afterPreIntSubmit(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pk) throws BOSException {
        ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pk);
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastPreIntDate(ctx, loanInterestBillInfo);
    }

    private static void afterRecIntSubmit(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pk) throws BOSException, EASBizException {
        ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pk);
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastSetteleDate(ctx, loanInterestBillInfo);
        String oprtState = (String)ctx.get((Object)"OPRTSTATE");
        if (FMHelper.isEmpty((String)oprtState) || !oprtState.equals("EDIT")) {
            ConsignLoanIntBillControllerBeanHelper.updateStrikeStatusAndAmt(ctx, loanInterestBillInfo);
        }
    }

    private static void saveBOTPRelationShip(Context ctx, ConsignLoanIntBillInfo infoInt, IObjectPK pkReturn) throws BOSException {
        botpRelationShip.clear();
        botpRelationShip.put(infoInt.getLoan().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        if (infoInt.getRepaymentBill() != null) {
            botpRelationShip.clear();
            botpRelationShip.put(infoInt.getRepaymentBill().getId().toString(), pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        }
    }

    public static void afterIntBillDeleted(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkDeletedIntBill) throws BOSException {
        if (loanInterestBillInfo.getIntCalType().getValue() == 1) {
            ConsignLoanIntBillControllerBeanHelper.afterRecIntDelete(ctx, loanInterestBillInfo, pkDeletedIntBill);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 0) {
            ConsignLoanIntBillControllerBeanHelper.afterPreIntDelete(ctx, loanInterestBillInfo);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 2) {
            ConsignLoanIntBillControllerBeanHelper.afterRepayDelete(ctx, loanInterestBillInfo, pkDeletedIntBill);
        }
        ConsignLoanIntBillControllerBeanHelper.updateAdjustRateStatusBeforeDelete(ctx, loanInterestBillInfo);
    }

    private static void updateAdjustRateStatusBeforeDelete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        HashSet<String> allUsedRate = new HashSet<String>();
        String sql1 = "select fsrcObjectID from  T_BOT_Relation where fDestObjectID != ? and  FdestentityID = '82C34957' and  FsrcentityID = '2D5093CD'";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{loanInterestBillInfo.getId().toString()});
        try {
            while (rs1.next()) {
                allUsedRate.add(rs1.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> notUsedRate = new HashSet<String>();
        String sql = "select fsrcObjectID from  T_BOT_Relation where fDestObjectID = ? and  FsrcentityID = '2D5093CD' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{loanInterestBillInfo.getId().toString()});
        try {
            while (rs.next()) {
                String sourceID = rs.getString(1);
                if (allUsedRate.contains(sourceID)) continue;
                notUsedRate.add(sourceID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (notUsedRate != null && notUsedRate.size() > 0) {
            String sqlUpdate = "update t_cl_clrateadjustmentbill set fisused = 0 where " + ConsignLoanIntBillControllerBeanHelper.getFilterString(notUsedRate);
            FMHelper.execute((Context)ctx, (String)sqlUpdate, (Object[])notUsedRate.toArray());
        }
    }

    private static void afterRepayDelete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkDeletedIntBill) throws BOSException {
        ConsingnRepaymentBillInfo repayBill;
        if (loanInterestBillInfo.getRepayBill() != null && (repayBill = loanInterestBillInfo.getRepayBill()).getLoanBalance().compareTo(Constants.ZERO) == 0) {
            ConsignLoanIntBillControllerBeanHelper.updateStrikeStatus(ctx, loanInterestBillInfo);
            ConsignLoanIntBillControllerBeanHelper.updateLoanBillLasSettleDate_Delete(ctx, loanInterestBillInfo);
        }
    }

    private static void afterPreIntDelete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLastPreIntDate_Delete(ctx, loanInterestBillInfo);
    }

    private static void updateLoanBillLastPreIntDate_Delete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        String sql = "update t_cl_consignmentloanbill set FLastPreIntDate=? where fid=?";
        java.util.Date lastPreIntDate = loanInterestBillInfo.getLastPreIntDate();
        lastPreIntDate = lastPreIntDate == null ? null : DateTimeUtils.truncateDate((java.util.Date)lastPreIntDate);
        Date daparam = null;
        if (lastPreIntDate != null) {
            daparam = new Date(lastPreIntDate.getTime());
        }
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{daparam, loanInterestBillInfo.getLoan().getId().toString()});
    }

    private static void afterRecIntDelete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo, IObjectPK pkDeletedIntBill) throws BOSException {
        ConsignLoanIntBillControllerBeanHelper.updateStrikeStatus(ctx, loanInterestBillInfo);
        ConsignLoanIntBillControllerBeanHelper.updateLoanBillLasSettleDate_Delete(ctx, loanInterestBillInfo);
    }

    private static void updateStrikeStatus(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        String sql = "update T_CL_ConsignLoanIntBill set FIsStriked=? where FStrilkeBy=? ";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{ResourceFactory.VALUE_0, loanInterestBillInfo.getId().toString()});
    }

    private static void updateLoanBillLasSettleDate_Delete(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException {
        String sql = "update t_cl_consignmentloanbill set FLastSettleDate=? where fid=?";
        java.util.Date lastSettleDate = loanInterestBillInfo.getLastSettleDate();
        lastSettleDate = lastSettleDate == null ? null : DateTimeUtils.truncateDate((java.util.Date)lastSettleDate);
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{lastSettleDate, loanInterestBillInfo.getLoan().getId().toString()});
    }
}

