/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignContactFactory;
import com.kingdee.eas.fm.cl.ConsignContactInfo;
import com.kingdee.eas.fm.cl.ConsignLoanRepayingPlanInfo;
import com.kingdee.eas.fm.cl.ConsignLoanUsingPlanInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillCollection;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.cl.ConsingnmentNoticeFactory;
import com.kingdee.eas.fm.cl.ConsingnmentNoticeInfo;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.ReturnWayEnum;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.app.AbstractConsignmentLoanBillControllerBean;
import com.kingdee.eas.fm.cl.app.ConsignmentLoanBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConsignmentLoanBillControllerBean
extends AbstractConsignmentLoanBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.ConsignmentLoanBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((ConsignmentLoanBillInfo)model).getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((ConsignmentLoanBillInfo)model));
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        ConsignmentLoanBillInfo sumbittedInfo = this.getConsignmentLoanBillInfo(ctx, "select * where id='" + pkReturn.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pkReturn, (IFMBgUsed)sumbittedInfo);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pkReturn, null);
        this.updateLoanApplyBill(ctx, (ConsignmentLoanBillInfo)model);
        return pkReturn;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ConsignmentLoanBillInfo oldInfo;
        ConsignmentLoanBillInfo info = (ConsignmentLoanBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((ConsignmentLoanBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getConsignmentLoanBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        super._update(ctx, pk, model);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)info);
    }

    private void updateLoanApplyBill(Context ctx, ConsignmentLoanBillInfo info) throws EASBizException, BOSException {
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterGenLoanOrgBill((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("consignContact.*"));
        ConsignmentLoanBillInfo info = this.getConsignmentLoanBillInfo(ctx, pk, sic);
        if (info.getConsignContact() != null) {
            int seq = info.getConsignContact().getContactSeq();
            if (info.getContactSeq() != seq) {
                FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"3_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)info.getId().toString()));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        if (coll != null && coll.size() > 0) {
            FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"4_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (info.getContactSeq() != 1) {
            String sql1 = " update T_CL_ConsignContact set FAddAmount = FAddAmount-?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{info.getLoanAmt(), info.getConsignContact().getId().toString()});
            String sql2 = " update T_CL_ConsignContact set FRemainAmount = FRemainAmount+?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{info.getLoanAmt(), info.getConsignContact().getId().toString()});
            String sql3 = " update T_CL_ConsignContact set FContactSeq = FContactSeq-1  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{info.getConsignContact().getId().toString()});
        } else {
            ConsignContactFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getConsignContact().getId()));
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterLoanOrgBillDeleted((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            ConsignmentLoanBillInfo info = (ConsignmentLoanBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        } else if (bosType.equals((Object)new LoanInfo().getBOSType())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("isCreateToLoan"));
                ConsignmentLoanBillInfo info = (ConsignmentLoanBillInfo)srcBillVO;
                info.setIsCreateToLoan(false);
                ConsignmentLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("isCreateToLoan"));
                ConsignmentLoanBillInfo info = (ConsignmentLoanBillInfo)srcBillVO;
                info.setIsCreateToLoan(true);
                ConsignmentLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            }
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        } else if (new ConsingnmentNoticeInfo().getBOSType().equals((Object)bosType)) {
            SelectorItemCollection getSic = new SelectorItemCollection();
            getSic.add("*");
            SelectorItemCollection updateSic = new SelectorItemCollection();
            updateSic.add("allLoanMoney");
            ConsignmentLoanBillInfo consignInfo = (ConsignmentLoanBillInfo)this.getValue(ctx, srcBillPK, getSic);
            String noticeID = relation.getDestObjectID();
            ConsingnmentNoticeInfo noticeInfo = ConsingnmentNoticeFactory.getLocalInstance(ctx).getConsingnmentNoticeInfo((IObjectPK)new ObjectUuidPK(noticeID));
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                BigDecimal allLoanMoney = consignInfo.getAllLoanMoney();
                BigDecimal thisLoanMoney = noticeInfo.getConsignAmt();
                BigDecimal allMoney = consignInfo.getLoanAmt();
                if ((allLoanMoney = allLoanMoney.add(thisLoanMoney)).compareTo(allMoney) > 0) {
                    BigDecimal over = allLoanMoney.subtract(allMoney);
                    Map map = FMHelper.getNantionalDateMap((Context)ctx);
                    DecimalFormat df = (DecimalFormat)map.get("numberFormat");
                    df.applyPattern(FMHelper.toPattern((int)2));
                    throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"5_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()) + df.format(over) + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"6_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale())));
                }
                StringBuffer sql = new StringBuffer();
                sql.append("update T_CL_ConsignmentLoanBill set FallLoanMoney = ? ");
                sql.append(" where FID = '").append(consignInfo.getId().toString()).append("' ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{allLoanMoney});
            }
        }
    }

    @Override
    protected void _overDue(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        this.overDueCheck(ctx, loanIDSet);
        this.doOverDue(ctx, loanIDSet);
    }

    private void doOverDue(Context ctx, Set loanIDSet) throws BOSException {
        String sql = "update T_CL_ConsignmentLoanBill set FIsOverdue = 1 where ";
        sql = sql + " fid in " + this.getValues(loanIDSet.toArray(new String[loanIDSet.size()]));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    private void overDueCheck(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIDSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        ConsignmentLoanBillCollection col = this.getConsignmentLoanBillCollection(ctx, evi);
        int size = col.size();
        ConsignmentLoanBillInfo tmp = null;
        StringBuffer sbMsg = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            tmp = col.get(i);
            if (tmp.getLoanBalance().compareTo(Constants.ZERO) > 0) continue;
            sbMsg.append(tmp.getNumber());
        }
        if (sbMsg.length() > 0) {
            sbMsg = sbMsg.deleteCharAt(sbMsg.length() - 1);
            throw new ConsignmentLoanException(ConsignmentLoanException.OVERDUE_ERROR, new Object[]{sbMsg.toString()});
        }
    }

    @Override
    protected void _cancelOverdue(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        String sql = "update T_CL_ConsignmentLoanBill set FIsOverdue = 0 where ";
        sql = sql + " fid in " + this.getValues(loanIDSet.toArray(new String[loanIDSet.size()]));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.updateConsignContact(ctx, (ConsignmentLoanBillInfo)model, pk);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        IObjectPK pk = super._submit(ctx, model);
        this.updateConsignContact(ctx, (ConsignmentLoanBillInfo)model, pk);
        return pk;
    }

    private void setDefaultValue(Context ctx, ConsignmentLoanBillInfo loanBaseBillInfo) throws BOSException, EASBizException {
        loanBaseBillInfo.setAdjustRateTimes(0);
        loanBaseBillInfo.setExtTimes(0);
        loanBaseBillInfo.setRepayTimes(0);
        Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
        loanBaseBillInfo.setEffectiveDate(NOW);
        loanBaseBillInfo.setMaturityDate(NOW);
        loanBaseBillInfo.setBizDate(NOW);
        loanBaseBillInfo.setIsHistoryBill(false);
        loanBaseBillInfo.setYearDays(360);
        loanBaseBillInfo.setIsHistoryBill(false);
        loanBaseBillInfo.setRepayTotalAmt(Constants.ZERO);
        loanBaseBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        loanBaseBillInfo.setFloatingPoint(Constants.ZERO);
        loanBaseBillInfo.setLoanAmt(Constants.ZERO);
        loanBaseBillInfo.setLoanBalanceAmt(Constants.ZERO);
        loanBaseBillInfo.setPenaRate(Constants.ZERO);
        loanBaseBillInfo.setIntFreeAmt(Constants.ZERO);
        loanBaseBillInfo.setRate(Constants.ZERO);
        loanBaseBillInfo.setSalesTaxDeductRate(Constants.ZERO);
        loanBaseBillInfo.setGuaranteeAmt(Constants.ZERO);
        loanBaseBillInfo.setHandlingChargeRate(Constants.ZERO);
        loanBaseBillInfo.setHandlingChargeAmt(Constants.ZERO);
        loanBaseBillInfo.setIntRateExpression(IntRateTypeExpressionEnum.YEAR);
        loanBaseBillInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        loanBaseBillInfo.setLoanAmtLocal(Constants.ZERO);
        loanBaseBillInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        IntRateTypeInfo rateType = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(ResourceFactory.getConsultativeRate()));
        loanBaseBillInfo.setRateType(rateType);
        loanBaseBillInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.INTERIOR);
        loanBaseBillInfo.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        loanBaseBillInfo.setConsignCompany(currentCompany);
        loanBaseBillInfo.setLastSettleDate(DateUtil.getBeforeDay((Date)NOW));
        loanBaseBillInfo.setCompany(currentCompany);
        loanBaseBillInfo.setRepayTimes(0);
        loanBaseBillInfo.setAdjustRateTimes(0);
        loanBaseBillInfo.getRepayEntries().clear();
        loanBaseBillInfo.getRepayEntries().add(this.createDefaultRepayPlan(NOW));
        loanBaseBillInfo.getConsignContact().getUsingEntries().clear();
        loanBaseBillInfo.getConsignContact().getUsingEntries().add(this.createDefaultUsingPlan(NOW));
        loanBaseBillInfo.setIsHistoryBill(false);
        loanBaseBillInfo.setIsOverDue(false);
    }

    private ConsignLoanRepayingPlanInfo createDefaultRepayPlan(Date nowDate) {
        ConsignLoanRepayingPlanInfo clrp = new ConsignLoanRepayingPlanInfo();
        clrp.setSeq(1);
        clrp.setRepayingDate(nowDate);
        clrp.setRepayingAmt(Constants.ZERO);
        return clrp;
    }

    private ConsignLoanUsingPlanInfo createDefaultUsingPlan(Date nowDate) {
        ConsignLoanUsingPlanInfo clrp = new ConsignLoanUsingPlanInfo();
        clrp.setSeq(1);
        clrp.setUsingDate(nowDate);
        clrp.setUsingAmt(Constants.ZERO);
        return clrp;
    }

    @Override
    protected void _anitAudit4WF(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            this.doAntiAudit(ctx, info);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)info.getId().toString()));
            view.setFilter(filter);
            JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
            if (coll != null && coll.size() > 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"7_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (StateEnum.EAA.equals((Object)info.getState())) {
                this.doAntiAudit(ctx, info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            if (StateEnum.SUBMISSION.equals((Object)info.getState())) {
                this.doAudit(ctx, info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            this.doAudit(ctx, info);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void doAudit(Context ctx, ConsignmentLoanBillInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CL_ConsignmentLoanBill set FState = ");
        sql.append(2);
        sql.append(" , FAUDITORID = '");
        sql.append(((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
        sql.append("' where FID = '");
        sql.append(info.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"8_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"9_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAntiAudit(Context ctx, ConsignmentLoanBillInfo info) throws BOSException {
        Set destSet = null;
        try {
            destSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        }
        catch (BTPException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (destSet != null && destSet.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"10_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CL_ConsignmentLoanBill set FState = ");
        sql.append(0);
        sql.append(" , FAUDITORID ='' where FID = '");
        sql.append(info.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"8_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"11_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected void _dispose(Context ctx, IObjectPK pk, BigDecimal consiAmt, BigDecimal loanAmt) throws BOSException {
        try {
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            String billId = info.getId().toString();
            boolean isBook = NTBookHelper.checkIsBook((Context)ctx, (Date)new Date());
            if (isBook) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"0_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            BigDecimal tmp = info.getAllLoanMoney().add(consiAmt);
            info.setAllLoanMoney(tmp);
            info.setDisposeAmount(consiAmt);
            info.setLoanDisposeAmount(loanAmt);
            ConsignmentLoanBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
            NTBookHelper.bookMoreSubsidiary((Context)ctx, (String)billId, (String)ConsignmentLoanBillSubsidiaryBookProvider.class.getName());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unDispose(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ObjectUuidPK[] pks;
            ISubsidiaryLedger iSub;
            ConsignmentLoanBillInfo info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo(pk);
            String billId = info.getId().toString();
            SubsidiaryLedgerCollection subsidiaryLedgerCollection = NTBookHelper.getLastSubsidiaryLedgerInfo((Context)ctx, (String)billId);
            if (subsidiaryLedgerCollection.size() > 0) {
                BigDecimal tmp = info.getAllLoanMoney().subtract(this.getCreditAmount(subsidiaryLedgerCollection));
                info.setAllLoanMoney(tmp);
                info.setDisposeAmount(new BigDecimal(0));
                info.setLoanDisposeAmount(new BigDecimal(0));
                ConsignmentLoanBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
                iSub = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
                pks = new ObjectUuidPK[subsidiaryLedgerCollection.size()];
                for (int i = 0; i < subsidiaryLedgerCollection.size(); ++i) {
                    pks[i] = new ObjectUuidPK(subsidiaryLedgerCollection.get(i).getId().toString());
                }
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"1_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            iSub.delete((IObjectPK[])pks);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal getCreditAmount(SubsidiaryLedgerCollection subColl) {
        BigDecimal allAmt = new BigDecimal(0);
        if (subColl != null && subColl.size() > 0) {
            for (int i = 0; i < subColl.size(); ++i) {
                allAmt = allAmt.add(subColl.get(i).getCreditAmount());
            }
        }
        return allAmt;
    }

    protected void updateConsignContact(Context ctx, ConsignmentLoanBillInfo info, IObjectPK pk) throws BOSException, EASBizException {
        ConsignContactInfo contactInfo = info.getConsignContact();
        if (contactInfo.getUsingEntries().size() == 0) {
            return;
        }
        if (contactInfo == null) {
            // empty if block
        }
        if (!info.isIsMulCon()) {
            if (contactInfo.getId() != null) {
                ConsignContactFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(contactInfo.getId()));
            }
            contactInfo.setContactNo(info.getContactNo());
            IObjectPK conPk = ConsignContactFactory.getLocalInstance(ctx).submit((CoreBaseInfo)contactInfo);
            String sql = " update T_CL_ConsignmentLoanBill set FConsignContactID = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
        } else if (info.getContactSeq() == 1) {
            if (contactInfo.getId() != null) {
                ConsignContactFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(contactInfo.getId()));
            }
            IObjectPK conPk = ConsignContactFactory.getLocalInstance(ctx).submit((CoreBaseInfo)contactInfo);
            String sql = " update T_CL_ConsignmentLoanBill set FConsignContactID = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
        } else {
            String sql1 = " update T_CL_ConsignContact set FAddAmount = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{contactInfo.getAddAmount(), info.getConsignContact().getId().toString()});
            String sql2 = " update T_CL_ConsignContact set FRemainAmount = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{contactInfo.getRemainAmount(), info.getConsignContact().getId().toString()});
            String sql3 = " update T_CL_ConsignContact set FContactSeq = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{new Integer(contactInfo.getContactSeq()), info.getConsignContact().getId().toString()});
        }
    }

    protected ConsignmentLoanBillInfo _getFirstConsignInMul(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fid from T_CL_ConsignmentLoanBill where FConsignContactID = ? and fisMulCon = ? and fcontactSeq = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), new Integer(1), new Integer(1)});
        String conId = "";
        try {
            if (rs.next()) {
                conId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ConsignmentLoanBillInfo info = null;
        if (!FMHelper.isEmpty((String)conId)) {
            info = this.getConsignmentLoanBillInfo(ctx, (IObjectPK)new ObjectStringPK(conId), this.getSelectorsForConsignContact());
        }
        return info;
    }

    protected SelectorItemCollection getSelectorsForConsignContact() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("depositary.id"));
        sic.add(new SelectorItemInfo("depositary.name"));
        sic.add(new SelectorItemInfo("depositary.number"));
        sic.add(new SelectorItemInfo("depositary.relatedCompany.id"));
        sic.add(new SelectorItemInfo("depositary.relatedCompany.name"));
        sic.add(new SelectorItemInfo("relationWithCmp"));
        sic.add(new SelectorItemInfo("consignCompany.id"));
        sic.add(new SelectorItemInfo("consignCompany.name"));
        sic.add(new SelectorItemInfo("consignCompany.number"));
        sic.add(new SelectorItemInfo("loanCompany.id"));
        sic.add(new SelectorItemInfo("loanCompany.name"));
        sic.add(new SelectorItemInfo("loanCompany.number"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("settleAcctView.id"));
        sic.add(new SelectorItemInfo("settleAcctView.name"));
        sic.add(new SelectorItemInfo("settleAcctView.number"));
        sic.add(new SelectorItemInfo("loanAcctView.id"));
        sic.add(new SelectorItemInfo("loanAcctView.name"));
        sic.add(new SelectorItemInfo("loanAcctView.number"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("finacingProduct.id"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("finacingProduct.number"));
        sic.add(new SelectorItemInfo("guaranteeType.id"));
        sic.add(new SelectorItemInfo("guaranteeType.name"));
        sic.add(new SelectorItemInfo("guaranteeType.number"));
        sic.add(new SelectorItemInfo("repayEntries.seq"));
        sic.add(new SelectorItemInfo("repayEntries.repayingDate"));
        sic.add(new SelectorItemInfo("repayEntries.repayingAmt"));
        sic.add(new SelectorItemInfo("rateType.id"));
        sic.add(new SelectorItemInfo("rateType.number"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("floatingPoint"));
        sic.add(new SelectorItemInfo("payIntType.*"));
        sic.add(new SelectorItemInfo("depositaryBank.id"));
        sic.add(new SelectorItemInfo("depositaryBank.number"));
        sic.add(new SelectorItemInfo("depositaryBank.name"));
        sic.add(new SelectorItemInfo("loanCompanyBank.id"));
        sic.add(new SelectorItemInfo("loanCompanyBank.number"));
        sic.add(new SelectorItemInfo("loanCompanyBank.name"));
        return sic;
    }
}

