/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillCollection;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.ConsingnmentNoticeInfo;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.app.AbstractConsingnRepaymentBillControllerBean;
import com.kingdee.eas.fm.cl.app.ConsingnRepaymentBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.cl.modelutils.AppUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConsingnRepaymentBillControllerBean
extends AbstractConsingnRepaymentBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.ConsingnRepaymentBillControllerBean");

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsingnRepaymentBillInfo oldInfo;
        ConsingnRepaymentBillInfo repayInfo = (ConsingnRepaymentBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((ConsingnRepaymentBillInfo)model));
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        if (null != repayInfo.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(repayInfo.getId())) && (oldInfo = this.getConsingnRepaymentBillInfo(ctx, "select * where id='" + repayInfo.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        repayInfo.setState(StateEnum.SUBMISSION);
        repayInfo.setLoanBaseBill(repayInfo.getLoan());
        repayInfo.setLastRepayDate(repayInfo.getLoan().getLastRepayDate());
        IObjectPK pk = super._submit(ctx, (IObjectValue)repayInfo);
        ConsingnRepaymentBillInfo sumbittedInfo = this.getConsingnRepaymentBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        this.reverseLoanRepay(ctx, sumbittedInfo.getSourceBillId(), "1");
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConsingnRepaymentBillInfo repayInfo = this.getConsingnRepaymentBillInfo(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)repayInfo.getId().toString()));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        if (coll != null && coll.size() > 0) {
            FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"4_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
        }
        repayInfo.setLoanBaseBill(repayInfo.getLoan());
        this.deleteRelatedIntBill(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        super._delete(ctx, pk);
        this.reverseLoanRepay(ctx, repayInfo.getSourceBillId(), "0");
        AppUtils.afterRepaymentBillDeleted(ctx, repayInfo);
    }

    private void deleteRelatedIntBill(Context ctx, IObjectPK repayBillPk) throws EASBizException, BOSException {
        ConsignLoanIntBillFactory.getLocalInstance(ctx).deleteRaleted(repayBillPk);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ex) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            ConsingnRepaymentBillInfo info = (ConsingnRepaymentBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        } else if (new ConsingnmentNoticeInfo().getBOSType().equals((Object)bosType)) {
            ConsingnRepaymentBillInfo info = (ConsingnRepaymentBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setIsGenerated(false);
            } else {
                info.setIsGenerated(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private ConsignLoanIntBillInfo findConsignLoanIntBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayBill.id", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        ConsignLoanIntBillCollection intCol = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dAPTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
            ConsignLoanIntBillInfo intRe = this.findConsignLoanIntBillInfo(ctx, (IObjectPK)srcBillPK);
            if (intRe == null || intRe.isFivouchered()) continue;
            try {
                ConsignLoanIntBillFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
                continue;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw new FMException(FMException.EASBIZADDBOT, new Object[]{e.getMessage()});
            }
        }
        return dAPTransformResult;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo intRe = this.findConsignLoanIntBillInfo(ctx, sourceBillPk);
        if (intRe != null && intRe.isFivouchered()) {
            ConsignLoanIntBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    @Override
    protected void _updateColumn(Context ctx, String billId, String columnName, String value) throws BOSException {
        if (billId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_CL_ConsingnRepaymentBill set ");
            sql.append(columnName).append(" = '");
            sql.append(value).append("' ");
            sql.append(" where FID = '").append(billId).append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _dispose(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsingnRepaymentBillInfo info = ConsingnRepaymentBillFactory.getLocalInstance(ctx).getConsingnRepaymentBillInfo(pk);
            String billId = info.getId().toString();
            if (NTBookHelper.checkIsBook((Context)ctx, (java.util.Date)new java.util.Date())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"0_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            info.setIsDispose(true);
            ConsingnRepaymentBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
            NTBookHelper.bookSubsidiary((Context)ctx, (String)billId, (String)ConsingnRepaymentBillSubsidiaryBookProvider.class.getName());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unDispose(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsingnRepaymentBillInfo info = ConsingnRepaymentBillFactory.getLocalInstance(ctx).getConsingnRepaymentBillInfo(pk);
            String billId = info.getId().toString();
            SubsidiaryLedgerCollection bookColl = NTBookHelper.getLastSubsidiaryLedgerInfo((Context)ctx, (String)billId);
            if (bookColl.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"1_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            info.setIsDispose(false);
            ConsingnRepaymentBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
            NTBookHelper.antiBookSubsidiary((Context)ctx, (String)billId);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void reverseLoanRepay(Context ctx, String LoanRepayID, String isCreate) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)LoanRepayID)) {
            String sql = "Update T_FIN_LoanRepaymentApply set FIsCreateRepayBill =? where Fid=?";
            FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, LoanRepayID});
        }
    }

    @Override
    protected void _updateRecBill(Context ctx, IObjectPK fundTransRecID, IObjectPK recBillID) throws BOSException {
        if (recBillID != null) {
            String sql = "update T_CL_ConsingnRepaymentBill set FRecBillID = ?,FIsGenRecBill=1 where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recBillID.toString(), fundTransRecID.toString()});
        } else {
            String sql = "update T_CL_ConsingnRepaymentBill set FRecBillID = null,FIsGenRecBill=0 where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fundTransRecID.toString()});
        }
    }

    @Override
    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
        String id2 = null;
        for (String id2 : ids) {
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), true);
    }

    @Override
    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        try {
            String id2 = null;
            String sql = null;
            for (String id2 : ids) {
                sql = "select 1 from t_bot_relation where fsrcobjectid = '" + id2 + "' and FDestEntityID <> '82C34957'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    throw new FMException(FMException.HASDESTBILLNOTUNAUDIT);
                }
                super.unAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), false);
    }

    protected void updateState(Context ctx, String id, boolean isAudit) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CL_ConsingnRepaymentBill set fstate = ?, fauditorID = ?, fauditTime = ? where fid = ? and fstate = ?");
        if (isAudit) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{2, userInfo.getId().toString(), new Date(this.getCurrentDate().getTime()), id, 1});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, null, null, id, 2});
        }
    }
}

