/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.cl.app.AbstractRepayBaseBillControllerBean;
import com.kingdee.eas.fm.cl.modelutils.AppUtils;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class RepayBaseBillControllerBean
extends AbstractRepayBaseBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.RepayBaseBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepayBaseBillInfo repayInfo = (RepayBaseBillInfo)model;
        IObjectPK pk = super._submit(ctx, (IObjectValue)repayInfo);
        boolean isModifyOper = false;
        if (model instanceof ConsingnRepaymentBillInfo) {
            isModifyOper = ((ConsingnRepaymentBillInfo)model).getIsModifyOper();
        } else if (model instanceof FundTransferRepayBillInfo) {
            isModifyOper = ((FundTransferRepayBillInfo)model).getIsModifyOper();
        }
        if (!isModifyOper) {
            AppUtils.afterRepaymentBillSubmited(ctx, repayInfo);
        } else if (repayInfo.getRepayDate().after(repayInfo.getLastRepayDate())) {
            AppUtils.reverseLoanBillLastRepayDate(ctx, repayInfo);
        }
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            RepayBaseBillInfo info = (RepayBaseBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
    }

    @Override
    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    protected Date getCurrentDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

