/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanStatisticalUnitEnum;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.app.RptConsignmentLoanFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Locale;

public class RptConsignmentLoanHelper {
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo baseCurrency;
    private String queryType;
    private Date startDate;
    private Date endDate;
    private ConsignmentLoanStatisticalUnitEnum amountUnit;
    private String loc;
    private String commonFilerToTimeDeposit;
    private String[] currencyIDs;
    private String[] loanCompanyIDs;
    private String[] customerIDs;
    private RelationshipWithLoanCompanyEnum relations;
    String unit = "1";
    private String groupByColum = "";
    private String configFile;

    public static RptConsignmentLoanHelper getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        return new RptConsignmentLoanHelper(params, ctx);
    }

    public RptConsignmentLoanHelper(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("query_type");
        this.startDate = (Date)params.getObject("startDate");
        this.endDate = (Date)params.getObject("endDate");
        this.amountUnit = (ConsignmentLoanStatisticalUnitEnum)((Object)params.getObject("amount_amt"));
        this.currencyIDs = (String[])params.getObject("currencyIDs");
        this.loanCompanyIDs = (String[])params.getObject("chLoanCompany");
        this.customerIDs = (String[])params.getObject("Customer");
        this.loc = this.getLoc(ctx);
        this.relations = (RelationshipWithLoanCompanyEnum)((Object)params.getObject("relations"));
        this.prepare(this.amountUnit.getValue());
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public void prepare(String amountUnit) throws BOSException, EASBizException {
        this.commonFilerToTimeDeposit = this.getCommonFilterToConsignmentLoan();
        if (amountUnit.equals("thousand")) {
            this.unit = "1000";
        } else if (amountUnit.equals("ten_thousand")) {
            this.unit = "10000";
        } else if (amountUnit.equals("million")) {
            this.unit = "1000000";
        } else if (amountUnit.equals("hundred_thousand")) {
            this.unit = "10000000";
        } else if (amountUnit.equals("hundred_million")) {
            this.unit = "100000000";
        }
    }

    private String getCommonFilterToConsignmentLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( FEffectedStatus = 2 and fcompanyid = '").append(this.currentCompany.getId().toString()).append("' ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and FLoanCompanyID in ").append(this.getValues(this.loanCompanyIDs));
        }
        if (this.customerIDs != null && this.customerIDs.length > 0) {
            sb.append(" and FCustomerID in ").append(this.getValues(this.customerIDs));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    public void setSchemaSource(Context ctx, SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSQLPrepared(), this.getSqlParams());
        ss.setDataItem("Horizon", this.getHorizonDataSQL(ctx), null);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        StringBuffer mdx = null;
        if (this.queryType.equals("by_company")) {
            sql.append("select com.FId as fid,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com where fisleaf = 1\n");
            ss.setDataItem("LoanCompany", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_LoanCompany.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"28_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"29_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"30_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"31_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_loanProduct")) {
            sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_FIN_FinancingProducts as cur\n");
            ss.setDataItem("FinancingProduct", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_FinancingProduct.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"32_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"33_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"34_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"35_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_currency")) {
            sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_Currency.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"36_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"37_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"34_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select  [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"38_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_customer")) {
            sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Customer as cur\n");
            ss.setDataItem("Customer", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_Customer.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"39_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"40_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"30_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"41_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_deposity")) {
            sql.append("select com.FId as fid,com.FName_").append(this.loc).append(" as FName from t_bd_bank as com where fisleaf = 1\n");
            ss.setDataItem("Depositary", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_Depositary.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"42_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"26_RptCLSchemaSourceMaker_ByDepositary", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"34_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"43_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_consignCompany")) {
            sql.append("select com.FId as fid,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com where fisleaf = 1\n");
            ss.setDataItem("ConsignCompany", sql.toString(), null);
            this.configFile = "RptConsignmentLoanSum_ConsignCompany.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"44_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"25_RptCLSchemaSourceMaker_ByConsignCompany", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"30_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"45_RptConsignmentLoanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        }
        ss.setCaller(RptConsignmentLoanFacadeControllerBean.class);
        ss.setFilename(this.configFile);
        if (mdx != null) {
            ss.setMdx(mdx.toString());
        }
    }

    private String getHorizonDataSQL(Context ctx) {
        String sql = ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"46_RptConsignmentLoanHelper", (Locale)ctx.getLocale()) + " union all " + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"47_RptConsignmentLoanHelper", (Locale)ctx.getLocale());
        return sql;
    }

    private String getSumSQLPrepared() {
        if (this.queryType.equals("by_company")) {
            this.groupByColum = " FLoanCompanyID ";
        } else if (this.queryType.equals("by_loanProduct")) {
            this.groupByColum = " FFinacingProductID ";
        } else if (this.queryType.equals("by_currency")) {
            this.groupByColum = " FCurrencyID ";
        } else if (this.queryType.equals("by_customer")) {
            this.groupByColum = " FCustomerID ";
        } else if (this.queryType.equals("by_consignCompany")) {
            this.groupByColum = " FConsignCompanyID ";
        } else if (this.queryType.equals("by_deposity")) {
            this.groupByColum = " FDepositaryID ";
        }
        this.groupByColum = this.groupByColum + ",fhorizonid ";
        StringBuffer sbSQL = new StringBuffer(1024);
        sbSQL.append(" select sum(QICHUYUE_LOCAL)/").append(this.unit).append(" as FQICHUYUE_LOCAL,                                                       \n");
        sbSQL.append("        sum(BENQIZENJIA_LOCAL)/").append(this.unit).append(" as FBENQIZENJIA_LOCAL,                                                 \n");
        sbSQL.append("        sum(BENQIHUANKUAN_LOCAL)/").append(this.unit).append(" as FBENQIHUANKUAN_LOCAL,                                             \n");
        sbSQL.append("        sum(QIMOYUE_LOCAL)/").append(this.unit).append(" as FQIMOYUE_LOCAL,fhorizonid,                                              \n");
        sbSQL.append("        sum(QIMOYUE_LOCAL+BENQIZENJIA_LOCAL+BENQIHUANKUAN_LOCAL+QIMOYUE_LOCAL) as sum,                  \n");
        if (this.queryType.equals("by_company")) {
            sbSQL.append(" FLoanCompanyID ");
        } else if (this.queryType.equals("by_loanProduct")) {
            sbSQL.append(" FFinacingProductID ");
        } else if (this.queryType.equals("by_currency")) {
            sbSQL.append(" FCurrencyID ");
        } else if (this.queryType.equals("by_customer")) {
            sbSQL.append(" FCustomerID ");
        } else if (this.queryType.equals("by_consignCompany")) {
            sbSQL.append(" FConsignCompanyID ");
        } else if (this.queryType.equals("by_deposity")) {
            sbSQL.append(" FDepositaryID ");
        }
        sbSQL.append(" from                                                                                                   \n");
        sbSQL.append(" \t(                                                                                                     \n");
        sbSQL.append(" \t\tselect qichuyue as QICHUYUE,qichuyue * FExchangeRate  as QICHUYUE_LOCAL,                            \n");
        sbSQL.append(" \t\t  \t\t benqiguihuan as BENQIHUANKUAN,benqiguihuan*FExchangeRate as BENQIHUANKUAN_LOCAL,             \n");
        sbSQL.append(" \t\t\t  \t benqizengjia as BENQIZENJIA, benqizengjia * FExchangeRate  as BENQIZENJIA_LOCAL,             \n");
        sbSQL.append(" \t\t\t  \t qimoyue as QIMOYUE, qimoyue * FExchangeRate as QIMOYUE_LOCAL,                                \n");
        if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
            sbSQL.append(" FLoanCompanyID, ");
        } else {
            sbSQL.append(" FCustomerID, ");
        }
        sbSQL.append("            FConsignCompanyID,                                                                         \n");
        sbSQL.append("            FDepositaryID,                                                                         \n");
        sbSQL.append("            FFinacingProductID,                                                                         \n");
        sbSQL.append("            FCurrencyID,fhorizonid                                                                      \n");
        sbSQL.append("     from                                                                                               \n");
        sbSQL.append("     (                                                                                                  \n");
        if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
            sbSQL.append(" select FLoanCompanyID, ");
        } else {
            sbSQL.append(" select FCustomerID, ");
        }
        sbSQL.append("            FConsignCompanyID,                                                                         \n");
        sbSQL.append("            FDepositaryID,                                                                         \n");
        sbSQL.append("              ( case when fhorizon <= 12 or fhorizon is null                                            \n");
        sbSQL.append("            \t\t\t\tthen 'shorthorizon'                                                                 \n");
        sbSQL.append(" \t\t\t\t\t\t      else 'longhorizon'                                                                    \n");
        sbSQL.append(" \t\t\t\t\t \t\t\t  end                                                                                   \n");
        sbSQL.append(" \t           ) as fhorizonid,                                                                           \n");
        sbSQL.append("              FFinacingProductID,                                                                       \n");
        sbSQL.append("              FCurrencyID,                                                                              \n");
        sbSQL.append("              fid,                                                                                      \n");
        sbSQL.append("              qichuyue,                                                                                 \n");
        sbSQL.append("              benqizengjia,                                                                             \n");
        sbSQL.append("              benqiguihuan,                                                                             \n");
        sbSQL.append("              FExchangeRate,                                                                            \n");
        sbSQL.append("              (qichuyue + benqizengjia - benqiguihuan) as qimoyue                                       \n");
        sbSQL.append("       from                                                                                             \n");
        sbSQL.append("       (                                                                                                \n");
        sbSQL.append("       \t                                                                                                \n");
        sbSQL.append("       \t                                                                                                \n");
        sbSQL.append("       \t                                                                                                \n");
        sbSQL.append("       \tselect fhorizon,                                                                 \n");
        if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
            sbSQL.append("FLoanCompanyID, ");
        } else {
            sbSQL.append("FCustomerID, ");
        }
        sbSQL.append("                FConsignCompanyID,                                                                     \n");
        sbSQL.append("                FDepositaryID,                                                                            \n");
        sbSQL.append("                FFinacingProductID,                                                                     \n");
        sbSQL.append("                FCurrencyID,                                                                            \n");
        sbSQL.append("                fid,                                                                                    \n");
        sbSQL.append("                FExchangeRate,                                                                          \n");
        sbSQL.append("                (                                                                                       \n");
        sbSQL.append("                \t(                                                                                     \n");
        sbSQL.append("                \t\tselect isnull(sum((                                                                 \n");
        sbSQL.append("                \t\t\tcase FIsHistoryBill\twhen 1                                                        \n");
        sbSQL.append("                \t\t\tthen FInitBalance                                                                 \n");
        sbSQL.append("  \t\t\t\t\t\t\t\t\t\telse FLoanAmt                                                                     \n");
        sbSQL.append("  \t\t\t\t\t\t\t\t\t\tend)),0) from T_CL_ConsignmentLoanBill where FEffectiveDate <  ?  and fid = a.fid \n");
        sbSQL.append("  \t\t\t\t\t\t\t\t) -                                                                                   \n");
        sbSQL.append("  \t\t\t\t\t\t\t\t\t(                                                                                   \n");
        sbSQL.append("  \t\t\t\t\t\t\t\t\t\tselect isnull(sum(FRepayAmt), 0) from T_CL_ConsingnRepaymentBill                  \n");
        sbSQL.append("                                   where FRepayDate <  ? and FLoanID = a.fid                            \n");
        sbSQL.append("                   )                                                                                    \n");
        sbSQL.append("                ) as qichuyue,                                                                          \n");
        sbSQL.append("                                                                                                        \n");
        sbSQL.append("                (                                                                                       \n");
        sbSQL.append("                \tselect isnull(sum((                                                                   \n");
        sbSQL.append("                \t\t\tcase FIsHistoryBill when 1                                                        \n");
        sbSQL.append("                \t\t\tthen FInitBalance                                                                 \n");
        sbSQL.append("                \t\t\telse FLoanAmt                                                                     \n");
        sbSQL.append("                \t\t\tend)), 0) from T_CL_ConsignmentLoanBill where  FEffectiveDate <=  ?               \n");
        sbSQL.append("                \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand FEffectiveDate >=  ?  and fid = a.fid     \n");
        sbSQL.append("                ) as benqizengjia,                                                                      \n");
        sbSQL.append("                                                                                                        \n");
        sbSQL.append("                (                                                                                       \n");
        sbSQL.append("                \tselect isnull(sum(FRepayAmt), 0) from T_CL_ConsingnRepaymentBill                      \n");
        sbSQL.append("                \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t where FRepayDate >=  ?                               \n");
        sbSQL.append("                \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t and  FRepayDate <= ?                                 \n");
        sbSQL.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t                 and FLoanID = a.fid                                  \n");
        sbSQL.append("                ) as benqiguihuan                                                                       \n");
        sbSQL.append("        from T_CL_ConsignmentLoanBill a                                                                 \n");
        sbSQL.append("        where                                                                                           \n");
        sbSQL.append(this.getCommonFilterToConsignmentLoanPrepared());
        sbSQL.append("        ) aa                                                                                            \n");
        sbSQL.append("     ) bb                                                                                               \n");
        sbSQL.append("  ) cc                                                                                                  \n");
        sbSQL.append("  group by  ").append(this.groupByColum).append(" \n");
        sbSQL.append("  having  sum(QICHUYUE_LOCAL)+sum(BENQIZENJIA_LOCAL)+sum(BENQIHUANKUAN_LOCAL)+sum(QIMOYUE_LOCAL)>0      \n");
        return sbSQL.toString();
    }

    private SqlParams getSqlParams() {
        SqlParams sp = new SqlParams();
        Object[] allparams = this.getParams();
        for (int i = 0; i < allparams.length; ++i) {
            sp.addObject(allparams[i]);
        }
        return sp;
    }

    private Object[] getParams() {
        int i;
        Object[] fixParam = new Object[]{this.startDate, this.startDate, this.endDate, this.startDate, this.startDate, this.endDate, this.currentCompany.getId().toString()};
        Object[] currencyParam = null;
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            currencyParam = new Object[this.getPlaceholderCount(this.currencyIDs.length)];
            this.setCurrencyParam(currencyParam);
        }
        Object[] loanCompanyIDParam = null;
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            for (int i2 = 0; i2 < this.loanCompanyIDs.length; ++i2) {
                loanCompanyIDParam = new Object[this.getPlaceholderCount(this.loanCompanyIDs.length)];
                this.setLoanCompanyParam(loanCompanyIDParam);
            }
        }
        int currencyParamCount = currencyParam == null ? 0 : currencyParam.length;
        int loanCompanyIDParamCount = loanCompanyIDParam == null ? 0 : loanCompanyIDParam.length;
        Object[] allParam = new Object[fixParam.length + currencyParamCount + loanCompanyIDParamCount];
        int currentPos = 0;
        for (i = 0; i < fixParam.length; ++i) {
            allParam[i] = fixParam[i];
        }
        currentPos = fixParam.length;
        if (currencyParamCount > 0) {
            for (i = 0; i < currencyParam.length; ++i) {
                allParam[currentPos + i] = currencyParam[i];
            }
        }
        currentPos += currencyParamCount;
        if (loanCompanyIDParamCount > 0) {
            for (i = 0; i < loanCompanyIDParam.length; ++i) {
                allParam[currentPos + i] = loanCompanyIDParam[i];
            }
        }
        return allParam;
    }

    private void setLoanCompanyParam(Object[] loanCompanyIDParam) {
        int loanCompanyIDChoosedCount = this.loanCompanyIDs.length;
        for (int i = 0; i < this.loanCompanyIDs.length; ++i) {
            loanCompanyIDParam[i] = this.loanCompanyIDs[i].toString();
        }
        for (int j = 0; j < loanCompanyIDParam.length - loanCompanyIDChoosedCount; ++j) {
            loanCompanyIDParam[j + loanCompanyIDChoosedCount] = "";
        }
    }

    private void setCurrencyParam(Object[] currencyParam) {
        int currencyIDChoosedCount = this.currencyIDs.length;
        for (int i = 0; i < currencyIDChoosedCount; ++i) {
            currencyParam[i] = this.currencyIDs[i].toString();
        }
        for (int j = 0; j < 10 - currencyIDChoosedCount; ++j) {
            currencyParam[j + currencyIDChoosedCount] = "";
        }
    }

    private String getCommonFilterToConsignmentLoanPrepared() {
        StringBuffer sb = new StringBuffer();
        sb.append("( FEffectedStatus = 2 and fcompanyid = ? ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and ").append(this.getCurrencyPrepared());
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and ").append(this.getLoanCompanyPrepared(this.loanCompanyIDs));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getLoanCompanyPrepared(String[] loanCompanyIDs) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(loanCompanyIDs.length);
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" FLoanCompanyID = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private String getCurrencyPrepared() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            sb.append(" fcurrencyid = ? ");
            if (i == 9) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private int getPlaceholderCount(int i) {
        if (i <= 20) {
            return 20;
        }
        if (i > 20 && i <= 40) {
            return 40;
        }
        if (i > 40 && i <= 60) {
            return 60;
        }
        if (i > 60 && i <= 80) {
            return 80;
        }
        return i;
    }
}

