/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.modelutils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JTextField;

public class ClientUtils {
    public static void initControlsBeforeOnLoad(KDComboBox comboCurrency, KDComboBox comboFinacingProduct, KDBizPromptBox prmtRateType) throws Exception {
        if (comboFinacingProduct != null) {
            ClientUtils.initFinacingProduct(comboFinacingProduct);
        }
        if (comboCurrency != null) {
            ClientUtils.initComboCurrency(comboCurrency);
        }
        if (prmtRateType != null) {
            ClientUtils.initRateType(prmtRateType);
        }
    }

    private static void initRateType(KDBizPromptBox prmtRateType) throws Exception {
        prmtRateType.setValue((Object)IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(ResourceFactory.getConsultativeRate())));
    }

    private static void initComboCurrency(KDComboBox comboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)comboCurrency, (boolean)false);
    }

    private static void initFinacingProduct(KDComboBox comboFinacingProduct) throws Exception {
    }

    private static EntityViewInfo getEntityView() {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(1), CompareType.EQUALS));
        env.setFilter(filter);
        return env;
    }

    public static BigDecimal calLoanAmtLocal(KDFormattedTextField txtLoanAmt, KDFormattedTextField txtExchangeRate) {
        return FMHelper.multiply((BigDecimal)txtLoanAmt.getBigDecimalValue(), (BigDecimal)txtExchangeRate.getBigDecimalValue());
    }

    public static void calYearDays(IntRateTypeExpressionEnum intRateTypeExpressionEnum, IntRateTypeInfo rateType, KDFormattedTextField txtYearDays, KDLabelContainer contyearRate) {
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            if (txtYearDays != null) {
                txtYearDays.setValue((Object)new Integer(360));
            }
            if (rateType != null) {
                if (ClientUtils.isConsultativeRate(rateType)) {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("rate_per"));
                } else {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("cankao_rate_per"));
                }
            }
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            if (txtYearDays != null) {
                txtYearDays.setValue((Object)new Integer(30));
            }
            if (rateType != null) {
                if (ClientUtils.isConsultativeRate(rateType)) {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("rate_ten_per"));
                } else {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("cankao_rate_thousand"));
                }
            }
        } else {
            if (txtYearDays != null) {
                txtYearDays.setValue((Object)new Integer(1));
            }
            if (rateType != null) {
                if (ClientUtils.isConsultativeRate(rateType)) {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("rate_ten_per"));
                } else {
                    contyearRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("cankao_rate_thousand"));
                }
            }
        }
    }

    public static boolean isConsultativeRate(IntRateTypeInfo rateType) {
        return rateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || rateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    public static void setPenaRateText(PenAccrualTypeEnum penAccrualType, KDLabelContainer contPenaRate) {
        if (penAccrualType == PenAccrualTypeEnum.ADD_ACCRUAL) {
            contPenaRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("dailyrate"));
        } else if (penAccrualType == PenAccrualTypeEnum.ADD_PERCENT) {
            contPenaRate.setBoundLabelText(ResourceFactory.getModelResourceMsg("penerate_text"));
        }
    }

    public static void calcRate(KDFormattedTextField txtExchangeRate, CurrencyInfo currencyInfo, String destCurrId, CompanyOrgUnitInfo company, Date date) throws Exception {
        if (currencyInfo == null || date == null) {
            return;
        }
        txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, null, (Date)date));
    }

    public static BigDecimal calcYearRate(IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, Date date) throws Exception {
        if (intType == null || floating == null || currency == null || date == null) {
            return Constants.ZERO;
        }
        BigDecimal yearRate = ClientUtils.getYearRateFromRateTable(date, currency.getId().toString(), intType.getId().toString());
        floating = floating.divide(Constants.ONE_HUNDRED, 6, 4);
        BigDecimal tmp = FMHelper.add((BigDecimal)Constants.ONE, (BigDecimal)floating);
        return FMHelper.multiply((BigDecimal)yearRate, (BigDecimal)tmp);
    }

    private static BigDecimal getYearRateFromRateTable(Date endDate, String currencyID, String typeID) throws BOSException, SQLException {
        BigDecimal yearRate = Constants.ZERO;
        String dateStr = FMConstants.FORMAT_TIME.format(endDate);
        StringBuffer sql = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sql.append("select top 1 a.fid, a.fyearRate, a.ftypeid, b.ffactor ");
        sql.append("from t_int_IntRateBase as a left outer join t_int_intRateType as b on a.fTypeId = b.fid ");
        sql.append("where a.feffectiveDate <= {" + dateStr + "} and a.fcurrencyid = '" + currencyID + "' and a.ftypeid = '" + typeID + "' and a.fbillState = '" + billState + "' and FIntTermID  is null ");
        sql.append("order by a.feffectiveDate desc");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rs.next()) {
            yearRate = rs.getBigDecimal(2);
        }
        return yearRate;
    }

    public static void initControlsAfterOnLoad(boolean enabled, KDFormattedTextField txtLoanBalanceAmt) {
        txtLoanBalanceAmt.setEnabled(enabled);
    }

    public static void setTableCellEditorByDate(KDTable tblMain, String property) {
        KDDatePicker dpDate = new KDDatePicker();
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        String dtformat = CtrlFormatUtilities.getDateFormatString();
        tblMain.getColumn(property).getStyleAttributes().setNumberFormat(dtformat);
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setMinimumValue((Comparable)Constants.ZERO);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static String trimZero(String str, String simbol) {
        String tmp;
        int i;
        if (str.indexOf(".") == -1) {
            return str.substring(0, str.indexOf(simbol)) + ".00" + simbol;
        }
        for (i = str.length() - 1; i >= 0; --i) {
            tmp = "";
            tmp = str.substring(i - 1, i);
            if (!tmp.equals("0") && !tmp.equals(" ")) break;
        }
        str = str.substring(0, i) + simbol;
        for (i = 0; i < str.length() - 1; ++i) {
            tmp = "";
            tmp = str.substring(i, i + 1);
            if (!tmp.equals("0")) break;
        }
        if ((str = str.substring(i)).equals("." + simbol)) {
            str = "0.00" + simbol;
        }
        if (str.startsWith(".")) {
            str = "0" + str;
        }
        if (str.endsWith("." + simbol)) {
            str = str.substring(0, str.indexOf(simbol));
            str = str + "00" + simbol;
        }
        return str;
    }

    public static boolean isConsultativeRate(String rateTypeID) {
        return rateTypeID.equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || rateTypeID.equals("QYYAAAAKQTYkfZJ0");
    }

    public static BigDecimal calcYearRateWithID(String intTypeID, BigDecimal floating, String currencyID, Date date) throws Exception {
        if (intTypeID == null || floating == null || currencyID == null || date == null) {
            return Constants.ZERO;
        }
        BigDecimal yearRate = ClientUtils.getYearRateFromRateTable(date, currencyID, intTypeID);
        floating = floating.divide(Constants.ONE_HUNDRED, 6, 4);
        BigDecimal tmp = FMHelper.add((BigDecimal)Constants.ONE, (BigDecimal)floating);
        return FMHelper.multiply((BigDecimal)yearRate, (BigDecimal)tmp);
    }
}

