/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.JournalBalanceUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountBankChangeFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBankChangeFacadeControllerBean
extends AbstractAccountBankChangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AccountBankChangeFacadeControllerBean");

    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        this.createSchemaSource_ByType(ss, params, ctx);
        return ss;
    }

    private Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private void createSchemaSource_ByType(SchemaSource ss, RptParams params, Context ctx) throws BOSException {
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        Date fromDate = (Date)params.getObject("fromDate");
        Date toDate = (Date)params.getObject("toDate");
        Date firstDay = this.getFirstDayOfMonth(fromDate);
        Date lastDay = DateUtil.getLastDayOfMonth((Date)toDate);
        Boolean isIncludeUsed = (Boolean)params.getObject("isIncludeUsed");
        String hzResoure = ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"3_AccountBankChangeFacadeControllerBean", (Locale)ctx.getLocale());
        Timestamp dtFirst = new Timestamp(firstDay.getTime());
        Timestamp dtLast = new Timestamp(lastDay.getTime());
        String loc = AccountBankChangeFacadeControllerBean.getLoc((Context)ctx);
        String configFile = "RptAccountBankChange_ByType.xml";
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        SqlParams spCompany = new SqlParams();
        sql.append("select A.FID,A.FName_").append(loc).append(" FName, A.FParentID from t_org_company A where 1=1 ");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
        ss.setDataItem("Company", sql.toString(), spCompany);
        boolean isByType = (Boolean)params.getObject("isByType");
        if (isByType) {
            sql.setLength(0);
            sql.append("select A.FID,A.FName_").append(loc).append(" FName,A.FNumber FNumber from T_BD_AccountProperty A ");
            ss.setDataItem("RegionType", sql.toString(), null);
        } else {
            sql.setLength(0);
            sql.append("Select 1 as FID,N'" + hzResoure + "' as fname,1 as FNumber ");
            ss.setDataItem("RegionType", sql.toString(), null);
        }
        String tempTable = AccountBankChangeFacadeControllerBean.getTempTableName((String)ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"2_AccountBankChangeFacadeControllerBean", (Locale)ctx.getLocale()), (Context)ctx);
        StringBuffer baseSql = this.getBaseSql(tempTable, isByType, isIncludeUsed);
        SqlParams baseSp = this.getSqlParam(dtFirst, dtLast);
        JournalBalanceUtil.appendFilter((String)"bb.FCompanyID", (Set)companyIdSet, (StringBuffer)baseSql, (SqlParams)baseSp, (String)"and");
        AccountBankChangeFacadeControllerBean.executeSelectInto((String)baseSql.toString(), (SqlParams)baseSp, (Context)ctx);
        baseSql.setLength(0);
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams factsp = new SqlParams();
        factSql.append("Select SUM(FMonthStart) FMonthStartSum,SUM(FMonthOpen) FMonthOpenSum,SUM(FMonthClose) FMonthCloseSum,SUM(FMonthModify) FMonthModifySum,SUM(FMonthStart) + SUM(FMonthOpen) - SUM(FMonthClose) FMonthEndSum,FCompanyID,PropertyID from ").append(tempTable);
        factGroup.append("\n group by FCompanyID,PropertyID ");
        factSql.append(factGroup);
        ss.setDataItem("Fact", factSql.toString(), factsp);
        if (isByType) {
            mdx.append(" with member [Company].[" + hzResoure + "] as 'sum([Company].levels(0).members)' ");
            mdx.append(" member [RegionType].[" + hzResoure + "] as 'sum([RegionType].members)' ");
            mdx.append("select {[RegionType].[" + hzResoure + "],[RegionType].members}*[Measures].members on columns, ");
            mdx.append(" non empty {[Company].members,[Company].[" + hzResoure + "]} on rows from fm");
        } else {
            mdx.append(" with member [Company].[" + hzResoure + "] as 'sum([Company].levels(0).members)' ");
            mdx.append("select {[RegionType].members*[Measures].members} on columns, ");
            mdx.append(" non empty {[Company].members,[Company].[" + hzResoure + "]} on rows from fm");
        }
        ss.setCaller(AccountBankChangeFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
    }

    private StringBuffer getBaseSql(String tempTable, boolean isByType, boolean isIncludeUsed) {
        StringBuffer baseSql = new StringBuffer();
        baseSql.append("SELECT * ").append("into ").append(tempTable).append("\n FROM (");
        if (isByType) {
            baseSql.append("SELECT A.FCompanyID AS FCompanyID,A.FID AS id,A.FPropertyId as PropertyID,");
        } else {
            baseSql.append("SELECT A.FCompanyID AS FCompanyID,A.FID AS id,case when P.FProperty <> 0 then 1 end PropertyID,");
        }
        baseSql.append("case when (A.FOpenDate < ? and A.FIsClosed<>1) or (A.FOpenDate < ? and A.FCloseDate >= ?)  then 1 else 0 end FMonthStart,").append("case when A.FOpenDate >= ? and A.FOpenDate <= ? then 1 else 0 end FMonthOpen,").append("case when A.FCloseDate >= ? and A.FCloseDate <= ? then 1 else 0 end FMonthClose,0 AS FMonthModify,").append("case when A.FOpenDate  <= ? and A.FIsClosed<>1 then 1 else 0 end FMonthEnd ").append(" FROM T_BD_AccountBanks AS A LEFT OUTER JOIN T_BD_AccountProperty AS P ON A.FPropertyId = P.FID where 1=1 ");
        if (!isIncludeUsed) {
            baseSql.append(" and A.FshareType <> 2 ");
        }
        baseSql.append(" union all ");
        if (isByType) {
            baseSql.append("SELECT M.FCompanyID AS FCompanyID ,M.FID AS id,AA.PropertyID AS PropertyID,");
        } else {
            baseSql.append("SELECT M.FCompanyID AS FCompanyID ,M.FID AS id,case when AA.Property <> 0 then 1 end PropertyID,");
        }
        baseSql.append("0 AS FMonthStart,0 AS FMonthOpen,0 AS FMonthClose,1 AS FMonthModify,0 AS FMonthEnd ");
        baseSql.append(" FROM T_BD_AcctModifyApply AS M LEFT OUTER JOIN (");
        baseSql.append("select A.FID AS ID,A.FPropertyId as PropertyID,P.FProperty AS Property from t_bd_accountbanks as A ");
        baseSql.append(" LEFT OUTER JOIN T_BD_AccountProperty AS P ON A.FPropertyId = P.FID where 1=1 ");
        if (!isIncludeUsed) {
            baseSql.append(" and A.FshareType <> 2 ");
        }
        baseSql.append(") AS AA ON M.FAccountBankID = AA.ID WHERE 1=1 ");
        baseSql.append(" and M.FID in (select MAX(FID) FROM T_BD_AcctModifyApply M where 1=1 and M.FConfirmDate is not null and M.FConfirmDate>=? and M.FConfirmDate<=? GROUP BY FAccountBankID)");
        baseSql.append(" ) bb where 1=1 ");
        return baseSql;
    }

    private SqlParams getSqlParam(Timestamp dtFirst, Timestamp dtLast) {
        SqlParams baseSp = new SqlParams();
        baseSp.addTimestamp(dtFirst).addTimestamp(dtFirst).addTimestamp(dtFirst).addTimestamp(dtFirst).addTimestamp(dtLast).addTimestamp(dtFirst).addTimestamp(dtLast).addTimestamp(dtLast).addTimestamp(dtFirst).addTimestamp(dtLast);
        return baseSp;
    }
}

