/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyEntryCollection;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyEntryInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyFactory;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyBillStateEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ModifyFieldEnum;
import com.kingdee.eas.basedata.assistant.app.AbstractAcctModifyApplyControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class AcctModifyApplyControllerBean
extends AbstractAcctModifyApplyControllerBean {
    private static final long serialVersionUID = 6056953190669830262L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AcctModifyApplyControllerBean");

    @Override
    protected boolean _audit(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null) {
            logger.error((Object)"AcctModifyApplyControllerBean/billID is null");
            return false;
        }
        this.audit4WF(ctx, billID);
        return true;
    }

    @Override
    protected boolean _antiAudit(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null) {
            logger.error((Object)"AcctModifyApplyControllerBean/billID is null");
            return false;
        }
        AcctModifyApplyInfo info = new AcctModifyApplyInfo();
        info.setId(BOSUuid.read((String)billID));
        info.setBillState(AcctModifyBillStateEnum.SAVED);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billState"));
        this.antiAudit4WF(ctx, billID);
        return true;
    }

    @Override
    protected void _audit4WF(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            AcctModifyApplyInfo info = new AcctModifyApplyInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(AcctModifyBillStateEnum.AUDITED);
            info.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("auditor"));
            AcctModifyApplyFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        }
        catch (EASBizException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            AcctModifyApplyInfo info = new AcctModifyApplyInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(AcctModifyBillStateEnum.SAVED);
            info.setAuditor(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("auditor"));
            AcctModifyApplyFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        }
        catch (EASBizException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _confirm(Context ctx, String billID) throws BOSException, EASBizException {
        AcctModifyApplyInfo amaTmp = this.getAcctModifyApplyInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        AccountBankInfo acctTmp = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(amaTmp.getAccountBank().getId()), this.getEntryBankAcntSelector());
        AcctModifyApplyEntryCollection entries = amaTmp.getEntrys();
        SelectorItemCollection acctSic = new SelectorItemCollection();
        if (entries != null && entries.size() != 0) {
            for (int i = 0; i < entries.size(); ++i) {
                AcctModifyApplyEntryInfo entry = entries.get(i);
                if (ModifyFieldEnum.BANK_ACCT_NUM.equals((Object)entry.getModifyField())) {
                    acctTmp.setBankAccountNumber(entry.getPostValue());
                    acctTmp.setOldBankAccountNumber(entry.getPreValue());
                } else if (ModifyFieldEnum.BANK.equals((Object)entry.getModifyField())) {
                    BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(entry.getPostValueId()));
                    acctTmp.setBank(bankInfo);
                } else if (ModifyFieldEnum.NAME.equals((Object)entry.getModifyField())) {
                    acctTmp.setName(entry.getPostValue().toString());
                } else if (ModifyFieldEnum.IS_BY_CUR.equals((Object)entry.getModifyField())) {
                    acctTmp.setIsByCurrency(Boolean.valueOf(entry.getPostValue()).booleanValue());
                    if (!Boolean.valueOf(entry.getPostValue()).booleanValue()) {
                        acctTmp.setCurrency(null);
                    }
                } else if (ModifyFieldEnum.IS_SET_BANK_INT.equals((Object)entry.getModifyField())) {
                    if (entry.getPostValue() != null) {
                        acctTmp.setIsSetBankInterface(Boolean.valueOf(entry.getPostValue()).booleanValue());
                        if (!Boolean.valueOf(entry.getPostValue()).booleanValue()) {
                            acctTmp.setAcctName(null);
                            acctTmp.setCountry(null);
                            acctTmp.setOpenArea(null);
                            acctTmp.setMaxPayAmount(null);
                            acctTmp.setIsOnlyRead(false);
                            acctTmp.setBankInterfaceType(null);
                            acctTmp.setBankInterFaceID(null);
                            acctTmp.setBankInterFace(null);
                            acctSic.add(new SelectorItemInfo("isOnlyRead"));
                            acctSic.add(new SelectorItemInfo("acctName"));
                            acctSic.add(new SelectorItemInfo("country"));
                            acctSic.add(new SelectorItemInfo("openArea"));
                            acctSic.add(new SelectorItemInfo("maxPayAmount"));
                            acctSic.add(new SelectorItemInfo("bankInterfaceType"));
                        }
                    }
                } else if (ModifyFieldEnum.IS_ONLY_READ.equals((Object)entry.getModifyField())) {
                    if (entry.getPostValue() != null) {
                        acctTmp.setIsOnlyRead(Boolean.valueOf(entry.getPostValue()).booleanValue());
                    }
                } else if (ModifyFieldEnum.ACCT_NAME.equals((Object)entry.getModifyField())) {
                    acctTmp.setAcctName(entry.getPostValue());
                } else if (ModifyFieldEnum.COUNTRY.equals((Object)entry.getModifyField())) {
                    CountryInfo countryInfo = CountryFactory.getLocalInstance((Context)ctx).getCountryInfo((IObjectPK)new ObjectUuidPK(entry.getPostValueId()));
                    acctTmp.setCountry(countryInfo);
                } else if (ModifyFieldEnum.OPEN_AREA.equals((Object)entry.getModifyField())) {
                    OpenAreaInfo openAreaInfo = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaInfo((IObjectPK)new ObjectUuidPK(entry.getPostValueId()));
                    acctTmp.setOpenArea(openAreaInfo);
                } else if (ModifyFieldEnum.MAX_PAY_AMT.equals((Object)entry.getModifyField())) {
                    if (entry.getPostValue() != null) {
                        acctTmp.setMaxPayAmount(new BigDecimal(entry.getPostValue()));
                    }
                } else if (ModifyFieldEnum.BANK_INT_TYPE.equals((Object)entry.getModifyField())) {
                    acctTmp.setBankInterfaceType(BankInterfaceTypeEnum.getEnum((String)entry.getPostValue()));
                    acctTmp.setBankInterFace(entry.getPostValue());
                    acctTmp.setBankInterFaceID(entry.getPostValueId());
                    acctSic.add(new SelectorItemInfo("bankInterFace"));
                    acctSic.add(new SelectorItemInfo("bankInterFaceID"));
                }
                acctSic.add(new SelectorItemInfo(entry.getModifyField().getValue()));
            }
        }
        AccountBankFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)acctTmp);
        AcctModifyApplyInfo info = new AcctModifyApplyInfo();
        info.setId(BOSUuid.read((String)billID));
        info.setBillState(AcctModifyBillStateEnum.CONFIRMED);
        info.setConfirmDate(DateUtil.getDayBegin());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("confirmDate"));
        AcctModifyApplyFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    private SelectorItemCollection getEntryBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("property.*"));
        sic.add(new SelectorItemInfo("country.*"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("subAccount.*"));
        return sic;
    }

    @Override
    protected void _canceled(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            AcctModifyApplyInfo info = new AcctModifyApplyInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(AcctModifyBillStateEnum.CANCELED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            AcctModifyApplyFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        }
        catch (EASBizException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            logger.error((Object)("AcctModifyApplyControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
    }
}

