/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AssItemsForCashCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.IEJBAccess;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotpFormulaUtil {
    private static Map hm = new HashMap();
    private static final String PaymentBill_BOSTYPE = "40284E81";
    private static final String ReceivingBill_BOSTYPE = "FA44FD5B";
    private static final String GeneralAsstActType_BOSTYPE = "F90B0133";
    private static final BOSObjectType PaymentBillBOSTYPE = new BOSObjectType("40284E81");
    private static final BOSObjectType ReceivingBillBOSTYPE = new BOSObjectType("FA44FD5B");
    private static final BOSObjectType GeneralAsstActTypeBOSTYPE = new BOSObjectType("F90B0133");
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.fm.common.BotpFormulaUtil");

    public static CoreBaseInfo getObjectByBosTypeAndNumber(Context ctx, BOSObjectType bosType, String billNumber) throws EASBizException, BOSException {
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("number", billNumber));
    }

    public static Object getObjectByBosTypeAndLongNumber(Context ctx, BOSObjectType bosType, String billLongNumber, String typeNumber) throws EASBizException, BOSException {
        String billLongNumberReal = billLongNumber.replace('.', '!');
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("longNumber", (Object)billLongNumberReal));
        f.getFilterItems().add(new FilterItemInfo("group.number", (Object)typeNumber));
        evi.setFilter(f);
        CoreBaseCollection cols = BotpFormulaUtil.getBizInterface(ctx, bosType).getCollection(evi);
        if (cols == null || cols.size() == 0) {
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"160_FMIsqlUIHandler"), billLongNumber);
            throw new BOSException(msgStr);
        }
        return cols.get(0);
    }

    public static CoreBaseInfo getObjectByBosTypeAndName(Context ctx, BOSObjectType bosType, String billName) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("name", (Object)billName));
        if (SysContext.getSysContext().getCurrentUserInfo() != null && SysContext.getSysContext().getCurrentUserInfo().getId() != null && !"00000000-0000-0000-0000-00000000000013B7DE7F".equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString())) {
            f.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getCU().getId()));
        }
        evi.setFilter(f);
        CoreBaseCollection cols = BotpFormulaUtil.getBizInterface(ctx, bosType).getCollection(evi);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)cols)) {
            if (GeneralAsstActTypeBOSTYPE.equals((Object)bosType)) {
                GeneralAsstActTypeCollection actTypeCollection = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(evi);
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                for (int i = 0; i < actTypeCollection.size(); ++i) {
                    if (!actTypeCollection.get(i).getCreatorCompany().getId().toString().equals(companyInfo.getId().toString())) continue;
                    return actTypeCollection.get(i);
                }
            }
            return cols.get(0);
        }
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("name", billName));
    }

    public static String getIDByBosTypeAndName(Context ctx, BOSObjectType bosType, String billName) throws EASBizException, BOSException {
        CoreBaseInfo info = BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("name", billName));
        return info.getId().toString();
    }

    public static CoreBaseInfo getObjectByBosTypeAndID(Context ctx, BOSObjectType bosType, String id) throws EASBizException, BOSException {
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("id", id));
    }

    public static CoreBaseInfo getAssActInfo(Context ctx, String billID, String number) {
        BOSObjectType bosType = BOSUuid.read((String)billID).getType();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("fromID");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billID));
        f.getFilterItems().add(new FilterItemInfo("asstActType.number", (Object)("" + number)));
        f.getFilterItems().add(new FilterItemInfo("isSelected", (Object)Boolean.TRUE));
        evi.setFilter(f);
        evi.setSelector(sic);
        String assTypeID = null;
        try {
            AssItemsForCashCollection assItemsForCash = null;
            if (PaymentBillBOSTYPE.equals((Object)bosType)) {
                assItemsForCash = AssItemsForCashPayFactory.getLocalInstance((Context)ctx).getAssItemsForCashCollection(evi);
            } else if (ReceivingBillBOSTYPE.equals((Object)bosType)) {
                assItemsForCash = AssItemsForCashRecFactory.getLocalInstance((Context)ctx).getAssItemsForCashCollection(evi);
            }
            if (assItemsForCash != null && assItemsForCash.size() > 0) {
                assTypeID = assItemsForCash.get(0).getFromID();
            }
            if (assTypeID != null) {
                BOSObjectType assType = BOSUuid.read(assTypeID).getType();
                return BotpFormulaUtil.getObjectByBosTypeAndID(ctx, assType, assTypeID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static ICoreBase getBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        ICoreBase icb = null;
        icb = BotpFormulaUtil.getStub(ctx).getEntityBizInterface(bosType);
        return icb;
    }

    private static String getOQL(String fieldName, String billNumber) {
        return "select * where " + fieldName + " = '" + billNumber + "'";
    }

    private static IEJBAccess getStub(Context ctx) throws BOSException {
        IEJBAccess stub = null;
        stub = ctx == null ? EJBAccessFactory.createRemoteInstance() : EJBAccessFactory.createLocalInstance(ctx);
        return stub;
    }

    public static Object getAsstActTypeByAsstActName(Context ctx, BOSObjectType bosType, String asstActName) throws BOSException, EASBizException {
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance(ctx).getEntityInfo(bosType);
        String tableName = eoi.getTable().getName();
        String oql = "select * where realtionDataObject = '" + tableName + "'";
        return AsstActTypeFactory.getLocalInstance((Context)ctx).getValue(oql);
    }

    public static CoreBaseInfo getAssActInfo(Context ctx, String billID, String entryID, String asstActTypeNumber) {
        BOSObjectType bosType = BOSUuid.read((String)billID).getType();
        String assTypeID = null;
        try {
            if (PaymentBillBOSTYPE.equals((Object)bosType)) {
                assTypeID = BotpFormulaUtil.getAsstActTypeID4Pay(ctx, billID, entryID, asstActTypeNumber);
            } else if (ReceivingBillBOSTYPE.equals((Object)bosType)) {
                assTypeID = BotpFormulaUtil.getAsstActTypeID4Rec(ctx, billID, entryID, asstActTypeNumber);
            }
            if (assTypeID != null && assTypeID.trim().length() > 0) {
                BOSObjectType assType = BOSUuid.read((String)assTypeID).getType();
                return BotpFormulaUtil.getObjectByBosTypeAndID(ctx, assType, assTypeID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static String getAsstActTypeID4Pay(Context ctx, String billID, String entryID, String asstActNumber) throws Exception {
        String asstActTypeID = "";
        StringBuffer sb = new StringBuffer();
        sb.append("select a.ffromid \n");
        sb.append("from T_Cas_AssItemsForCashPay as a\n");
        sb.append("left join t_cas_paymentbill as b on a.fparentid = b.fid \n");
        sb.append("inner join t_bd_asstacttype as c on a.fasstacttypeid = c.fid \n");
        sb.append("where FisSelected = 1 and c.fnumber = ? \n");
        sb.append("and  b.fid = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{asstActNumber, billID});
        if (rs.next()) {
            asstActTypeID = rs.getString(1);
        }
        if (entryID != null) {
            sb = new StringBuffer();
            sb.append("select  a.ffromid \n");
            sb.append("from T_Cas_AssItemsForCashPay as a\n");
            sb.append("left join t_cas_paymentbillentry as b on a.fentryparentid = b.fid \n");
            sb.append("inner join t_bd_asstacttype as c on a.fasstacttypeid = c.fid \n");
            sb.append("where FisSelected = 1 and c.fnumber = ? \n");
            sb.append("and  b.fid = ? \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{asstActNumber, entryID});
            if (rs.next()) {
                asstActTypeID = rs.getString(1);
            }
        }
        return asstActTypeID;
    }

    private static String getAsstActTypeID4Rec(Context ctx, String billID, String entryID, String asstActNumber) throws Exception {
        String asstActTypeID = "";
        StringBuffer sb = new StringBuffer();
        sb.append("select  a.ffromid \n");
        sb.append("from T_Cas_AssItemsForCashRec as a\n");
        sb.append("left join t_cas_receivingbill as b on a.fparentid = b.fid \n");
        sb.append("inner join t_bd_asstacttype as c on a.fasstacttypeid = c.fid \n");
        sb.append("where FisSelected = 1 and c.fnumber = ? \n");
        sb.append("and  b.fid = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{asstActNumber, billID});
        if (rs.next()) {
            asstActTypeID = rs.getString(1);
        }
        if (entryID != null) {
            sb = new StringBuffer();
            sb.append("select  a.ffromid \n");
            sb.append("from T_Cas_AssItemsForCashRec as a\n");
            sb.append("left join t_cas_receivingbillentry as b on a.fentryparentid = b.fid \n");
            sb.append("inner join t_bd_asstacttype as c on a.fasstacttypeid = c.fid \n");
            sb.append("where FisSelected = 1 and c.fnumber = ? \n");
            sb.append("and  b.fid = ? \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{asstActNumber, entryID});
            if (rs.next()) {
                asstActTypeID = rs.getString(1);
            }
        }
        return asstActTypeID;
    }

    private static EntityViewInfo getEntity(String billID, String number, int type) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        if (type == 0) {
            f.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billID));
        } else {
            f.getFilterItems().add(new FilterItemInfo("entryParent.id", (Object)billID));
        }
        f.getFilterItems().add(new FilterItemInfo("asstActType.number", (Object)number));
        f.getFilterItems().add(new FilterItemInfo("isSelected", (Object)Boolean.TRUE));
        evi.setFilter(f);
        return evi;
    }
}

