/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptWebFacadeFactory;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.EreceiptLinkHelper;
import com.kingdee.eas.fm.erec.SortItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EReceiptCommonHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.EReceiptCommonHelper");
    public static final String PDFMap = "pdfMap";
    public static final String ERMap = "erMap";

    public static List getPDFValues(Context ctx, String voucherId) throws BOSException, EASBizException {
        List PDFFileList = new ArrayList();
        ArrayList<String> voucherList = new ArrayList<String>();
        HashMap<String, SortItem[]> sortIemMap = new HashMap<String, SortItem[]>();
        SortItem[] sortItems = new SortItem[1];
        SortItem sortItem = new SortItem();
        sortItem.setFiled("amount");
        sortItem.setSortType(SortType.DESCEND);
        sortItems[0] = sortItem;
        sortIemMap.put("sortItems", sortItems);
        IVoucherEntry iVoucherEntry = null;
        iVoucherEntry = ctx == null ? VoucherEntryFactory.getRemoteInstance() : VoucherEntryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bill", (Object)voucherId, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("account.isBank"));
        view.setSelector(selector);
        view.setFilter(fi);
        VoucherEntryCollection Info = iVoucherEntry.getVoucherEntryCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)Info)) {
            for (int i = 0; i < Info.size(); ++i) {
                VoucherEntryInfo entry = Info.get(i);
                if (!entry.getAccount().isIsBank()) continue;
                voucherList.add(voucherId);
                try {
                    PDFFileList = EreceiptLinkHelper.getPDFListByBillIds((Context)ctx, voucherList, sortIemMap);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                return PDFFileList;
            }
        }
        return PDFFileList;
    }

    public static Map<String, List<byte[]>> getPDFMapValues(Context ctx, List voucherList) throws BOSException, EASBizException {
        return EreceiptLinkHelper.getPDFsByBillIds((Context)ctx, (List)voucherList);
    }

    public static List getEreceiptIdListByBillId(Context ctx, String billId) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(billId);
        return EreceiptLinkHelper.getErecIdLsitByBillIds((Context)ctx, idList);
    }

    public static List getEreceiptIdListByBillIdList(Context ctx, List billIdList) throws BOSException, EASBizException {
        return EreceiptLinkHelper.getErecIdLsitByBillIds((Context)ctx, (List)billIdList);
    }

    public static List getEreceiptIdListByVoucherID(Context ctx, String voucherId) throws BOSException, EASBizException {
        List idList = new ArrayList();
        ArrayList<String> voucherList = new ArrayList<String>();
        voucherList.add(voucherId);
        idList = EreceiptLinkHelper.getErecIdLsitByBillIds((Context)ctx, voucherList);
        return idList;
    }

    public static String getEreceiptIdStrByVoucherID(Context ctx, String voucherId) throws BOSException, EASBizException {
        String str = "";
        List idList = new ArrayList();
        idList = EReceiptCommonHelper.getEreceiptIdListByVoucherID(ctx, voucherId);
        HashSet set = new HashSet(idList);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            if (EmptyUtil.isEmpty((String)str)) {
                str = str + (String)it.next();
                continue;
            }
            str = str + "," + (String)it.next();
        }
        return str;
    }

    public static String getEreceiptIdStrByBillId(Context ctx, String billId) throws BOSException, EASBizException {
        String str = "";
        List idList = new ArrayList();
        idList = EReceiptCommonHelper.getEreceiptIdListByBillId(ctx, billId);
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            if (EmptyUtil.isEmpty((String)str)) {
                str = str + (String)it.next();
                continue;
            }
            str = str + "," + (String)it.next();
        }
        return str;
    }

    public static String getEreceiptIdStrByBillIdList(Context ctx, List billIdList) throws BOSException, EASBizException {
        String str = "";
        List idList = new ArrayList();
        idList = EReceiptCommonHelper.getEreceiptIdListByBillIdList(ctx, billIdList);
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            if (EmptyUtil.isEmpty((String)str)) {
                str = str + (String)it.next();
                continue;
            }
            str = str + "," + (String)it.next();
        }
        return str;
    }

    public static List getPDFValueByIdList(Context ctx, List idList) throws EASBizException, BOSException {
        List result = new ArrayList();
        result = EmptyUtil.isEmpty((Object)ctx) ? EReceiptWebFacadeFactory.getRemoteInstance().getEReceiptPDFByteValues(idList) : EReceiptWebFacadeFactory.getLocalInstance((Context)ctx).getEReceiptPDFByteValues(idList);
        return result;
    }

    public static Map getEReceiptValidCodeByIdList(Context ctx, List idList) throws EASBizException, BOSException {
        HashMap eRMap = new HashMap();
        if (EmptyUtil.isEmpty((Collection)idList)) {
            return eRMap;
        }
        IEReceipt iEReceipt = null;
        iEReceipt = ctx == null ? EReceiptFactory.getRemoteInstance() : EReceiptFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        EReceiptCollection eRCol = iEReceipt.getEReceiptCollection(view);
        for (int i = 0; i < eRCol.size(); ++i) {
            EReceiptInfo info = eRCol.get(i);
            if (eRMap.containsKey(info.getId())) continue;
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("ValidCode", info.getValidCode());
            infoMap.put("Currency", info.getCurrency());
            infoMap.put("TransactionAmountInFigures", info.getAmount());
            eRMap.put(info.getId().toString(), infoMap);
        }
        return eRMap;
    }

    public static Map getPDFValueByIdList(Context ctx, List idList, Boolean isConvertToPDF) throws EASBizException, BOSException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        Map pdfMap = EreceiptLinkHelper.getPDFsByBillIds((Context)ctx, (List)idList, (boolean)false);
        IEReceipt iEReceipt = null;
        iEReceipt = ctx == null ? EReceiptFactory.getRemoteInstance() : EReceiptFactory.getLocalInstance((Context)ctx);
        HashMap eRMap = new HashMap();
        if (!EmptyUtil.isEmpty(pdfMap.keySet())) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("validCode"));
            sic.add(new SelectorItemInfo("fileName"));
            sic.add(new SelectorItemInfo("amount"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", pdfMap.keySet(), CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(sic);
            EReceiptCollection eRCol = iEReceipt.getEReceiptCollection(view);
            for (int i = 0; i < eRCol.size(); ++i) {
                EReceiptInfo info = eRCol.get(i);
                if (eRMap.containsKey(info.getId())) continue;
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("ValidCode", info.getValidCode());
                infoMap.put("fileName", info.getFileName());
                infoMap.put("TransactionAmountInFigures", info.getAmount());
                eRMap.put(info.getId().toString(), infoMap);
            }
        }
        result.put(PDFMap, pdfMap);
        result.put(ERMap, eRMap);
        return result;
    }
}

