/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemReferenceHelper;
import com.kingdee.eas.ma.budget.VisualItemCollection;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FMBGHelper {
    private static final Logger logger = CoreUIObject.getLogger(FMBGHelper.class);
    static String FMBGUSED_TAB = "T_BG_BillUsedItem";

    private static void fillInfoBgItem(Context ctx, Map valueMap, IFMBgUsed fmInfo) {
        FMBgItemProp[] bgItemProps = fmInfo.getBgItemProps();
        CoreBaseInfo info = (CoreBaseInfo)fmInfo;
        for (int i = 0; i < bgItemProps.length; ++i) {
            FMBgItemProp bgItemProp = bgItemProps[i];
            String valueBgItemNumber = info.getString(bgItemProp.getBgItemNumberProp());
            if (valueBgItemNumber == null) {
                info.setString(bgItemProp.getBgItemIDProp(), null);
                info.setString(bgItemProp.getBgItemNameProp(), null);
                continue;
            }
            VisualItemInfo vInfo = (VisualItemInfo)valueMap.get(valueBgItemNumber);
            info.setString(bgItemProp.getBgItemIDProp(), vInfo.getId().toString());
            info.setString(bgItemProp.getBgItemNameProp(), vInfo.getName());
        }
    }

    private static void fillInfoBgItem(Context ctx, Map valueMap, IFMBgUsed[] fmInfo) {
        int l = fmInfo.length;
        for (int k = 0; k < l; ++k) {
            FMBgItemProp[] bgItemProps = fmInfo[k].getBgItemProps();
            CoreBaseInfo info = (CoreBaseInfo)fmInfo[k];
            for (int i = 0; i < bgItemProps.length; ++i) {
                FMBgItemProp bgItemProp = bgItemProps[i];
                String valueBgItemNumber = info.getString(bgItemProp.getBgItemNumberProp());
                if (valueBgItemNumber == null) {
                    info.setString(bgItemProp.getBgItemIDProp(), null);
                    info.setString(bgItemProp.getBgItemNameProp(), null);
                    continue;
                }
                VisualItemInfo vInfo = (VisualItemInfo)valueMap.get(valueBgItemNumber);
                info.setString(bgItemProp.getBgItemIDProp(), vInfo.getId().toString());
                info.setString(bgItemProp.getBgItemNameProp(), vInfo.getName());
            }
        }
    }

    private static Map getVisualItemMap(Context ctx, Map numberMap) throws BOSException, EASBizException {
        VisualItemCollection col = BgFacadeFactory.getLocalInstance((Context)ctx).getVisualItemCollection(numberMap, true, ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString());
        HashMap<String, VisualItemInfo> valueMap = new HashMap<String, VisualItemInfo>();
        for (int i = 0; i < col.size(); ++i) {
            VisualItemInfo vInfo = col.get(i);
            valueMap.put(vInfo.getNumber(), vInfo);
        }
        return valueMap.size() == 0 ? null : valueMap;
    }

    private static Map getBgNumberMap(Context ctx, IFMBgUsed fmInfo) {
        FMBgItemProp[] bgItemProps = fmInfo.getBgItemProps();
        CoreBaseInfo info = (CoreBaseInfo)fmInfo;
        HashMap numberMap = new HashMap();
        for (int i = 0; i < bgItemProps.length; ++i) {
            FMBgItemProp bgItemProp = bgItemProps[i];
            String valueBgItemNumber = info.getString(bgItemProp.getBgItemNumberProp());
            if (valueBgItemNumber == null) {
                info.setString(bgItemProp.getBgItemIDProp(), null);
                info.setString(bgItemProp.getBgItemNameProp(), null);
                continue;
            }
            numberMap.put(valueBgItemNumber, null);
        }
        if (numberMap.size() == 0) {
            return null;
        }
        return numberMap;
    }

    private static Map getBgNumberMap(Context ctx, IFMBgUsed[] fmInfo) {
        HashMap numberMap = new HashMap();
        int l = fmInfo.length;
        for (int k = 0; k < l; ++k) {
            FMBgItemProp[] bgItemProps = fmInfo[k].getBgItemProps();
            CoreBaseInfo info = (CoreBaseInfo)fmInfo[k];
            for (int i = 0; i < bgItemProps.length; ++i) {
                FMBgItemProp bgItemProp = bgItemProps[i];
                String valueBgItemNumber = info.getString(bgItemProp.getBgItemNumberProp());
                if (valueBgItemNumber == null) {
                    info.setString(bgItemProp.getBgItemIDProp(), null);
                    info.setString(bgItemProp.getBgItemNameProp(), null);
                    continue;
                }
                numberMap.put(valueBgItemNumber, null);
            }
        }
        if (numberMap.size() == 0) {
            return null;
        }
        return numberMap;
    }

    public static void fillBgItem(Context ctx, IFMBgUsed[] fmInfo) throws BOSException, EASBizException {
        boolean isFpItem = FMBGHelper.getIsFpOrBg(ctx);
        if (isFpItem) {
            return;
        }
        if (FMHelper.isEmpty(fmInfo)) {
            return;
        }
        Map numberMap = FMBGHelper.getBgNumberMap(ctx, fmInfo);
        if (numberMap == null) {
            return;
        }
        Map valueMap = FMBGHelper.getVisualItemMap(ctx, numberMap);
        if (valueMap == null) {
            return;
        }
        FMBGHelper.fillInfoBgItem(ctx, valueMap, fmInfo);
    }

    public static void fillBgItem(Context ctx, IFMBgUsed fmInfo) throws BOSException, EASBizException {
        boolean isFpItem = FMBGHelper.getIsFpOrBg(ctx);
        if (isFpItem) {
            return;
        }
        if (FMHelper.isEmpty(fmInfo)) {
            return;
        }
        Map numberMap = FMBGHelper.getBgNumberMap(ctx, fmInfo);
        if (numberMap == null) {
            return;
        }
        Map valueMap = FMBGHelper.getVisualItemMap(ctx, numberMap);
        if (valueMap == null) {
            return;
        }
        FMBGHelper.fillInfoBgItem(ctx, valueMap, fmInfo);
    }

    public static void signBgItemUsed(Context ctx, IObjectPK pk, IFMBgUsed fmInfo) throws BOSException, EASBizException {
        boolean isFpItem = FMBGHelper.getIsFpOrBg(ctx);
        if (isFpItem) {
            return;
        }
        ArrayList<String> bgItemCombinIDS = new ArrayList<String>();
        FMBgItemProp[] bgItemProps = fmInfo.getBgItemProps();
        for (int i = 0; i < bgItemProps.length; ++i) {
            String bgItemId = ((CoreBaseInfo)fmInfo).getString(bgItemProps[i].getBgItemIDProp());
            if (FMHelper.isEmpty(bgItemId)) continue;
            bgItemCombinIDS.add(bgItemId);
        }
        BgItemReferenceHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, bgItemCombinIDS);
    }

    public static void signBgItemRelease(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isFpItem = FMBGHelper.getIsFpOrBg(ctx);
        if (isFpItem) {
            return;
        }
        BgItemReferenceHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    public static void signBgItemRelease(Context ctx, IObjectPK[] pks) throws BOSException {
        boolean isFpItem = FMBGHelper.getIsFpOrBg(ctx);
        if (isFpItem) {
            return;
        }
        BgItemReferenceHelper.signBgItemRelease((Context)ctx, (IObjectPK[])pks);
    }

    public static boolean getIsFpOrBg(Context ctx) {
        if (ctx != null) {
            try {
                String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"BG056");
                return !FMHelper.isEmpty(paramValue) && !"0".equals(paramValue);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        try {
            String paramValue = ParamManager.getParamValue(null, null, (String)"BG056");
            return !FMHelper.isEmpty(paramValue) && !"0".equals(paramValue);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static void reverseLoanExt(Context ctx, String LoanExtID, String isForExh) throws BOSException, EASBizException {
        BOSUuid sbid;
        if (!FMHelper.isEmpty(LoanExtID) && (sbid = BOSUuid.read((String)LoanExtID)).getType().equals((Object)new LoanExhibitionInfo().getBOSType())) {
            String sql = "Update T_FIN_LoanExhibition  set FIsForExh =?  where Fid=?";
            FMDBHelper.execute(ctx, sql, new String[]{isForExh, LoanExtID});
        }
    }
}

