/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.CtrlNodeEnum;
import com.kingdee.eas.fm.common.FMBizParamCollection;
import com.kingdee.eas.fm.common.FMBizParamFactory;
import com.kingdee.eas.fm.common.FMBizParamInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IFMBizParam;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.IMbgParams;
import com.kingdee.eas.ma.base.MbgParamsFactory;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import org.apache.log4j.Logger;

public class FmMbgHelper {
    public static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.utils.BgParamCHelper");

    public static void checkBizUnitInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FmMbgHelper.checkBizUnitInfo(ctx, model, FmMbgHelper.getCompanyId(ctx));
    }

    public static void checkBizUnitInfo(Context ctx, IObjectValue model, String companyId) throws BOSException, EASBizException {
        String infoCompanyId = FmMbgHelper.getInfoCompany(ctx, null, model);
        if (infoCompanyId != null && !FmMbgHelper.isCtrl(ctx, model.getBOSType(), infoCompanyId)) {
            return;
        }
        if (infoCompanyId == null && !FmMbgHelper.isCtrl(ctx, model.getBOSType(), companyId)) {
            return;
        }
        BgControlCaller caller = new BgControlCaller();
        if (ctx == null) {
            caller.checkBizUnitInfo(model, null);
        } else {
            caller.checkBizUnitInfo(ctx, model, null);
        }
    }

    public static void requestBudget(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget(ctx, pk, FmMbgHelper.getCompanyId(ctx));
    }

    public static void requestBudget(Context ctx, IObjectPK pk, String companyId) throws EASBizException, BOSException {
        String infoCompanyId = FmMbgHelper.getInfoCompany(ctx, pk, null);
        if (infoCompanyId != null && !FmMbgHelper.isCtrl(ctx, BOSUuid.read((String)pk.toString()).getType(), infoCompanyId)) {
            return;
        }
        if (infoCompanyId == null && !FmMbgHelper.isCtrl(ctx, pk)) {
            return;
        }
        BgControlCaller caller = new BgControlCaller();
        IControlResult result = caller.requestBudget(ctx, BOSUuid.read((String)pk.toString()));
        if (result.getResult() == 1) {
            return;
        }
        if (result.getResult() != 5) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{result.getCause()});
        }
        caller.specialBudget(ctx, BOSUuid.read((String)pk.toString()));
    }

    public static void returnBudget(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FmMbgHelper.returnBudget(ctx, pk, FmMbgHelper.getCompanyId(ctx));
    }

    public static void returnBudget(Context ctx, IObjectPK pk, String companyId) throws BOSException, EASBizException {
        String infoCompanyId = FmMbgHelper.getInfoCompany(ctx, pk, null);
        if (infoCompanyId != null && !FmMbgHelper.isCtrl(ctx, BOSUuid.read((String)pk.toString()).getType(), infoCompanyId)) {
            return;
        }
        if (infoCompanyId == null && !FmMbgHelper.isCtrl(ctx, pk)) {
            return;
        }
        BgControlCaller caller = new BgControlCaller();
        caller.returnBudget(ctx, BOSUuid.read((String)pk.toString()));
    }

    public static void checkBizUnitInfo(Context ctx, IObjectValue model, CtrlNodeEnum ctrlNode) throws BOSException, EASBizException {
        CtrlNodeEnum ctrlNode2 = CtrlNodeEnum.submit;
        FMBizParamInfo info = null;
        String companyId = FmMbgHelper.getInfoCompany(ctx, null, model);
        info = companyId != null ? FmMbgHelper.getBizParamInfo(ctx, model.getBOSType(), companyId) : FmMbgHelper.getBizParamInfo(ctx, model.getBOSType());
        if (info != null) {
            ctrlNode2 = info.getCtrlNode();
        }
        if (ctrlNode == ctrlNode2) {
            FmMbgHelper.checkBizUnitInfo(ctx, model);
        }
    }

    public static void requestBudget(Context ctx, IObjectPK pk, CtrlNodeEnum ctrlNode) throws EASBizException, BOSException {
        CtrlNodeEnum ctrlNode2 = CtrlNodeEnum.submit;
        FMBizParamInfo info = null;
        String companyId = FmMbgHelper.getInfoCompany(ctx, pk, null);
        info = companyId != null ? FmMbgHelper.getBizParamInfo(ctx, BOSUuid.read((String)pk.toString()).getType(), companyId) : FmMbgHelper.getBizParamInfo(ctx, pk);
        if (info != null) {
            ctrlNode2 = info.getCtrlNode();
        }
        if (ctrlNode == ctrlNode2 && companyId != null) {
            FmMbgHelper.requestBudget(ctx, pk, companyId);
        } else if (ctrlNode == ctrlNode2) {
            FmMbgHelper.requestBudget(ctx, pk);
        }
    }

    public static void returnBudget(Context ctx, IObjectPK pk, CtrlNodeEnum ctrlNode) throws EASBizException, BOSException {
        CtrlNodeEnum ctrlNode2 = CtrlNodeEnum.submit;
        FMBizParamInfo info = null;
        String companyId = FmMbgHelper.getInfoCompany(ctx, pk, null);
        info = companyId != null ? FmMbgHelper.getBizParamInfo(ctx, BOSUuid.read((String)pk.toString()).getType(), companyId) : FmMbgHelper.getBizParamInfo(ctx, pk);
        if (info != null) {
            ctrlNode2 = info.getCtrlNode();
        }
        if (ctrlNode == ctrlNode2 && companyId != null) {
            FmMbgHelper.returnBudget(ctx, pk, companyId);
        } else if (ctrlNode == ctrlNode2) {
            FmMbgHelper.returnBudget(ctx, pk);
        }
    }

    public static IContextHelper getHelper(Context ctx) {
        if (ctx == null) {
            return ContextHelperFactory.getRemoteInstance();
        }
        return ContextHelperFactory.getLocalInstance((Context)ctx);
    }

    public static boolean isMBG_C001(Context ctx, String companyId) {
        boolean MBG_C001 = false;
        try {
            if (EmptyUtil.isEmpty((String)companyId)) {
                companyId = FmMbgHelper.getCompanyId(ctx);
            }
            IMbgParams MbgParams = null;
            MbgParams = ctx != null ? MbgParamsFactory.getLocalInstance((Context)ctx) : MbgParamsFactory.getRemoteInstance();
            String value = MbgParams.getParamValue(companyId, "MBG_C001");
            MBG_C001 = !StringUtils.isEmpty((String)value) ? Boolean.valueOf(value) : false;
        }
        catch (Exception ex) {
            logger.error((Object)"load system param error:", (Throwable)ex);
        }
        return MBG_C001;
    }

    public static String getCompanyId(Context ctx) {
        return FmMbgHelper.getHelper(ctx).getCurrentCompany().getId().toString();
    }

    public static boolean isCtrl(Context ctx, IObjectPK pk) throws BOSException {
        return FmMbgHelper.isCtrl(ctx, BOSUuid.read((String)pk.toString()).getType());
    }

    public static boolean isCtrl(Context ctx, BOSObjectType bosType) throws BOSException {
        return FmMbgHelper.isCtrl(ctx, bosType, FmMbgHelper.getCompanyId(ctx));
    }

    public static boolean isCtrl(Context ctx, BOSObjectType bosType, String companyId) throws BOSException {
        FMBizParamInfo info = FmMbgHelper.getBizParamInfo(ctx, bosType, companyId);
        return info == null ? false : info.isIsCtrl();
    }

    public static FMBizParamInfo getBizParamInfo(Context ctx, IObjectPK pk) throws BOSException {
        return FmMbgHelper.getBizParamInfo(ctx, BOSUuid.read((String)pk.toString()).getType());
    }

    public static FMBizParamInfo getBizParamInfo(Context ctx, BOSObjectType bosType) throws BOSException {
        return FmMbgHelper.getBizParamInfo(ctx, bosType, FmMbgHelper.getCompanyId(ctx));
    }

    public static FMBizParamInfo getBizParamInfo(Context ctx, BOSObjectType bosType, String companyId) throws BOSException {
        String boName = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType).getFullName();
        IFMBizParam iFMBiz = null;
        iFMBiz = ctx == null ? FMBizParamFactory.getRemoteInstance() : FMBizParamFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bizBill.boName", (Object)boName);
        filter.appendFilterItem("company.id", (Object)companyId);
        view.setFilter(filter);
        FMBizParamCollection coll = iFMBiz.getFMBizParamCollection(view);
        if (coll != null && !coll.isEmpty()) {
            return coll.get(0);
        }
        return null;
    }

    public static String getInfoCompany(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, UuidException, EASBizException {
        BOSObjectType bosType = null;
        if (model != null) {
            bosType = model.getBOSType();
        } else if (pk != null) {
            bosType = BOSUuid.read((String)pk.toString()).getType();
        }
        if (bosType != null && (new TransUpBillInfo().getBOSType().equals((Object)bosType) || new TransDownBillInfo().getBOSType().equals((Object)bosType))) {
            if (model == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("company");
                ICoreBase iCoreBase = (ICoreBase)CDOUtils.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk.toString()).getType());
                model = iCoreBase.getValue(pk, sic);
            }
            if (model != null && model.getObjectValue("company") != null) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)model.getObjectValue("company");
                return company.getId().toString();
            }
        }
        return null;
    }
}

