/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.core.util.DateUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UserOptionUtil {
    public static Map getUserOptionMap(Container container, Map map) throws Exception {
        int size = container.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Object value;
            String name;
            Component c = container.getComponent(i);
            if (c instanceof KDPanel) {
                KDPanel panel = (KDPanel)c;
                UserOptionUtil.getUserOptionMap((Container)panel, map);
            }
            if (c instanceof KDLabelContainer) {
                KDLabelContainer labelContainer = (KDLabelContainer)c;
                UserOptionUtil.getUserOptionMap((Container)labelContainer, map);
            }
            if (c instanceof KDContainer) {
                KDContainer container2 = (KDContainer)c;
                UserOptionUtil.getUserOptionMap((Container)container2, map);
            }
            if (c instanceof KDTabbedPane) {
                KDTabbedPane tabbedPane = (KDTabbedPane)c;
                UserOptionUtil.getUserOptionMap((Container)tabbedPane, map);
            }
            if (c instanceof KDTextField) {
                KDTextField txt = (KDTextField)c;
                name = txt.getName();
                value = txt.getText();
                map.put(name, value);
            }
            if (c instanceof KDDatePicker) {
                KDDatePicker dpk = (KDDatePicker)c;
                name = dpk.getName();
                value = DateUtil.DateToString((Date)((Date)dpk.getValue()));
                map.put(name, value);
            }
            if (c instanceof KDComboBox) {
                KDComboBox combo = (KDComboBox)c;
                name = combo.getName();
                value = new Integer(combo.getSelectedIndex());
                map.put(name, value);
            }
            if (c instanceof KDPromptBox) {
                // empty if block
            }
            if (c instanceof KDRadioButton) {
                KDRadioButton rb = (KDRadioButton)c;
                name = rb.getName();
                value = new Boolean(rb.isSelected());
                map.put(name, value);
            }
            if (c instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)c;
                name = cb.getName();
                value = new Boolean(cb.isSelected());
                map.put(name, value);
            }
            if (!(c instanceof KDTable)) continue;
            KDTable table = (KDTable)c;
            for (int j = 0; j < table.getRowCount(); ++j) {
                IRow row = table.getRow(j);
                for (int m = 0; m < table.getColumnCount(); ++m) {
                    ICell cell = row.getCell(m);
                    String name2 = row.getRowIndex() + ":" + cell.getColumnIndex();
                    map.put(name2, cell.getValue());
                }
            }
        }
        return map;
    }

    public static String getUserOptionValue(Container container) throws Exception {
        return UserOptionUtil.getUserOptionValue(container, null);
    }

    public static String getUserOptionValue(Container container, Map map) throws Exception {
        if (map == null) {
            map = new HashMap();
        }
        UserOptionUtil.getUserOptionMap(container, map);
        return UserOptionUtil.map2String(map);
    }

    public static void setUIStatus(Container container, Map map) throws Exception {
        if (map == null || map.size() == 0) {
            return;
        }
        int size = container.getComponentCount();
        for (int i = 0; i < size; ++i) {
            KDCheckBox cb;
            KDRadioButton rb;
            KDComboBox combo;
            KDDatePicker dpk;
            KDTextField txt;
            String name;
            Component c = container.getComponent(i);
            if (c instanceof KDPanel) {
                KDPanel panel = (KDPanel)c;
                UserOptionUtil.setUIStatus((Container)panel, map);
            }
            if (c instanceof KDLabelContainer) {
                KDLabelContainer labelContainer = (KDLabelContainer)c;
                UserOptionUtil.setUIStatus((Container)labelContainer, map);
            }
            if (c instanceof KDContainer) {
                KDContainer container2 = (KDContainer)c;
                UserOptionUtil.setUIStatus((Container)container2, map);
            }
            if (c instanceof KDTabbedPane) {
                KDTabbedPane tabbedPane = (KDTabbedPane)c;
                UserOptionUtil.setUIStatus((Container)tabbedPane, map);
            }
            if (c instanceof KDTextField && map.get(name = (txt = (KDTextField)c).getName()) != null) {
                txt.setText((String)map.get(name));
            }
            if (c instanceof KDDatePicker && map.get(name = (dpk = (KDDatePicker)c).getName()) != null) {
                String date = (String)map.get(name);
                dpk.setValue((Object)DateUtil.stringToDate((String)date));
            }
            if (c instanceof KDComboBox && map.get(name = (combo = (KDComboBox)c).getName()) != null) {
                combo.setSelectedIndex(Integer.parseInt(map.get(name).toString()));
            }
            if (c instanceof KDPromptBox) {
                // empty if block
            }
            if (c instanceof KDRadioButton && map.get(name = (rb = (KDRadioButton)c).getName()) != null) {
                rb.setSelected(new Boolean((String)map.get(name)).booleanValue());
            }
            if (c instanceof KDCheckBox && map.get(name = (cb = (KDCheckBox)c).getName()) != null) {
                cb.setSelected(new Boolean((String)map.get(name)).booleanValue());
            }
            if (!(c instanceof KDTable)) continue;
            KDTable table = (KDTable)c;
            IRow row = null;
            for (int m = 0; m < table.getRowCount(); ++m) {
                row = table.getRow(m);
                for (int n = 0; n < table.getColumnCount(); ++n) {
                    if ("true".equals(map.get(m + ":" + n)) || "false".equals(map.get(m + ":" + n))) {
                        row.getCell(n).setValue((Object)Boolean.valueOf(map.get(m + ":" + n).toString()));
                        continue;
                    }
                    row.getCell(n).setValue(map.get(m + ":" + n));
                }
            }
        }
    }

    public static String map2String(Map map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : map.entrySet()) {
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
            sb.append(";");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static Map string2Map(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        String temp = null;
        if (s == null) {
            return map;
        }
        while (s.indexOf(";") != -1) {
            temp = s.substring(0, s.indexOf(";"));
            if (temp.indexOf("=") != -1) {
                String name = temp.substring(0, temp.indexOf("="));
                String value = temp.substring(temp.indexOf("=") + 1);
                map.put(name, value);
            }
            s = s.substring(s.indexOf(";") + 1);
        }
        map.put(s.substring(0, s.indexOf("=")), s.substring(s.indexOf("=") + 1));
        return map;
    }
}

