/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBizBillCollection;
import com.kingdee.eas.fm.common.FMBizParamCollection;
import com.kingdee.eas.fm.common.FMBizParamFactory;
import com.kingdee.eas.fm.common.FMBizParamInfo;
import com.kingdee.eas.fm.common.app.AbstractFMBizBillControllerBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMBizBillControllerBean
extends AbstractFMBizBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.app.FMBizBillControllerBean");
    private Set<String> ids = new HashSet<String>();

    @Override
    protected void _updateParam(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        FMBizBillCollection billColl = (FMBizBillCollection)coll;
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            this.ids.add(billColl.get(i).getId().toString());
        }
        this.refillSet(ctx);
        this.addnewOrUpdate(ctx, billColl);
    }

    private void refillSet(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizBill", this.ids, CompareType.INCLUDE));
        view.setFilter(filter);
        FMBizParamCollection coll = FMBizParamFactory.getLocalInstance(ctx).getFMBizParamCollection(view);
        this.ids.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this.ids.add(coll.get(i).getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addnewOrUpdate(Context ctx, FMBizBillCollection coll) throws EASBizException, BOSException {
        String update = "update T_CO_FMBizParam set fisCtrl = ?, fctrlNode = ? where fid = ?";
        String addnew = "insert into T_CO_FMBizParam(fid, fbizBillId, fcompanyId, fisCtrl, fctrlNode) values (?,?,?,?,?)";
        Connection conn = this.getConnection(ctx);
        PreparedStatement updatePS = null;
        PreparedStatement addnewPS = null;
        FMBizParamInfo paramInfo = null;
        try {
            updatePS = conn.prepareStatement(update);
            addnewPS = conn.prepareStatement(addnew);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < coll.get(i).getBizParam().size(); ++j) {
                    paramInfo = coll.get(i).getBizParam().get(j);
                    if (this.ids.contains(paramInfo.getId().toString())) {
                        updatePS.setInt(1, paramInfo.isIsCtrl() ? 1 : 0);
                        updatePS.setInt(2, paramInfo.getCtrlNode().getValue());
                        updatePS.setString(3, paramInfo.getId().toString());
                        updatePS.addBatch();
                        continue;
                    }
                    addnewPS.setString(1, paramInfo.getId().toString());
                    addnewPS.setString(2, paramInfo.getBizBill().getId().toString());
                    addnewPS.setString(3, paramInfo.getCompany().getId().toString());
                    addnewPS.setInt(4, paramInfo.isIsCtrl() ? 1 : 0);
                    addnewPS.setInt(5, paramInfo.getCtrlNode().getValue());
                    addnewPS.addBatch();
                }
            }
            updatePS.executeBatch();
            addnewPS.executeBatch();
        }
        catch (SQLException e) {
            logger.info((Object)"SQL Exception:", (Throwable)e);
        }
        finally {
            try {
                if (updatePS != null) {
                    updatePS.close();
                }
                if (addnewPS != null) {
                    addnewPS.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.info((Object)"SQL Exception:", (Throwable)e);
            }
        }
    }
}

