/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.app.AbstractFMDatataskRunServerControllerBean;
import com.kingdee.eas.fm.common.task.FMTaskExternalCodeRunner;
import com.kingdee.eas.tools.datatask.BDEntityInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DatataskException;
import com.kingdee.eas.tools.datatask.DatataskMode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ExtendsDataskParameter;
import com.kingdee.eas.tools.datatask.FileInfo;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.ExcelTaskLog;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogManager;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.runtime.ExcelInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReaderTask;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.DataGridExportExcelRunner;
import com.kingdee.eas.tools.datatask.task.IEImplGenerator;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskParameter;
import com.kingdee.eas.tools.datatask.task.ImpExpParam;
import com.kingdee.eas.tools.datatask.task.MultiExcelInfo;
import com.kingdee.eas.tools.datatask.task.MultiTempletExportRunner;
import com.kingdee.eas.tools.datatask.task.MultitaskExcelSchedule;
import com.kingdee.eas.tools.datatask.task.TaskExportEASDataRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskExternalCodeRunner;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.tools.datatask.util.FileTransferInfo;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.ZipUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FMDatataskRunServerControllerBean
extends AbstractFMDatataskRunServerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.app.FMDatataskRunServerControllerBean");
    private String serverFileName = "";

    private ReturnInfo runOnExportMode(DatataskParameter param, Context ctx) throws BOSException, DatataskException {
        TaskExternalCode task = null;
        ReturnInfo res = new ReturnInfo();
        try {
            param.putContextParam((Object)"context", (Object)ctx);
            this.serverFileName = GlobalFunction.getTempFileName((String)param.getLogUuID(), (String)param.getFileType());
            param.setOpenFileName(this.serverFileName);
            task = TaskTemplateAdapter.getTaskExternalCode((String)param.solutionName, (Context)ctx);
            task.setTaskUuID(param.getLogUuID());
            task.setTaskParameter((ITaskParameter)param);
            String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"0_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
            BOSObjectType bizObjType = this.getBOSType();
            IObjectPK instancePK = null;
            String instanceDetail = task.getName();
            String logItemName = "dataExport";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
            TaskExportEASDataRunner runner = new TaskExportEASDataRunner((ITask)task, ctx);
            runner.run();
            File f = new File(GlobalFunction.getFilePathForServer(), this.serverFileName);
            if (f.isFile() && f.exists()) {
                res.setData((Object)ZipUtil.gzipFile((File)f, (boolean)true));
            }
            if (TaskLogUtil.getLog((String)task.getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)task.getTaskUuID()).getTaskState())) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TaskLog log = new TaskLog(0);
            log.setLogUuID(param.getLogUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportTaskError", (Locale)ctx.getLocale());
            log.addException(errorMsg, (Throwable)ex, null);
            TaskLogUtil.putLog((TaskLog)log);
        }
        return res;
    }

    private ReturnInfo runOnImportMode(DatataskParameter param, Context ctx) throws BOSException, DatataskException {
        TaskExternalCode task = null;
        ReturnInfo result = null;
        try {
            task = TaskTemplateAdapter.getTaskExternalCode((String)param.solutionName, (Context)ctx);
            task.setTaskUuID(param.getLogUuID());
            task.setTaskParameter((ITaskParameter)param);
            String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"1_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
            BOSObjectType bizObjType = this.getBOSType();
            IObjectPK instancePK = null;
            String instanceDetail = task.getName();
            String logItemName = "dataImport";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
            if (!this.isBatchImportOperate(task)) {
                FMTaskExternalCodeRunner runner = new FMTaskExternalCodeRunner((ITask)task, ctx);
                result = runner.run();
            } else {
                IEImplGenerator runner = new IEImplGenerator();
                runner.runImport(ctx, task);
            }
            if (TaskLogUtil.getLog((String)task.getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)task.getTaskUuID()).getTaskState())) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TaskLog log = new TaskLog(0);
            log.setLogUuID(param.getLogUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importTaskError", (Locale)ctx.getLocale());
            log.addException(errorMsg, (Throwable)ex, null);
            TaskLogUtil.putLog((TaskLog)log);
        }
        return result;
    }

    private void runOnImportMode(DatataskParameter param, Context ctx, TaskLog taskLog) throws BOSException, DatataskException {
        TaskExternalCode task = null;
        try {
            task = TaskTemplateAdapter.getTaskExternalCode((String)param.solutionName, (Context)ctx);
            task.setTaskUuID(param.getLogUuID());
            task.setTaskParameter((ITaskParameter)param);
            String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"1_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
            BOSObjectType bizObjType = this.getBOSType();
            IObjectPK instancePK = null;
            String instanceDetail = task.getName();
            String logItemName = "dataImport";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
            TaskExternalCodeRunner runner = new TaskExternalCodeRunner((ITask)task, ctx);
            runner.setTaskLog(taskLog);
            runner.run();
            if (TaskLogUtil.getLog((String)task.getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)task.getTaskUuID()).getTaskState())) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TaskLog log = new TaskLog(0);
            log.setLogUuID(param.getLogUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importTaskError", (Locale)ctx.getLocale());
            log.addException(errorMsg, (Throwable)ex, null);
            TaskLogUtil.putLog((TaskLog)log);
        }
    }

    private boolean isBatchImportOperate(TaskExternalCode taskCode) throws Exception {
        if (TaskUtil.isUserDefineTrans((TaskExternalCode)taskCode)) {
            return false;
        }
        Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
        Object o = classDefinition.newInstance();
        return BlockDataTransmission.class.isAssignableFrom(o.getClass());
    }

    @Override
    protected void _run(Context ctx, ArrayList params) throws BOSException, DatataskException {
        DatataskParameter param = (DatataskParameter)params.get(0);
        if (DatataskMode.isImpMode((int)param.datataskMode)) {
            this.runOnImportMode(param, ctx);
        } else if (param.datataskMode == 1 || param.datataskMode == 64) {
            this.runOnExportMode(param, ctx);
        } else {
            String msg = "not support datataskmode " + param.datataskMode;
            throw new BOSException(msg);
        }
    }

    @Override
    protected TaskLog _getTaskLog(Context ctx, String uuid) throws BOSException {
        TaskLogManager lm = TaskLogManager.instance;
        ILog log = lm.getLog(uuid);
        if (log == null) {
            return null;
        }
        return (TaskLog)log;
    }

    @Override
    protected void _runImportTasks(Context ctx, ExtendsDataskParameter[] params) throws BOSException {
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            this.runImportTask(ctx, params[i]);
        }
    }

    @Override
    protected void _runImportTask(Context ctx, ExtendsDataskParameter param) throws BOSException {
        DatataskParameter dp = param.getParam();
        TaskExternalCode task = param.getTask();
        try {
            dp.getContextParam().put("context", ctx);
            task.setTaskParameter((ITaskParameter)dp);
            String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"1_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
            BOSObjectType bizObjType = this.getBOSType();
            IObjectPK instancePK = null;
            String instanceDetail = task.getName();
            String logItemName = "dataImport";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
            if (!this.isBatchImportOperate(task)) {
                TaskExternalCodeRunner runner = new TaskExternalCodeRunner((ITask)task, ctx);
                runner.run();
            } else {
                IEImplGenerator runner = new IEImplGenerator();
                runner.runImport(ctx, task);
            }
            if (TaskLogUtil.getLog((String)task.getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)task.getTaskUuID()).getTaskState())) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TaskLog log = new TaskLog(0);
            log.setLogUuID(task.getTaskUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importTaskError", (Locale)ctx.getLocale());
            log.addException(errorMsg, (Throwable)ex, null);
            TaskLogUtil.putLog((TaskLog)log);
        }
    }

    @Override
    protected void _clearTaskLog(Context ctx, String logUuid) throws BOSException {
        TaskLogUtil.clearLog((String)logUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] _getExportFile(Context ctx, String fileName) throws BOSException {
        this.serverFileName = fileName;
        String filePath = GlobalFunction.getFilePathForServer();
        File f = new File(filePath, this.serverFileName);
        byte[] fileData = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            fileData = new byte[fis.available()];
            fis.read(fileData);
        }
        catch (Exception err) {
            logger.error((Object)err);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            f.delete();
        }
        return fileData;
    }

    @Override
    protected void _writeTaskLog(Context ctx, TaskLog taskLog) throws BOSException {
        TaskLogUtil.putLog((TaskLog)taskLog);
    }

    @Override
    protected ReturnInfo _runExportTask(Context ctx, ITask[] tasks) throws BOSException {
        HashMap<String, String> fileNames = new HashMap<String, String>();
        ReturnInfo res = new ReturnInfo();
        int size = tasks.length;
        for (int i = 0; i < size; ++i) {
            DatataskParameter dp = (DatataskParameter)tasks[i].getTaskParameter();
            dp.getContextParam().put("exportFrom", "tool");
            dp.getContextParam().put("context", ctx);
            if (fileNames.get(dp.getOpenFileName()) != null) {
                dp.setOpenFileName((String)fileNames.get(dp.getOpenFileName()));
            } else {
                this.serverFileName = GlobalFunction.getTempFileName((String)dp.getLogUuID(), (String)dp.getFileType());
                fileNames.put(dp.getOpenFileName(), this.serverFileName);
                dp.setOpenFileName(this.serverFileName);
            }
            try {
                String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"0_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
                BOSObjectType bizObjType = this.getBOSType();
                IObjectPK instancePK = null;
                String instanceDetail = tasks[i].getName();
                String logItemName = "dataExport";
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
                TaskExportEASDataRunner runner = new TaskExportEASDataRunner(tasks[i], ctx);
                runner.run();
                if (TaskLogUtil.getLog((String)tasks[i].getTaskUuID()) == null || !TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)tasks[i].getTaskUuID()).getTaskState())) continue;
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                TaskLog log = new TaskLog(0);
                log.setLogUuID(tasks[i].getTaskUuID());
                log.setTaskState(TaskStateEnum.FAILEND);
                String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportTaskError", (Locale)ctx.getLocale());
                log.addException(errorMsg, (Throwable)ex, null);
                TaskLogUtil.putLog((TaskLog)log);
            }
        }
        HashMap zipmap = new HashMap();
        try {
            for (Map.Entry entry : fileNames.entrySet()) {
                File f = new File(GlobalFunction.getFilePathForServer(), (String)entry.getValue());
                if (!f.isFile() || !f.exists()) continue;
                zipmap.put(entry.getKey(), ZipUtil.gzipFile((File)f, (boolean)true));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        res.setData(zipmap);
        return res;
    }

    @Override
    protected void _runExportTask(Context ctx, ArrayList params, ITask task) throws BOSException {
        DatataskParameter dp = (DatataskParameter)params.get(0);
        try {
            dp.getContextParam().put("exportFrom", "tool");
            dp.getContextParam().put("context", ctx);
            this.serverFileName = GlobalFunction.getTempFileName((String)dp.getLogUuID(), (String)dp.getFileType());
            dp.setOpenFileName(this.serverFileName);
            task.setTaskParameter((ITaskParameter)dp);
            String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"0_DatataskRunServerControllerBean", (Locale)ctx.getLocale());
            BOSObjectType bizObjType = this.getBOSType();
            IObjectPK instancePK = null;
            String instanceDetail = task.getName();
            String logItemName = "dataExport";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
            TaskExportEASDataRunner runner = new TaskExportEASDataRunner(task, ctx);
            runner.run();
            if (TaskLogUtil.getLog((String)task.getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog((String)task.getTaskUuID()).getTaskState())) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TaskLog log = new TaskLog(0);
            log.setLogUuID(task.getTaskUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportTaskError", (Locale)ctx.getLocale());
            log.addException(errorMsg, (Throwable)ex, null);
            TaskLogUtil.putLog((TaskLog)log);
        }
    }

    @Override
    protected String _getQueryInfo(Context ctx, String className) throws BOSException {
        Object result = null;
        try {
            Class<?> transmissionClass = Class.forName(className);
            Method getQueryMethod = transmissionClass.getMethod("getExportQueryInfo", Context.class);
            result = getQueryMethod.invoke(transmissionClass.newInstance(), ctx);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return (String)result;
    }

    private void discardNotExistTables(Context ctx, HashMap infoMap) throws Exception {
        Connection conn = this.getConnection(ctx);
        Statement stmt = conn.createStatement();
        Iterator iter = infoMap.keySet().iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            if (!tableName.startsWith("t_") && !tableName.startsWith("T_")) {
                iter.remove();
                logger.info((Object)("The database object " + tableName + " is not a table!"));
                continue;
            }
            try {
                stmt.execute("SELECT 1 FROM " + tableName);
            }
            catch (SQLException e) {
                iter.remove();
                logger.error((Object)("The data center " + ctx.getAIS() + " has't table " + tableName + "!"));
            }
        }
        stmt.close();
        conn.close();
    }

    @Override
    protected Map _getBDEntityInfoMap(Context ctx) throws BOSException {
        long startTime = System.currentTimeMillis();
        HashMap<String, BDEntityInfo> infoMap = new HashMap<String, BDEntityInfo>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectCollection entityCol = loader.getEntityCollection();
        block2: for (EntityObjectInfo entityInfo : entityCol) {
            for (EntityObjectInfo baseEntityInfo = entityInfo.getBaseEntity(); baseEntityInfo != null; baseEntityInfo = baseEntityInfo.getBaseEntity()) {
                if (!"DataBase".equalsIgnoreCase(baseEntityInfo.getName()) && !"DataBaseD".equalsIgnoreCase(baseEntityInfo.getName())) continue;
                String name = entityInfo.getName();
                DataTableInfo tableInfo = entityInfo.getTable();
                if (name == null || tableInfo == null) continue block2;
                BDEntityInfo info = new BDEntityInfo();
                info.setEntityName(name);
                info.putEntityAlias(new Locale("L2"), entityInfo.getAlias(new Locale("L2")));
                info.putEntityAlias(new Locale("L3"), entityInfo.getAlias(new Locale("L3")));
                info.setTableName(tableInfo.getName());
                infoMap.put(info.getTableName(), info);
                continue block2;
            }
        }
        try {
            this.discardNotExistTables(ctx, infoMap);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("The time spent on getting basedata entity's information is: " + (endTime - startTime) + "ms"));
        return infoMap;
    }

    @Override
    protected void _translateBasedata(Context ctx, List tableList) throws BOSException {
        long startTime = System.currentTimeMillis();
        SQLException source = null;
        String firstErrorTable = null;
        String srcLang = ctx.getLocale().getLanguage().toUpperCase(Locale.ENGLISH);
        String targetLang = srcLang.equals("L2") ? "L3" : "L2";
        Connection conn = this.getConnection(ctx);
        for (String tableName : tableList) {
            try {
                this.translateTable(conn, tableName, srcLang, targetLang);
            }
            catch (SQLException e) {
                if (source == null) {
                    source = e;
                    firstErrorTable = tableName;
                }
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.info((Object)("The translation from " + ("L2".equals(srcLang) ? "simple chinese to tranditional chinese" : "traditional chinese to simple chinese") + " of " + tableName + " failed!"));
            }
        }
        if (source != null) {
            throw new BOSException(firstErrorTable, source);
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("The count of translated tables is: " + tableList.size()));
        logger.info((Object)("The time spent on translating tables is: " + (endTime - startTime) + "ms"));
    }

    private void translateTable(Connection conn, String tableName, String srcLang, String targetLang) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1=2");
        ResultSetMetaData rsmd = rs.getMetaData();
        HashSet<String> srcColNames = new HashSet<String>();
        HashSet<String> targetColNames = new HashSet<String>();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String columnName = rsmd.getColumnName(i).toUpperCase(Locale.ENGLISH);
            if (columnName.endsWith("_" + srcLang)) {
                srcColNames.add(columnName);
                continue;
            }
            if (!columnName.endsWith("_" + targetLang)) continue;
            targetColNames.add(columnName);
        }
        rs.close();
        stmt.close();
        if (!targetColNames.isEmpty()) {
            String updateSql = "UPDATE " + tableName + " SET ";
            for (String colName : targetColNames) {
                updateSql = updateSql + colName + " = NULL, ";
            }
            updateSql = updateSql.substring(0, updateSql.length() - 2);
            stmt = conn.createStatement();
            stmt.executeUpdate(updateSql);
            stmt.close();
        }
        if (!srcColNames.isEmpty()) {
            Iterator srcIter = srcColNames.iterator();
            HashMap<String, String> srcToTarget = new HashMap<String, String>();
            while (srcIter.hasNext()) {
                String srcColumnName = (String)srcIter.next();
                String targetColumnName = srcColumnName.substring(0, srcColumnName.length() - 2) + targetLang;
                if (!targetColNames.contains(targetColumnName)) continue;
                srcToTarget.put(srcColumnName, targetColumnName);
            }
            if (!srcToTarget.isEmpty()) {
                stmt = conn.createStatement(1005, 1008);
                String selectSql = "SELECT ";
                for (String srcColumnName : srcToTarget.keySet()) {
                    selectSql = selectSql + srcColumnName + ", ";
                    selectSql = selectSql + (String)srcToTarget.get(srcColumnName) + ", ";
                }
                selectSql = selectSql.substring(0, selectSql.length() - 2) + " FROM " + tableName;
                rs = stmt.executeQuery(selectSql);
                while (rs.next()) {
                    boolean updated = false;
                    for (String srcColumn : srcToTarget.keySet()) {
                        String targetColumn = (String)srcToTarget.get(srcColumn);
                        String srcValue = rs.getString(srcColumn);
                        String targetValue = rs.getString(targetColumn);
                        if (srcValue == null || (targetValue = this.convert(srcValue, srcLang, targetLang)) == null) continue;
                        rs.updateString(targetColumn, targetValue);
                        updated = true;
                    }
                    if (!updated) continue;
                    rs.updateRow();
                }
                rs.close();
                stmt.close();
            }
        }
        logger.info((Object)("The translation from " + ("L2".equals(srcLang) ? "simple chinese to tranditional chinese" : "traditional chinese to simple chinese") + " of " + tableName + " succeeded!"));
    }

    private String convert(String srcValue, String srcLang, String targetLang) {
        String targetValue = null;
        if ("L2".equals(srcLang) && "L3".equals(targetLang)) {
            targetValue = STConverter.sc2tc((String)srcValue);
        }
        if ("L3".equals(srcLang) && "L2".equals(targetLang)) {
            targetValue = STConverter.tc2sc((String)srcValue);
        }
        return targetValue;
    }

    @Override
    protected ReturnInfo _runSingleTask(Context ctx, DatataskParameter param) throws BOSException, DatataskException {
        ReturnInfo res = new ReturnInfo();
        if (DatataskMode.isImpMode((int)param.datataskMode)) {
            res = this.runOnImportMode(param, ctx);
        } else if (param.datataskMode == 1 || param.datataskMode == 64) {
            res = this.runOnExportMode(param, ctx);
        } else {
            String msg = "not support datataskmode " + param.datataskMode;
            throw new BOSException(msg);
        }
        return res;
    }

    @Override
    protected void _runMuitiTask(Context ctx, ArrayList params, boolean isDataInOneFile) throws BOSException, DatataskException {
        if (params == null || params.size() <= 0) {
            throw new IllegalArgumentException("no params");
        }
        int mode = ((DatataskParameter)params.get((int)0)).datataskMode;
        if (!DatataskMode.isImpMode((int)mode)) {
            throw new IllegalArgumentException("just suport import mode!");
        }
        if (isDataInOneFile) {
            DatataskParameter firstDp = null;
            int size = params.size();
            TaskLog log = new TaskLog(0);
            try {
                for (int i = 0; i < size; ++i) {
                    DatataskParameter dp = (DatataskParameter)params.get(i);
                    if (size > 1) {
                        dp.getContextParam().put("isMultiSheetImport", true);
                    }
                    this.runOnImportMode(dp, ctx, log);
                }
            }
            catch (DatataskException e) {
                throw e;
            }
            catch (BOSException e) {
                throw e;
            }
            finally {
                if (size > 1) {
                    firstDp = (DatataskParameter)params.get(0);
                    this.removeServerTempFile(firstDp.getOpenFileName());
                }
            }
        } else {
            throw new IllegalArgumentException("not support now!");
        }
    }

    protected void removeServerTempFile(String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileInfo _getServerFile(Context ctx, String serverFilePath, boolean hasContent, boolean isVirtualFilePath) throws BOSException {
        String actualPath = serverFilePath;
        if (isVirtualFilePath) {
            actualPath = this.getActualPath(ctx, serverFilePath);
        }
        String easPath = this.getServerTemplatePath();
        FileInfo fi = new FileInfo();
        String completePath = FMDatataskRunServerControllerBean.getServerPath(easPath + File.separator + actualPath);
        File f = new File(FilenameUtils.normalize((String)completePath));
        String fileName = completePath.substring(completePath.lastIndexOf(File.separator) + 1, completePath.length());
        fi.setFileName(fileName);
        if (!f.exists()) {
            fi.setExist(false);
            return fi;
        }
        fi.setExist(true);
        byte[] fileData = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            if (hasContent) {
                fileData = new byte[fis.available()];
                fis.read(fileData);
                fi.setSize(fileData.length);
                fi.setData(fileData);
            } else {
                fi.setSize(fis.available());
            }
        }
        catch (Exception err) {
            logger.error((Object)err);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        return fi;
    }

    private String getActualPath(Context ctx, String number) {
        String sql = "select FFilePath as filePath from T_BD_TemplateExport where fnumber = '" + number + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                String filePath = rs.getString("filePath");
                return filePath;
            }
        }
        catch (Exception e) {
            logger.error((Object)("get file path error" + e));
        }
        return null;
    }

    private String getServerTemplatePath() {
        String easPath = System.getProperty("EAS_HOME");
        StringBuffer templatePath = new StringBuffer();
        templatePath.append(easPath).append(File.separator).append("server").append(File.separator).append("deploy").append(File.separator).append("fileserver.ear").append(File.separator).append("easWebClient").append(File.separator).append("template");
        return templatePath.toString();
    }

    private static String getServerPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return path;
        }
        String leftfix = "\\";
        String rightfix = "/";
        if (path.indexOf(leftfix) < 0 && path.indexOf(rightfix) < 0) {
            return path;
        }
        String[] paths = null;
        paths = path.split("\\\\|/+");
        return FMDatataskRunServerControllerBean.array2String(paths, File.separator);
    }

    private static String array2String(String[] paths, String separator) {
        if (paths != null && paths.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < paths.length; ++i) {
                if (i != paths.length - 1) {
                    sb.append(paths[i] + separator);
                    continue;
                }
                sb.append(paths[i]);
            }
            return sb.toString();
        }
        return "";
    }

    public static void main(String[] args) {
        String apath = "/account\\account/account\\account//account\\dd.xls";
        String bpath = "c:/kingdee/account/dd.xls";
        String fileSeperatorInRootPath = "/";
        String[] serverPaths = null;
        String[] serverPaths2 = null;
        fileSeperatorInRootPath = apath.indexOf("\\") < 0 ? "/" : "\\\\";
        serverPaths = apath.split("\\\\");
        serverPaths2 = bpath.split("/");
        System.out.println("apath:" + serverPaths.length);
        System.out.println("apath:" + serverPaths2.length);
        System.out.println("apath:" + FMDatataskRunServerControllerBean.getServerPath(apath));
        System.out.println("apath:" + FMDatataskRunServerControllerBean.getServerPath(bpath));
    }

    @Override
    protected Map _getQueryInfoSet(Context ctx, List dataTransmissionClassNameList) throws BOSException, EASBizException {
        HashMap<String, String> queryInfoMap = new HashMap<String, String>();
        if (dataTransmissionClassNameList == null || dataTransmissionClassNameList.size() == 0) {
            return queryInfoMap;
        }
        Iterator iterator = dataTransmissionClassNameList.iterator();
        String dataTransmissionClassName = null;
        String queryInfoName = null;
        while (iterator != null && iterator.hasNext()) {
            dataTransmissionClassName = (String)iterator.next();
            if (dataTransmissionClassName == null || dataTransmissionClassName.trim().length() == 0) continue;
            queryInfoName = this._getQueryInfo(ctx, dataTransmissionClassName);
            queryInfoMap.put(dataTransmissionClassName, queryInfoName);
        }
        return queryInfoMap;
    }

    @Override
    protected void _delExportFile(Context ctx, String fileName) throws BOSException {
        this.serverFileName = fileName;
        String filePath = GlobalFunction.getFilePathForServer();
        File f = new File(filePath, this.serverFileName);
        if (f.exists() && f.isFile()) {
            if (f.delete()) {
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"80_DatataskRunServerControllerBean", (Locale)ctx.getLocale()) + filePath + this.serverFileName));
            } else {
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"81_DatataskRunServerControllerBean", (Locale)ctx.getLocale()) + filePath + this.serverFileName));
            }
        } else {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"82_DatataskRunServerControllerBean", (Locale)ctx.getLocale()) + filePath + this.serverFileName));
        }
    }

    @Override
    protected ReturnInfo _dataGridExport(Context ctx, DatataskParameter param) throws BOSException {
        TaskExternalCode task = null;
        ReturnInfo res = new ReturnInfo();
        try {
            ExternalStructInfo structInfo = new ExternalStructInfo();
            structInfo.setObjectDesc((String)param.getContextParam().get("title"));
            String[] columnModel = (String[])param.getContextParam().get("columnModel");
            for (int i = 0; i < columnModel.length; ++i) {
                String[] column = columnModel[i].split(",");
                boolean isHidden = Boolean.valueOf(column[1]);
                if (isHidden) continue;
                FieldPropertyInfo fpi = new FieldPropertyInfo();
                fpi.setFieldColNumber(i + 1);
                fpi.setFieldName(column[0]);
                fpi.setFieldDesc(column[2]);
                structInfo.addField(fpi);
            }
            TaskExternalCode taskcode = new TaskExternalCode(null);
            taskcode.setExternalStructInfo(structInfo);
            this.serverFileName = GlobalFunction.getTempFileName((String)param.getFileUuId(), (String)param.getFileType());
            param.setOpenFileName(this.serverFileName);
            task = taskcode;
            task.setTaskParameter((ITaskParameter)param);
            task.setTaskUuID(param.getLogUuID());
            DataGridExportExcelRunner runner = new DataGridExportExcelRunner((ITask)task, ctx);
            runner.call();
            File f = new File(GlobalFunction.getFilePathForServer(), this.serverFileName);
            if (f.isFile() && f.exists()) {
                res.setData((Object)f.length());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return res;
    }

    @Override
    protected ReturnInfo _downLoadFile(Context ctx, Map map) throws BOSException {
        ReturnInfo rs = new ReturnInfo();
        String fileName = (String)map.get("fileName");
        long pos = (Long)map.get("pos");
        FileTransferInfo file = ZipUtil.getFileTransfer((String)fileName, (long)pos);
        rs.setData((Object)file);
        return rs;
    }

    @Override
    protected ReturnInfo _getMultiExcelInfo(Context ctx, String fileUuId, String fileName, String importParam) throws BOSException {
        List importList = JSONObject.parseArray((String)importParam, ImpExpParam.class);
        ArrayList<String> solus = new ArrayList<String>();
        HashMap<String, Integer> solu2Seq = new HashMap<String, Integer>();
        for (ImpExpParam param : importList) {
            String solu = param.getSolu();
            int seq = param.getSeq();
            solus.add(solu);
            solu2Seq.put(solu, seq);
        }
        Map structMap = TaskTemplateAdapter.getStructMap(solus, (Context)ctx);
        ExternalExcelXDataReaderTask dataReader = new ExternalExcelXDataReaderTask(fileUuId, fileName, structMap);
        dataReader.setLocacle(ctx.getLocale());
        ReturnInfo rs = new ReturnInfo();
        try {
            dataReader.parseFile();
            MultiExcelInfo multinfo = new MultiExcelInfo();
            multinfo.setFileUuId(fileUuId);
            multinfo.setFileName(fileName);
            multinfo.setErrFileUuId(GlobalFunction.getUuID());
            ExcelInfo excelinfo = (ExcelInfo)dataReader.getFileInfo(fileUuId);
            List sheets = excelinfo.getSheetList();
            int rowCount = 0;
            for (ExcelInfo.ExcelSheetInfo sheet : sheets) {
                int sheetId = sheet.getSheetId();
                String sheetName = sheet.getSheetName();
                String solu = sheet.getStructInfo().getObjectName();
                multinfo.addSheetId2Name(sheetId, sheetName);
                multinfo.addSheetId2Solu(sheetId, solu);
                multinfo.addSolu2Seq(solu, ((Integer)solu2Seq.get(solu)).intValue());
                int _count = sheet.getRowCount();
                if (_count == 0) {
                    Object[] join = new Object[]{sheetName};
                    String msg = EASResourceJoinUtil.getServerString((String)"sheetIsEmpty", (Object[])join, (Locale)ctx.getOriginLocale());
                    throw new TaskRunnerException(msg);
                }
                rowCount += _count;
            }
            multinfo.setRowCount(rowCount);
            rs.setData((Object)multinfo);
            rs.setMsg("success");
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e.getOriginalMessage());
            rs.setMsg("error");
            String msg = EASResourceJoinUtil.getServerString((String)"parseSoluFailed", (Locale)ctx.getOriginLocale());
            String err = e.getOriginalMessage();
            if (err.indexOf("Caused") > -1) {
                err = err.substring(0, err.indexOf("Caused") - 1);
            }
            rs.setData((Object)(msg + err));
        }
        return rs;
    }

    @Override
    protected void _addImportTask(Context ctx, String taskUuId, List multiExcelList, Map ctxParam) throws BOSException {
        MultitaskExcelSchedule.addImportTask((String)taskUuId, (List)multiExcelList, (Map)ctxParam, (Context)ctx);
    }

    @Override
    protected String _getTaskProgress(Context ctx, String taskUuId) throws BOSException {
        ArrayList rs = new ArrayList();
        List list = TaskLogUtil.getLogByTask((String)taskUuId);
        boolean isDone = MultitaskExcelSchedule.isDone((String)taskUuId);
        for (ILog ilog : list) {
            ExcelTaskLog log = (ExcelTaskLog)ilog;
            Map sheetMap = log.getSheetList();
            Iterator iter = sheetMap.values().iterator();
            while (iter.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("excelId", log.getFileUuID());
                map.put("excelStatus", log.getTaskState());
                ExcelTaskLog.ExcelSheetTaskLog sheetLog = (ExcelTaskLog.ExcelSheetTaskLog)iter.next();
                map.put("sheetId", sheetLog.getSheetID());
                map.put("successNum", sheetLog.getSuccessRowCount());
                map.put("failNum", sheetLog.getFailRowCount());
                map.put("sheetResultState", sheetLog.getSheetResultState());
                map.put("sheetImportState", sheetLog.getSheetImportState());
                map.put("blankRowCount", sheetLog.getBlankRowCount());
                rs.add(map);
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("taskRs", Boolean.valueOf(isDone));
        map.put("sheetRs", rs);
        return JSONObject.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    @Override
    protected void _stopTask(Context ctx, String taskUuId) throws BOSException {
        MultitaskExcelSchedule.stopTask((String)taskUuId);
    }

    @Override
    protected String _getSheetLog(Context ctx, String taskUuId, String fileUuId, int sheetId) throws BOSException {
        String msg = "";
        ExcelTaskLog log = (ExcelTaskLog)TaskLogUtil.getLog((String)taskUuId, (String)fileUuId);
        if (log != null) {
            ExcelTaskLog.ExcelSheetTaskLog sheetlog = log.get(sheetId);
            if (sheetlog != null) {
                msg = sheetlog.getErrorInfo();
                if (StringUtils.isEmpty((String)msg)) {
                    msg = EASResourceJoinUtil.getServerString((String)"noErrMsg", (Locale)ctx.getLocale());
                }
            } else {
                msg = log.getErrMsg();
                if (StringUtils.isEmpty((String)msg)) {
                    msg = EASResourceJoinUtil.getServerString((String)"sheetNotImported", (Locale)ctx.getLocale());
                }
            }
        } else {
            msg = EASResourceJoinUtil.getServerString((String)"sheetNotImported", (Locale)ctx.getLocale());
        }
        return msg;
    }

    @Override
    protected void _clearMultiTaskLog(Context ctx, String taskUuId) throws BOSException {
        TaskLogUtil.clearMultiLog((String)taskUuId);
    }

    @Override
    protected void _delFile(Context ctx, List fileNames) throws BOSException {
        if (fileNames != null) {
            String filePath = GlobalFunction.getFilePathForServer();
            for (Object fileName : fileNames) {
                File f = new File(filePath, fileName.toString());
                if (!f.exists() || !f.isFile()) continue;
                f.delete();
            }
        }
    }

    @Override
    protected void _exportTempFile(Context ctx, List solu, String fileUuId) throws BOSException {
        Map structMap = TaskTemplateAdapter.getStructMap((List)solu, (Context)ctx);
        List<ExternalStructInfo> structs = Arrays.asList(structMap.values().toArray(new ExternalStructInfo[0]));
        MultiTempletExportRunner temp = new MultiTempletExportRunner(structs, fileUuId);
        temp.writeExcel();
    }

    @Override
    protected void _addExportTask(Context ctx, String taskUuId, List exportParamList, Map ctxParam) throws BOSException {
        MultitaskExcelSchedule.addExportTask((String)taskUuId, (List)exportParamList, (Map)ctxParam, (Context)ctx);
    }

    @Override
    protected Map _getExportAllRowCount(Context ctx, String taskUuId, List exportParamList) throws BOSException {
        ExcelTaskLog log = null;
        HashMap<String, Comparable<Boolean>> rsmap = new HashMap<String, Comparable<Boolean>>();
        int expRowCounts = 0;
        boolean isOK = false;
        for (int i = 0; i < exportParamList.size(); ++i) {
            ImpExpParam exp = (ImpExpParam)exportParamList.get(i);
            String solu = exp.getSolu();
            log = (ExcelTaskLog)TaskLogUtil.getLog((String)taskUuId, (String)solu);
            if (log != null && log.getTaskState().getValue() != 1) {
                expRowCounts += log.getExpAllRowCount();
                isOK = true;
                continue;
            }
            isOK = false;
        }
        rsmap.put("isOK", Boolean.valueOf(isOK));
        if (isOK) {
            rsmap.put("expRowCounts", Integer.valueOf(expRowCounts));
        }
        return rsmap;
    }

    @Override
    protected Map _getExoportProgerss(Context ctx, String taskUuId) throws BOSException {
        HashMap<String, Object> rsmap = new HashMap<String, Object>();
        List list = TaskLogUtil.getLogByTask((String)taskUuId);
        boolean isDone = MultitaskExcelSchedule.isDone((String)taskUuId);
        int rowCounts = 0;
        boolean hasErrMsg = false;
        TaskStateEnum state = TaskStateEnum.FAILEND;
        for (ILog ilog : list) {
            ExcelTaskLog log = (ExcelTaskLog)ilog;
            rowCounts += log.getExpCurrentRowCount();
            if (isDone && state.getValue() == 4 && log.getTaskState().getValue() == 3) {
                state = log.getTaskState();
            }
            if (hasErrMsg) continue;
            hasErrMsg = log.hasErrMsg();
        }
        if (isDone) {
            rsmap.put("taskStatus", state);
        }
        rsmap.put("hasErrMsg", hasErrMsg);
        rsmap.put("isDone", isDone);
        rsmap.put("exportedRowCounts", rowCounts);
        return rsmap;
    }

    @Override
    protected String _getExportLog(Context ctx, String taskUuId) throws BOSException {
        StringBuilder msg = new StringBuilder();
        List list = TaskLogUtil.getLogByTask((String)taskUuId);
        for (ILog ilog : list) {
            ExcelTaskLog log = (ExcelTaskLog)ilog;
            msg.append(log.getExcelErrorInfo());
        }
        return msg.toString();
    }
}

