/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.AbstractRateAdjustmentBaseBillControllerBean;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBack;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.Map;

public class RateAdjustmentBaseBillControllerBean
extends AbstractRateAdjustmentBaseBillControllerBean {
    private static Map botpRelationShip = new HashMap();

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber(ctx, (BillBaseInfo)model, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    protected void afterRateAdjustmentBillCreated(Context ctx, IRateAdjustmentBaseBillCallBack callback) throws BOSException, EASBizException {
        this.updateLoanBill_addnew(ctx, callback);
        RateAdjustmentBaseBillControllerBean.saveBOTPRelationShip(ctx, callback);
    }

    private void updateLoanBill_addnew(Context ctx, IRateAdjustmentBaseBillCallBack callback) throws BOSException, EASBizException {
        StringBuffer sbUpdate = new StringBuffer();
        sbUpdate.append("update  ").append(callback.getSrcLoanTableName());
        sbUpdate.append(" set FLastAdjustDate=? ");
        sbUpdate.append(" , FAdjustRateTimes = FAdjustRateTimes + 1 ");
        sbUpdate.append("where fid = ?");
        DbUtil.execute((Context)ctx, (String)sbUpdate.toString(), (Object[])new Object[]{callback.getAdjDate(), callback.getSrcLoanID()});
    }

    private static void saveBOTPRelationShip(Context ctx, IRateAdjustmentBaseBillCallBack callback) throws BOSException, EASBizException {
        botpRelationShip.clear();
        botpRelationShip.put(callback.getSrcLoanID(), callback.getRateAdjBillID());
        BOTPUtil.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
    }

    protected void afterRateAdjustBillDeleted(Context ctx, IRateAdjustmentBaseBillCallBack callback) throws EASBizException, BOSException {
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)callback.getCoreBaseInfo(), (String)callback.getCompanyID());
        this.updateLoanBill_deleted(ctx, callback);
    }

    private void updateLoanBill_deleted(Context ctx, IRateAdjustmentBaseBillCallBack callback) throws EASBizException, BOSException {
        StringBuffer sbUpdate = new StringBuffer();
        sbUpdate.append("update ").append(callback.getSrcLoanTableName());
        sbUpdate.append(" set FAdjustRateTimes = FAdjustRateTimes - 1,FLastAdjustDate=? ");
        sbUpdate.append("where fid = ?");
        FMHelper.execute(ctx, sbUpdate.toString(), new Object[]{callback.getLastAdjustDate(), callback.getSrcLoanID()});
    }
}

