/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMResultPrinter;
import com.kingdee.eas.fm.common.RemoteTestException;
import com.kingdee.eas.fm.common.ServerTestCase;
import com.kingdee.eas.fm.common.app.AbstractRemoteTestRunnerControllerBean;
import com.kingdee.eas.fm.common.app.TestCaseClassLoader;
import com.kingdee.util.Uuid;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class RemoteTestRunnerControllerBean
extends AbstractRemoteTestRunnerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.app.RemoteTestRunnerControllerBean");
    private transient SessionContext ctx;

    @Override
    public void _setProperty(Context ctx, String testClassName, String propertyName, String propertyValue) throws BOSException, EASBizException {
        Method m = null;
        Class<?> testClass = null;
        try {
            testClass = Class.forName(testClassName);
            m = testClass.getMethod("setProperty", String.class, String.class);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            m.invoke(testClass, propertyName, propertyValue);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    @Override
    public String _runMethod(Context ctx, Class testClass, String testMethod) throws BOSException, EASBizException {
        String info = null;
        try {
            Constructor m = null;
            m = testClass.getConstructor(String.class);
            ServerTestCase test = null;
            test = (ServerTestCase)((Object)m.newInstance(testMethod));
            test.setContext(ctx);
            TestSuite suite = new TestSuite();
            suite.addTest((Test)test);
            info = this.run(ctx, suite);
        }
        catch (Exception e1) {
            throw new BOSException("run Method", (Throwable)e1);
        }
        return info;
    }

    @Override
    public String _runCase(Context ctx, Class testClass) throws BOSException, EASBizException {
        TestSuite suite = new TestSuite(testClass);
        String info = this.run(ctx, suite);
        return info;
    }

    private String run(Context ctx, TestSuite suite) throws BOSException {
        PrintStream out = null;
        String info = null;
        try {
            Object setMethod = null;
            out = System.out;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream writer = new PrintStream(byteArrayOutputStream);
            System.setOut(writer);
            FMResultPrinter rp = new FMResultPrinter(writer);
            TestResult result = new TestResult();
            result.addListener((TestListener)rp);
            long startTime = System.currentTimeMillis();
            Enumeration e = suite.tests();
            while (e.hasMoreElements() && !result.shouldStop()) {
                ServerTestCase test = (ServerTestCase)((Object)e.nextElement());
                test.setContext(ctx);
                suite.runTest((Test)test, result);
            }
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            System.setOut(writer);
            rp.print2(result, runTime);
            info = byteArrayOutputStream.toString();
        }
        catch (Exception e1) {
            throw new BOSException("run Method", (Throwable)e1);
        }
        finally {
            System.setOut(out);
        }
        return info;
    }

    @Override
    public String _getProperty(Context ctx, String dataProviderClassName, String name) throws BOSException, EASBizException {
        Object result = null;
        try {
            Method m = null;
            Class<?> testClass = null;
            testClass = Class.forName(dataProviderClassName);
            m = testClass.getMethod("getProperty", String.class);
            result = m.invoke(testClass, name);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return result.toString();
    }

    @Override
    protected String _runMethod(Context ctx, String testCase, String testMethodName) throws BOSException, EASBizException {
        Class<?> tc = null;
        try {
            String cp = System.getProperty("java.class.path");
            TestCaseClassLoader loader = new TestCaseClassLoader(cp);
            tc = loader.loadClass(testCase);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("runCase", (Throwable)e);
        }
        return this._runMethod(ctx, tc, testMethodName);
    }

    @Override
    protected String _runCase(Context ctx, String testClass) throws BOSException, EASBizException {
        Class<?> tc = null;
        try {
            String cp = System.getProperty("class.path");
            TestCaseClassLoader loader = new TestCaseClassLoader(cp);
            tc = loader.loadClass(testClass);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("runCase", (Throwable)e);
        }
        return this._runCase(ctx, tc);
    }

    @Override
    protected Uuid _createUuid(Context ctx) throws BOSException, EASBizException {
        return Uuid.create();
    }

    @Override
    protected Object _invokeMethod(Context ctx, String className, String methodName, Class[] parameterTypes, Object[] args) throws BOSException, EASBizException {
        try {
            Class<?> cls = Class.forName(className);
            Object ins = cls.newInstance();
            Method method = cls.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(ins, args);
        }
        catch (Exception e) {
            throw new BOSException("invoke err", (Throwable)e);
        }
    }

    @Override
    protected Object _invokeBizMethod(Context ctx, String className, String methodName, Class[] parameterTypes, Object[] args) throws BOSException, EASBizException {
        Class[] innerParameterTypes = new Class[parameterTypes.length + 1];
        innerParameterTypes[0] = Context.class;
        System.arraycopy(parameterTypes, 0, innerParameterTypes, 1, parameterTypes.length);
        Object[] innerArgs = new Object[args.length + 1];
        innerArgs[0] = ctx;
        System.arraycopy(args, 0, innerArgs, 1, args.length);
        return this._invokeMethod(ctx, className, methodName, innerParameterTypes, innerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run(Context ctx, String className, String methodName) throws BOSException, EASBizException {
        block11: {
            ServerTestCase testCase = this.getTestInstance(className, methodName);
            testCase.setContext(ctx);
            this.setUpEJB(testCase);
            RemoteTestException exception = null;
            try {
                this.runTestCase(testCase);
            }
            catch (RemoteTestException e) {
                exception = e;
            }
            finally {
                block12: {
                    try {
                        this.tearDownEJB(testCase);
                    }
                    catch (RemoteTestException e) {
                        if (exception == null) break block12;
                        exception = e;
                    }
                }
                if (exception == null) break block11;
                throw exception;
            }
        }
    }

    private void setUpEJB(ServerTestCase testCase) throws RemoteTestException {
        try {
            try {
                testCase.setUpEJB();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
        }
        catch (Throwable e) {
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)((Object)e);
            }
            throw new RemoteTestException(e);
        }
    }

    private void runTestCase(ServerTestCase testCase) throws RemoteTestException {
        try {
            try {
                testCase.runBare();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
        }
        catch (Throwable e) {
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)((Object)e);
            }
            throw new RemoteTestException(e);
        }
    }

    private void tearDownEJB(ServerTestCase testCase) throws RemoteTestException {
        try {
            try {
                testCase.tearDownEJB();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
        }
        catch (Throwable e) {
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)((Object)e);
            }
            throw new RemoteTestException(e);
        }
    }

    private ServerTestCase getTestInstance(String className, String methodName) {
        Class<?> testClass = null;
        try {
            String cp = System.getProperty("java.class.path");
            String mename = this.getClass().getName();
            String name = mename.replace('.', '/') + ".class";
            testClass = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException("Test class not found : " + className);
        }
        Constructor<?> constructor = null;
        try {
            constructor = testClass.getConstructor(String.class);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException("Test class does not have a constructor which has a single String argument.");
        }
        try {
            ServerTestCase testCase = (ServerTestCase)((Object)constructor.newInstance(methodName));
            testCase.setServerSide(true);
            return testCase;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException("Cannot instantiate test class: " + testClass.getName());
        }
    }

    public void setSessionContext(SessionContext ctx) throws RemoteException, EJBException {
        super.setSessionContext(ctx);
    }
}

