/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fm.common.ROMRowSet;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public class SQL {
    private LinkedHashMap<String, Object[]> sqls = new LinkedHashMap();
    private Context ctx;

    public SQL(Context ctx) {
        this.ctx = ctx;
    }

    public SQL(Context ctx, String sql) {
        this.ctx = ctx;
        this.sqls.put(sql, new Object[0]);
    }

    public SQL(Context ctx, String sql, Object ... params) {
        this.ctx = ctx;
        this.sqls.put(sql, params);
    }

    public SQL add(String sql) {
        this.sqls.put(sql, new Object[0]);
        return this;
    }

    public SQL add(String sql, Object ... params) {
        this.sqls.put(sql, params);
        return this;
    }

    public SQL clear() {
        this.sqls.clear();
        return this;
    }

    public SQL execute() throws BOSException {
        this._execute();
        return this;
    }

    public ROMRowSet query() throws BOSException {
        if (this.sqls.size() == 0) {
            return null;
        }
        String sql = (String)this.sqls.keySet().toArray()[0];
        Object[] params = (Object[])this.sqls.values().toArray()[0];
        if (params.length != 0) {
            switch (this.getSqlType(sql)) {
                case str: {
                    return FMDBHelper.executeQuery(this.ctx, sql);
                }
                case strFrm: {
                    return FMDBHelper.executeQuery(this.ctx, String.format(sql, params));
                }
                case msgFrm: {
                    return FMDBHelper.executeQuery(this.ctx, MessageFormat.format(sql, params));
                }
                case preFrm: {
                    return FMDBHelper.executeQuery(this.ctx, sql, params);
                }
            }
        }
        return FMDBHelper.executeQuery(this.ctx, sql);
    }

    private SqlType getSqlType(String sql) {
        if (sql == null) {
            return SqlType.str;
        }
        if (sql.indexOf("{0}") > -1) {
            return SqlType.msgFrm;
        }
        if (sql.indexOf("%d") > -1 || sql.indexOf("%o") > -1 || sql.indexOf("%s") > -1 || sql.indexOf("%S") > -1 || sql.indexOf("%h") > -1 || sql.indexOf("%H") > -1 || sql.indexOf("%x") > -1 || sql.indexOf("%X") > -1 || sql.indexOf("%f") > -1 || sql.indexOf("%g") > -1 || sql.indexOf("%G") > -1 || sql.indexOf("%t") > -1 || sql.indexOf("%T") > -1 || sql.indexOf("%b") > -1 || sql.indexOf("%B") > -1) {
            return SqlType.strFrm;
        }
        if (sql.indexOf("?") > -1) {
            return SqlType.preFrm;
        }
        return SqlType.str;
    }

    public String toString() {
        if (this.sqls.size() == 0) {
            return "";
        }
        String all = "";
        for (Map.Entry<String, Object[]> entry : this.sqls.entrySet()) {
            String sql = entry.getKey();
            Object[] params = entry.getValue();
            if (params.length == 0) {
                all = all + sql + "\n";
                continue;
            }
            switch (this.getSqlType(sql)) {
                case str: {
                    all = all + sql + "\n";
                    break;
                }
                case strFrm: {
                    all = all + String.format(sql, params) + "\n";
                    break;
                }
                case msgFrm: {
                    all = all + MessageFormat.format(sql, params) + "\n";
                    break;
                }
                case preFrm: {
                    String ps = "";
                    for (Object obj : params) {
                        ps = ps + "," + obj;
                    }
                    all = all + "\n[" + ps.substring(1) + "]\n";
                }
            }
        }
        return all;
    }

    private void _execute() throws BOSException {
        if (this.sqls.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.createStatement();
            boolean notPreStmt = false;
            block15: for (Map.Entry<String, Object[]> entry : this.sqls.entrySet()) {
                String sql = entry.getKey();
                Object[] params = entry.getValue();
                if (params.length == 0) {
                    notPreStmt = true;
                    stmt.addBatch(sql);
                    continue;
                }
                switch (this.getSqlType(sql)) {
                    case str: {
                        notPreStmt = true;
                        stmt.addBatch(sql);
                        break;
                    }
                    case strFrm: {
                        notPreStmt = true;
                        stmt.addBatch(String.format(sql, params));
                        break;
                    }
                    case msgFrm: {
                        notPreStmt = true;
                        stmt.addBatch(MessageFormat.format(sql, params));
                        break;
                    }
                    case preFrm: {
                        PreparedStatement ptmt = null;
                        ptmt = conn.prepareStatement(sql);
                        for (int i = 0; i < params.length; ++i) {
                            ptmt.setObject(i + 1, params[i]);
                        }
                        try {
                            ptmt.execute();
                            continue block15;
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                        finally {
                            SQLUtils.cleanup((Statement)ptmt);
                            continue block15;
                        }
                    }
                }
            }
            if (notPreStmt) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static void main(String[] args) throws BOSException {
        SQL a = new SQL(null, "select aa id=%d %s", 60, "1");
        a.query();
        a.clear().add("update a from xx where id=?", "1").add("update b from xx where id={0}", "2").add("update c from xx where id=$s and idx=%d", "2", 10);
        a.execute();
    }

    private static enum SqlType {
        str,
        msgFrm,
        strFrm,
        preFrm;

    }
}

