/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.fm.common.UserOptionUtil;
import com.kingdee.eas.fm.common.app.AbstractUserOptionControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserOptionControllerBean
extends AbstractUserOptionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.app.UserOptionControllerBean");

    @Override
    protected Map _getUserOptionMap(Context ctx, String userId, String companyId, String optKey, String name) throws BOSException, EASBizException {
        Map map = null;
        List list = this._getUserOptionMapList(ctx, userId, companyId, optKey, name);
        if (list != null && list.size() != 0) {
            map = (Map)list.get(0);
        }
        return map;
    }

    @Override
    protected void _submit(Context arg0, IObjectValue arg1, boolean isMultiOption) throws BOSException, EASBizException {
        UserOptionInfo userOptionInfo = (UserOptionInfo)arg1;
        if (!isMultiOption) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)arg0).getCurrentUser();
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)arg0).getCurrentCompany();
            String sql = "DELETE FROM T_FMCommon_UserOption WHERE FCreateUserID = ? AND FCompanyID = ? AND FOptKey = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            Object optValue = null;
            try {
                conn = this.getConnection(arg0);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)userInfo.getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)companyInfo.getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)userOptionInfo.getOptKey());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        super._submit(arg0, arg1);
    }

    @Override
    protected Map _getUserOptionMap(Context ctx, String optKey) throws BOSException, EASBizException {
        return this._getUserOptionMap(ctx, null, null, optKey, null);
    }

    @Override
    protected Map _getUserOptionMap(Context ctx, String optKey, String name) throws BOSException, EASBizException {
        return this._getUserOptionMap(ctx, null, null, optKey, name);
    }

    @Override
    protected List _getUserOptionMapList(Context ctx, String userId, String companyId, String optKey, String name) throws BOSException {
        ArrayList<Map> list = new ArrayList<Map>();
        String sql = null;
        if (userId == null) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            userId = userInfo.getId().toString();
        }
        if (companyId == null) {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            companyId = companyInfo.getId().toString();
        }
        sql = name == null ? "SELECT FOptValue FROM T_FMCommon_UserOption WHERE FCreateUserID = ? AND FCompanyID = ? AND FOptKey = ?" : "SELECT FOptValue FROM T_FMCommon_UserOption WHERE FCreateUserID = ? AND FCompanyID = ? AND FOptKey = ? AND FName = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String optValue = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)userId);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)companyId);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)optKey);
            if (name != null) {
                pstmt.setString(4, name);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                optValue = rs.getString("FOptValue");
                list.add(UserOptionUtil.string2Map(optValue));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return list;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, String key, String value, String optKey, String name, String companyid) throws BOSException, EASBizException {
        UserOptionCollection optionCollection = new UserOptionCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyid));
        if (optKey != null) {
            fi.getFilterItems().add(new FilterItemInfo("optKey", (Object)optKey));
        }
        if (name != null) {
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        }
        evi.setFilter(fi);
        UserOptionCollection userOptionCollection = this.getUserOptionCollection(ctx, evi);
        UserOptionInfo userOptionInfo = null;
        int size = userOptionCollection.size();
        for (int i = 0; i < size; ++i) {
            userOptionInfo = userOptionCollection.get(i);
            Map map = UserOptionUtil.string2Map(userOptionInfo.getOptValue());
            String bankAcctIds = (String)map.get(key);
            if (bankAcctIds == null) continue;
            while (bankAcctIds.indexOf("&") != -1) {
                String id = bankAcctIds.substring(0, bankAcctIds.indexOf("&"));
                if (id.equals(value)) {
                    optionCollection.add(userOptionInfo);
                    break;
                }
                bankAcctIds = bankAcctIds.substring(bankAcctIds.indexOf("&") + 1);
            }
            if (!bankAcctIds.equals(value)) continue;
            optionCollection.add(userOptionInfo);
        }
        return optionCollection;
    }

    @Override
    protected void _submit(Context ctx, IObjectValue objectValue, boolean isMultiOption, String companyId) throws BOSException, EASBizException {
        UserOptionInfo userOptionInfo = (UserOptionInfo)objectValue;
        if (!isMultiOption) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            String sql = "DELETE FROM T_FMCommon_UserOption WHERE FCreateUserID = ? AND FCompanyID = ? AND FOptKey = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)userInfo.getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)companyId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)userOptionInfo.getOptKey());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        super._submit(ctx, objectValue);
    }
}

