/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.common.service.FmBatchExecutorFactory;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.IBatchExecutor;
import com.kingdee.eas.framework.batchaction.service.ActionProxy;
import com.kingdee.eas.framework.batchaction.service.BatchActionManager;
import com.kingdee.eas.framework.batchaction.service.BatchExecuteParams;
import com.kingdee.eas.framework.batchaction.service.GeneralActionProxy;
import com.kingdee.eas.framework.client.service.ForewarnService;
import com.kingdee.eas.framework.permission.PermissionServiceHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMActionProxy
extends GeneralActionProxy {
    private static Logger logger = Logger.getLogger(FMActionProxy.class);
    static final Class[] IOBJECTVALUE_TYPE = new Class[]{IObjectValue.class};
    static final Class[] SET_TYPE = new Class[]{Set.class};
    static final Class[] LIST_TYPE = new Class[]{List.class};
    static final Class[] STRING_TYPE = new Class[]{String.class};
    static final Class[] PK_TYPE = new Class[]{IObjectPK.class};
    private Map serviceContext;

    public FMActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        super(action, actionMethod, bizAction);
    }

    public FMActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction, BatchActionManager actionManager) {
        super(action, actionMethod, bizAction);
        this.setActionManager(actionManager);
    }

    public FMActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction, BatchActionManager actionManager, Map serviceContext) {
        super(action, actionMethod, bizAction);
        this.serviceContext = serviceContext;
        this.setActionManager(actionManager);
    }

    protected BatchExecuteParams initBatchExecuteParams(IBizCtrl iBizInterface, BatchSelectionEntries selectionEntry) {
        BatchExecuteParams batchParams;
        block5: {
            boolean isHead;
            Object[] paramType;
            block7: {
                block6: {
                    block4: {
                        paramType = this.getAppropriateParamType(iBizInterface);
                        isHead = this.getLevel().equals((Object)ActionLevelEnum.HEAD);
                        batchParams = new BatchExecuteParams(this.getBizAction(), this.getActionManager().getClzIBizFactory(this.getLevel()), this.getActionMethod(), (Class[])paramType, selectionEntry, this.getActionManager().getContextType(), iBizInterface.getType());
                        if (!Arrays.equals(paramType, PK_TYPE)) break block4;
                        int size = selectionEntry.size();
                        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                            BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                            if (entry.getResult() == ActionResultEnum.ERROR) continue;
                            batchParams.newParamsEntry().add((Object)new ObjectUuidPK(BOSUuid.read((String)(isHead ? entry.getId() : entry.getEntryId()))));
                        }
                        break block5;
                    }
                    if (!Arrays.equals(paramType, STRING_TYPE)) break block6;
                    int size = selectionEntry.size();
                    for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                        BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                        if (entry.getResult() == ActionResultEnum.ERROR) continue;
                        batchParams.newParamsEntry().add((Object)(isHead ? entry.getId() : entry.getEntryId()));
                    }
                    break block5;
                }
                if (!Arrays.equals(paramType, LIST_TYPE)) break block7;
                int size = selectionEntry.size();
                for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                    BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                    ArrayList<String> idList = new ArrayList<String>();
                    if (entry.getResult() == ActionResultEnum.ERROR) continue;
                    idList.add(isHead ? entry.getId() : entry.getEntryId());
                    batchParams.newParamsEntry().add(idList);
                }
                break block5;
            }
            if (!Arrays.equals(paramType, SET_TYPE)) break block5;
            int size = selectionEntry.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                HashSet<String> set = new HashSet<String>();
                if (entry.getResult() == ActionResultEnum.ERROR) continue;
                set.add(isHead ? entry.getId() : entry.getEntryId());
                batchParams.newParamsEntry().add(set);
            }
        }
        return batchParams;
    }

    protected Class[] getAppropriateParamType(IBizCtrl iBizInterface) {
        if (this.isParamTypeHas(iBizInterface, PK_TYPE)) {
            return PK_TYPE;
        }
        if (this.isParamTypeHas(iBizInterface, STRING_TYPE)) {
            return STRING_TYPE;
        }
        if (this.isParamTypeHas(iBizInterface, LIST_TYPE)) {
            return LIST_TYPE;
        }
        if (this.isParamTypeHas(iBizInterface, SET_TYPE)) {
            return SET_TYPE;
        }
        throw new IllegalArgumentException("You must define the interface method parameter in String or IObjectPK type.");
    }

    protected boolean doActionPerformed(BatchSelectionEntries selectionEntry) throws Exception {
        String actionName = this.getClientActionName();
        try {
            PermissionServiceHelper.getInstance().doPermissionService((ActionProxy)this, selectionEntry, this.uiObj.getMetaDataPK(), (IMetaDataPK)new MetaDataPK(actionName));
        }
        catch (Exception e) {
            this.action.getUIObject().handUIException((Throwable)e);
        }
        boolean isSuccess = super.doActionPerformed(selectionEntry);
        try {
            if (isSuccess && this.serviceContext != null) {
                this.serviceContext.put("ACTION", this.action);
                new ForewarnService().afterActionPerformed(this.serviceContext);
            }
        }
        catch (Exception e) {
            this.action.getUIObject().handUIException((Throwable)e);
        }
        return isSuccess;
    }

    protected String getClientActionName() {
        String actionName = "";
        String clzName = this.action.getClass().getName();
        int idx = clzName.lastIndexOf(36);
        actionName = idx > -1 ? clzName.substring(idx + 1) : ((idx = clzName.lastIndexOf(46)) > -1 ? clzName.substring(idx + 1) : clzName);
        return actionName;
    }

    protected boolean beforeAction() {
        if (this.getBizAction().equals((Object)BatchActionEnum.DELETE) && !MsgBox.isYes((int)MsgBox.showConfirm2(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return false;
        }
        return super.beforeAction();
    }

    protected IBatchExecutor getBatchExecutor(Context mainContext) throws BOSException {
        return FmBatchExecutorFactory.getRemoteInstanceWithObjectContext(mainContext);
    }
}

