/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.fm.common.task.FMTaskAbstractRunnerAdapter;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class FMTaskRecordRunnerAdapter
extends FMTaskAbstractRunnerAdapter {
    private static Logger logger = SysLog.getLogger(FMTaskRecordRunnerAdapter.class);
    protected boolean continueCondition = false;
    protected int nCurCount;
    protected int nSuccessCount;
    protected int nFailCount;
    protected int nBlankCount;
    protected boolean stopOnDataErr = false;

    public FMTaskRecordRunnerAdapter(ITask task) {
        this(task, null);
    }

    public FMTaskRecordRunnerAdapter(ITask task, Context ctx) {
        super(task, ctx);
        this.task = task;
        this.tl.setLogUuID(task.getTaskUuID());
        this.nCurCount = 0;
    }

    @Override
    public void callRollbackProcess() throws Exception {
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
    }

    @Override
    protected ReturnInfo onMainRunningProcess() throws TaskRunnerException {
        try {
            if (this.continueCondition) {
                this.onBeforeEachRunningLoop();
            }
        }
        catch (TaskRunnerException ex) {
            logger.error((Object)ex);
            this.onDataError(ex);
        }
        ReturnInfo result = this.onRecordProcess();
        return result;
    }

    protected ReturnInfo onRecordProcess() throws TaskRunnerException {
        ReturnInfo result = new ReturnInfo();
        ArrayList<Object> data = new ArrayList<Object>();
        while (this.hasMoreRecord() && this.continueCondition) {
            ++this.nCurCount;
            try {
                data.add(this.onEachRunningLoop());
                if (this.nSuccessCount % 100 != 0) continue;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Throwable ex) {
                ++this.nFailCount;
                this.onDataError(ex);
            }
        }
        if (this.nSuccessCount % 100 != 0) {
            this.tl.setSuccessRecordCount(this.nSuccessCount);
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog((TaskLog)this.tl);
        result.setData(data);
        return result;
    }

    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)ex).getExceptionCode() == 4) {
            throw (TaskRunnerException)ex;
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.nFailCount > 100) {
            ex = new TaskRunnerException(ex.getMessage());
        }
        this.tl.addException(errMsg, ex, Integer.valueOf(this.nCurCount));
        this.tl.setFailRecordCount(this.nFailCount);
        TaskLogUtil.putLog((TaskLog)this.tl);
        this.dataErrorHandle(ex);
    }

    protected String getMsgOnDataErr() {
        return EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)this.locale) + this.nCurCount + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)this.locale);
    }

    protected void onDataErrorStop(Throwable ex) {
        this.continueCondition = false;
        this.stopOnDataErr = true;
    }

    protected void dataErrorHandle(Throwable ex) throws TaskRunnerException {
        if (this.task.getDataErrHandleStrategy() == 4) {
            this.onDataErrorSkip(ex);
        } else if (this.task.getDataErrHandleStrategy() == 5) {
            this.onDataErrorStop(ex);
        }
    }

    protected void onDataErrorSkip(Throwable ex) {
        this.continueCondition = true;
        this.stopOnDataErr = false;
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        this.tl.setLogUuID(this.task.getTaskUuID());
        this.tl.setTaskState(TaskStateEnum.INITTASK);
        TaskLogUtil.putLog((TaskLog)this.tl);
        this.continueCondition = true;
    }

    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        if (this.needInitCountFlag) {
            this.nCurCount = 0;
            this.nFailCount = 0;
            this.nSuccessCount = 0;
        } else if (this.tl != null) {
            this.nFailCount = this.tl.getFailRecordCount();
            this.nSuccessCount = this.tl.getSuccessRecordCount();
        }
    }

    protected abstract boolean hasMoreRecord() throws TaskRunnerException;

    protected abstract Object onEachRunningLoop() throws Exception;
}

